/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.logging.messages.ManagementConsoleMessages;
import org.apache.qpid.server.logging.messages.PortMessages;
import org.apache.qpid.server.management.plugin.DojoHelper;
import org.apache.qpid.server.management.plugin.HttpManagementConfiguration;
import org.apache.qpid.server.management.plugin.RewriteServlet;
import org.apache.qpid.server.management.plugin.connector.TcpAndSslSelectChannelConnector;
import org.apache.qpid.server.management.plugin.filter.ExceptionHandlingFilter;
import org.apache.qpid.server.management.plugin.filter.ForbiddingAuthorisationFilter;
import org.apache.qpid.server.management.plugin.filter.ForbiddingTraceFilter;
import org.apache.qpid.server.management.plugin.filter.LoggingFilter;
import org.apache.qpid.server.management.plugin.filter.PreemptiveSessionInvalidationFilter;
import org.apache.qpid.server.management.plugin.filter.RedirectingAuthorisationFilter;
import org.apache.qpid.server.management.plugin.filter.RewriteRequestForUncompressedJavascript;
import org.apache.qpid.server.management.plugin.servlet.FileServlet;
import org.apache.qpid.server.management.plugin.servlet.RootServlet;
import org.apache.qpid.server.management.plugin.servlet.rest.ApiDocsServlet;
import org.apache.qpid.server.management.plugin.servlet.rest.BrokerQueryServlet;
import org.apache.qpid.server.management.plugin.servlet.rest.JsonValueServlet;
import org.apache.qpid.server.management.plugin.servlet.rest.LogoutServlet;
import org.apache.qpid.server.management.plugin.servlet.rest.MetaDataServlet;
import org.apache.qpid.server.management.plugin.servlet.rest.QueueReportServlet;
import org.apache.qpid.server.management.plugin.servlet.rest.RestServlet;
import org.apache.qpid.server.management.plugin.servlet.rest.SaslServlet;
import org.apache.qpid.server.management.plugin.servlet.rest.StructureServlet;
import org.apache.qpid.server.management.plugin.servlet.rest.TimeZoneServlet;
import org.apache.qpid.server.management.plugin.servlet.rest.VirtualHostQueryServlet;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.KeyStore;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.Protocol;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.model.Transport;
import org.apache.qpid.server.model.TrustStore;
import org.apache.qpid.server.model.adapter.AbstractPluginAdapter;
import org.apache.qpid.server.model.port.HttpPort;
import org.apache.qpid.server.model.port.PortManager;
import org.apache.qpid.server.transport.PortBindFailureException;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.apache.qpid.transport.network.security.ssl.QpidMultipleTrustManager;
import org.apache.qpid.transport.network.security.ssl.SSLUtil;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(category=false, type="MANAGEMENT-HTTP")
public class HttpManagement
extends AbstractPluginAdapter<HttpManagement>
implements HttpManagementConfiguration<HttpManagement>,
PortManager {
    private static final String PORT_SERVLET_ATTRIBUTE = "org.apache.qpid.server.model.Port";
    private final Logger _logger = LoggerFactory.getLogger(HttpManagement.class);
    public static final int DEFAULT_TIMEOUT_IN_SECONDS = 600;
    public static final String TIME_OUT = "sessionTimeout";
    public static final String HTTP_BASIC_AUTHENTICATION_ENABLED = "httpBasicAuthenticationEnabled";
    public static final String HTTPS_BASIC_AUTHENTICATION_ENABLED = "httpsBasicAuthenticationEnabled";
    public static final String HTTP_SASL_AUTHENTICATION_ENABLED = "httpSaslAuthenticationEnabled";
    public static final String HTTPS_SASL_AUTHENTICATION_ENABLED = "httpsSaslAuthenticationEnabled";
    public static final String PLUGIN_TYPE = "MANAGEMENT-HTTP";
    public static final String DEFAULT_LOGOUT_URL = "/logout.html";
    private static final String OPERATIONAL_LOGGING_NAME = "Web";
    private static final String JSESSIONID_COOKIE_PREFIX = "JSESSIONID_";
    private static final String[] STATIC_FILE_TYPES = new String[]{"*.js", "*.css", "*.html", "*.png", "*.gif", "*.jpg", "*.jpeg", "*.json", "*.txt", "*.xsl", "*.svg"};
    private Server _server;
    @ManagedAttributeField
    private boolean _httpsSaslAuthenticationEnabled;
    @ManagedAttributeField
    private boolean _httpSaslAuthenticationEnabled;
    @ManagedAttributeField
    private boolean _httpsBasicAuthenticationEnabled;
    @ManagedAttributeField
    private boolean _httpBasicAuthenticationEnabled;
    @ManagedAttributeField
    private int _sessionTimeout;
    @ManagedAttributeField
    public String _corsAllowOrigins;
    @ManagedAttributeField
    public Set<String> _corsAllowMethods;
    @ManagedAttributeField
    public String _corsAllowHeaders;
    @ManagedAttributeField
    public boolean _corsAllowCredentials;
    @ManagedAttributeField
    private boolean _compressResponses;
    private boolean _allowPortActivation;
    private Map<HttpPort<?>, Connector> _portConnectorMap = new HashMap();
    private volatile boolean _serveUncompressedDojo;

    @ManagedObjectFactoryConstructor
    public HttpManagement(Map<String, Object> attributes, Broker broker) {
        super(attributes, broker);
    }

    protected void onOpen() {
        super.onOpen();
        this._serveUncompressedDojo = Boolean.TRUE.equals(this.getContextValue(Boolean.class, "qpid.httpManagement.serveUncompressedDojo"));
    }

    @StateTransition(currentState={State.UNINITIALIZED, State.ERRORED}, desiredState=State.ACTIVE)
    private ListenableFuture<Void> doStart() {
        Collection<HttpPort<?>> httpPorts = this.getEligibleHttpPorts(this.getBroker().getPorts());
        if (httpPorts.isEmpty()) {
            this._logger.warn("HttpManagement plugin is configured but no suitable HTTP ports are available.");
        } else {
            this.getBroker().getEventLogger().message(ManagementConsoleMessages.STARTUP((String)OPERATIONAL_LOGGING_NAME));
            this._server = this.createServer(httpPorts);
            try {
                this._server.start();
                this.logOperationalListenMessages();
            }
            catch (PortBindFailureException e) {
                this.getBroker().getEventLogger().message(PortMessages.BIND_FAILED((String)"HTTP", (Number)e.getAddress().getPort()));
                throw e;
            }
            catch (Exception e) {
                throw new ServerScopedRuntimeException("Failed to start HTTP management on ports : " + httpPorts, (Throwable)e);
            }
            this.getBroker().getEventLogger().message(ManagementConsoleMessages.READY((String)OPERATIONAL_LOGGING_NAME));
        }
        this.setState(State.ACTIVE);
        return Futures.immediateFuture(null);
    }

    protected void onClose() {
        if (this._server != null) {
            try {
                this.logOperationalShutdownMessage();
                this._server.stop();
            }
            catch (Exception e) {
                throw new ServerScopedRuntimeException("Failed to stop HTTP management", (Throwable)e);
            }
        }
        this.getBroker().getEventLogger().message(ManagementConsoleMessages.STOPPED((String)OPERATIONAL_LOGGING_NAME));
    }

    @Override
    public int getSessionTimeout() {
        return this._sessionTimeout;
    }

    @Override
    public String getCorsAllowOrigins() {
        return this._corsAllowOrigins;
    }

    @Override
    public Set<String> getCorsAllowMethods() {
        return this._corsAllowMethods;
    }

    @Override
    public String getCorsAllowHeaders() {
        return this._corsAllowHeaders;
    }

    @Override
    public boolean getCorsAllowCredentials() {
        return this._corsAllowCredentials;
    }

    private Server createServer(Collection<HttpPort<?>> ports) {
        this._logger.debug("Starting up web server on {}", ports);
        this._allowPortActivation = true;
        Server server = new Server();
        server.setThreadPool((ThreadPool)new ZeroSizedThreadPool());
        int lastPort = -1;
        for (HttpPort<?> port : ports) {
            SelectChannelConnector connector = this.createConnector(port);
            server.addConnector((Connector)connector);
            this._portConnectorMap.put(port, (Connector)connector);
            lastPort = port.getPort();
        }
        this._allowPortActivation = false;
        ServletContextHandler root = new ServletContextHandler(1);
        root.setContextPath("/");
        root.setCompactPath(true);
        server.setHandler((Handler)root);
        server.setSendServerVersion(false);
        ErrorHandler errorHandler = new ErrorHandler(){

            protected void writeErrorPageBody(HttpServletRequest request, Writer writer, int code, String message, boolean showStacks) throws IOException {
                String uri = request.getRequestURI();
                this.writeErrorPageMessage(request, writer, code, message, uri);
                for (int i = 0; i < 20; ++i) {
                    writer.write("<br/>                                                \n");
                }
            }
        };
        root.setErrorHandler(errorHandler);
        root.getServletContext().setAttribute("Qpid.broker", (Object)this.getBroker());
        root.getServletContext().setAttribute("Qpid.managementConfiguration", (Object)this);
        root.addFilter(new FilterHolder((Filter)new ExceptionHandlingFilter()), "/*", EnumSet.allOf(DispatcherType.class));
        FilterHolder corsFilter = new FilterHolder((Filter)new CrossOriginFilter());
        corsFilter.setInitParameter("allowedOrigins", this.getCorsAllowOrigins());
        corsFilter.setInitParameter("allowedMethods", Joiner.on((String)",").join(this.getCorsAllowMethods()));
        corsFilter.setInitParameter("allowedHeaders", this.getCorsAllowHeaders());
        corsFilter.setInitParameter("allowCredentials", String.valueOf(this.getCorsAllowCredentials()));
        root.addFilter(corsFilter, "/*", EnumSet.of(DispatcherType.REQUEST));
        root.addFilter(new FilterHolder((Filter)new PreemptiveSessionInvalidationFilter()), "/api/*", EnumSet.of(DispatcherType.REQUEST));
        FilterHolder loggingFilter = new FilterHolder((Filter)new LoggingFilter());
        root.addFilter(loggingFilter, "/api/*", EnumSet.of(DispatcherType.REQUEST));
        root.addFilter(loggingFilter, "/service/*", EnumSet.of(DispatcherType.REQUEST));
        root.addFilter(new FilterHolder((Filter)new ForbiddingTraceFilter()), "/*", EnumSet.of(DispatcherType.REQUEST));
        FilterHolder restAuthorizationFilter = new FilterHolder((Filter)new ForbiddingAuthorisationFilter());
        restAuthorizationFilter.setInitParameter("allowed", "/service/sasl");
        root.addFilter(restAuthorizationFilter, "/api/*", EnumSet.of(DispatcherType.REQUEST));
        root.addFilter(restAuthorizationFilter, "/apidocs/*", EnumSet.of(DispatcherType.REQUEST));
        root.addFilter(restAuthorizationFilter, "/service/*", EnumSet.of(DispatcherType.REQUEST));
        root.addFilter(new FilterHolder((Filter)new RedirectingAuthorisationFilter()), "/index.html", EnumSet.of(DispatcherType.REQUEST));
        root.addFilter(new FilterHolder((Filter)new RedirectingAuthorisationFilter()), "/", EnumSet.of(DispatcherType.REQUEST));
        if (this._serveUncompressedDojo) {
            root.addFilter(RewriteRequestForUncompressedJavascript.class, "/dojo/dojo/*", EnumSet.of(DispatcherType.REQUEST));
            root.addFilter(RewriteRequestForUncompressedJavascript.class, "/dojo/dojox/*", EnumSet.of(DispatcherType.REQUEST));
        }
        this.addRestServlet(root, Broker.class);
        ServletHolder queryServlet = new ServletHolder((Servlet)new BrokerQueryServlet());
        root.addServlet(queryServlet, "/api/latest/querybroker/*");
        root.addServlet(queryServlet, "/api/v6.1/querybroker/*");
        ServletHolder vhQueryServlet = new ServletHolder((Servlet)new VirtualHostQueryServlet());
        root.addServlet(vhQueryServlet, "/api/latest/queryvhost/*");
        root.addServlet(vhQueryServlet, "/api/v6.1/queryvhost/*");
        ServletHolder apiDocsServlet = new ServletHolder((Servlet)new ApiDocsServlet(this.getModel()));
        ServletHolder rewriteSerlvet = new ServletHolder((Servlet)new RewriteServlet("^(.*)$", "$1/"));
        for (String path : new String[]{"/apidocs", "/apidocs/latest", "/apidocs/" + this.getLatestSupportedVersion()}) {
            root.addServlet(rewriteSerlvet, path);
            root.addServlet(apiDocsServlet, path + "/");
        }
        root.addServlet(new ServletHolder((Servlet)new StructureServlet()), "/service/structure");
        root.addServlet(new ServletHolder((Servlet)new QueueReportServlet()), "/service/queuereport/*");
        root.addServlet(new ServletHolder((Servlet)new MetaDataServlet(this.getModel())), "/service/metadata");
        root.addServlet(new ServletHolder((Servlet)new SaslServlet()), "/service/sasl");
        root.addServlet(new ServletHolder((Servlet)new RootServlet("/", "/apidocs/", "index.html")), "/");
        root.addServlet(new ServletHolder((Servlet)new LogoutServlet()), "/logout");
        root.addServlet(new ServletHolder((Servlet)new FileServlet(DojoHelper.getDojoPath(), true)), "/dojo/dojo/*");
        root.addServlet(new ServletHolder((Servlet)new FileServlet(DojoHelper.getDijitPath(), true)), "/dojo/dijit/*");
        root.addServlet(new ServletHolder((Servlet)new FileServlet(DojoHelper.getDojoxPath(), true)), "/dojo/dojox/*");
        root.addServlet(new ServletHolder((Servlet)new FileServlet(DojoHelper.getDgridPath(), true)), "/dojo/dgrid/*");
        root.addServlet(new ServletHolder((Servlet)new FileServlet(DojoHelper.getDstorePath(), true)), "/dojo/dstore/*");
        for (String pattern : STATIC_FILE_TYPES) {
            root.addServlet(new ServletHolder((Servlet)new FileServlet()), pattern);
        }
        root.addServlet(new ServletHolder((Servlet)new TimeZoneServlet()), "/service/timezones");
        SessionManager sessionManager = root.getSessionHandler().getSessionManager();
        sessionManager.getSessionCookieConfig().setName(JSESSIONID_COOKIE_PREFIX + lastPort);
        sessionManager.getSessionCookieConfig().setHttpOnly(true);
        sessionManager.setMaxInactiveInterval(((Integer)this.getAttribute(TIME_OUT)).intValue());
        return server;
    }

    private SelectChannelConnector createConnector(HttpPort<?> port) {
        port.setPortManager((PortManager)this);
        if (port.getState() != State.ACTIVE) {
            port.startAsync();
        }
        SelectChannelConnector connector = null;
        Set transports = port.getTransports();
        if (!transports.contains(Transport.SSL)) {
            HttpPort<?> thePort = port;
            connector = new SelectChannelConnector((Port)thePort){
                final /* synthetic */ Port val$thePort;
                {
                    this.val$thePort = port;
                }

                public void customize(EndPoint endpoint, Request request) throws IOException {
                    super.customize(endpoint, request);
                    request.setAttribute(HttpManagement.PORT_SERVLET_ATTRIBUTE, (Object)this.val$thePort);
                }

                public void open() throws IOException {
                    try {
                        super.open();
                    }
                    catch (BindException e) {
                        InetSocketAddress addr = this.getHost() == null ? new InetSocketAddress(this.getPort()) : new InetSocketAddress(this.getHost(), this.getPort());
                        throw new PortBindFailureException(addr);
                    }
                }
            };
        } else if (transports.contains(Transport.SSL)) {
            connector = this.createSslConnector(port);
        } else {
            throw new IllegalArgumentException("Unexpected transport on port " + port.getName() + ":" + transports);
        }
        String bindingAddress = port.getBindingAddress();
        if (bindingAddress != null && !bindingAddress.trim().equals("") && !bindingAddress.trim().equals("*")) {
            connector.setHost(bindingAddress.trim());
        }
        connector.setPort(port.getPort());
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setName("HttpManagement-" + port.getName());
        int additionalInternalThreads = (Integer)port.getContextValue(Integer.class, "port.http.additionalInternalThreads");
        int maximumQueueRequests = (Integer)port.getContextValue(Integer.class, "port.http.maximumQueuedRequests");
        int threadPoolMaximum = port.getThreadPoolMaximum();
        int threadPoolMinimum = port.getThreadPoolMinimum();
        threadPool.setMaxQueued(maximumQueueRequests);
        threadPool.setMaxThreads(threadPoolMaximum + additionalInternalThreads);
        threadPool.setMinThreads(threadPoolMinimum + additionalInternalThreads);
        int jettyAcceptorLimit = 2 * Runtime.getRuntime().availableProcessors();
        connector.setAcceptors(Math.min(Math.max(1, threadPoolMaximum / 2), jettyAcceptorLimit));
        connector.setThreadPool((ThreadPool)threadPool);
        return connector;
    }

    private SelectChannelConnector createSslConnector(final HttpPort<?> port) {
        boolean needClientCert;
        KeyStore keyStore = port.getKeyStore();
        Collection trustStores = port.getTrustStores();
        if (keyStore == null) {
            throw new IllegalConfigurationException("Key store is not configured. Cannot start management on HTTPS port without keystore");
        }
        SslContextFactory factory = new SslContextFactory(){

            public String[] selectProtocols(String[] enabledProtocols, String[] supportedProtocols) {
                return SSLUtil.filterEnabledProtocols((String[])enabledProtocols, (String[])supportedProtocols, (List)port.getTlsProtocolWhiteList(), (List)port.getTlsProtocolBlackList());
            }

            public String[] selectCipherSuites(String[] enabledCipherSuites, String[] supportedCipherSuites) {
                return SSLUtil.filterEnabledCipherSuites((String[])enabledCipherSuites, (String[])supportedCipherSuites, (List)port.getTlsCipherSuiteWhiteList(), (List)port.getTlsCipherSuiteBlackList());
            }

            public void customize(SSLEngine sslEngine) {
                super.customize(sslEngine);
                this.useCipherOrderIfPossible(sslEngine);
            }

            private void useCipherOrderIfPossible(SSLEngine sslEngine) {
                if (port.getTlsCipherSuiteWhiteList() != null && !port.getTlsCipherSuiteWhiteList().isEmpty()) {
                    SSLUtil.useCipherOrderIfPossible((SSLEngine)sslEngine);
                }
            }
        };
        boolean bl = needClientCert = port.getNeedClientAuth() || port.getWantClientAuth();
        if (needClientCert && trustStores.isEmpty()) {
            throw new IllegalConfigurationException("Client certificate authentication is enabled on AMQP port '" + this.getName() + "' but no trust store defined");
        }
        try {
            TrustManager[] trustManagers;
            SSLContext sslContext = SSLUtil.tryGetSSLContext();
            KeyManager[] keyManagers = keyStore.getKeyManagers();
            if (trustStores == null || trustStores.isEmpty()) {
                trustManagers = null;
            } else if (trustStores.size() == 1) {
                trustManagers = ((TrustStore)trustStores.iterator().next()).getTrustManagers();
            } else {
                ArrayList<TrustManager> trustManagerList = new ArrayList<TrustManager>();
                QpidMultipleTrustManager mulTrustManager = new QpidMultipleTrustManager();
                for (TrustStore ts : trustStores) {
                    TrustManager[] managers = ts.getTrustManagers();
                    if (managers == null) continue;
                    for (TrustManager manager : managers) {
                        if (manager instanceof X509TrustManager) {
                            mulTrustManager.addTrustManager((X509TrustManager)manager);
                            continue;
                        }
                        trustManagerList.add(manager);
                    }
                }
                if (!mulTrustManager.isEmpty()) {
                    trustManagerList.add((TrustManager)mulTrustManager);
                }
                trustManagers = trustManagerList.toArray(new TrustManager[trustManagerList.size()]);
            }
            sslContext.init(keyManagers, trustManagers, null);
            factory.setSslContext(sslContext);
            if (port.getNeedClientAuth()) {
                factory.setNeedClientAuth(true);
            } else if (port.getWantClientAuth()) {
                factory.setWantClientAuth(true);
            }
        }
        catch (GeneralSecurityException e) {
            throw new ServerScopedRuntimeException("Cannot configure port " + port.getName() + " for transport " + Transport.SSL, (Throwable)e);
        }
        TcpAndSslSelectChannelConnector connector = port.getTransports().contains(Transport.TCP) ? new TcpAndSslSelectChannelConnector(factory){

            @Override
            public void customize(EndPoint endpoint, Request request) throws IOException {
                super.customize(endpoint, request);
                request.setAttribute(HttpManagement.PORT_SERVLET_ATTRIBUTE, (Object)port);
            }

            public void open() throws IOException {
                try {
                    super.open();
                }
                catch (BindException e) {
                    InetSocketAddress addr = this.getHost() == null ? new InetSocketAddress(this.getPort()) : new InetSocketAddress(this.getHost(), this.getPort());
                    throw new PortBindFailureException(addr);
                }
            }
        } : new SslSelectChannelConnector(factory){

            public void customize(EndPoint endpoint, Request request) throws IOException {
                super.customize(endpoint, request);
                request.setAttribute(HttpManagement.PORT_SERVLET_ATTRIBUTE, (Object)port);
            }

            public void open() throws IOException {
                try {
                    super.open();
                }
                catch (BindException e) {
                    InetSocketAddress addr = this.getHost() == null ? new InetSocketAddress(this.getPort()) : new InetSocketAddress(this.getHost(), this.getPort());
                    throw new PortBindFailureException(addr);
                }
            }
        };
        return connector;
    }

    /*
     * WARNING - void declaration
     */
    private void addRestServlet(ServletContextHandler root, Class<? extends ConfiguredObject> rootClass) {
        HashSet<Class<? extends ConfiguredObject>> categories = new HashSet<Class<? extends ConfiguredObject>>(this.getModel().getDescendantCategories(rootClass));
        categories.add(rootClass);
        for (Class clazz : categories) {
            String name = clazz.getSimpleName().toLowerCase();
            ArrayList<Class> hierarchyList = new ArrayList<Class>();
            if (clazz != rootClass) {
                void var5_5;
                Collection parentCategories;
                hierarchyList.add(clazz);
                while (!(parentCategories = this.getModel().getParentTypes((Class)var5_5)).contains(rootClass)) {
                    hierarchyList.addAll(parentCategories);
                    Class clazz2 = (Class)parentCategories.iterator().next();
                }
                Collections.reverse(hierarchyList);
            }
            Class[] hierarchyArray = hierarchyList.toArray(new Class[hierarchyList.size()]);
            ServletHolder servletHolder = new ServletHolder(name, (Servlet)new RestServlet(hierarchyArray));
            servletHolder.getRegistration().setMultipartConfig(new MultipartConfigElement("", ((Long)this.getContextValue(Long.class, "maxHttpFileUploadSize")).longValue(), -1L, ((Integer)this.getContextValue(Integer.class, "maxHttpFileUploadSize")).intValue()));
            List<String> paths = Arrays.asList("/api/latest/" + name, "/api/v6.1/" + name);
            for (String path : paths) {
                root.addServlet(servletHolder, path + "/*");
            }
            ServletHolder docServletHolder = new ServletHolder(name + "docs", (Servlet)new ApiDocsServlet(this.getModel(), paths, hierarchyArray));
            root.addServlet(docServletHolder, "/apidocs/latest/" + name + "/");
            root.addServlet(docServletHolder, "/apidocs/v6.1/" + name + "/");
            root.addServlet(docServletHolder, "/apidocs/latest/" + name);
            root.addServlet(docServletHolder, "/apidocs/v6.1/" + name);
        }
        ServletHolder versionsServletHolder = new ServletHolder((Servlet)new JsonValueServlet(this.getApiProperties()));
        root.addServlet(versionsServletHolder, "/api");
        root.addServlet(versionsServletHolder, "/api/");
    }

    private Map<String, Object> getApiProperties() {
        return Collections.singletonMap("supportedVersions", this.getSupportedRestApiVersions());
    }

    private List<String> getSupportedRestApiVersions() {
        return Collections.singletonList(this.getLatestSupportedVersion());
    }

    private String getLatestSupportedVersion() {
        return "v" + String.valueOf("6.1");
    }

    private void logOperationalListenMessages() {
        for (Map.Entry<HttpPort<?>, Connector> portConnector : this._portConnectorMap.entrySet()) {
            HttpPort<?> port = portConnector.getKey();
            Connector connector = portConnector.getValue();
            Set transports = port.getTransports();
            for (Transport transport : transports) {
                this.getBroker().getEventLogger().message(ManagementConsoleMessages.LISTENING((String)Protocol.HTTP.name(), (String)transport.name(), (Number)connector.getLocalPort()));
            }
        }
    }

    private void logOperationalShutdownMessage() {
        for (Connector connector : this._portConnectorMap.values()) {
            this.getBroker().getEventLogger().message(ManagementConsoleMessages.SHUTTING_DOWN((String)Protocol.HTTP.name(), (Number)connector.getLocalPort()));
        }
    }

    private Collection<HttpPort<?>> getEligibleHttpPorts(Collection<Port<?>> ports) {
        HashSet<HttpPort> httpPorts = new HashSet<HttpPort>();
        for (Port<?> port : ports) {
            if (State.ACTIVE != port.getDesiredState() || State.ERRORED == port.getState() || !port.getProtocols().contains(Protocol.HTTP)) continue;
            httpPorts.add((HttpPort)port);
        }
        return Collections.unmodifiableCollection(httpPorts);
    }

    public boolean isActivationAllowed(Port<?> port) {
        return this._allowPortActivation;
    }

    @Override
    public boolean isHttpsSaslAuthenticationEnabled() {
        return this._httpsSaslAuthenticationEnabled;
    }

    @Override
    public boolean isHttpSaslAuthenticationEnabled() {
        return this._httpSaslAuthenticationEnabled;
    }

    @Override
    public boolean isHttpsBasicAuthenticationEnabled() {
        return this._httpsBasicAuthenticationEnabled;
    }

    @Override
    public boolean isHttpBasicAuthenticationEnabled() {
        return this._httpBasicAuthenticationEnabled;
    }

    @Override
    public boolean isCompressResponses() {
        return this._compressResponses;
    }

    @Override
    public AuthenticationProvider getAuthenticationProvider(HttpServletRequest request) {
        HttpPort<?> port = HttpManagement.getPort(request);
        return port == null ? null : port.getAuthenticationProvider();
    }

    public static Set<String> getAllAvailableCorsMethodCombinations() {
        List<String> methods = Arrays.asList("OPTION", "HEAD", "GET", "POST", "PUT", "DELETE");
        HashSet combinations = new HashSet();
        int n = methods.size();
        assert (n < 31) : "Too many combination to calculate";
        for (int i = 0; i < 1 << n; ++i) {
            HashSet<String> currentCombination = new HashSet<String>();
            for (int index = 0; index < n; ++index) {
                if ((i & 1 << index) == 0) continue;
                currentCombination.add(methods.get(index));
            }
            combinations.add(currentCombination);
        }
        HashSet<String> combinationsAsString = new HashSet<String>(combinations.size());
        ObjectMapper mapper = new ObjectMapper();
        for (Set set : combinations) {
            try {
                StringWriter writer = new StringWriter();
                Throwable throwable = null;
                try {
                    mapper.writeValue((Writer)writer, (Object)set);
                    combinationsAsString.add(writer.toString());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (writer == null) continue;
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    writer.close();
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unexpected IO Exception generating JSON string", e);
            }
        }
        return Collections.unmodifiableSet(combinationsAsString);
    }

    public static HttpPort<?> getPort(HttpServletRequest request) {
        return (HttpPort)request.getAttribute(PORT_SERVLET_ATTRIBUTE);
    }

    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        int value;
        super.validateChange(proxyForValidation, changedAttributes);
        HttpManagementConfiguration updated = (HttpManagementConfiguration)proxyForValidation;
        if (changedAttributes.contains("name") && !this.getName().equals(updated.getName())) {
            throw new IllegalConfigurationException("Changing the name of http management plugin is not allowed");
        }
        if (changedAttributes.contains(TIME_OUT) && (value = updated.getSessionTimeout()) < 0) {
            throw new IllegalConfigurationException("Only positive integer value can be specified for the session time out attribute");
        }
    }

    private static class ZeroSizedThreadPool
    implements ThreadPool {
        private ZeroSizedThreadPool() {
        }

        public boolean dispatch(Runnable job) {
            throw new IllegalStateException("Job unexpectedly dispatched to server thread pool. Cannot dispatch");
        }

        public void join() throws InterruptedException {
        }

        public int getThreads() {
            return 0;
        }

        public int getIdleThreads() {
            return 0;
        }

        public boolean isLowOnThreads() {
            return false;
        }
    }
}

