/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.jdbc;

import java.security.Principal;
import java.util.Map;
import org.apache.qpid.server.configuration.updater.TaskExecutor;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.model.AbstractSystemConfig;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.SystemConfigFactoryConstructor;
import org.apache.qpid.server.store.DurableConfigurationStore;
import org.apache.qpid.server.store.jdbc.GenericJDBCConfigurationStore;
import org.apache.qpid.server.store.jdbc.JDBCSystemConfig;

@ManagedObject(category=false, type="JDBC")
public class JDBCSystemConfigImpl
extends AbstractSystemConfig<JDBCSystemConfigImpl>
implements JDBCSystemConfig<JDBCSystemConfigImpl> {
    public static final String SYSTEM_CONFIG_TYPE = "JDBC";
    @ManagedAttributeField
    private String _connectionUrl;
    @ManagedAttributeField
    private String _connectionPoolType;
    @ManagedAttributeField
    private String _username;
    @ManagedAttributeField
    private String _password;

    @SystemConfigFactoryConstructor
    public JDBCSystemConfigImpl(TaskExecutor taskExecutor, EventLogger eventLogger, Principal systemPrincipal, Map<String, Object> attributes) {
        super(taskExecutor, eventLogger, systemPrincipal, attributes);
    }

    protected DurableConfigurationStore createStoreObject() {
        return new GenericJDBCConfigurationStore(Broker.class);
    }

    @Override
    public String getConnectionUrl() {
        return this._connectionUrl;
    }

    @Override
    public String getConnectionPoolType() {
        return this._connectionPoolType;
    }

    @Override
    public String getUsername() {
        return this._username;
    }

    @Override
    public String getPassword() {
        return this._password;
    }
}

