/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime;

import java.util.Optional;
import org.apache.pulsar.common.util.Reflections;
import org.apache.pulsar.functions.auth.FunctionAuthProvider;
import org.apache.pulsar.functions.instance.AuthenticationConfig;
import org.apache.pulsar.functions.instance.InstanceConfig;
import org.apache.pulsar.functions.proto.Function;
import org.apache.pulsar.functions.runtime.Runtime;
import org.apache.pulsar.functions.runtime.RuntimeCustomizer;
import org.apache.pulsar.functions.secretsproviderconfigurator.SecretsProviderConfigurator;
import org.apache.pulsar.functions.worker.ConnectorsManager;
import org.apache.pulsar.functions.worker.FunctionsManager;
import org.apache.pulsar.functions.worker.WorkerConfig;

public interface RuntimeFactory
extends AutoCloseable {
    public void initialize(WorkerConfig var1, AuthenticationConfig var2, SecretsProviderConfigurator var3, ConnectorsManager var4, FunctionsManager var5, Optional<FunctionAuthProvider> var6, Optional<RuntimeCustomizer> var7) throws Exception;

    public Runtime createContainer(InstanceConfig var1, String var2, String var3, Long var4) throws Exception;

    default public boolean externallyManaged() {
        return false;
    }

    default public void doAdmissionChecks(Function.FunctionDetails functionDetails) {
    }

    default public Optional<? extends FunctionAuthProvider> getAuthProvider() {
        return Optional.empty();
    }

    default public Optional<? extends RuntimeCustomizer> getRuntimeCustomizer() {
        return Optional.empty();
    }

    @Override
    public void close();

    public static RuntimeFactory getFuntionRuntimeFactory(String className) {
        return (RuntimeFactory)Reflections.createInstance((String)className, RuntimeFactory.class, (ClassLoader)Thread.currentThread().getContextClassLoader());
    }
}

