/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.client.api.schema.SchemaInfoProvider;
import org.apache.pulsar.client.api.schema.SchemaReader;
import org.apache.pulsar.client.api.schema.SchemaWriter;
import org.apache.pulsar.client.impl.schema.AbstractSchema;
import org.apache.pulsar.client.impl.schema.reader.AbstractMultiVersionReader;
import org.apache.pulsar.common.protocol.schema.BytesSchemaVersion;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.ByteBufInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStructSchema<T>
extends AbstractSchema<T> {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractStructSchema.class);
    protected final SchemaInfo schemaInfo;
    protected SchemaReader<T> reader;
    protected SchemaWriter<T> writer;
    protected SchemaInfoProvider schemaInfoProvider;

    public AbstractStructSchema(SchemaInfo schemaInfo) {
        this.schemaInfo = schemaInfo;
    }

    public byte[] encode(T message) {
        return this.writer.write(message);
    }

    public T decode(byte[] bytes) {
        return (T)this.reader.read(bytes);
    }

    public T decode(byte[] bytes, byte[] schemaVersion) {
        return (T)this.reader.read(bytes, schemaVersion);
    }

    @Override
    public T decode(ByteBuf byteBuf) {
        return (T)this.reader.read((InputStream)new ByteBufInputStream(byteBuf));
    }

    @Override
    public T decode(ByteBuf byteBuf, byte[] schemaVersion) {
        return (T)this.reader.read((InputStream)new ByteBufInputStream(byteBuf), schemaVersion);
    }

    public SchemaInfo getSchemaInfo() {
        return this.schemaInfo;
    }

    public void setSchemaInfoProvider(SchemaInfoProvider schemaInfoProvider) {
        if (this.reader != null) {
            this.reader.setSchemaInfoProvider(schemaInfoProvider);
        }
        this.schemaInfoProvider = schemaInfoProvider;
    }

    @Override
    public Schema<T> atSchemaVersion(byte[] schemaVersion) throws SchemaSerializationException {
        Objects.requireNonNull(schemaVersion);
        if (this.schemaInfoProvider == null) {
            return this;
        }
        try {
            SchemaInfo schemaInfo = (SchemaInfo)this.schemaInfoProvider.getSchemaByVersion(schemaVersion).get();
            if (schemaInfo == null) {
                throw new SchemaSerializationException("Unknown version " + BytesSchemaVersion.of(schemaVersion));
            }
            return this.getAbstractStructSchemaAtVersion(schemaVersion, schemaInfo);
        }
        catch (ExecutionException err) {
            throw new SchemaSerializationException(err.getCause());
        }
        catch (InterruptedException err) {
            Thread.currentThread().interrupt();
            throw new SchemaSerializationException((Throwable)err);
        }
    }

    private AbstractStructSchema<T> getAbstractStructSchemaAtVersion(byte[] schemaVersion, SchemaInfo schemaInfo) {
        return new WrappedVersionedSchema(schemaInfo, schemaVersion, this);
    }

    protected void setWriter(SchemaWriter<T> writer) {
        this.writer = writer;
    }

    protected void setReader(SchemaReader<T> reader) {
        this.reader = reader;
    }

    protected SchemaReader<T> getReader() {
        return this.reader;
    }

    private static class WrappedVersionedSchema<T>
    extends AbstractStructSchema<T> {
        private final byte[] schemaVersion;
        private final AbstractStructSchema<T> parent;

        public WrappedVersionedSchema(SchemaInfo schemaInfo, byte[] schemaVersion, AbstractStructSchema<T> parent) {
            super(schemaInfo);
            this.schemaVersion = schemaVersion;
            this.writer = null;
            this.reader = parent.reader;
            this.schemaInfoProvider = parent.schemaInfoProvider;
            this.parent = parent;
        }

        public boolean requireFetchingSchemaInfo() {
            return true;
        }

        @Override
        public T decode(byte[] bytes) {
            return this.decode(bytes, this.schemaVersion);
        }

        @Override
        public T decode(ByteBuf byteBuf) {
            return this.decode(byteBuf, this.schemaVersion);
        }

        @Override
        public byte[] encode(T message) {
            throw new UnsupportedOperationException("This schema is not meant to be used for encoding");
        }

        public Optional<Object> getNativeSchema() {
            if (this.reader instanceof AbstractMultiVersionReader) {
                AbstractMultiVersionReader abstractMultiVersionReader = (AbstractMultiVersionReader)this.reader;
                try {
                    SchemaReader schemaReader = abstractMultiVersionReader.getSchemaReader(this.schemaVersion);
                    return schemaReader.getNativeSchema();
                }
                catch (ExecutionException err) {
                    throw new RuntimeException(err.getCause());
                }
            }
            return Optional.empty();
        }

        public String toString() {
            return "VersionedSchema(type=" + this.schemaInfo.getType() + ",schemaVersion=" + BytesSchemaVersion.of(this.schemaVersion) + ",name=" + this.schemaInfo.getName() + ")";
        }
    }
}

