/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.conf;

import java.io.Serializable;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.apache.pulsar.client.impl.conf.ConsumerConfigurationData;

public class TopicConsumerConfigurationData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private TopicNameMatcher topicNameMatcher;
    private int priorityLevel;

    public static TopicConsumerConfigurationData ofTopicsPattern(@NonNull Pattern topicsPattern, int priorityLevel) {
        if (topicsPattern == null) {
            throw new NullPointerException("topicsPattern is marked non-null but is null");
        }
        return TopicConsumerConfigurationData.of(new TopicNameMatcher.TopicsPattern(topicsPattern), priorityLevel);
    }

    public static TopicConsumerConfigurationData ofTopicsPattern(@NonNull Pattern topicsPattern, ConsumerConfigurationData<?> conf) {
        if (topicsPattern == null) {
            throw new NullPointerException("topicsPattern is marked non-null but is null");
        }
        return TopicConsumerConfigurationData.ofTopicsPattern(topicsPattern, conf.getPriorityLevel());
    }

    public static TopicConsumerConfigurationData ofTopicName(@NonNull String topicName, int priorityLevel) {
        if (topicName == null) {
            throw new NullPointerException("topicName is marked non-null but is null");
        }
        return TopicConsumerConfigurationData.of(new TopicNameMatcher.TopicName(topicName), priorityLevel);
    }

    public static TopicConsumerConfigurationData ofTopicName(@NonNull String topicName, ConsumerConfigurationData<?> conf) {
        if (topicName == null) {
            throw new NullPointerException("topicName is marked non-null but is null");
        }
        return TopicConsumerConfigurationData.ofTopicName(topicName, conf.getPriorityLevel());
    }

    static TopicConsumerConfigurationData of(@NonNull TopicNameMatcher topicNameMatcher, int priorityLevel) {
        if (topicNameMatcher == null) {
            throw new NullPointerException("topicNameMatcher is marked non-null but is null");
        }
        return new TopicConsumerConfigurationData(topicNameMatcher, priorityLevel);
    }

    public TopicNameMatcher getTopicNameMatcher() {
        return this.topicNameMatcher;
    }

    public int getPriorityLevel() {
        return this.priorityLevel;
    }

    public void setTopicNameMatcher(TopicNameMatcher topicNameMatcher) {
        this.topicNameMatcher = topicNameMatcher;
    }

    public void setPriorityLevel(int priorityLevel) {
        this.priorityLevel = priorityLevel;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TopicConsumerConfigurationData)) {
            return false;
        }
        TopicConsumerConfigurationData other = (TopicConsumerConfigurationData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPriorityLevel() != other.getPriorityLevel()) {
            return false;
        }
        TopicNameMatcher this$topicNameMatcher = this.getTopicNameMatcher();
        TopicNameMatcher other$topicNameMatcher = other.getTopicNameMatcher();
        return !(this$topicNameMatcher == null ? other$topicNameMatcher != null : !this$topicNameMatcher.equals(other$topicNameMatcher));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TopicConsumerConfigurationData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPriorityLevel();
        TopicNameMatcher $topicNameMatcher = this.getTopicNameMatcher();
        result = result * 59 + ($topicNameMatcher == null ? 43 : $topicNameMatcher.hashCode());
        return result;
    }

    public String toString() {
        return "TopicConsumerConfigurationData(topicNameMatcher=" + this.getTopicNameMatcher() + ", priorityLevel=" + this.getPriorityLevel() + ")";
    }

    public TopicConsumerConfigurationData() {
    }

    public TopicConsumerConfigurationData(TopicNameMatcher topicNameMatcher, int priorityLevel) {
        this.topicNameMatcher = topicNameMatcher;
        this.priorityLevel = priorityLevel;
    }

    public static interface TopicNameMatcher
    extends Serializable {
        public boolean matches(String var1);

        public static class TopicName
        implements TopicNameMatcher {
            @NonNull
            private final String topicName;

            @Override
            public boolean matches(String topicName) {
                return this.topicName.equals(topicName);
            }

            public TopicName(@NonNull String topicName) {
                if (topicName == null) {
                    throw new NullPointerException("topicName is marked non-null but is null");
                }
                this.topicName = topicName;
            }
        }

        public static class TopicsPattern
        implements TopicNameMatcher {
            @NonNull
            private final Pattern topicsPattern;

            @Override
            public boolean matches(String topicName) {
                return this.topicsPattern.matcher(topicName).matches();
            }

            public TopicsPattern(@NonNull Pattern topicsPattern) {
                if (topicsPattern == null) {
                    throw new NullPointerException("topicsPattern is marked non-null but is null");
                }
                this.topicsPattern = topicsPattern;
            }
        }
    }
}

