/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.Worker;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.common.functions.WorkerInfo;
import org.apache.pulsar.common.policies.data.WorkerFunctionInstanceStats;
import org.apache.pulsar.common.stats.Metrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerImpl
extends BaseResource
implements Worker {
    private static final Logger log = LoggerFactory.getLogger(WorkerImpl.class);
    private final WebTarget workerStats;
    private final WebTarget worker;

    public WorkerImpl(WebTarget web, Authentication auth, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.worker = web.path("/admin/v2/worker");
        this.workerStats = web.path("/admin/v2/worker-stats");
    }

    public List<WorkerFunctionInstanceStats> getFunctionsStats() throws PulsarAdminException {
        return (List)this.sync(() -> this.getFunctionsStatsAsync());
    }

    public CompletableFuture<List<WorkerFunctionInstanceStats>> getFunctionsStatsAsync() {
        WebTarget path = this.workerStats.path("functionsmetrics");
        final CompletableFuture<List<WorkerFunctionInstanceStats>> future = new CompletableFuture<List<WorkerFunctionInstanceStats>>();
        this.asyncGetRequest(path, new InvocationCallback<Response>(){

            public void completed(Response response) {
                if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                    future.completeExceptionally((Throwable)new ClientErrorException(response));
                } else {
                    List metricsList = (List)response.readEntity((GenericType)new GenericType<List<WorkerFunctionInstanceStats>>(){});
                    future.complete(metricsList);
                }
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(BaseResource.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public Collection<Metrics> getMetrics() throws PulsarAdminException {
        return (Collection)this.sync(() -> this.getMetricsAsync());
    }

    public CompletableFuture<Collection<Metrics>> getMetricsAsync() {
        WebTarget path = this.workerStats.path("metrics");
        final CompletableFuture<Collection<Metrics>> future = new CompletableFuture<Collection<Metrics>>();
        this.asyncGetRequest(path, new InvocationCallback<Response>(){

            public void completed(Response response) {
                if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                    future.completeExceptionally((Throwable)new ClientErrorException(response));
                } else {
                    future.complete((Collection)response.readEntity((GenericType)new GenericType<List<Metrics>>(){}));
                }
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(BaseResource.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public List<WorkerInfo> getCluster() throws PulsarAdminException {
        return (List)this.sync(() -> this.getClusterAsync());
    }

    public CompletableFuture<List<WorkerInfo>> getClusterAsync() {
        WebTarget path = this.worker.path("cluster");
        final CompletableFuture<List<WorkerInfo>> future = new CompletableFuture<List<WorkerInfo>>();
        this.asyncGetRequest(path, new InvocationCallback<Response>(){

            public void completed(Response response) {
                if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                    future.completeExceptionally((Throwable)new ClientErrorException(response));
                } else {
                    future.complete((List)response.readEntity((GenericType)new GenericType<List<WorkerInfo>>(){}));
                }
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(BaseResource.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public WorkerInfo getClusterLeader() throws PulsarAdminException {
        return (WorkerInfo)this.sync(() -> this.getClusterLeaderAsync());
    }

    public CompletableFuture<WorkerInfo> getClusterLeaderAsync() {
        WebTarget path = this.worker.path("cluster").path("leader");
        final CompletableFuture<WorkerInfo> future = new CompletableFuture<WorkerInfo>();
        this.asyncGetRequest(path, new InvocationCallback<Response>(){

            public void completed(Response response) {
                if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                    future.completeExceptionally((Throwable)new ClientErrorException(response));
                } else {
                    future.complete((WorkerInfo)response.readEntity((GenericType)new GenericType<WorkerInfo>(){}));
                }
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(BaseResource.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public Map<String, Collection<String>> getAssignments() throws PulsarAdminException {
        return (Map)this.sync(() -> this.getAssignmentsAsync());
    }

    public CompletableFuture<Map<String, Collection<String>>> getAssignmentsAsync() {
        WebTarget path = this.worker.path("assignments");
        final CompletableFuture<Map<String, Collection<String>>> future = new CompletableFuture<Map<String, Collection<String>>>();
        this.asyncGetRequest(path, new InvocationCallback<Response>(){

            public void completed(Response response) {
                if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                    future.completeExceptionally((Throwable)new ClientErrorException(response));
                } else {
                    future.complete((Map)response.readEntity((GenericType)new GenericType<Map<String, Collection<String>>>(){}));
                }
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(BaseResource.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void rebalance() throws PulsarAdminException {
        this.sync(this::rebalanceAsync);
    }

    public CompletableFuture<Void> rebalanceAsync() {
        WebTarget path = this.worker.path("rebalance");
        return this.asyncPutRequest(path, Entity.entity((Object)"", (String)"application/json"));
    }
}

