/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminBuilder;
import org.apache.pulsar.client.admin.internal.PulsarAdminImpl;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationFactory;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.client.impl.conf.ConfigurationDataUtils;

public class PulsarAdminBuilderImpl
implements PulsarAdminBuilder {
    protected ClientConfigurationData conf;
    private int connectTimeout = 60;
    private int readTimeout = 60;
    private int requestTimeout = 300;
    private int autoCertRefreshTime = 300;
    private TimeUnit connectTimeoutUnit = TimeUnit.SECONDS;
    private TimeUnit readTimeoutUnit = TimeUnit.SECONDS;
    private TimeUnit requestTimeoutUnit = TimeUnit.SECONDS;
    private TimeUnit autoCertRefreshTimeUnit = TimeUnit.SECONDS;
    private ClassLoader clientBuilderClassLoader = null;

    public PulsarAdmin build() throws PulsarClientException {
        return new PulsarAdminImpl(this.conf.getServiceUrl(), this.conf, this.connectTimeout, this.connectTimeoutUnit, this.readTimeout, this.readTimeoutUnit, this.requestTimeout, this.requestTimeoutUnit, this.autoCertRefreshTime, this.autoCertRefreshTimeUnit, this.clientBuilderClassLoader);
    }

    public PulsarAdminBuilderImpl() {
        this.conf = new ClientConfigurationData();
    }

    private PulsarAdminBuilderImpl(ClientConfigurationData conf) {
        this.conf = conf;
    }

    public PulsarAdminBuilder clone() {
        return new PulsarAdminBuilderImpl(this.conf.clone());
    }

    public PulsarAdminBuilder loadConf(Map<String, Object> config) {
        this.conf = (ClientConfigurationData)ConfigurationDataUtils.loadData(config, (Object)this.conf, ClientConfigurationData.class);
        return this;
    }

    public PulsarAdminBuilder serviceHttpUrl(String serviceHttpUrl) {
        this.conf.setServiceUrl(serviceHttpUrl);
        return this;
    }

    public PulsarAdminBuilder authentication(Authentication authentication) {
        this.conf.setAuthentication(authentication);
        return this;
    }

    public PulsarAdminBuilder authentication(String authPluginClassName, Map<String, String> authParams) throws PulsarClientException.UnsupportedAuthenticationException {
        this.conf.setAuthentication(AuthenticationFactory.create((String)authPluginClassName, authParams));
        return this;
    }

    public PulsarAdminBuilder authentication(String authPluginClassName, String authParamsString) throws PulsarClientException.UnsupportedAuthenticationException {
        this.conf.setAuthentication(AuthenticationFactory.create((String)authPluginClassName, (String)authParamsString));
        return this;
    }

    public PulsarAdminBuilder tlsKeyFilePath(String tlsKeyFilePath) {
        this.conf.setTlsKeyFilePath(tlsKeyFilePath);
        return this;
    }

    public PulsarAdminBuilder tlsCertificateFilePath(String tlsCertificateFilePath) {
        this.conf.setTlsCertificateFilePath(tlsCertificateFilePath);
        return this;
    }

    public PulsarAdminBuilder tlsTrustCertsFilePath(String tlsTrustCertsFilePath) {
        this.conf.setTlsTrustCertsFilePath(tlsTrustCertsFilePath);
        return this;
    }

    public PulsarAdminBuilder allowTlsInsecureConnection(boolean allowTlsInsecureConnection) {
        this.conf.setTlsAllowInsecureConnection(allowTlsInsecureConnection);
        return this;
    }

    public PulsarAdminBuilder enableTlsHostnameVerification(boolean enableTlsHostnameVerification) {
        this.conf.setTlsHostnameVerificationEnable(enableTlsHostnameVerification);
        return this;
    }

    public PulsarAdminBuilder useKeyStoreTls(boolean useKeyStoreTls) {
        this.conf.setUseKeyStoreTls(useKeyStoreTls);
        return this;
    }

    public PulsarAdminBuilder sslProvider(String sslProvider) {
        this.conf.setSslProvider(sslProvider);
        return this;
    }

    public PulsarAdminBuilder tlsKeyStoreType(String tlsKeyStoreType) {
        this.conf.setTlsKeyStoreType(tlsKeyStoreType);
        return this;
    }

    public PulsarAdminBuilder tlsKeyStorePath(String tlsTrustStorePath) {
        this.conf.setTlsKeyStorePath(tlsTrustStorePath);
        return this;
    }

    public PulsarAdminBuilder tlsKeyStorePassword(String tlsKeyStorePassword) {
        this.conf.setTlsKeyStorePassword(tlsKeyStorePassword);
        return this;
    }

    public PulsarAdminBuilder tlsTrustStoreType(String tlsTrustStoreType) {
        this.conf.setTlsTrustStoreType(tlsTrustStoreType);
        return this;
    }

    public PulsarAdminBuilder tlsTrustStorePath(String tlsTrustStorePath) {
        this.conf.setTlsTrustStorePath(tlsTrustStorePath);
        return this;
    }

    public PulsarAdminBuilder tlsTrustStorePassword(String tlsTrustStorePassword) {
        this.conf.setTlsTrustStorePassword(tlsTrustStorePassword);
        return this;
    }

    public PulsarAdminBuilder tlsCiphers(Set<String> tlsCiphers) {
        this.conf.setTlsCiphers(tlsCiphers);
        return this;
    }

    public PulsarAdminBuilder tlsProtocols(Set<String> tlsProtocols) {
        this.conf.setTlsProtocols(tlsProtocols);
        return this;
    }

    public PulsarAdminBuilder connectionTimeout(int connectionTimeout, TimeUnit connectionTimeoutUnit) {
        this.connectTimeout = connectionTimeout;
        this.connectTimeoutUnit = connectionTimeoutUnit;
        return this;
    }

    public PulsarAdminBuilder readTimeout(int readTimeout, TimeUnit readTimeoutUnit) {
        this.readTimeout = readTimeout;
        this.readTimeoutUnit = readTimeoutUnit;
        return this;
    }

    public PulsarAdminBuilder requestTimeout(int requestTimeout, TimeUnit requestTimeoutUnit) {
        this.requestTimeout = requestTimeout;
        this.requestTimeoutUnit = requestTimeoutUnit;
        return this;
    }

    public PulsarAdminBuilder autoCertRefreshTime(int autoCertRefreshTime, TimeUnit autoCertRefreshTimeUnit) {
        this.autoCertRefreshTime = autoCertRefreshTime;
        this.autoCertRefreshTimeUnit = autoCertRefreshTimeUnit;
        return this;
    }

    public PulsarAdminBuilder setContextClassLoader(ClassLoader clientBuilderClassLoader) {
        this.clientBuilderClassLoader = clientBuilderClassLoader;
        return this;
    }
}

