/*
 * Decompiled with CFR 0.152.
 */
package org.openxml4j.opc.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.openxml4j.opc.internal.MemoryPackagePart;

public final class MemoryPackagePartOutputStream
extends OutputStream {
    private MemoryPackagePart part;
    private ByteArrayOutputStream buff;

    public MemoryPackagePartOutputStream(MemoryPackagePart part) {
        this.part = part;
        this.buff = new ByteArrayOutputStream();
    }

    public void write(int b) throws IOException {
        this.buff.write(b);
    }

    public void close() throws IOException {
        this.flush();
    }

    public void flush() throws IOException {
        this.buff.flush();
        if (this.part.data != null) {
            byte[] newArray = new byte[this.part.data.length + this.buff.size()];
            System.arraycopy(this.part.data, 0, newArray, 0, this.part.data.length);
            byte[] buffArr = this.buff.toByteArray();
            System.arraycopy(buffArr, 0, newArray, this.part.data.length, buffArr.length);
            this.part.data = newArray;
        } else {
            this.part.data = this.buff.toByteArray();
        }
        this.buff.reset();
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.buff.write(b, off, len);
    }

    public void write(byte[] b) throws IOException {
        this.buff.write(b);
    }
}

