/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.ui;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public final class ImageUtil {
    private ImageUtil() {
    }

    public static BufferedImage getRotatedImage(BufferedImage image, int rotation) {
        BufferedImage rotatedImage;
        int width = image.getWidth();
        int height = image.getHeight();
        double x = 0.0;
        double y = 0.0;
        switch (rotation % 360) {
            case 90: {
                x = height;
                rotatedImage = new BufferedImage(height, width, 1);
                break;
            }
            case 270: {
                y = width;
                rotatedImage = new BufferedImage(height, width, 1);
                break;
            }
            case 180: {
                x = width;
                y = height;
                rotatedImage = new BufferedImage(width, height, 1);
                break;
            }
            default: {
                return image;
            }
        }
        Graphics2D g = (Graphics2D)rotatedImage.getGraphics();
        g.translate(x, y);
        g.rotate(Math.toRadians(rotation));
        g.drawImage((Image)image, 0, 0, null);
        g.dispose();
        return rotatedImage;
    }
}

