/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ear;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import org.apache.maven.plugin.ear.EarPluginException;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

abstract class AbstractXmlWriter {
    private final String encoding;
    protected static final String MODULE_ELEMENT = "module";
    protected static final String SERVICE_ELEMENT = "service";

    AbstractXmlWriter(String encoding) {
        this.encoding = encoding;
    }

    protected Writer initializeWriter(File destinationFile) throws EarPluginException {
        try {
            return WriterFactory.newXmlWriter((File)destinationFile);
        }
        catch (IOException ex) {
            throw new EarPluginException("Exception while opening file[" + destinationFile.getAbsolutePath() + "]", ex);
        }
    }

    protected XMLWriter initializeXmlWriter(Writer writer, String docType) {
        return new PrettyPrintXMLWriter(writer, this.encoding, docType);
    }

    protected void close(Writer closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getEncoding() {
        return this.encoding;
    }
}

