/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.inject;

import com.google.inject.MembersInjector;
import java.util.List;
import org.sonatype.guice.bean.inject.PropertyBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BeanInjector<B>
implements MembersInjector<B> {
    private static final ThreadLocal<boolean[]> isInjectingHolder = new ThreadLocal<boolean[]>(){

        @Override
        protected boolean[] initialValue() {
            return new boolean[]{false};
        }
    };
    private final PropertyBinding[] bindings;

    BeanInjector(List<PropertyBinding> bindings) {
        int size = bindings.size();
        this.bindings = new PropertyBinding[size];
        int i = 0;
        int n = size;
        while (i < size) {
            this.bindings[i++] = bindings.get(--n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void injectMembers(B bean) {
        boolean[] isInjecting = isInjectingHolder.get();
        if (!isInjecting[0]) {
            isInjecting[0] = true;
            try {
                this.doInjection(bean);
            }
            finally {
                isInjecting[0] = false;
            }
        } else {
            this.doInjection(bean);
        }
    }

    static boolean isInjecting() {
        return isInjectingHolder.get()[0];
    }

    private void doInjection(Object bean) {
        for (PropertyBinding b : this.bindings) {
            b.injectProperty(bean);
        }
    }
}

