/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.tools.cli;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.tools.cli.Cli;

public abstract class AbstractCli
implements Cli {
    public static final char QUIET = 'q';
    public static final char DEBUG = 'X';
    public static final char ERRORS = 'e';
    public static final char HELP = 'h';
    public static final char VERSION = 'v';
    public static final char SET_SYSTEM_PROPERTY = 'D';
    private Options options;
    static /* synthetic */ Class class$org$codehaus$plexus$tools$cli$AbstractCli;

    public abstract Options buildCliOptions(Options var1);

    public abstract void invokePlexusComponent(CommandLine var1, PlexusContainer var2) throws Exception;

    public String getPomPropertiesPath() {
        return null;
    }

    public int execute(String[] args) {
        ClassWorld classWorld = new ClassWorld("plexus.core", Thread.currentThread().getContextClassLoader());
        return this.execute(args, classWorld);
    }

    public int execute(String[] args, ClassWorld classWorld) {
        boolean showErrors;
        CommandLine cli;
        try {
            cli = this.parse(args);
        }
        catch (ParseException e) {
            System.err.println("Unable to parse command line options: " + e.getMessage());
            this.displayHelp();
            return 1;
        }
        if (System.getProperty("java.class.version", "44.0").compareTo("48.0") < 0) {
            System.err.println("Sorry, but JDK 1.4 or above is required to execute Maven");
            System.err.println("You appear to be using Java version: " + System.getProperty("java.version", "<unknown>"));
            return 1;
        }
        boolean debug = cli.hasOption('X');
        boolean quiet = !debug && cli.hasOption('q');
        boolean bl = showErrors = debug || cli.hasOption('e');
        if (showErrors) {
            System.out.println("+ Error stacktraces are turned on.");
        }
        if (debug) {
            boolean loggingLevel = false;
        } else if (quiet) {
            boolean loggingLevel = false;
        } else {
            boolean loggingLevel = false;
        }
        if (cli.hasOption('h')) {
            this.displayHelp();
            return 0;
        }
        if (cli.hasOption('v')) {
            this.showVersion();
            return 0;
        }
        if (debug) {
            this.showVersion();
        }
        try {
            ContainerConfiguration configuration = new DefaultContainerConfiguration().setClassWorld(classWorld);
            DefaultPlexusContainer plexus = new DefaultPlexusContainer(configuration);
            this.invokePlexusComponent(cli, plexus);
        }
        catch (PlexusContainerException e) {
            this.showFatalError("Cannot create Plexus container.", e, true);
        }
        catch (ComponentLookupException e) {
            this.showError("Cannot lookup application component.", e, true);
        }
        catch (Exception e) {
            this.showError("Problem executing command line.", e, true);
        }
        return 0;
    }

    protected int showFatalError(String message, Exception e, boolean show) {
        System.err.println("FATAL ERROR: " + message);
        if (show) {
            System.err.println("Error stacktrace:");
            e.printStackTrace();
        } else {
            System.err.println("For more information, run with the -e flag");
        }
        return 1;
    }

    protected void showError(String message, Exception e, boolean show) {
        System.err.println(message);
        if (show) {
            System.err.println("Error stacktrace:");
            e.printStackTrace();
        }
    }

    private void showVersion() {
        try {
            Properties properties = new Properties();
            String pomPropertiesPath = this.getPomPropertiesPath();
            if (pomPropertiesPath == null) {
                System.err.println("Unable determine version from JAR file.");
                return;
            }
            InputStream is = (class$org$codehaus$plexus$tools$cli$AbstractCli == null ? (class$org$codehaus$plexus$tools$cli$AbstractCli = AbstractCli.class$("org.codehaus.plexus.tools.cli.AbstractCli")) : class$org$codehaus$plexus$tools$cli$AbstractCli).getClassLoader().getResourceAsStream(pomPropertiesPath);
            if (is == null) {
                System.err.println("Unable determine version from JAR file.");
                return;
            }
            properties.load(is);
            if (properties.getProperty("builtOn") != null) {
                System.out.println("Version: " + properties.getProperty("version", "unknown") + " built on " + properties.getProperty("builtOn"));
            } else {
                System.out.println("Version: " + properties.getProperty("version", "unknown"));
            }
        }
        catch (IOException e) {
            System.err.println("Unable determine version from JAR file: " + e.getMessage());
        }
    }

    private Properties getExecutionProperties(CommandLine commandLine) {
        Properties executionProperties = new Properties();
        if (commandLine.hasOption('D')) {
            String[] defStrs = commandLine.getOptionValues('D');
            for (int i = 0; i < defStrs.length; ++i) {
                this.setCliProperty(defStrs[i], executionProperties);
            }
        }
        ((Hashtable)executionProperties).putAll(System.getProperties());
        return executionProperties;
    }

    private void setCliProperty(String property, Properties executionProperties) {
        String value;
        String name;
        int i = property.indexOf("=");
        if (i <= 0) {
            name = property.trim();
            value = "true";
        } else {
            name = property.substring(0, i).trim();
            value = property.substring(i + 1).trim();
        }
        executionProperties.setProperty(name, value);
        System.setProperty(name, value);
    }

    public Options buildDefaultCliOptions() {
        this.options = new Options();
        OptionBuilder.withLongOpt("define");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Define a system property");
        this.options.addOption(OptionBuilder.create('D'));
        OptionBuilder.withLongOpt("help");
        OptionBuilder.withDescription("Display help information");
        this.options.addOption(OptionBuilder.create('h'));
        OptionBuilder.withLongOpt("version");
        OptionBuilder.withDescription("Display version information");
        this.options.addOption(OptionBuilder.create('v'));
        OptionBuilder.withLongOpt("quiet");
        OptionBuilder.withDescription("Quiet output - only show errors");
        this.options.addOption(OptionBuilder.create('q'));
        OptionBuilder.withLongOpt("debug");
        OptionBuilder.withDescription("Produce execution debug output");
        this.options.addOption(OptionBuilder.create('X'));
        OptionBuilder.withLongOpt("errors");
        OptionBuilder.withDescription("Produce execution error messages");
        this.options.addOption(OptionBuilder.create('e'));
        return this.buildCliOptions(this.options);
    }

    public CommandLine parse(String[] args) throws ParseException {
        String[] cleanArgs = AbstractCli.cleanArgs(args);
        GnuParser parser = new GnuParser();
        return parser.parse(this.buildDefaultCliOptions(), cleanArgs);
    }

    private static String[] cleanArgs(String[] args) {
        ArrayList<String> cleaned = new ArrayList<String>();
        StringBuffer currentArg = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            boolean addedToBuffer = false;
            if (arg.startsWith("\"")) {
                if (currentArg != null) {
                    cleaned.add(currentArg.toString());
                }
                currentArg = new StringBuffer(arg.substring(1));
                addedToBuffer = true;
            }
            if (arg.endsWith("\"")) {
                String cleanArgPart = arg.substring(0, arg.length() - 1);
                if (currentArg != null) {
                    if (addedToBuffer) {
                        currentArg.setLength(currentArg.length() - 1);
                    } else {
                        currentArg.append(' ').append(cleanArgPart);
                    }
                    cleaned.add(currentArg.toString());
                } else {
                    cleaned.add(cleanArgPart);
                }
                currentArg = null;
                continue;
            }
            if (addedToBuffer) continue;
            if (currentArg != null) {
                currentArg.append(' ').append(arg);
                continue;
            }
            cleaned.add(arg);
        }
        if (currentArg != null) {
            cleaned.add(currentArg.toString());
        }
        int cleanedSz = cleaned.size();
        String[] cleanArgs = null;
        cleanArgs = cleanedSz == 0 ? args : cleaned.toArray(new String[cleanedSz]);
        return cleanArgs;
    }

    public void displayHelp() {
        System.out.println();
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("mvn [options] [<goal(s)>] [<phase(s)>]", "\nOptions:", this.options, "\n");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

