/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.fml;

import org.apache.maven.doxia.macro.MacroExecutionException;
import org.apache.maven.doxia.module.fml.FmlMarkup;
import org.apache.maven.doxia.parser.Xhtml5BaseParser;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FmlContentParser
extends Xhtml5BaseParser
implements FmlMarkup {
    private static final Logger LOGGER = LoggerFactory.getLogger(FmlContentParser.class);
    private boolean isEmptyElement;

    protected void handleStartTag(XmlPullParser parser, Sink sink) throws XmlPullParserException, MacroExecutionException {
        this.isEmptyElement = parser.isEmptyElementTag();
        if (parser.getName().equals(QUESTION_TAG.toString()) || parser.getName().equals(TITLE.toString()) || parser.getName().equals(ANSWER_TAG.toString())) {
            return;
        }
        if (parser.getName().equals(SOURCE_TAG.toString())) {
            this.verbatim();
            sink.verbatim(SinkEventAttributeSet.SOURCE);
        } else if (!this.baseStartTag(parser, sink)) {
            if (this.isEmptyElement) {
                this.handleUnknown(parser, sink, 1);
            } else {
                this.handleUnknown(parser, sink, 2);
            }
            LOGGER.warn("Unrecognized fml tag <{}> at [{}:{}]", new Object[]{parser.getName(), parser.getLineNumber(), parser.getColumnNumber()});
        }
    }

    protected void handleEndTag(XmlPullParser parser, Sink sink) throws XmlPullParserException, MacroExecutionException {
        if (parser.getName().equals(QUESTION_TAG.toString()) || parser.getName().equals(TITLE.toString()) || parser.getName().equals(ANSWER_TAG.toString())) {
            return;
        }
        if (parser.getName().equals(SOURCE_TAG.toString())) {
            this.verbatim_();
            sink.verbatim_();
        } else if (!this.baseEndTag(parser, sink) && !this.isEmptyElement) {
            this.handleUnknown(parser, sink, 3);
        }
        this.isEmptyElement = false;
    }

    protected void init() {
        super.init();
        this.isEmptyElement = false;
    }
}

