/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.search.similarities;

import java.io.Closeable;
import java.io.IOException;
import java.util.Random;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.similarities.IndriDirichletSimilarity;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.tests.index.RandomIndexWriter;
import org.apache.lucene.tests.search.CheckHits;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.apache.lucene.tests.util.TestUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.SmallFloat;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public abstract class BaseSimilarityTestCase
extends LuceneTestCase {
    static LeafReader READER;
    static Directory DIR;
    static final long MAXDOC_FORTESTING = 0x1000000000000L;
    static final long MAXTOKENS_FORTESTING = 0x2000000000000L;
    private static final BytesRef TERM;

    @BeforeClass
    public static void beforeClass() throws Exception {
        DIR = BaseSimilarityTestCase.newDirectory();
        RandomIndexWriter writer = new RandomIndexWriter(BaseSimilarityTestCase.random(), DIR);
        Document doc = new Document();
        FieldType fieldType = new FieldType((IndexableFieldType)TextField.TYPE_NOT_STORED);
        fieldType.setOmitNorms(true);
        doc.add((IndexableField)BaseSimilarityTestCase.newField("field", "value", fieldType));
        writer.addDocument(doc);
        READER = BaseSimilarityTestCase.getOnlyLeafReader((IndexReader)writer.getReader());
        writer.close();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        IOUtils.close((Closeable[])new Closeable[]{READER, DIR});
        READER = null;
        DIR = null;
    }

    protected abstract Similarity getSimilarity(Random var1);

    static CollectionStatistics newCorpus(Random random, int norm) {
        long sumTotalTermFreq;
        long sumDocFreq;
        long upperBound;
        long docCount;
        long maxDoc;
        int lowerBound = norm == 0 ? 1 : SmallFloat.byte4ToInt((byte)((byte)norm));
        switch (random.nextInt(6)) {
            case 0: {
                maxDoc = 1L;
                break;
            }
            case 1: {
                maxDoc = 2L;
                break;
            }
            case 2: {
                maxDoc = TestUtil.nextLong(random, 3L, 16L);
                break;
            }
            case 3: {
                maxDoc = TestUtil.nextLong(random, 16L, 100000L);
                break;
            }
            case 4: {
                maxDoc = TestUtil.nextLong(random, 100000L, 0x1000000000000L);
                break;
            }
            default: {
                maxDoc = 0x1000000000000L;
            }
        }
        switch (random.nextInt(3)) {
            case 0: {
                docCount = 1L;
                break;
            }
            case 1: {
                docCount = TestUtil.nextLong(random, 1L, maxDoc);
                break;
            }
            default: {
                docCount = maxDoc;
            }
        }
        try {
            upperBound = Math.min(0x2000000000000L, Math.multiplyExact(docCount, Integer.MAX_VALUE));
        }
        catch (ArithmeticException overflow) {
            upperBound = 0x2000000000000L;
        }
        switch (random.nextInt(3)) {
            case 0: {
                sumDocFreq = docCount;
                break;
            }
            case 1: {
                sumDocFreq = upperBound + 1L - (long)lowerBound;
                break;
            }
            default: {
                sumDocFreq = TestUtil.nextLong(random, docCount, upperBound + 1L - (long)lowerBound);
            }
        }
        switch (random.nextInt(4)) {
            case 0: {
                sumTotalTermFreq = sumDocFreq;
                break;
            }
            case 1: {
                sumTotalTermFreq = sumDocFreq - 1L + (long)lowerBound;
                break;
            }
            case 2: {
                sumTotalTermFreq = upperBound;
                break;
            }
            default: {
                assert (sumDocFreq - 1L + (long)lowerBound <= upperBound);
                sumTotalTermFreq = TestUtil.nextLong(random, sumDocFreq - 1L + (long)lowerBound, upperBound);
            }
        }
        return new CollectionStatistics("field", maxDoc, docCount, sumTotalTermFreq, sumDocFreq);
    }

    static TermStatistics newTerm(Random random, CollectionStatistics corpus) {
        long totalTermFreq;
        long upperBound;
        long docFreq;
        switch (random.nextInt(3)) {
            case 0: {
                docFreq = 1L;
                break;
            }
            case 1: {
                docFreq = corpus.docCount();
                break;
            }
            default: {
                docFreq = TestUtil.nextLong(random, 1L, corpus.docCount());
            }
        }
        try {
            upperBound = Math.min(corpus.sumTotalTermFreq(), Math.multiplyExact(docFreq, Integer.MAX_VALUE));
        }
        catch (ArithmeticException overflow) {
            upperBound = corpus.sumTotalTermFreq();
        }
        if (corpus.sumTotalTermFreq() == corpus.sumDocFreq()) {
            totalTermFreq = docFreq;
        } else {
            switch (random.nextInt(3)) {
                case 0: {
                    totalTermFreq = docFreq;
                    break;
                }
                case 1: {
                    totalTermFreq = upperBound;
                    break;
                }
                default: {
                    totalTermFreq = TestUtil.nextLong(random, docFreq, upperBound);
                }
            }
        }
        return new TermStatistics(TERM, docFreq, totalTermFreq);
    }

    public void testRandomScoring() throws Exception {
        Random random = BaseSimilarityTestCase.random();
        int iterations = BaseSimilarityTestCase.atLeast(1);
        for (int i = 0; i < iterations; ++i) {
            Similarity similarity = this.getSimilarity(random);
            for (int j = 0; j < 3; ++j) {
                for (int k = 1; k < 256; ++k) {
                    CollectionStatistics corpus = BaseSimilarityTestCase.newCorpus(random, k);
                    for (int l = 0; l < 10; ++l) {
                        float boost;
                        float freq;
                        TermStatistics term = BaseSimilarityTestCase.newTerm(random, corpus);
                        if (term.totalTermFreq() == term.docFreq()) {
                            freq = 1.0f;
                        } else if (term.docFreq() == 1L) {
                            freq = Math.toIntExact(term.totalTermFreq());
                        } else {
                            int upperBound = Math.toIntExact(Math.min(term.totalTermFreq() - term.docFreq() + 1L, Integer.MAX_VALUE));
                            if (random.nextBoolean()) {
                                switch (random.nextInt(3)) {
                                    case 0: {
                                        freq = 1.0f;
                                        break;
                                    }
                                    case 1: {
                                        freq = upperBound;
                                        break;
                                    }
                                    default: {
                                        freq = TestUtil.nextInt(random, 1, upperBound);
                                        break;
                                    }
                                }
                            } else {
                                float freqCandidate;
                                switch (random.nextInt(2)) {
                                    case 0: {
                                        freqCandidate = Float.MIN_VALUE;
                                        break;
                                    }
                                    default: {
                                        freqCandidate = (float)upperBound * random.nextFloat();
                                    }
                                }
                                if (freqCandidate <= Float.MIN_VALUE) {
                                    freqCandidate = Math.nextUp(Float.MIN_VALUE);
                                }
                                freq = freqCandidate;
                            }
                        }
                        switch (random.nextInt(5)) {
                            case 0: {
                                boost = 0.0f;
                                break;
                            }
                            case 1: {
                                boost = Float.MIN_VALUE;
                                break;
                            }
                            case 2: {
                                boost = 1.0f;
                                break;
                            }
                            case 3: {
                                boost = 2.1474836E9f;
                                break;
                            }
                            default: {
                                boost = random.nextFloat() * 2.1474836E9f;
                            }
                        }
                        BaseSimilarityTestCase.doTestScoring(similarity, corpus, term, boost, freq, k);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doTestScoring(Similarity similarity, CollectionStatistics corpus, TermStatistics term, float boost, float freq, int norm) throws IOException {
        boolean success = false;
        Similarity.SimScorer scorer = similarity.scorer(boost, corpus, new TermStatistics[]{term});
        try {
            Explanation prevExplanation;
            float maxScore = scorer.score(Float.MAX_VALUE, 1L);
            BaseSimilarityTestCase.assertFalse((String)"maxScore is NaN", (boolean)Float.isNaN(maxScore));
            float score = scorer.score(freq, (long)norm);
            BaseSimilarityTestCase.assertTrue((String)("infinite/NaN score: " + score), (boolean)Float.isFinite(score));
            if (!(similarity instanceof IndriDirichletSimilarity)) {
                BaseSimilarityTestCase.assertTrue((String)("negative score: " + score), (score >= 0.0f ? 1 : 0) != 0);
            }
            BaseSimilarityTestCase.assertTrue((String)("greater than maxScore: " + score + ">" + maxScore), (score <= maxScore ? 1 : 0) != 0);
            Explanation explanation = scorer.explain(Explanation.match((Number)Float.valueOf(freq), (String)"freq, occurrences of term within document", (Explanation[])new Explanation[0]), (long)norm);
            if ((double)score != explanation.getValue().doubleValue()) {
                BaseSimilarityTestCase.fail((String)("expected: " + score + ", got: " + String.valueOf(explanation)));
            }
            if (BaseSimilarityTestCase.rarely()) {
                CheckHits.verifyExplanation("<test query>", 0, score, true, explanation);
            }
            float prevFreq = BaseSimilarityTestCase.random().nextBoolean() && freq == (float)((int)freq) && freq > 1.0f && term.docFreq() > 1L ? freq - 1.0f : Math.nextDown(freq);
            float prevScore = scorer.score(prevFreq, (long)norm);
            BaseSimilarityTestCase.assertTrue((boolean)Float.isFinite(prevScore));
            if (!(similarity instanceof IndriDirichletSimilarity)) {
                BaseSimilarityTestCase.assertTrue((prevScore >= 0.0f ? 1 : 0) != 0);
            }
            if ((double)prevScore != (prevExplanation = scorer.explain(Explanation.match((Number)Float.valueOf(prevFreq), (String)"freq, occurrences of term within document", (Explanation[])new Explanation[0]), (long)norm)).getValue().doubleValue()) {
                BaseSimilarityTestCase.fail((String)("expected: " + prevScore + ", got: " + String.valueOf(prevExplanation)));
            }
            if (BaseSimilarityTestCase.rarely()) {
                CheckHits.verifyExplanation("test query (prevFreq)", 0, prevScore, true, prevExplanation);
            }
            if (prevScore > score) {
                System.out.println(prevExplanation);
                System.out.println(explanation);
                BaseSimilarityTestCase.fail((String)("score(" + prevFreq + ")=" + prevScore + " > score(" + freq + ")=" + score));
            }
            if (norm > 1) {
                Explanation prevNormExplanation;
                float prevNormScore = scorer.score(freq, (long)(norm - 1));
                BaseSimilarityTestCase.assertTrue((boolean)Float.isFinite(prevNormScore));
                if (!(similarity instanceof IndriDirichletSimilarity)) {
                    BaseSimilarityTestCase.assertTrue((prevNormScore >= 0.0f ? 1 : 0) != 0);
                }
                if ((double)prevNormScore != (prevNormExplanation = scorer.explain(Explanation.match((Number)Float.valueOf(freq), (String)"freq, occurrences of term within document", (Explanation[])new Explanation[0]), (long)(norm - 1))).getValue().doubleValue()) {
                    BaseSimilarityTestCase.fail((String)("expected: " + prevNormScore + ", got: " + String.valueOf(prevNormExplanation)));
                }
                if (BaseSimilarityTestCase.rarely()) {
                    CheckHits.verifyExplanation("test query (prevNorm)", 0, prevNormScore, true, prevNormExplanation);
                }
                if (prevNormScore < score) {
                    System.out.println(prevNormExplanation);
                    System.out.println(explanation);
                    BaseSimilarityTestCase.fail((String)("score(" + freq + "," + (norm - 1) + ")=" + prevNormScore + " < score(" + freq + "," + norm + ")=" + score));
                }
            }
            if (term.docFreq() > 1L && freq < (float)term.totalTermFreq()) {
                Explanation prevTermExplanation;
                TermStatistics prevTerm = new TermStatistics(term.term(), term.docFreq() - 1L, term.totalTermFreq() - 1L);
                Similarity.SimScorer prevTermScorer = similarity.scorer(boost, corpus, new TermStatistics[]{term});
                float prevTermScore = prevTermScorer.score(freq, (long)norm);
                BaseSimilarityTestCase.assertTrue((boolean)Float.isFinite(prevTermScore));
                if (!(similarity instanceof IndriDirichletSimilarity)) {
                    BaseSimilarityTestCase.assertTrue((prevTermScore >= 0.0f ? 1 : 0) != 0);
                }
                if ((double)prevTermScore != (prevTermExplanation = prevTermScorer.explain(Explanation.match((Number)Float.valueOf(freq), (String)"freq, occurrences of term within document", (Explanation[])new Explanation[0]), (long)norm)).getValue().doubleValue()) {
                    BaseSimilarityTestCase.fail((String)("expected: " + prevTermScore + ", got: " + String.valueOf(prevTermExplanation)));
                }
                if (BaseSimilarityTestCase.rarely()) {
                    CheckHits.verifyExplanation("test query (prevTerm)", 0, prevTermScore, true, prevTermExplanation);
                }
                if (prevTermScore < score) {
                    System.out.println(prevTermExplanation);
                    System.out.println(explanation);
                    BaseSimilarityTestCase.fail((String)("score(" + freq + "," + String.valueOf(prevTerm) + ")=" + prevTermScore + " < score(" + freq + "," + String.valueOf(term) + ")=" + score));
                }
            }
            success = true;
        }
        finally {
            if (!success) {
                System.out.println(similarity);
                System.out.println(corpus);
                System.out.println(term);
                if (norm == 0) {
                    System.out.println("norms=omitted");
                } else {
                    System.out.println("norm=" + norm + " (doc length ~ " + SmallFloat.byte4ToInt((byte)((byte)norm)) + ")");
                }
                System.out.println("freq=" + freq);
            }
        }
    }

    static {
        TERM = new BytesRef((CharSequence)"term");
    }
}

