/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.analysis;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.AbstractAnalysisFactory;
import org.apache.lucene.analysis.CharFilterFactory;
import org.apache.lucene.analysis.TokenFilterFactory;
import org.apache.lucene.analysis.TokenizerFactory;
import org.apache.lucene.tests.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.util.ClasspathResourceLoader;
import org.apache.lucene.util.ResourceLoader;
import org.apache.lucene.util.ResourceLoaderAware;
import org.apache.lucene.util.Version;

public abstract class BaseTokenStreamFactoryTestCase
extends BaseTokenStreamTestCase {
    private AbstractAnalysisFactory analysisFactory(Class<? extends AbstractAnalysisFactory> clazz, Version matchVersion, ResourceLoader loader, String ... keysAndValues) throws Exception {
        if (keysAndValues.length % 2 == 1) {
            throw new IllegalArgumentException("invalid keysAndValues map");
        }
        HashMap<String, String> args = new HashMap<String, String>();
        for (int i = 0; i < keysAndValues.length; i += 2) {
            String previous = args.put(keysAndValues[i], keysAndValues[i + 1]);
            BaseTokenStreamFactoryTestCase.assertNull((String)("duplicate values for key: " + keysAndValues[i]), (Object)previous);
        }
        if (matchVersion != null) {
            String previous = args.put("luceneMatchVersion", matchVersion.toString());
            BaseTokenStreamFactoryTestCase.assertNull((String)"duplicate values for key: luceneMatchVersion", (Object)previous);
        }
        AbstractAnalysisFactory factory = null;
        try {
            factory = clazz.getConstructor(Map.class).newInstance(args);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)e.getCause();
            }
            throw e;
        }
        if (factory instanceof ResourceLoaderAware) {
            ((ResourceLoaderAware)factory).inform(loader);
        }
        return factory;
    }

    protected TokenizerFactory tokenizerFactory(String name, String ... keysAndValues) throws Exception {
        return this.tokenizerFactory(name, Version.LATEST, keysAndValues);
    }

    protected TokenizerFactory tokenizerFactory(String name, Version version, String ... keysAndValues) throws Exception {
        return this.tokenizerFactory(name, version, (ResourceLoader)new ClasspathResourceLoader(((Object)((Object)this)).getClass()), keysAndValues);
    }

    protected TokenizerFactory tokenizerFactory(String name, Version matchVersion, ResourceLoader loader, String ... keysAndValues) throws Exception {
        return (TokenizerFactory)this.analysisFactory(TokenizerFactory.lookupClass((String)name), matchVersion, loader, keysAndValues);
    }

    protected TokenFilterFactory tokenFilterFactory(String name, Version version, String ... keysAndValues) throws Exception {
        return this.tokenFilterFactory(name, version, (ResourceLoader)new ClasspathResourceLoader(((Object)((Object)this)).getClass()), keysAndValues);
    }

    protected TokenFilterFactory tokenFilterFactory(String name, String ... keysAndValues) throws Exception {
        return this.tokenFilterFactory(name, Version.LATEST, keysAndValues);
    }

    protected TokenFilterFactory tokenFilterFactory(String name, Version matchVersion, ResourceLoader loader, String ... keysAndValues) throws Exception {
        return (TokenFilterFactory)this.analysisFactory(TokenFilterFactory.lookupClass((String)name), matchVersion, loader, keysAndValues);
    }

    protected CharFilterFactory charFilterFactory(String name, String ... keysAndValues) throws Exception {
        return this.charFilterFactory(name, Version.LATEST, (ResourceLoader)new ClasspathResourceLoader(((Object)((Object)this)).getClass()), keysAndValues);
    }

    protected CharFilterFactory charFilterFactory(String name, Version matchVersion, ResourceLoader loader, String ... keysAndValues) throws Exception {
        return (CharFilterFactory)this.analysisFactory(CharFilterFactory.lookupClass((String)name), matchVersion, loader, keysAndValues);
    }
}

