/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.util.GeoUtils;

public final class GeoPointField
extends Field {
    public static final int PRECISION_STEP = 9;
    public static final FieldType TYPE_NOT_STORED = new FieldType();
    public static final FieldType TYPE_STORED;

    public GeoPointField(String name, double lon, double lat, Field.Store stored) {
        super(name, stored == Field.Store.YES ? TYPE_STORED : TYPE_NOT_STORED);
        this.fieldsData = GeoUtils.mortonHash(lon, lat);
    }

    public GeoPointField(String name, double lon, double lat, FieldType type) {
        super(name, type);
        if (type.numericType() != FieldType.NumericType.LONG) {
            throw new IllegalArgumentException("type.numericType() must be LONG but got " + type.numericType());
        }
        this.fieldsData = GeoUtils.mortonHash(lon, lat);
    }

    static {
        TYPE_NOT_STORED.setTokenized(false);
        TYPE_NOT_STORED.setOmitNorms(true);
        TYPE_NOT_STORED.setIndexOptions(IndexOptions.DOCS);
        TYPE_NOT_STORED.setDocValuesType(DocValuesType.SORTED_NUMERIC);
        TYPE_NOT_STORED.setNumericType(FieldType.NumericType.LONG);
        TYPE_NOT_STORED.setNumericPrecisionStep(9);
        TYPE_NOT_STORED.freeze();
        TYPE_STORED = new FieldType();
        TYPE_STORED.setTokenized(false);
        TYPE_STORED.setOmitNorms(true);
        TYPE_STORED.setIndexOptions(IndexOptions.DOCS);
        TYPE_STORED.setDocValuesType(DocValuesType.SORTED_NUMERIC);
        TYPE_STORED.setNumericType(FieldType.NumericType.LONG);
        TYPE_STORED.setNumericPrecisionStep(9);
        TYPE_STORED.setStored(true);
        TYPE_STORED.freeze();
    }
}

