/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.bkdtree;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.bkdtree.BKDTreeReader;
import org.apache.lucene.bkdtree.BKDTreeSortedNumericDocValues;
import org.apache.lucene.bkdtree.BKDTreeWriter;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ToStringUtils;

public class BKDPointInBBoxQuery
extends Query {
    final String field;
    final double minLat;
    final double maxLat;
    final double minLon;
    final double maxLon;

    public BKDPointInBBoxQuery(String field, double minLat, double maxLat, double minLon, double maxLon) {
        this.field = field;
        if (!BKDTreeWriter.validLat(minLat)) {
            throw new IllegalArgumentException("minLat=" + minLat + " is not a valid latitude");
        }
        if (!BKDTreeWriter.validLat(maxLat)) {
            throw new IllegalArgumentException("maxLat=" + maxLat + " is not a valid latitude");
        }
        if (!BKDTreeWriter.validLon(minLon)) {
            throw new IllegalArgumentException("minLon=" + minLon + " is not a valid longitude");
        }
        if (!BKDTreeWriter.validLon(maxLon)) {
            throw new IllegalArgumentException("maxLon=" + maxLon + " is not a valid longitude");
        }
        this.minLon = minLon;
        this.maxLon = maxLon;
        this.minLat = minLat;
        this.maxLat = maxLat;
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new Weight(this){
            private float queryNorm;
            private float queryWeight;

            public void extractTerms(Set<Term> terms) {
            }

            public float getValueForNormalization() throws IOException {
                this.queryWeight = BKDPointInBBoxQuery.this.getBoost();
                return this.queryWeight * this.queryWeight;
            }

            public void normalize(float norm, float topLevelBoost) {
                this.queryNorm = norm * topLevelBoost;
                this.queryWeight *= this.queryNorm;
            }

            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                boolean exists;
                Scorer s = this.scorer(context);
                boolean bl = exists = s != null && s.advance(doc) == doc;
                if (exists) {
                    return Explanation.match((float)this.queryWeight, (String)(BKDPointInBBoxQuery.this.toString() + ", product of:"), (Explanation[])new Explanation[]{Explanation.match((float)BKDPointInBBoxQuery.this.getBoost(), (String)"boost", (Explanation[])new Explanation[0]), Explanation.match((float)this.queryNorm, (String)"queryNorm", (Explanation[])new Explanation[0])});
                }
                return Explanation.noMatch((String)(BKDPointInBBoxQuery.this.toString() + " doesn't match id " + doc), (Explanation[])new Explanation[0]);
            }

            public Scorer scorer(LeafReaderContext context) throws IOException {
                LeafReader reader = context.reader();
                SortedNumericDocValues sdv = reader.getSortedNumericDocValues(BKDPointInBBoxQuery.this.field);
                if (sdv == null) {
                    return null;
                }
                if (!(sdv instanceof BKDTreeSortedNumericDocValues)) {
                    throw new IllegalStateException("field \"" + BKDPointInBBoxQuery.this.field + "\" was not indexed with BKDTreeDocValuesFormat: got: " + sdv);
                }
                BKDTreeSortedNumericDocValues treeDV = (BKDTreeSortedNumericDocValues)sdv;
                BKDTreeReader tree = treeDV.getBKDTreeReader();
                DocIdSet result = tree.intersect(BKDPointInBBoxQuery.this.minLat, BKDPointInBBoxQuery.this.maxLat, BKDPointInBBoxQuery.this.minLon, BKDPointInBBoxQuery.this.maxLon, treeDV.delegate);
                final DocIdSetIterator disi = result.iterator();
                return new Scorer(this){

                    public float score() throws IOException {
                        return queryWeight;
                    }

                    public int freq() throws IOException {
                        return 1;
                    }

                    public int docID() {
                        return disi.docID();
                    }

                    public int nextDoc() throws IOException {
                        return disi.nextDoc();
                    }

                    public int advance(int target) throws IOException {
                        return disi.advance(target);
                    }

                    public long cost() {
                        return disi.cost();
                    }
                };
            }
        };
    }

    public Query rewrite(IndexReader reader) throws IOException {
        if (this.maxLon < this.minLon) {
            BooleanQuery.Builder q = new BooleanQuery.Builder();
            q.setDisableCoord(true);
            BKDPointInBBoxQuery left = new BKDPointInBBoxQuery(this.field, this.minLat, this.maxLat, -180.0, this.maxLon);
            left.setBoost(this.getBoost());
            q.add(new BooleanClause((Query)left, BooleanClause.Occur.SHOULD));
            BKDPointInBBoxQuery right = new BKDPointInBBoxQuery(this.field, this.minLat, this.maxLat, this.minLon, BKDTreeWriter.MAX_LON_INCL);
            right.setBoost(this.getBoost());
            q.add(new BooleanClause((Query)right, BooleanClause.Occur.SHOULD));
            return q.build();
        }
        return this;
    }

    public int hashCode() {
        int hash = super.hashCode();
        hash += (int)Double.doubleToRawLongBits(this.minLat) ^ 0x14FA55FB;
        hash += (int)Double.doubleToRawLongBits(this.maxLat) ^ 0x733FA5FE;
        hash += (int)Double.doubleToRawLongBits(this.minLon) ^ 0x14FA55FB;
        return hash += (int)Double.doubleToRawLongBits(this.maxLon) ^ 0x733FA5FE;
    }

    public boolean equals(Object other) {
        if (super.equals(other) && other instanceof BKDPointInBBoxQuery) {
            BKDPointInBBoxQuery q = (BKDPointInBBoxQuery)((Object)other);
            return this.field.equals(q.field) && this.minLat == q.minLat && this.maxLat == q.maxLat && this.minLon == q.minLon && this.maxLon == q.maxLon;
        }
        return false;
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(((Object)((Object)this)).getClass().getSimpleName());
        sb.append(':');
        if (!this.field.equals(field)) {
            sb.append("field=");
            sb.append(this.field);
            sb.append(':');
        }
        return sb.append(" Lower Left: [").append(this.minLon).append(',').append(this.minLat).append(']').append(" Upper Right: [").append(this.maxLon).append(',').append(this.maxLat).append("]").append(ToStringUtils.boost((float)this.getBoost())).toString();
    }
}

