/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.facet.FacetField;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesFacetField;
import org.apache.lucene.facet.taxonomy.AssociationFacetField;
import org.apache.lucene.facet.taxonomy.FacetLabel;
import org.apache.lucene.facet.taxonomy.FloatAssociationFacetField;
import org.apache.lucene.facet.taxonomy.IntAssociationFacetField;
import org.apache.lucene.facet.taxonomy.TaxonomyWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.IntsRefBuilder;

public class FacetsConfig {
    public static final String DEFAULT_INDEX_FIELD_NAME = "$facets";
    private final Map<String, DimConfig> fieldTypes = new ConcurrentHashMap<String, DimConfig>();
    private final Map<String, String> assocDimTypes = new ConcurrentHashMap<String, String>();
    public static final DimConfig DEFAULT_DIM_CONFIG = new DimConfig();
    private static final char DELIM_CHAR = '\u001f';
    private static final char ESCAPE_CHAR = '\u001e';

    protected DimConfig getDefaultDimConfig() {
        return DEFAULT_DIM_CONFIG;
    }

    public DimConfig getDimConfig(String dimName) {
        DimConfig ft = this.fieldTypes.get(dimName);
        if (ft == null) {
            ft = this.getDefaultDimConfig();
        }
        return ft;
    }

    public synchronized void setHierarchical(String dimName, boolean v) {
        DimConfig ft = this.fieldTypes.get(dimName);
        if (ft == null) {
            ft = new DimConfig();
            this.fieldTypes.put(dimName, ft);
        }
        ft.hierarchical = v;
    }

    public synchronized void setMultiValued(String dimName, boolean v) {
        DimConfig ft = this.fieldTypes.get(dimName);
        if (ft == null) {
            ft = new DimConfig();
            this.fieldTypes.put(dimName, ft);
        }
        ft.multiValued = v;
    }

    public synchronized void setRequireDimCount(String dimName, boolean v) {
        DimConfig ft = this.fieldTypes.get(dimName);
        if (ft == null) {
            ft = new DimConfig();
            this.fieldTypes.put(dimName, ft);
        }
        ft.requireDimCount = v;
    }

    public synchronized void setIndexFieldName(String dimName, String indexFieldName) {
        DimConfig ft = this.fieldTypes.get(dimName);
        if (ft == null) {
            ft = new DimConfig();
            this.fieldTypes.put(dimName, ft);
        }
        ft.indexFieldName = indexFieldName;
    }

    public Map<String, DimConfig> getDimConfigs() {
        return this.fieldTypes;
    }

    private static void checkSeen(Set<String> seenDims, String dim) {
        if (seenDims.contains(dim)) {
            throw new IllegalArgumentException("dimension \"" + dim + "\" is not multiValued, but it appears more than once in this document");
        }
        seenDims.add(dim);
    }

    public Document build(Document doc) throws IOException {
        return this.build(null, doc);
    }

    public Document build(TaxonomyWriter taxoWriter, Document doc) throws IOException {
        HashMap<String, List<FacetField>> byField = new HashMap<String, List<FacetField>>();
        HashMap<String, List<SortedSetDocValuesFacetField>> dvByField = new HashMap<String, List<SortedSetDocValuesFacetField>>();
        HashMap<String, List<AssociationFacetField>> assocByField = new HashMap<String, List<AssociationFacetField>>();
        HashSet<String> seenDims = new HashSet<String>();
        for (IndexableField field : doc) {
            String indexFieldName;
            List<Field> fields;
            DimConfig dimConfig;
            Field facetField;
            if (field.fieldType() == FacetField.TYPE) {
                facetField = (FacetField)field;
                dimConfig = this.getDimConfig(facetField.dim);
                if (!dimConfig.multiValued) {
                    FacetsConfig.checkSeen(seenDims, facetField.dim);
                }
                if ((fields = (ArrayList<Field>)byField.get(indexFieldName = dimConfig.indexFieldName)) == null) {
                    fields = new ArrayList<Field>();
                    byField.put(indexFieldName, fields);
                }
                fields.add(facetField);
            }
            if (field.fieldType() == SortedSetDocValuesFacetField.TYPE) {
                facetField = (SortedSetDocValuesFacetField)field;
                dimConfig = this.getDimConfig(facetField.dim);
                if (!dimConfig.multiValued) {
                    FacetsConfig.checkSeen(seenDims, facetField.dim);
                }
                if ((fields = (List)dvByField.get(indexFieldName = dimConfig.indexFieldName)) == null) {
                    fields = new ArrayList();
                    dvByField.put(indexFieldName, fields);
                }
                fields.add(facetField);
            }
            if (field.fieldType() != AssociationFacetField.TYPE) continue;
            facetField = (AssociationFacetField)field;
            dimConfig = this.getDimConfig(facetField.dim);
            if (!dimConfig.multiValued) {
                FacetsConfig.checkSeen(seenDims, facetField.dim);
            }
            if (dimConfig.hierarchical) {
                throw new IllegalArgumentException("AssociationFacetField cannot be hierarchical (dim=\"" + facetField.dim + "\")");
            }
            if (dimConfig.requireDimCount) {
                throw new IllegalArgumentException("AssociationFacetField cannot requireDimCount (dim=\"" + facetField.dim + "\")");
            }
            indexFieldName = dimConfig.indexFieldName;
            fields = (List)assocByField.get(indexFieldName);
            if (fields == null) {
                fields = new ArrayList();
                assocByField.put(indexFieldName, fields);
            }
            fields.add(facetField);
            String type = facetField instanceof IntAssociationFacetField ? "int" : (facetField instanceof FloatAssociationFacetField ? "float" : "bytes");
            String curType = this.assocDimTypes.get(indexFieldName);
            if (curType == null) {
                this.assocDimTypes.put(indexFieldName, type);
                continue;
            }
            if (curType.equals(type)) continue;
            throw new IllegalArgumentException("mixing incompatible types of AssocationFacetField (" + curType + " and " + type + ") in indexed field \"" + indexFieldName + "\"; use FacetsConfig to change the indexFieldName for each dimension");
        }
        Document result = new Document();
        this.processFacetFields(taxoWriter, byField, result);
        this.processSSDVFacetFields(dvByField, result);
        this.processAssocFacetFields(taxoWriter, assocByField, result);
        for (IndexableField field : doc.getFields()) {
            IndexableFieldType ft = field.fieldType();
            if (ft == FacetField.TYPE || ft == SortedSetDocValuesFacetField.TYPE || ft == AssociationFacetField.TYPE) continue;
            result.add(field);
        }
        return result;
    }

    private void processFacetFields(TaxonomyWriter taxoWriter, Map<String, List<FacetField>> byField, Document doc) throws IOException {
        for (Map.Entry<String, List<FacetField>> ent : byField.entrySet()) {
            String indexFieldName = ent.getKey();
            IntsRefBuilder ordinals = new IntsRefBuilder();
            for (FacetField facetField : ent.getValue()) {
                DimConfig ft = this.getDimConfig(facetField.dim);
                if (facetField.path.length > 1 && !ft.hierarchical) {
                    throw new IllegalArgumentException("dimension \"" + facetField.dim + "\" is not hierarchical yet has " + facetField.path.length + " components");
                }
                FacetLabel cp = new FacetLabel(facetField.dim, facetField.path);
                this.checkTaxoWriter(taxoWriter);
                int ordinal = taxoWriter.addCategory(cp);
                ordinals.append(ordinal);
                if (ft.multiValued && (ft.hierarchical || ft.requireDimCount)) {
                    int parent = taxoWriter.getParent(ordinal);
                    while (parent > 0) {
                        ordinals.append(parent);
                        parent = taxoWriter.getParent(parent);
                    }
                    if (!ft.requireDimCount) {
                        ordinals.setLength(ordinals.length() - 1);
                    }
                }
                for (int i = 1; i <= cp.length; ++i) {
                    doc.add((IndexableField)new StringField(indexFieldName, FacetsConfig.pathToString(cp.components, i), Field.Store.NO));
                }
            }
            doc.add((IndexableField)new BinaryDocValuesField(indexFieldName, this.dedupAndEncode(ordinals.get())));
        }
    }

    private void processSSDVFacetFields(Map<String, List<SortedSetDocValuesFacetField>> byField, Document doc) throws IOException {
        for (Map.Entry<String, List<SortedSetDocValuesFacetField>> ent : byField.entrySet()) {
            String indexFieldName = ent.getKey();
            for (SortedSetDocValuesFacetField facetField : ent.getValue()) {
                FacetLabel cp = new FacetLabel(facetField.dim, facetField.label);
                String fullPath = FacetsConfig.pathToString(cp.components, cp.length);
                doc.add((IndexableField)new SortedSetDocValuesField(indexFieldName, new BytesRef((CharSequence)fullPath)));
                doc.add((IndexableField)new StringField(indexFieldName, fullPath, Field.Store.NO));
                doc.add((IndexableField)new StringField(indexFieldName, facetField.dim, Field.Store.NO));
            }
        }
    }

    private void processAssocFacetFields(TaxonomyWriter taxoWriter, Map<String, List<AssociationFacetField>> byField, Document doc) throws IOException {
        for (Map.Entry<String, List<AssociationFacetField>> ent : byField.entrySet()) {
            byte[] bytes = new byte[16];
            int upto = 0;
            String indexFieldName = ent.getKey();
            for (AssociationFacetField field : ent.getValue()) {
                this.checkTaxoWriter(taxoWriter);
                FacetLabel label = new FacetLabel(field.dim, field.path);
                int ordinal = taxoWriter.addCategory(label);
                if (upto + 4 > bytes.length) {
                    bytes = ArrayUtil.grow((byte[])bytes, (int)(upto + 4));
                }
                bytes[upto++] = (byte)(ordinal >> 24);
                bytes[upto++] = (byte)(ordinal >> 16);
                bytes[upto++] = (byte)(ordinal >> 8);
                bytes[upto++] = (byte)ordinal;
                if (upto + field.assoc.length > bytes.length) {
                    bytes = ArrayUtil.grow((byte[])bytes, (int)(upto + field.assoc.length));
                }
                System.arraycopy(field.assoc.bytes, field.assoc.offset, bytes, upto, field.assoc.length);
                upto += field.assoc.length;
                for (int i = 1; i <= label.length; ++i) {
                    doc.add((IndexableField)new StringField(indexFieldName, FacetsConfig.pathToString(label.components, i), Field.Store.NO));
                }
            }
            doc.add((IndexableField)new BinaryDocValuesField(indexFieldName, new BytesRef(bytes, 0, upto)));
        }
    }

    protected BytesRef dedupAndEncode(IntsRef ordinals) {
        Arrays.sort(ordinals.ints, ordinals.offset, ordinals.length);
        byte[] bytes = new byte[5 * ordinals.length];
        int lastOrd = -1;
        int upto = 0;
        for (int i = 0; i < ordinals.length; ++i) {
            int ord = ordinals.ints[ordinals.offset + i];
            if (ord <= lastOrd) continue;
            int delta = lastOrd == -1 ? ord : ord - lastOrd;
            if ((delta & 0xFFFFFF80) == 0) {
                bytes[upto] = (byte)delta;
                ++upto;
            } else if ((delta & 0xFFFFC000) == 0) {
                bytes[upto] = (byte)(0x80 | (delta & 0x3F80) >> 7);
                bytes[upto + 1] = (byte)(delta & 0x7F);
                upto += 2;
            } else if ((delta & 0xFFE00000) == 0) {
                bytes[upto] = (byte)(0x80 | (delta & 0x1FC000) >> 14);
                bytes[upto + 1] = (byte)(0x80 | (delta & 0x3F80) >> 7);
                bytes[upto + 2] = (byte)(delta & 0x7F);
                upto += 3;
            } else if ((delta & 0xF0000000) == 0) {
                bytes[upto] = (byte)(0x80 | (delta & 0xFE00000) >> 21);
                bytes[upto + 1] = (byte)(0x80 | (delta & 0x1FC000) >> 14);
                bytes[upto + 2] = (byte)(0x80 | (delta & 0x3F80) >> 7);
                bytes[upto + 3] = (byte)(delta & 0x7F);
                upto += 4;
            } else {
                bytes[upto] = (byte)(0x80 | (delta & 0xF0000000) >> 28);
                bytes[upto + 1] = (byte)(0x80 | (delta & 0xFE00000) >> 21);
                bytes[upto + 2] = (byte)(0x80 | (delta & 0x1FC000) >> 14);
                bytes[upto + 3] = (byte)(0x80 | (delta & 0x3F80) >> 7);
                bytes[upto + 4] = (byte)(delta & 0x7F);
                upto += 5;
            }
            lastOrd = ord;
        }
        return new BytesRef(bytes, 0, upto);
    }

    private void checkTaxoWriter(TaxonomyWriter taxoWriter) {
        if (taxoWriter == null) {
            throw new IllegalStateException("a non-null TaxonomyWriter must be provided when indexing FacetField or AssociationFacetField");
        }
    }

    public static String pathToString(String dim, String[] path) {
        String[] fullPath = new String[1 + path.length];
        fullPath[0] = dim;
        System.arraycopy(path, 0, fullPath, 1, path.length);
        return FacetsConfig.pathToString(fullPath, fullPath.length);
    }

    public static String pathToString(String[] path) {
        return FacetsConfig.pathToString(path, path.length);
    }

    public static String pathToString(String[] path, int length) {
        if (length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            String s = path[i];
            if (s.length() == 0) {
                throw new IllegalArgumentException("each path component must have length > 0 (got: \"\")");
            }
            int numChars = s.length();
            for (int j = 0; j < numChars; ++j) {
                char ch = s.charAt(j);
                if (ch == '\u001f' || ch == '\u001e') {
                    sb.append('\u001e');
                }
                sb.append(ch);
            }
            sb.append('\u001f');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public static String[] stringToPath(String s) {
        ArrayList<String> parts = new ArrayList<String>();
        int length = s.length();
        if (length == 0) {
            return new String[0];
        }
        char[] buffer = new char[length];
        int upto = 0;
        boolean lastEscape = false;
        for (int i = 0; i < length; ++i) {
            char ch = s.charAt(i);
            if (lastEscape) {
                buffer[upto++] = ch;
                lastEscape = false;
                continue;
            }
            if (ch == '\u001e') {
                lastEscape = true;
                continue;
            }
            if (ch == '\u001f') {
                parts.add(new String(buffer, 0, upto));
                upto = 0;
                continue;
            }
            buffer[upto++] = ch;
        }
        parts.add(new String(buffer, 0, upto));
        assert (!lastEscape);
        return parts.toArray(new String[parts.size()]);
    }

    public static final class DimConfig {
        public boolean hierarchical;
        public boolean multiValued;
        public boolean requireDimCount;
        public String indexFieldName = "$facets";
    }
}

