/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Metric;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import kafka.api.IntegrationTestHarness;
import kafka.api.KafkaSasl$;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.JaasTestUtils;
import kafka.utils.JaasTestUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.TestJaasConfig;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.server.log.remote.storage.NoOpRemoteLogMetadataManager;
import org.apache.kafka.server.log.remote.storage.NoOpRemoteStorageManager;
import org.apache.kafka.server.log.remote.storage.RemoteStorageMetrics;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r%a\u0001\u0002\u0014(\u00011BQ\u0001\u000e\u0001\u0005\u0002UBqa\u000e\u0001C\u0002\u0013\u0005\u0003\b\u0003\u0004@\u0001\u0001\u0006I!\u000f\u0005\u0006\u0001\u0002!\t&\u0011\u0005\b\u001f\u0002\u0011\r\u0011\"\u0003Q\u0011\u0019I\u0006\u0001)A\u0005#\"9!\f\u0001b\u0001\n\u0013Y\u0006B\u00023\u0001A\u0003%A\fC\u0004f\u0001\t\u0007I\u0011\u0002)\t\r\u0019\u0004\u0001\u0015!\u0003R\u0011\u00159\u0007\u0001\"\u0015i\u0011\u001d\t\bA1A\u0005RIDa\u0001 \u0001!\u0002\u0013\u0019\bbB?\u0001\u0005\u0004%\tF\u001d\u0005\u0007}\u0002\u0001\u000b\u0011B:\t\r}\u0004A\u0011IA\u0001\u0011\u001d\t9\u0003\u0001C!\u0003SAq!a\r\u0001\t\u0003\t)\u0004C\u0004\u0002l\u0001!I!!\u001c\t\u000f\u0005\u0005\u0006\u0001\"\u0003\u0002$\"9\u0011q\u0015\u0001\u0005\n\u0005%\u0006bBA^\u0001\u0011%\u0011Q\u0018\u0005\b\u0003\u007f\u0004A\u0011\u0002B\u0001\u0011\u001d\u0011\t\u0002\u0001C\u0005\u0005'AqAa\u0007\u0001\t\u0013\u0011i\u0002C\u0004\u0003&\u0001!IAa\n\t\u000f\t-\u0002\u0001\"\u0003\u0003.!I!q\u000f\u0001\u0012\u0002\u0013%!\u0011\u0010\u0005\b\u0005'\u0003A\u0011\u0002BK\u0011\u001d\u0011y\u000b\u0001C\u0005\u0005cC\u0011B!2\u0001#\u0003%IAa\u001f\t\u000f\t\u001d\u0007\u0001\"\u0003\u0003J\"9!Q\u001a\u0001\u0005\n\t=\u0007b\u0002Bu\u0001\u0011%!1\u001e\u0005\n\u0005g\u0004\u0011\u0013!C\u0005\u0005kDqA!?\u0001\t\u0013\u0011Y\u0010C\u0004\u0004\u0002\u0001!Iaa\u0001\u0003\u00175+GO]5dgR+7\u000f\u001e\u0006\u0003Q%\n1!\u00199j\u0015\u0005Q\u0013!B6bM.\f7\u0001A\n\u0004\u00015\n\u0004C\u0001\u00180\u001b\u00059\u0013B\u0001\u0019(\u0005YIe\u000e^3he\u0006$\u0018n\u001c8UKN$\b*\u0019:oKN\u001c\bC\u0001\u00183\u0013\t\u0019tEA\u0005TCNd7+\u001a;va\u00061A(\u001b8jiz\"\u0012A\u000e\t\u0003]\u0001\t1B\u0019:pW\u0016\u00148i\\;oiV\t\u0011\b\u0005\u0002;{5\t1HC\u0001=\u0003\u0015\u00198-\u00197b\u0013\tq4HA\u0002J]R\fAB\u0019:pW\u0016\u00148i\\;oi\u0002\nA\u0002\\5ti\u0016tWM\u001d(b[\u0016,\u0012A\u0011\t\u0003\u00076k\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000bqA\\3uo>\u00148N\u0003\u0002H\u0011\u000611m\\7n_:T!AK%\u000b\u0005)[\u0015AB1qC\u000eDWMC\u0001M\u0003\ry'oZ\u0005\u0003\u001d\u0012\u0013A\u0002T5ti\u0016tWM\u001d(b[\u0016\f\u0001d[1gW\u0006\u001cE.[3oiN\u000b7\u000f\\'fG\"\fg.[:n+\u0005\t\u0006C\u0001*X\u001b\u0005\u0019&B\u0001+V\u0003\u0011a\u0017M\\4\u000b\u0003Y\u000bAA[1wC&\u0011\u0001l\u0015\u0002\u0007'R\u0014\u0018N\\4\u00023-\fgm[1DY&,g\u000e^*bg2lUm\u00195b]&\u001cX\u000eI\u0001\u001aW\u000647.Y*feZ,'oU1tY6+7\r[1oSNl7/F\u0001]!\ri&-U\u0007\u0002=*\u0011q\fY\u0001\nS6lW\u000f^1cY\u0016T!!Y\u001e\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002d=\n!A*[:u\u0003iY\u0017MZ6b'\u0016\u0014h/\u001a:TCNdW*Z2iC:L7/\\:!\u0003aY\u0017MZ6b'\u0016\u0014h/\u001a:KC\u0006\u001cXI\u001c;ss:\u000bW.Z\u0001\u001aW\u000647.Y*feZ,'OS1bg\u0016sGO]=OC6,\u0007%\u0001\ttK\u000e,(/\u001b;z!J|Go\\2pYV\t\u0011\u000e\u0005\u0002k_6\t1N\u0003\u0002m[\u0006!\u0011-\u001e;i\u0015\tqg)\u0001\u0005tK\u000e,(/\u001b;z\u0013\t\u00018N\u0001\tTK\u000e,(/\u001b;z!J|Go\\2pY\u0006!2/\u001a:wKJ\u001c\u0016m\u001d7Qe>\u0004XM\u001d;jKN,\u0012a\u001d\t\u0004uQ4\u0018BA;<\u0005\u0011\u0019v.\\3\u0011\u0005]TX\"\u0001=\u000b\u0005e,\u0016\u0001B;uS2L!a\u001f=\u0003\u0015A\u0013x\u000e]3si&,7/A\u000btKJ4XM]*bg2\u0004&o\u001c9feRLWm\u001d\u0011\u0002)\rd\u0017.\u001a8u'\u0006\u001cH\u000e\u0015:pa\u0016\u0014H/[3t\u0003U\u0019G.[3oiN\u000b7\u000f\u001c)s_B,'\u000f^5fg\u0002\nQa]3u+B$B!a\u0001\u0002\nA\u0019!(!\u0002\n\u0007\u0005\u001d1H\u0001\u0003V]&$\bbBA\u0006!\u0001\u0007\u0011QB\u0001\ti\u0016\u001cH/\u00138g_B!\u0011qBA\u000e\u001b\t\t\tBC\u0002)\u0003'QA!!\u0006\u0002\u0018\u00059!.\u001e9ji\u0016\u0014(bAA\r\u0017\u0006)!.\u001e8ji&!\u0011QDA\t\u0005!!Vm\u001d;J]\u001a|\u0007f\u0001\t\u0002\"A!\u0011qBA\u0012\u0013\u0011\t)#!\u0005\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<o)\t\t\u0019\u0001K\u0002\u0012\u0003[\u0001B!a\u0004\u00020%!\u0011\u0011GA\t\u0005%\te\r^3s\u000b\u0006\u001c\u0007.A\u0006uKN$X*\u001a;sS\u000e\u001cH\u0003BA\u0002\u0003oAq!!\u000f\u0013\u0001\u0004\tY$\u0001\u000etsN$X-\u001c*f[>$Xm\u0015;pe\u0006<W-\u00128bE2,G\rE\u0002;\u0003{I1!a\u0010<\u0005\u001d\u0011un\u001c7fC:DsAEA\"\u0003'\n)\u0006\u0005\u0003\u0002F\u0005=SBAA$\u0015\u0011\tI%a\u0013\u0002\u0011A\u0014xN^5eKJTA!!\u0014\u0002\u0014\u00051\u0001/\u0019:b[NLA!!\u0015\u0002H\tYa+\u00197vKN{WO]2f\u0003!\u0011wn\u001c7fC:\u001cH\u0006BA,\u00033J\u0012!A\r\u0002\u0001!:!#!\u0018\u0002f\u0005\u001d\u0004\u0003BA0\u0003Cj!!a\u0013\n\t\u0005\r\u00141\n\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018\u0001\u00028b[\u0016\f#!!\u001b\u0002aQ,7\u000f^'fiJL7m\u001d\u0011xSRD\u0007e]=ti\u0016l'+Z7pi\u0016\u001cFo\u001c:bO\u0016,e.\u00192mK\u0012T\u0004e\u001f\u0019~\u0003-\u0019XM\u001c3SK\u000e|'\u000fZ:\u0015\u0015\u0005\r\u0011qNAG\u0003#\u000b)\nC\u0004\u0002rM\u0001\r!a\u001d\u0002\u0011A\u0014x\u000eZ;dKJ\u0004\u0002\"!\u001e\u0002~\u0005\u0005\u0015\u0011Q\u0007\u0003\u0003oRA!!\u001d\u0002z)\u0019\u00111\u0010%\u0002\u000f\rd\u0017.\u001a8ug&!\u0011qPA<\u00055Y\u0015MZ6b!J|G-^2feB)!(a!\u0002\b&\u0019\u0011QQ\u001e\u0003\u000b\u0005\u0013(/Y=\u0011\u0007i\nI)C\u0002\u0002\fn\u0012AAQ=uK\"1\u0011qR\nA\u0002e\n!B\\;n%\u0016\u001cwN\u001d3t\u0011\u0019\t\u0019j\u0005a\u0001s\u0005Q!/Z2pe\u0012\u001c\u0016N_3\t\u000f\u0005]5\u00031\u0001\u0002\u001a\u0006\u0011A\u000f\u001d\t\u0005\u00037\u000bi*D\u0001G\u0013\r\tyJ\u0012\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003u9WM\\3sCR,\u0017)\u001e;iK:$\u0018nY1uS>tg)Y5mkJ,G\u0003BA\u0002\u0003KCq!a&\u0015\u0001\u0004\tI*A\u0015wKJLg-_&bM.\f'+\u0019;f\u001b\u0016$(/[2t\u0011\u00064XmQ;nk2\fG/\u001b<f\u0007>,h\u000e\u001e\u000b\u0007\u0003\u0007\tY+!,\t\u000f\u0005ET\u00031\u0001\u0002t!9\u0011qV\u000bA\u0002\u0005E\u0016\u0001C2p]N,X.\u001a:\u0011\u0011\u0005M\u0016qWAA\u0003\u0003k!!!.\u000b\t\u0005=\u0016\u0011P\u0005\u0005\u0003s\u000b)L\u0001\u0005D_:\u001cX/\\3s\u0003i1XM]5gs\u000ec\u0017.\u001a8u-\u0016\u00148/[8o\u001b\u0016$(/[2t)\u0019\t\u0019!a0\u0002h\"9\u0011\u0011\u0019\fA\u0002\u0005\r\u0017aB7fiJL7m\u001d\u0019\u0005\u0003\u000b\f)\u000eE\u0004x\u0003\u000f\fY-!5\n\u0007\u0005%\u0007PA\u0002NCB\u0004B!a'\u0002N&\u0019\u0011q\u001a$\u0003\u00155+GO]5d\u001d\u0006lW\r\u0005\u0003\u0002T\u0006UG\u0002\u0001\u0003\r\u0003/\fy,!A\u0001\u0002\u000b\u0005\u0011\u0011\u001c\u0002\u0004?\u0012\n\u0014\u0003BAn\u0003C\u00042AOAo\u0013\r\tyn\u000f\u0002\b\u001d>$\b.\u001b8h!\u0011\tY*a9\n\u0007\u0005\u0015hI\u0001\u0004NKR\u0014\u0018n\u0019\u0005\b\u0003S4\u0002\u0019AAv\u0003\u0019)g\u000e^5usB!\u0011Q^A~\u001d\u0011\ty/a>\u0011\u0007\u0005E8(\u0004\u0002\u0002t*\u0019\u0011Q_\u0016\u0002\rq\u0012xn\u001c;?\u0013\r\tIpO\u0001\u0007!J,G-\u001a4\n\u0007a\u000biPC\u0002\u0002zn\n\u0011E^3sS\u001aL(I]8lKJ\fU\u000f\u001e5f]RL7-\u0019;j_:lU\r\u001e:jGN$B!a\u0001\u0003\u0004!9!QA\fA\u0002\t\u001d\u0011AB:feZ,'\u000f\u0005\u0003\u0003\n\t5QB\u0001B\u0006\u0015\r\u0011)!K\u0005\u0005\u0005\u001f\u0011YAA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\u0018\u0001\n<fe&4\u0017P\u0011:pW\u0016\u0014X*Z:tC\u001e,7i\u001c8wKJ\u001c\u0018n\u001c8NKR\u0014\u0018nY:\u0015\u0011\u0005\r!Q\u0003B\f\u00053AqA!\u0002\u0019\u0001\u0004\u00119\u0001\u0003\u0004\u0002\u0014b\u0001\r!\u000f\u0005\b\u0003/C\u0002\u0019AAM\u0003U1XM]5gs\n\u0013xn[3s5.lU\r\u001e:jGN$b!a\u0001\u0003 \t\u0005\u0002b\u0002B\u00033\u0001\u0007!q\u0001\u0005\b\u0005GI\u0002\u0019AAv\u0003\u0015!x\u000e]5d\u0003a1XM]5gs\n\u0013xn[3s\u000bJ\u0014xN]'fiJL7m\u001d\u000b\u0005\u0003\u0007\u0011I\u0003C\u0004\u0003\u0006i\u0001\rAa\u0002\u0002#Y,'/\u001b4z\u0017\u000647.Y'fiJL7-\u0006\u0003\u00030\tUBC\u0003B\u0019\u0005;\u0012yFa\u001b\u0003nQ!!1\u0007B!!\u0011\t\u0019N!\u000e\u0005\u000f\t]2D1\u0001\u0003:\t\tA+\u0005\u0003\u0002\\\nm\u0002c\u0001\u001e\u0003>%\u0019!qH\u001e\u0003\u0007\u0005s\u0017\u0010C\u0004\u0003Dm\u0001\rA!\u0012\u0002\rY,'/\u001b4z!\u001dQ$q\tB&\u0005gI1A!\u0013<\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0004\u0003N\t]\u0013\u0011\u001d\b\u0005\u0005\u001f\u0012\u0019F\u0004\u0003\u0002r\nE\u0013\"\u0001\u001f\n\u0007\tU3(A\u0004qC\u000e\\\u0017mZ3\n\t\te#1\f\u0002\t\u0013R,'/\u00192mK*\u0019!QK\u001e\t\u000f\u0005\u00154\u00041\u0001\u0002l\"9\u0011\u0011Y\u000eA\u0002\t\u0005\u0004\u0007\u0002B2\u0005O\u0002ra^Ad\u0003\u0017\u0014)\u0007\u0005\u0003\u0002T\n\u001dD\u0001\u0004B5\u0005?\n\t\u0011!A\u0003\u0002\u0005e'aA0%e!9\u0011\u0011^\u000eA\u0002\u0005-\b\"\u0003B87A\u0005\t\u0019\u0001B9\u0003\u00159'o\\;q!\u0015Q$1OAv\u0013\r\u0011)h\u000f\u0002\u0007\u001fB$\u0018n\u001c8\u00027Y,'/\u001b4z\u0017\u000647.Y'fiJL7\r\n3fM\u0006,H\u000e\u001e\u00135+\u0011\u0011YH!%\u0016\u0005\tu$\u0006\u0002B9\u0005\u007fZ#A!!\u0011\t\t\r%QR\u0007\u0003\u0005\u000bSAAa\"\u0003\n\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005\u0017[\u0014AC1o]>$\u0018\r^5p]&!!q\u0012BC\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0003\b\u0005oa\"\u0019\u0001B\u001d\u0003Mi\u0017\r_&bM.\fW*\u001a;sS\u000e4\u0016\r\\;f))\u00119J!(\u0003 \n-&Q\u0016\t\u0004u\te\u0015b\u0001BNw\t1Ai\\;cY\u0016Dq!!\u001a\u001e\u0001\u0004\tY\u000fC\u0004\u0002Bv\u0001\rA!)1\t\t\r&q\u0015\t\bo\u0006\u001d\u00171\u001aBS!\u0011\t\u0019Na*\u0005\u0019\t%&qTA\u0001\u0002\u0003\u0015\t!!7\u0003\u0007}#3\u0007C\u0004\u0002jv\u0001\r!a;\t\u000f\t=T\u00041\u0001\u0003r\u0005Ib/\u001a:jMf\\\u0015MZ6b\u001b\u0016$(/[2SK\u000e|'\u000fZ3e))\t\u0019Aa-\u00036\n\u0005'1\u0019\u0005\b\u0003Kr\u0002\u0019AAv\u0011\u001d\t\tM\ba\u0001\u0005o\u0003DA!/\u0003>B9q/a2\u0002L\nm\u0006\u0003BAj\u0005{#ABa0\u00036\u0006\u0005\t\u0011!B\u0001\u00033\u00141a\u0018\u00135\u0011\u001d\tIO\ba\u0001\u0003WD\u0011Ba\u001c\u001f!\u0003\u0005\rA!\u001d\u0002GY,'/\u001b4z\u0017\u000647.Y'fiJL7MU3d_J$W\r\u001a\u0013eK\u001a\fW\u000f\u001c;%i\u0005\t\u00120Y7nKJlU\r\u001e:jGZ\u000bG.^3\u0015\t\tm\"1\u001a\u0005\b\u0003K\u0002\u0003\u0019AAv\u0003=I\u0018-\\7fe\"K7\u000f^8he\u0006lG\u0003\u0002Bi\u0005O\u0004BAa5\u0003d6\u0011!Q\u001b\u0006\u0005\u0005/\u0014I.\u0001\u0003d_J,'\u0002BAa\u00057TAA!8\u0003`\u00061\u00110Y7nKJT!A!9\u0002\u0007\r|W.\u0003\u0003\u0003f\nU'!\u0003%jgR|wM]1n\u0011\u001d\t)'\ta\u0001\u0003W\f!D^3sS\u001aL\u0018,Y7nKJlU\r\u001e:jGJ+7m\u001c:eK\u0012$bAa&\u0003n\n=\bbBA3E\u0001\u0007\u00111\u001e\u0005\n\u0005\u0007\u0012\u0003\u0013!a\u0001\u0005c\u0004rA\u000fB$\u0005/\u000bY$\u0001\u0013wKJLg-_-b[6,'/T3ue&\u001c'+Z2pe\u0012,G\r\n3fM\u0006,H\u000e\u001e\u00133+\t\u00119P\u000b\u0003\u0003r\n}\u0014A\u0006<fe&4\u0017PT8SKF,Xm\u001d;NKR\u0014\u0018nY:\u0015\t\u0005\r!Q \u0005\b\u0005\u007f$\u0003\u0019AAv\u00031)'O]8s\u001b\u0016\u001c8/Y4f\u0003i1XM]5gsJ+Wn\u001c;f'R|'/Y4f\u001b\u0016$(/[2t)\u0011\t\u0019a!\u0002\t\u000f\r\u001dQ\u00051\u0001\u0002<\u0005!2\u000f[8vY\u0012\u001cuN\u001c;bS:lU\r\u001e:jGN\u0004")
public class MetricsTest
extends IntegrationTestHarness
implements SaslSetup {
    private final int brokerCount;
    private final String kafkaClientSaslMechanism;
    private final List<String> kafkaServerSaslMechanisms;
    private final String kafkaServerJaasEntryName;
    private final Some<Properties> serverSaslProperties;
    private final Some<Properties> clientSaslProperties;
    private File kafka$api$SaslSetup$$workDir;
    private Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup.initializeKerberos$(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup.jaasSections$default$4$(this);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasClientLoginModule$default$2() {
        return SaslSetup.jaasClientLoginModule$default$2$(this);
    }

    @Override
    public String jaasAdminLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasAdminLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasAdminLoginModule$default$2() {
        return SaslSetup.jaasAdminLoginModule$default$2$(this);
    }

    @Override
    public String jaasScramClientLoginModule(String clientSaslScramMechanism, String scramUser, String scramPassword) {
        return SaslSetup.jaasScramClientLoginModule$(this, clientSaslScramMechanism, scramUser, scramPassword);
    }

    @Override
    public Admin createPrivilegedAdminClient() {
        return SaslSetup.createPrivilegedAdminClient$(this);
    }

    @Override
    public Admin createAdminClient(String brokerList, SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> clientSaslProperties, String scramMechanism, String user, String password) {
        return SaslSetup.createAdminClient$(this, brokerList, securityProtocol, trustStoreFile, clientSaslProperties, scramMechanism, user, password);
    }

    @Override
    public void createScramCredentialsViaPrivilegedAdminClient(String userName, String password) {
        SaslSetup.createScramCredentialsViaPrivilegedAdminClient$(this, userName, password);
    }

    @Override
    public void createScramCredentials(Admin adminClient, String userName, String password) {
        SaslSetup.createScramCredentials$((SaslSetup)this, adminClient, userName, password);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup.createScramCredentials$((SaslSetup)this, zkConnect, userName, password);
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    @Override
    public ListenerName listenerName() {
        return new ListenerName("CLIENT");
    }

    private String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    private List<String> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    private String kafkaServerJaasEntryName() {
        return this.kafkaServerJaasEntryName;
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SASL_PLAINTEXT;
    }

    public Some<Properties> serverSaslProperties() {
        return this.serverSaslProperties;
    }

    public Some<Properties> clientSaslProperties() {
        return this.clientSaslProperties;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        if (testInfo.getDisplayName().contains("testMetrics") && testInfo.getDisplayName().endsWith("true")) {
            this.serverConfig().setProperty("remote.log.storage.system.enable", "true");
            this.serverConfig().setProperty("remote.log.storage.manager.class.name", NoOpRemoteStorageManager.class.getName());
            this.serverConfig().setProperty("remote.log.metadata.manager.class.name", NoOpRemoteLogMetadataManager.class.getName());
        }
        this.verifyNoRequestMetrics("Request metrics not removed in a previous test");
        this.startSasl(this.jaasSections((Seq<String>)this.kafkaServerSaslMechanisms(), (Option<String>)new Some((Object)this.kafkaClientSaslMechanism()), KafkaSasl$.MODULE$, this.kafkaServerJaasEntryName()));
        super.setUp(testInfo);
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        this.closeSasl();
        this.verifyNoRequestMetrics("Request metrics not removed in this test");
    }

    @ParameterizedTest(name="testMetrics with systemRemoteStorageEnabled: {0}")
    @ValueSource(booleans={true, false})
    public void testMetrics(boolean systemRemoteStorageEnabled) {
        String topic = "topicWithOldMessageFormat";
        Properties props = new Properties();
        props.setProperty("message.format.version", "0.9.0");
        this.createTopic(topic, 1, 1, props, this.createTopic$default$5(), this.createTopic$default$6());
        TopicPartition tp = new TopicPartition(topic, 0);
        int numRecords = 10;
        int recordSize = 100000;
        Properties prop = new Properties();
        prop.setProperty("enable.idempotence", "false");
        ByteArraySerializer x$2 = this.createProducer$default$1();
        ByteArraySerializer x$3 = this.createProducer$default$2();
        KafkaProducer producer = this.createProducer(x$2, x$3, prop);
        this.sendRecords(producer, numRecords, recordSize, tp);
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)tp, (List)Nil$.MODULE$)).asJava());
        consumer.seek(tp, 0L);
        TestUtils$.MODULE$.consumeRecords(consumer, numRecords, 15000L);
        this.verifyKafkaRateMetricsHaveCumulativeCount(producer, consumer);
        this.verifyClientVersionMetrics(consumer.metrics(), "Consumer");
        this.verifyClientVersionMetrics(producer.metrics(), "Producer");
        KafkaServer server = (KafkaServer)this.servers().head();
        this.verifyBrokerMessageConversionMetrics(server, recordSize, tp);
        this.verifyBrokerErrorMetrics((KafkaServer)this.servers().head());
        this.verifyBrokerZkMetrics(server, topic);
        this.generateAuthenticationFailure(tp);
        this.verifyBrokerAuthenticationMetrics(server);
        this.verifyRemoteStorageMetrics(systemRemoteStorageEnabled);
    }

    private void sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, int recordSize, TopicPartition tp) {
        byte[] bytes = new byte[recordSize];
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable)i -> producer.send(new ProducerRecord(tp.topic(), Predef$.MODULE$.int2Integer(tp.partition()), Predef$.MODULE$.long2Long((long)BoxesRunTime.unboxToInt((Object)i)), (Object)new StringBuilder(4).append("key ").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes(), (Object)bytes)));
        producer.flush();
    }

    private void generateAuthenticationFailure(TopicPartition tp) {
        Properties saslProps = new Properties();
        saslProps.put("sasl.mechanism", this.kafkaClientSaslMechanism());
        saslProps.put("sasl.jaas.config", TestJaasConfig.jaasConfigProperty((String)this.kafkaClientSaslMechanism(), (String)"badUser", (String)"badPass"));
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        SecurityProtocol x$5 = this.securityProtocol();
        Option<File> x$6 = this.trustStoreFile();
        Some x$7 = new Some((Object)saslProps);
        long x$8 = 0x100000L;
        int x$9 = Integer.MAX_VALUE;
        int x$10 = 30000;
        int x$11 = 0;
        int x$12 = 16384;
        String x$13 = "none";
        ByteArraySerializer x$14 = new ByteArraySerializer();
        ByteArraySerializer x$15 = new ByteArraySerializer();
        boolean x$16 = false;
        try (KafkaProducer producer = TestUtils$.MODULE$.createProducer(x$1, 0, 1000L, x$8, x$9, x$10, x$11, x$12, x$13, 1000, x$5, x$6, (Option<Properties>)x$7, x$14, x$15, x$16);){
            try {
                producer.send(new ProducerRecord(tp.topic(), Predef$.MODULE$.int2Integer(tp.partition()), (Object)"key".getBytes(), (Object)"value".getBytes())).get();
            }
            catch (Exception exception) {}
        }
    }

    private void verifyKafkaRateMetricsHaveCumulativeCount(KafkaProducer<byte[], byte[]> producer, Consumer<byte[], byte[]> consumer) {
        Set consumerMetricNames = CollectionConverters$.MODULE$.SetHasAsScala(consumer.metrics().keySet()).asScala().toSet();
        ((IterableOnceOps)consumerMetricNames.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaRateMetricsHaveCumulativeCount$1(x$1)))).foreach((Function1 & Serializable)x$2 -> {
            MetricsTest.verify$1(x$2, consumerMetricNames);
            return BoxedUnit.UNIT;
        });
        Set producerMetricNames = CollectionConverters$.MODULE$.SetHasAsScala(producer.metrics().keySet()).asScala().toSet();
        Set producerExclusions = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"compression-rate"}));
        ((IterableOnceOps)((IterableOps)producerMetricNames.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaRateMetricsHaveCumulativeCount$3(x$3)))).filterNot((Function1 & Serializable)metricName -> BoxesRunTime.boxToBoolean((boolean)producerExclusions.contains((Object)metricName.name())))).foreach((Function1 & Serializable)x$4 -> {
            MetricsTest.verify$1(x$4, producerMetricNames);
            return BoxedUnit.UNIT;
        });
        this.verifyKafkaMetricRecorded("records-consumed-rate", consumer.metrics(), "Consumer", (Option<String>)None$.MODULE$);
        this.verifyKafkaMetricRecorded("records-consumed-total", consumer.metrics(), "Consumer", (Option<String>)None$.MODULE$);
        this.verifyKafkaMetricRecorded("record-send-rate", producer.metrics(), "Producer", (Option<String>)None$.MODULE$);
        this.verifyKafkaMetricRecorded("record-send-total", producer.metrics(), "Producer", (Option<String>)None$.MODULE$);
    }

    private void verifyClientVersionMetrics(Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity) {
        new .colon.colon((Object)"commit-id", (List)new .colon.colon((Object)"version", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)name -> {
            MetricsTest.$anonfun$verifyClientVersionMetrics$1(this, metrics, entity, name);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private void verifyBrokerAuthenticationMetrics(KafkaServer server) {
        Map metrics = server.metrics().metrics();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!MetricsTest.$anonfun$verifyBrokerAuthenticationMetrics$1(this, metrics)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"failed-authentication-total not updated");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.verifyKafkaMetricRecorded("successful-authentication-rate", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
        this.verifyKafkaMetricRecorded("successful-authentication-total", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
        this.verifyKafkaMetricRecorded("failed-authentication-rate", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
        this.verifyKafkaMetricRecorded("failed-authentication-total", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
    }

    private void verifyBrokerMessageConversionMetrics(KafkaServer server, int recordSize, TopicPartition tp) {
        String requestMetricsPrefix = "kafka.network:type=RequestMetrics";
        double requestBytes = this.verifyYammerMetricRecorded(new StringBuilder(34).append(requestMetricsPrefix).append(",name=RequestBytes,request=Produce").toString(), this.verifyYammerMetricRecorded$default$2());
        double tempBytes = this.verifyYammerMetricRecorded(new StringBuilder(42).append(requestMetricsPrefix).append(",name=TemporaryMemoryBytes,request=Produce").toString(), this.verifyYammerMetricRecorded$default$2());
        Assertions.assertTrue((tempBytes >= (double)recordSize ? 1 : 0) != 0, (String)new StringBuilder(57).append("Unexpected temporary memory size requestBytes ").append(requestBytes).append(" tempBytes ").append(tempBytes).toString());
        this.verifyYammerMetricRecorded("kafka.server:type=BrokerTopicMetrics,name=ProduceMessageConversionsPerSec", this.verifyYammerMetricRecorded$default$2());
        String verifyYammerMetricRecorded_name = new StringBuilder(46).append(requestMetricsPrefix).append(",name=MessageConversionsTimeMs,request=Produce").toString();
        double verifyYammerMetricRecorded_metricValue = BoxesRunTime.unboxToDouble((Object)this.yammerMetricValue(verifyYammerMetricRecorded_name));
        Assertions.assertTrue((boolean)MetricsTest.$anonfun$verifyBrokerMessageConversionMetrics$1(verifyYammerMetricRecorded_metricValue), (String)new StringBuilder(48).append("Broker metric not recorded correctly for ").append(verifyYammerMetricRecorded_name).append(" value ").append(verifyYammerMetricRecorded_metricValue).toString());
        Object var9_7 = null;
        this.verifyYammerMetricRecorded(new StringBuilder(32).append(requestMetricsPrefix).append(",name=RequestBytes,request=Fetch").toString(), this.verifyYammerMetricRecorded$default$2());
        String verifyYammerMetricRecorded_name2 = new StringBuilder(40).append(requestMetricsPrefix).append(",name=TemporaryMemoryBytes,request=Fetch").toString();
        double verifyYammerMetricRecorded_metricValue2 = BoxesRunTime.unboxToDouble((Object)this.yammerMetricValue(verifyYammerMetricRecorded_name2));
        Assertions.assertTrue((boolean)MetricsTest.$anonfun$verifyBrokerMessageConversionMetrics$2(verifyYammerMetricRecorded_metricValue2), (String)new StringBuilder(48).append("Broker metric not recorded correctly for ").append(verifyYammerMetricRecorded_name2).append(" value ").append(verifyYammerMetricRecorded_metricValue2).toString());
        Object var12_9 = null;
        this.verifyYammerMetricRecorded(new StringBuilder(35).append(requestMetricsPrefix).append(",name=RequestBytes,request=Metadata").toString(), this.verifyYammerMetricRecorded$default$2());
    }

    private void verifyBrokerZkMetrics(KafkaServer server, String topic) {
        Histogram histogram = this.yammerHistogram("kafka.server:type=ZooKeeperClientMetrics,name=ZooKeeperRequestLatencyMs");
        long initialCount = histogram.count();
        ((KafkaServer)this.servers().head()).zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        Assertions.assertTrue((histogram.count() > initialCount ? 1 : 0) != 0, (String)"ZooKeeper latency not recorded");
        double min = histogram.min();
        Assertions.assertTrue((min >= 0.0 ? 1 : 0) != 0, (String)new StringBuilder(36).append("Min latency should not be negative: ").append(min).toString());
        Assertions.assertEquals((Object)"CONNECTED", (Object)this.yammerMetricValue("SessionState"), (String)"Unexpected ZK state");
    }

    private void verifyBrokerErrorMetrics(KafkaServer server) {
        int startErrorMetricCount = MetricsTest.errorMetricCount$1();
        String errorMetricPrefix = "kafka.network:type=RequestMetrics,name=ErrorsPerSec";
        this.verifyYammerMetricRecorded(new StringBuilder(28).append(errorMetricPrefix).append(",request=Metadata,error=NONE").toString(), this.verifyYammerMetricRecorded$default$2());
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        try {
            consumer.partitionsFor("12{}!");
        }
        catch (InvalidTopicException invalidTopicException) {}
        this.verifyYammerMetricRecorded(new StringBuilder(47).append(errorMetricPrefix).append(",request=Metadata,error=INVALID_TOPIC_EXCEPTION").toString(), this.verifyYammerMetricRecorded$default$2());
        int currentErrorMetricCount = MetricsTest.errorMetricCount$1();
        Assertions.assertEquals((int)(startErrorMetricCount + 1), (int)currentErrorMetricCount);
        Assertions.assertTrue((currentErrorMetricCount < 10 ? 1 : 0) != 0, (String)new StringBuilder(23).append("Too many error metrics ").append(currentErrorMetricCount).toString());
        try {
            consumer.partitionsFor("non-existing-topic");
        }
        catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {}
        this.verifyYammerMetricRecorded(new StringBuilder(50).append(errorMetricPrefix).append(",request=Metadata,error=UNKNOWN_TOPIC_OR_PARTITION").toString(), this.verifyYammerMetricRecorded$default$2());
    }

    private <T> T verifyKafkaMetric(String name, Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity, Option<String> group, Function1<Iterable<org.apache.kafka.common.Metric>, T> verify) {
        scala.collection.mutable.Map matchingMetrics = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(metrics).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaMetric$1(name, group, x0$1)));
        Assertions.assertTrue((boolean)matchingMetrics.nonEmpty(), (String)new StringBuilder(17).append("Metric not found ").append(name).toString());
        return (T)verify.apply((Object)matchingMetrics.values());
    }

    private <T> Option<String> verifyKafkaMetric$default$4() {
        return None$.MODULE$;
    }

    private double maxKafkaMetricValue(String name, Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity, Option<String> group) {
        scala.collection.mutable.Map verifyKafkaMetric_matchingMetrics = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(metrics).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaMetric$1(name, group, x0$1)));
        Assertions.assertTrue((boolean)verifyKafkaMetric_matchingMetrics.nonEmpty(), (String)new StringBuilder(17).append("Metric not found ").append(name).toString());
        return MetricsTest.$anonfun$maxKafkaMetricValue$1(verifyKafkaMetric_matchingMetrics.values());
    }

    private void verifyKafkaMetricRecorded(String name, Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity, Option<String> group) {
        double value = this.maxKafkaMetricValue(name, metrics, entity, group);
        Assertions.assertTrue((value > 0.0 ? 1 : 0) != 0, (String)new StringBuilder(42).append(entity).append(" metric not recorded correctly for ").append(name).append(" value ").append(value).toString());
    }

    private Option<String> verifyKafkaMetricRecorded$default$4() {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    private Object yammerMetricValue(String name) {
        void var4_4;
        scala.collection.mutable.Map allMetrics = CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala();
        Tuple2 tuple2 = (Tuple2)allMetrics.find((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$yammerMetricValue$1(name, x0$1))).getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)new StringBuilder(43).append("Unable to find broker metric ").append(name).append(": allMetrics: ").append(allMetrics.keySet().map((Function1 & Serializable)x$7 -> x$7.getMBeanName())).toString()));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Metric metric = (Metric)tuple2._2();
        if (var4_4 instanceof Meter) {
            return BoxesRunTime.boxToDouble((double)((Meter)var4_4).count());
        }
        if (var4_4 instanceof Histogram) {
            return BoxesRunTime.boxToDouble((double)((Histogram)var4_4).max());
        }
        if (var4_4 instanceof Gauge) {
            return ((Gauge)var4_4).value();
        }
        return Assertions.fail((String)new StringBuilder(34).append("Unexpected broker metric of class ").append(var4_4.getClass()).toString());
    }

    /*
     * WARNING - void declaration
     */
    private Histogram yammerHistogram(String name) {
        void var4_4;
        scala.collection.mutable.Map allMetrics = CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala();
        Tuple2 tuple2 = (Tuple2)allMetrics.find((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$yammerHistogram$1(name, x0$1))).getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)new StringBuilder(43).append("Unable to find broker metric ").append(name).append(": allMetrics: ").append(allMetrics.keySet().map((Function1 & Serializable)x$8 -> x$8.getMBeanName())).toString()));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Metric metric = (Metric)tuple2._2();
        if (var4_4 instanceof Histogram) {
            return (Histogram)var4_4;
        }
        throw new AssertionError((Object)new StringBuilder(34).append("Unexpected broker metric of class ").append(var4_4.getClass()).toString());
    }

    private double verifyYammerMetricRecorded(String name, Function1<Object, Object> verify) {
        double metricValue = BoxesRunTime.unboxToDouble((Object)this.yammerMetricValue(name));
        Assertions.assertTrue((boolean)verify.apply$mcZD$sp(metricValue), (String)new StringBuilder(48).append("Broker metric not recorded correctly for ").append(name).append(" value ").append(metricValue).toString());
        return metricValue;
    }

    private Function1<Object, Object> verifyYammerMetricRecorded$default$2() {
        return (JFunction1.mcZD.sp & Serializable)d -> d > 0.0;
    }

    private void verifyNoRequestMetrics(String errorMessage) {
        scala.collection.mutable.Map metrics = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyNoRequestMetrics$1(x0$1)));
        Assertions.assertTrue((boolean)metrics.isEmpty(), (String)new StringBuilder(2).append(errorMessage).append(": ").append(metrics.keys()).toString());
    }

    private void verifyRemoteStorageMetrics(boolean shouldContainMetrics) {
        List metrics = ((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(RemoteStorageMetrics.allMetrics()).asScala().filter((Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyRemoteStorageMetrics$1(name)))).toList();
        if (shouldContainMetrics) {
            Assertions.assertEquals((int)RemoteStorageMetrics.allMetrics().size(), (int)metrics.size(), (String)new StringBuilder(27).append("Only ").append(metrics).append(" appear in the metrics").toString());
            return;
        }
        Assertions.assertEquals((int)0, (int)metrics.size(), (String)new StringBuilder(33).append(metrics).append(" should not appear in the metrics").toString());
    }

    private static final boolean exists$1(String name, MetricName rateMetricName, Set allMetricNames) {
        return allMetricNames.contains((Object)new MetricName(name, rateMetricName.group(), "", rateMetricName.tags()));
    }

    private static final void verify$1(MetricName rateMetricName, Set allMetricNames) {
        String name = rateMetricName.name();
        boolean totalExists = MetricsTest.exists$1(name.replace("-rate", "-total"), rateMetricName, allMetricNames);
        boolean totalTimeExists = MetricsTest.exists$1(name.replace("-rate", "-time"), rateMetricName, allMetricNames);
        Assertions.assertTrue((totalExists || totalTimeExists ? 1 : 0) != 0, (String)new StringBuilder(48).append("No cumulative count/time metric for rate metric ").append(rateMetricName).toString());
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaRateMetricsHaveCumulativeCount$1(MetricName x$1) {
        return x$1.name().endsWith("-rate");
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaRateMetricsHaveCumulativeCount$3(MetricName x$3) {
        return x$3.name().endsWith("-rate");
    }

    public static final /* synthetic */ void $anonfun$verifyClientVersionMetrics$2(String entity$1, String name$1, Iterable matchingMetrics) {
        Assertions.assertEquals((int)1, (int)matchingMetrics.size());
        org.apache.kafka.common.Metric metric = (org.apache.kafka.common.Metric)matchingMetrics.head();
        Object value = metric.metricValue();
        Assertions.assertNotNull((Object)value, (String)new StringBuilder(21).append(entity$1).append(" metric not recorded ").append(name$1).toString());
        Assertions.assertNotNull((Object)BoxesRunTime.boxToBoolean((value instanceof String && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)value)) ? 1 : 0) != 0), (String)new StringBuilder(37).append(entity$1).append(" metric ").append(name$1).append(" should be a non-empty String").toString());
        Assertions.assertTrue((boolean)metric.metricName().tags().containsKey("client-id"), (String)"Client-id not specified");
    }

    public static final /* synthetic */ void $anonfun$verifyClientVersionMetrics$1(MetricsTest $this, Map metrics$1, String entity$1, String name) {
        None$ verifyKafkaMetric_group = None$.MODULE$;
        scala.collection.mutable.Map verifyKafkaMetric_matchingMetrics = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(metrics$1).asScala().filter(arg_0 -> MetricsTest.$anonfun$verifyKafkaMetric$1$adapted(name, (Option)verifyKafkaMetric_group, arg_0));
        Assertions.assertTrue((boolean)verifyKafkaMetric_matchingMetrics.nonEmpty(), (String)new StringBuilder(17).append("Metric not found ").append(name).toString());
        Iterable iterable = verifyKafkaMetric_matchingMetrics.values();
        MetricsTest.$anonfun$verifyClientVersionMetrics$2(entity$1, name, iterable);
    }

    public static final /* synthetic */ boolean $anonfun$verifyBrokerAuthenticationMetrics$1(MetricsTest $this, Map metrics$2) {
        return $this.maxKafkaMetricValue("failed-authentication-total", metrics$2, "Broker", (Option<String>)new Some((Object)"socket-server-metrics")) > 0.0;
    }

    public static final /* synthetic */ String $anonfun$verifyBrokerAuthenticationMetrics$2() {
        return "failed-authentication-total not updated";
    }

    public static final /* synthetic */ boolean $anonfun$verifyBrokerMessageConversionMetrics$1(double value) {
        return value > 0.0;
    }

    public static final /* synthetic */ boolean $anonfun$verifyBrokerMessageConversionMetrics$2(double value) {
        return value == 0.0;
    }

    public static final /* synthetic */ boolean $anonfun$verifyBrokerErrorMetrics$1(com.yammer.metrics.core.MetricName x$5) {
        String string = x$5.getName();
        String string2 = "ErrorsPerSec";
        return string != null && string.equals(string2);
    }

    private static final int errorMetricCount$1() {
        return CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala().count((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyBrokerErrorMetrics$1(x$5)));
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaMetric$2(MetricName metricName$1, String x$6) {
        String string = x$6;
        String string2 = metricName$1.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaMetric$1(String name$2, Option group$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetricName metricName = (MetricName)x0$1._1();
            String string = metricName.name();
            return !(string != null ? !string.equals(name$2) : name$2 != null) && group$1.forall((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaMetric$2(metricName, x$6)));
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ double $anonfun$maxKafkaMetricValue$2(double max, org.apache.kafka.common.Metric metric) {
        return Math.max(max, BoxesRunTime.unboxToDouble((Object)metric.metricValue()));
    }

    public static final /* synthetic */ double $anonfun$maxKafkaMetricValue$1(Iterable matchingMetrics) {
        return BoxesRunTime.unboxToDouble((Object)matchingMetrics.foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(max, metric) -> BoxesRunTime.boxToDouble((double)MetricsTest.$anonfun$maxKafkaMetricValue$2(BoxesRunTime.unboxToDouble((Object)max), metric))));
    }

    public static final /* synthetic */ boolean $anonfun$yammerMetricValue$1(String name$3, Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((com.yammer.metrics.core.MetricName)x0$1._1()).getMBeanName().endsWith(name$3);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$yammerHistogram$1(String name$4, Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((com.yammer.metrics.core.MetricName)x0$1._1()).getMBeanName().endsWith(name$4);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyNoRequestMetrics$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((com.yammer.metrics.core.MetricName)x0$1._1()).getMBeanName().startsWith("kafka.network:type=RequestMetrics");
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyRemoteStorageMetrics$2(com.yammer.metrics.core.MetricName name$5, Tuple2 metric) {
        return ((com.yammer.metrics.core.MetricName)metric._1()).getMBeanName().equals(name$5.getMBeanName());
    }

    public static final /* synthetic */ boolean $anonfun$verifyRemoteStorageMetrics$1(com.yammer.metrics.core.MetricName name) {
        return CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().find((Function1 & Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyRemoteStorageMetrics$2(name, metric))).isDefined();
    }

    public MetricsTest() {
        SaslSetup.$init$(this);
        this.brokerCount = 1;
        this.kafkaClientSaslMechanism = "PLAIN";
        this.kafkaServerSaslMechanisms = new .colon.colon((Object)this.kafkaClientSaslMechanism(), (List)Nil$.MODULE$);
        this.kafkaServerJaasEntryName = new StringBuilder(1).append(this.listenerName().value().toLowerCase(Locale.ROOT)).append(".").append(JaasTestUtils$.MODULE$.KafkaServerContextName()).toString();
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ZkEnableSecureAclsProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "2.8");
        this.producerConfig().setProperty("linger.ms", "10");
        this.producerConfig().setProperty("compression.type", "gzip");
        this.serverSaslProperties = new Some((Object)this.kafkaServerSaslProperties((Seq<String>)this.kafkaServerSaslMechanisms(), this.kafkaClientSaslMechanism()));
        this.clientSaslProperties = new Some((Object)this.kafkaClientSaslProperties(this.kafkaClientSaslMechanism(), this.kafkaClientSaslProperties$default$2()));
        Statics.releaseFence();
    }

    public static final /* synthetic */ Object $anonfun$maxKafkaMetricValue$1$adapted(Iterable matchingMetrics) {
        return BoxesRunTime.boxToDouble((double)MetricsTest.$anonfun$maxKafkaMetricValue$1(matchingMetrics));
    }

    public static final /* synthetic */ Object $anonfun$verifyClientVersionMetrics$2$adapted(String entity$1, String name$1, Iterable matchingMetrics) {
        MetricsTest.$anonfun$verifyClientVersionMetrics$2(entity$1, name$1, matchingMetrics);
        return BoxedUnit.UNIT;
    }
}

