/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.metrics.KafkaMetricsGroup;
import kafka.tools.MirrorMaker;
import kafka.tools.MirrorMaker$defaultMirrorMakerMessageHandler$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.clients.consumer.CommitFailedException;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.sys.package$;
import scala.util.control.ControlThrowable;

public final class MirrorMaker$
implements KafkaMetricsGroup {
    public static MirrorMaker$ MODULE$;
    private MirrorMaker.MirrorMakerProducer producer;
    private Seq<MirrorMaker.MirrorMakerThread> mirrorMakerThreads;
    private final AtomicBoolean kafka$tools$MirrorMaker$$isShuttingDown;
    private final AtomicInteger kafka$tools$MirrorMaker$$numDroppedMessages;
    private MirrorMaker.MirrorMakerMessageHandler kafka$tools$MirrorMaker$$messageHandler;
    private int kafka$tools$MirrorMaker$$offsetCommitIntervalMs;
    private boolean kafka$tools$MirrorMaker$$abortOnSendFailure;
    private volatile boolean kafka$tools$MirrorMaker$$exitingOnSendFailure;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new MirrorMaker$();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        MirrorMaker$ mirrorMaker$ = this;
        synchronized (mirrorMaker$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public MirrorMaker.MirrorMakerProducer producer() {
        return this.producer;
    }

    public void producer_$eq(MirrorMaker.MirrorMakerProducer x$1) {
        this.producer = x$1;
    }

    private Seq<MirrorMaker.MirrorMakerThread> mirrorMakerThreads() {
        return this.mirrorMakerThreads;
    }

    private void mirrorMakerThreads_$eq(Seq<MirrorMaker.MirrorMakerThread> x$1) {
        this.mirrorMakerThreads = x$1;
    }

    public AtomicBoolean kafka$tools$MirrorMaker$$isShuttingDown() {
        return this.kafka$tools$MirrorMaker$$isShuttingDown;
    }

    public AtomicInteger kafka$tools$MirrorMaker$$numDroppedMessages() {
        return this.kafka$tools$MirrorMaker$$numDroppedMessages;
    }

    public MirrorMaker.MirrorMakerMessageHandler kafka$tools$MirrorMaker$$messageHandler() {
        return this.kafka$tools$MirrorMaker$$messageHandler;
    }

    private void kafka$tools$MirrorMaker$$messageHandler_$eq(MirrorMaker.MirrorMakerMessageHandler x$1) {
        this.kafka$tools$MirrorMaker$$messageHandler = x$1;
    }

    public int kafka$tools$MirrorMaker$$offsetCommitIntervalMs() {
        return this.kafka$tools$MirrorMaker$$offsetCommitIntervalMs;
    }

    private void kafka$tools$MirrorMaker$$offsetCommitIntervalMs_$eq(int x$1) {
        this.kafka$tools$MirrorMaker$$offsetCommitIntervalMs = x$1;
    }

    public boolean kafka$tools$MirrorMaker$$abortOnSendFailure() {
        return this.kafka$tools$MirrorMaker$$abortOnSendFailure;
    }

    private void kafka$tools$MirrorMaker$$abortOnSendFailure_$eq(boolean x$1) {
        this.kafka$tools$MirrorMaker$$abortOnSendFailure = x$1;
    }

    public boolean kafka$tools$MirrorMaker$$exitingOnSendFailure() {
        return this.kafka$tools$MirrorMaker$$exitingOnSendFailure;
    }

    public void kafka$tools$MirrorMaker$$exitingOnSendFailure_$eq(boolean x$1) {
        this.kafka$tools$MirrorMaker$$exitingOnSendFailure = x$1;
    }

    public void main(String[] args) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting mirror maker");
        try {
            String rebalanceListenerArgs;
            OptionParser parser = new OptionParser(false);
            ArgumentAcceptingOptionSpec consumerConfigOpt = parser.accepts("consumer.config", "Embedded consumer config for consuming from the source cluster.").withRequiredArg().describedAs("config file").ofType(String.class);
            parser.accepts("new.consumer", "DEPRECATED Use new consumer in mirror maker (this is the default so this option will be removed in a future version).");
            ArgumentAcceptingOptionSpec producerConfigOpt = parser.accepts("producer.config", "Embedded producer config.").withRequiredArg().describedAs("config file").ofType(String.class);
            ArgumentAcceptingOptionSpec numStreamsOpt = parser.accepts("num.streams", "Number of consumption streams.").withRequiredArg().describedAs("Number of threads").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1), (Object[])new Integer[0]);
            ArgumentAcceptingOptionSpec whitelistOpt = parser.accepts("whitelist", "Whitelist of topics to mirror.").withRequiredArg().describedAs("Java regex (String)").ofType(String.class);
            ArgumentAcceptingOptionSpec offsetCommitIntervalMsOpt = parser.accepts("offset.commit.interval.ms", "Offset commit interval in ms.").withRequiredArg().describedAs("offset commit interval in millisecond").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(60000), (Object[])new Integer[0]);
            ArgumentAcceptingOptionSpec consumerRebalanceListenerOpt = parser.accepts("consumer.rebalance.listener", "The consumer rebalance listener to use for mirror maker consumer.").withRequiredArg().describedAs("A custom rebalance listener of type ConsumerRebalanceListener").ofType(String.class);
            ArgumentAcceptingOptionSpec rebalanceListenerArgsOpt = parser.accepts("rebalance.listener.args", "Arguments used by custom rebalance listener for mirror maker consumer.").withRequiredArg().describedAs("Arguments passed to custom rebalance listener constructor as a string.").ofType(String.class);
            ArgumentAcceptingOptionSpec messageHandlerOpt = parser.accepts("message.handler", "Message handler which will process every record in-between consumer and producer.").withRequiredArg().describedAs("A custom message handler of type MirrorMakerMessageHandler").ofType(String.class);
            ArgumentAcceptingOptionSpec messageHandlerArgsOpt = parser.accepts("message.handler.args", "Arguments used by custom message handler for mirror maker.").withRequiredArg().describedAs("Arguments passed to message handler constructor.").ofType(String.class);
            ArgumentAcceptingOptionSpec abortOnSendFailureOpt = parser.accepts("abort.on.send.failure", "Configure the mirror maker to exit on a failed send.").withRequiredArg().describedAs("Stop the entire mirror maker when a send failure occurs").ofType(String.class).defaultsTo((Object)"true", (Object[])new String[0]);
            OptionSpecBuilder helpOpt = parser.accepts("help", "Print this message.");
            if (args.length == 0) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "Continuously copy data between two Kafka clusters.");
            }
            OptionSet options = parser.parse(args);
            if (options.has((OptionSpec)helpOpt)) {
                parser.printHelpOn((OutputStream)System.out);
                throw package$.MODULE$.exit(0);
            }
            CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{consumerConfigOpt, producerConfigOpt}));
            Properties consumerProps = Utils.loadProps((String)((String)options.valueOf((OptionSpec)consumerConfigOpt)));
            if (!options.has((OptionSpec)whitelistOpt)) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "whitelist must be specified");
                throw package$.MODULE$.exit(1);
            }
            if (!consumerProps.containsKey("partition.assignment.strategy")) {
                System.err.println("WARNING: The default partition assignment strategy of the mirror maker will change from 'range' to 'roundrobin' in an upcoming release (so that better load balancing can be achieved). If you prefer to make this switch in advance of that release add the following to the corresponding config: 'partition.assignment.strategy=org.apache.kafka.clients.consumer.RoundRobinAssignor'");
            }
            this.kafka$tools$MirrorMaker$$abortOnSendFailure_$eq(new StringOps(Predef$.MODULE$.augmentString((String)options.valueOf((OptionSpec)abortOnSendFailureOpt))).toBoolean());
            this.kafka$tools$MirrorMaker$$offsetCommitIntervalMs_$eq((Integer)options.valueOf((OptionSpec)offsetCommitIntervalMsOpt));
            int numStreams = (Integer)options.valueOf((OptionSpec)numStreamsOpt);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    MirrorMaker$.MODULE$.cleanShutdown();
                }
            });
            Properties producerProps = Utils.loadProps((String)((String)options.valueOf((OptionSpec)producerConfigOpt)));
            boolean sync = producerProps.getProperty("producer.type", "async").equals("sync");
            producerProps.remove("producer.type");
            this.maybeSetDefaultProperty(producerProps, "retries", ((Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)).toString());
            this.maybeSetDefaultProperty(producerProps, "max.block.ms", ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
            this.maybeSetDefaultProperty(producerProps, "acks", "all");
            this.maybeSetDefaultProperty(producerProps, "max.in.flight.requests.per.connection", "1");
            producerProps.setProperty("key.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
            producerProps.setProperty("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
            this.producer_$eq(new MirrorMaker.MirrorMakerProducer(sync, producerProps));
            String customRebalanceListenerClass = (String)options.valueOf((OptionSpec)consumerRebalanceListenerOpt);
            None$ customRebalanceListener = customRebalanceListenerClass != null ? ((rebalanceListenerArgs = (String)options.valueOf((OptionSpec)rebalanceListenerArgsOpt)) != null ? new Some(CoreUtils$.MODULE$.createObject(customRebalanceListenerClass, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{rebalanceListenerArgs}))) : new Some(CoreUtils$.MODULE$.createObject(customRebalanceListenerClass, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[0])))) : None$.MODULE$;
            Seq<MirrorMaker.ConsumerWrapper> mirrorMakerConsumers = this.createConsumers(numStreams, consumerProps, (Option<ConsumerRebalanceListener>)customRebalanceListener, (Option<String>)Option$.MODULE$.apply(options.valueOf((OptionSpec)whitelistOpt)));
            this.mirrorMakerThreads_$eq((Seq<MirrorMaker.MirrorMakerThread>)((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numStreams).map((Function1 & Serializable & scala.Serializable)i -> MirrorMaker$.$anonfun$main$3(mirrorMakerConsumers, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())));
            String customMessageHandlerClass = (String)options.valueOf((OptionSpec)messageHandlerOpt);
            String messageHandlerArgs = (String)options.valueOf((OptionSpec)messageHandlerArgsOpt);
            this.kafka$tools$MirrorMaker$$messageHandler_$eq(customMessageHandlerClass != null ? (messageHandlerArgs != null ? (MirrorMaker.MirrorMakerMessageHandler)CoreUtils$.MODULE$.createObject(customMessageHandlerClass, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{messageHandlerArgs})) : (MirrorMaker.MirrorMakerMessageHandler)CoreUtils$.MODULE$.createObject(customMessageHandlerClass, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[0]))) : MirrorMaker$defaultMirrorMakerMessageHandler$.MODULE$);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ControlThrowable) {
                ControlThrowable controlThrowable = (ControlThrowable)throwable2;
                throw (Throwable)controlThrowable;
            }
            if (throwable2 != null) {
                Throwable throwable3 = throwable2;
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception when starting mirror maker.", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable3);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
        this.mirrorMakerThreads().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.start();
            return BoxedUnit.UNIT;
        });
        this.mirrorMakerThreads().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.awaitShutdown();
            return BoxedUnit.UNIT;
        });
    }

    public Seq<MirrorMaker.ConsumerWrapper> createConsumers(int numStreams, Properties consumerConfigProps, Option<ConsumerRebalanceListener> customRebalanceListener, Option<String> whitelist) {
        this.maybeSetDefaultProperty(consumerConfigProps, "enable.auto.commit", "false");
        consumerConfigProps.setProperty("key.deserializer", ByteArrayDeserializer.class.getName());
        consumerConfigProps.setProperty("value.deserializer", ByteArrayDeserializer.class.getName());
        String groupIdString = consumerConfigProps.getProperty("group.id");
        IndexedSeq consumers = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numStreams).map((Function1 & Serializable & scala.Serializable)i -> MirrorMaker$.$anonfun$createConsumers$1(consumerConfigProps, groupIdString, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        whitelist.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException("White list cannot be empty");
        });
        return (Seq)consumers.map((Function1 & Serializable & scala.Serializable)consumer -> new MirrorMaker.ConsumerWrapper((Consumer<byte[], byte[]>)consumer, customRebalanceListener, whitelist), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public void commitOffsets(MirrorMaker.ConsumerWrapper consumerWrapper) {
        if (!this.kafka$tools$MirrorMaker$$exitingOnSendFailure()) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Committing offsets.");
            try {
                consumerWrapper.commit();
            }
            catch (WakeupException e) {
                consumerWrapper.commit();
                throw e;
            }
            catch (CommitFailedException commitFailedException) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(190).append("Failed to commit offsets because the consumer group has rebalanced and assigned partitions to another instance. If you see this regularly, it could indicate that you need to either increase ").append(new StringBuilder(66).append("the consumer's ").append("session.timeout.ms").append(" or reduce the number of records ").toString()).append(new StringBuilder(47).append("handled on each iteration with ").append("max.poll.records").toString()).toString());
            }
        } else {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exiting on send failure, skip committing offsets.");
        }
    }

    public void cleanShutdown() {
        block1: {
            if (!this.kafka$tools$MirrorMaker$$isShuttingDown().compareAndSet(false, true)) break block1;
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Start clean shutdown.");
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down consumer threads.");
            if (this.mirrorMakerThreads() != null) {
                this.mirrorMakerThreads().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                    x$3.shutdown();
                    return BoxedUnit.UNIT;
                });
                this.mirrorMakerThreads().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                    x$4.awaitShutdown();
                    return BoxedUnit.UNIT;
                });
            }
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Closing producer.");
            this.producer().close();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Kafka mirror maker shutdown successfully");
        }
    }

    private void maybeSetDefaultProperty(Properties properties, String propertyName, String defaultValue) {
        block0: {
            String propertyValue = properties.getProperty(propertyName);
            properties.setProperty(propertyName, (String)Option$.MODULE$.apply((Object)propertyValue).getOrElse((Function0 & Serializable & scala.Serializable)() -> defaultValue));
            String string = properties.getProperty(propertyName);
            String string2 = defaultValue;
            if (!(string == null ? string2 != null : !string.equals(string2))) break block0;
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Property %s is overridden to %s - data loss or message reordering is possible.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{propertyName, propertyValue})));
        }
    }

    public static final /* synthetic */ MirrorMaker.MirrorMakerThread $anonfun$main$3(Seq mirrorMakerConsumers$1, int i) {
        return new MirrorMaker.MirrorMakerThread((MirrorMaker.ConsumerWrapper)mirrorMakerConsumers$1.apply(i), i);
    }

    public static final /* synthetic */ KafkaConsumer $anonfun$createConsumers$1(Properties consumerConfigProps$1, String groupIdString$1, int i) {
        consumerConfigProps$1.setProperty("client.id", new StringBuilder(1).append(groupIdString$1).append("-").append(((Object)BoxesRunTime.boxToInteger((int)i)).toString()).toString());
        return new KafkaConsumer(consumerConfigProps$1);
    }

    private MirrorMaker$() {
        MODULE$ = this;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.producer = null;
        this.mirrorMakerThreads = null;
        this.kafka$tools$MirrorMaker$$isShuttingDown = new AtomicBoolean(false);
        this.kafka$tools$MirrorMaker$$numDroppedMessages = new AtomicInteger(0);
        this.kafka$tools$MirrorMaker$$messageHandler = null;
        this.kafka$tools$MirrorMaker$$offsetCommitIntervalMs = 0;
        this.kafka$tools$MirrorMaker$$abortOnSendFailure = true;
        this.kafka$tools$MirrorMaker$$exitingOnSendFailure = false;
        this.newGauge("MirrorMaker-numDroppedMessages", new Gauge<Object>(){

            public int value() {
                return MirrorMaker$.MODULE$.kafka$tools$MirrorMaker$$numDroppedMessages().get();
            }
        }, this.newGauge$default$3());
    }
}

