/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import kafka.api.ApiVersion$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.ConfigHandler;
import kafka.server.Constants$;
import kafka.server.KafkaConfig;
import kafka.server.QuotaFactory;
import kafka.server.ReplicationQuotaManager;
import kafka.server.ThrottledReplicaListValidator$;
import kafka.utils.Logging;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001a4A!\u0001\u0002\u0001\u000f\t\u0011Bk\u001c9jG\u000e{gNZ5h\u0011\u0006tG\r\\3s\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001\t\u001dI\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0011\u001b\u0005\u0011\u0011BA\t\u0003\u00055\u0019uN\u001c4jO\"\u000bg\u000e\u001a7feB\u00111CF\u0007\u0002))\u0011Q\u0003B\u0001\u0006kRLGn]\u0005\u0003/Q\u0011q\u0001T8hO&tw\r\u0003\u0005\u001a\u0001\t\u0015\r\u0011\"\u0003\u001b\u0003)awnZ'b]\u0006<WM]\u000b\u00027A\u0011AdH\u0007\u0002;)\u0011a\u0004B\u0001\u0004Y><\u0017B\u0001\u0011\u001e\u0005)aunZ'b]\u0006<WM\u001d\u0005\tE\u0001\u0011\t\u0011)A\u00057\u0005YAn\\4NC:\fw-\u001a:!\u0011!!\u0003A!A!\u0002\u0013)\u0013aC6bM.\f7i\u001c8gS\u001e\u0004\"a\u0004\u0014\n\u0005\u001d\u0012!aC&bM.\f7i\u001c8gS\u001eD\u0001\"\u000b\u0001\u0003\u0006\u0004%\tAK\u0001\u0007cV|G/Y:\u0016\u0003-\u0002\"\u0001\f\u001c\u000f\u00055\"dB\u0001\u00184\u001d\ty#'D\u00011\u0015\t\td!\u0001\u0004=e>|GOP\u0005\u0002\u000b%\u00111\u0001B\u0005\u0003k\t\tA\"U;pi\u00064\u0015m\u0019;pefL!a\u000e\u001d\u0003\u001bE+x\u000e^1NC:\fw-\u001a:t\u0015\t)$\u0001\u0003\u0005;\u0001\t\u0005\t\u0015!\u0003,\u0003\u001d\tXo\u001c;bg\u0002BQ\u0001\u0010\u0001\u0005\u0002u\na\u0001P5oSRtD\u0003\u0002 @\u0001\u0006\u0003\"a\u0004\u0001\t\u000beY\u0004\u0019A\u000e\t\u000b\u0011Z\u0004\u0019A\u0013\t\u000b%Z\u0004\u0019A\u0016\t\u000b\r\u0003A\u0011\u0001#\u0002)A\u0014xnY3tg\u000e{gNZ5h\u0007\"\fgnZ3t)\r)\u0005J\u0015\t\u0003\u0013\u0019K!a\u0012\u0006\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0013\n\u0003\rAS\u0001\u0006i>\u0004\u0018n\u0019\t\u0003\u0017>s!\u0001T'\u0011\u0005=R\u0011B\u0001(\u000b\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001+\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u00059S\u0001\"B*C\u0001\u0004!\u0016a\u0003;pa&\u001c7i\u001c8gS\u001e\u0004\"!\u0016.\u000e\u0003YS!a\u0016-\u0002\tU$\u0018\u000e\u001c\u0006\u00023\u0006!!.\u0019<b\u0013\tYfK\u0001\u0006Qe>\u0004XM\u001d;jKNDQ!\u0018\u0001\u0005\u0002y\u000b\u0001\u0004]1sg\u0016$\u0006N]8ui2,G\rU1si&$\u0018n\u001c8t)\u0011y6\u000e\u001c8\u0011\u0007\u0001,\u0007N\u0004\u0002bG:\u0011qFY\u0005\u0002\u0017%\u0011AMC\u0001\ba\u0006\u001c7.Y4f\u0013\t1wMA\u0002TKFT!\u0001\u001a\u0006\u0011\u0005%I\u0017B\u00016\u000b\u0005\rIe\u000e\u001e\u0005\u0006'r\u0003\r\u0001\u0016\u0005\u0006[r\u0003\r\u0001[\u0001\tEJ|7.\u001a:JI\")q\u000e\u0018a\u0001\u0015\u0006!\u0001O]8q\u0011\u0015\t\b\u0001\"\u0001s\u0003=)\u0007p\u00197vI\u0016$7i\u001c8gS\u001e\u001cHcA:woB\u00191\n\u001e&\n\u0005U\f&aA*fi\")\u0011\n\u001da\u0001\u0015\")1\u000b\u001da\u0001)\u0002")
public class TopicConfigHandler
implements ConfigHandler,
Logging {
    private final LogManager logManager;
    private final KafkaConfig kafkaConfig;
    private final QuotaFactory.QuotaManagers quotas;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        TopicConfigHandler topicConfigHandler = this;
        synchronized (topicConfigHandler) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private LogManager logManager() {
        return this.logManager;
    }

    public QuotaFactory.QuotaManagers quotas() {
        return this.quotas;
    }

    @Override
    public void processConfigChanges(String topic, Properties topicConfig) {
        scala.collection.immutable.Set<String> configNamesToExclude = this.excludedConfigs(topic, topicConfig);
        Buffer logs = this.logManager().logsByTopic(topic).toBuffer();
        if (logs.nonEmpty()) {
            Properties props = new Properties();
            ((IterableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(topicConfig).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                BoxedUnit boxedUnit = !configNamesToExclude.contains((Object)key) ? props.put(key, value) : BoxedUnit.UNIT;
                return boxedUnit;
            });
            LogConfig logConfig = LogConfig$.MODULE$.fromProps(this.logManager().currentDefaultConfig().originals(), props);
            logs.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                x$1.updateConfig((Set<String>)((MapLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(topicConfig).asScala()).keySet(), logConfig);
                return BoxedUnit.UNIT;
            });
        }
        this.updateThrottledList$1(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), this.quotas().leader(), topic, topicConfig);
        this.updateThrottledList$1(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), this.quotas().follower(), topic, topicConfig);
    }

    public Seq<Object> parseThrottledPartitions(Properties topicConfig, int brokerId, String prop) {
        String configValue = topicConfig.get(prop).toString().trim();
        ThrottledReplicaListValidator$.MODULE$.ensureValidString(prop, configValue);
        String string = configValue;
        Seq seq = "".equals(string) ? (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$) : ("*".equals(string) ? Constants$.MODULE$.AllReplicas() : new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])configValue.trim().split(","))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.split(":"), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))))).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TopicConfigHandler.$anonfun$parseThrottledPartitions$2(brokerId, x$3))))).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)TopicConfigHandler.$anonfun$parseThrottledPartitions$3(x$4)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).toSeq());
        return seq;
    }

    public scala.collection.immutable.Set<String> excludedConfigs(String topic, Properties topicConfig) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)topicConfig.getProperty(LogConfig$.MODULE$.MessageFormatVersionProp())).flatMap((Function1 & Serializable & scala.Serializable)versionString -> {
            None$ none$;
            if ($this.kafkaConfig.interBrokerProtocolVersion().$less(ApiVersion$.MODULE$.apply((String)versionString))) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Log configuration ").append(LogConfig$.MODULE$.MessageFormatVersionProp()).append(" is ignored for `").append(topic).append("` because `").append((String)versionString).append("` ").append(new StringBuilder(61).append("is not compatible with Kafka inter-broker protocol version `").append($this.kafkaConfig.interBrokerProtocolVersionString()).append("`").toString()).toString());
                none$ = new Some((Object)LogConfig$.MODULE$.MessageFormatVersionProp());
            } else {
                none$ = None$.MODULE$;
            }
            return none$;
        })).toSet();
    }

    private final void updateThrottledList$1(String prop, ReplicationQuotaManager quotaManager, String topic$1, Properties topicConfig$1) {
        if (topicConfig$1.containsKey(prop) && topicConfig$1.getProperty(prop).length() > 0) {
            Seq<Object> partitions = this.parseThrottledPartitions(topicConfig$1, this.kafkaConfig.brokerId(), prop);
            quotaManager.markThrottled(topic$1, partitions);
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Setting ").append(prop).append(" on broker ").append($this.kafkaConfig.brokerId()).append(" for topic: ").append(topic$1).append(" and partitions ").append(partitions).toString());
        } else {
            quotaManager.removeThrottle(topic$1);
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Removing ").append(prop).append(" from broker ").append($this.kafkaConfig.brokerId()).append(" for topic ").append(topic$1).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$parseThrottledPartitions$2(int brokerId$1, String[] x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3[1])).toInt() == brokerId$1;
    }

    public static final /* synthetic */ int $anonfun$parseThrottledPartitions$3(String[] x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4[0])).toInt();
    }

    public TopicConfigHandler(LogManager logManager, KafkaConfig kafkaConfig, QuotaFactory.QuotaManagers quotas) {
        this.logManager = logManager;
        this.kafkaConfig = kafkaConfig;
        this.quotas = quotas;
        Logging.$init$(this);
    }
}

