/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.common.TopicAndPartition;
import kafka.controller.StateChangeLogger;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t-d\u0001B\u0001\u0003\u0001\u001d\u0011Q\"T3uC\u0012\fG/Y\"bG\",'BA\u0002\u0005\u0003\u0019\u0019XM\u001d<fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001Aa\u0002\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0003#\u0011\tQ!\u001e;jYNL!a\u0005\t\u0003\u000f1{wmZ5oO\"AQ\u0003\u0001B\u0001B\u0003%a#\u0001\u0005ce>\\WM]%e!\tIq#\u0003\u0002\u0019\u0015\t\u0019\u0011J\u001c;\t\u000bi\u0001A\u0011A\u000e\u0002\rqJg.\u001b;?)\tab\u0004\u0005\u0002\u001e\u00015\t!\u0001C\u0003\u00163\u0001\u0007a\u0003C\u0004!\u0001\t\u0007I\u0011B\u0011\u0002\u000b\r\f7\r[3\u0016\u0003\t\u0002Ba\t\u0015+k5\tAE\u0003\u0002&M\u00059Q.\u001e;bE2,'BA\u0014\u000b\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003S\u0011\u00121!T1q!\tY#G\u0004\u0002-aA\u0011QFC\u0007\u0002])\u0011qFB\u0001\u0007yI|w\u000e\u001e \n\u0005ER\u0011A\u0002)sK\u0012,g-\u0003\u00024i\t11\u000b\u001e:j]\u001eT!!\r\u0006\u0011\t\rBcC\u000e\t\u0003o\u0011s!\u0001\u000f\"\u000e\u0003eR!AO\u001e\u0002\u0011I,\u0017/^3tiNT!\u0001P\u001f\u0002\r\r|W.\\8o\u0015\t)aH\u0003\u0002@\u0001\u00061\u0011\r]1dQ\u0016T\u0011!Q\u0001\u0004_J<\u0017BA\":\u0003U)\u0006\u000fZ1uK6+G/\u00193bi\u0006\u0014V-];fgRL!!\u0012$\u0003\u001dA\u000b'\u000f^5uS>t7\u000b^1uK*\u00111)\u000f\u0005\u0007\u0011\u0002\u0001\u000b\u0011\u0002\u0012\u0002\r\r\f7\r[3!\u0011\u001dQ\u0005\u00011A\u0005\n-\u000bAbY8oiJ|G\u000e\\3s\u0013\u0012,\u0012\u0001\u0014\t\u0004\u001353\u0012B\u0001(\u000b\u0005\u0019y\u0005\u000f^5p]\"9\u0001\u000b\u0001a\u0001\n\u0013\t\u0016\u0001E2p]R\u0014x\u000e\u001c7fe&#w\fJ3r)\t\u0011V\u000b\u0005\u0002\n'&\u0011AK\u0003\u0002\u0005+:LG\u000fC\u0004W\u001f\u0006\u0005\t\u0019\u0001'\u0002\u0007a$\u0013\u0007\u0003\u0004Y\u0001\u0001\u0006K\u0001T\u0001\u000eG>tGO]8mY\u0016\u0014\u0018\n\u001a\u0011)\u0005]S\u0006CA\u0005\\\u0013\ta&B\u0001\u0005w_2\fG/\u001b7f\u0011\u001dq\u0006A1A\u0005\n}\u000bA\"\u00197jm\u0016\u0014%o\\6feN,\u0012\u0001\u0019\t\u0005G!2\u0012\r\u0005\u0002cK6\t1M\u0003\u0002e\t\u000591\r\\;ti\u0016\u0014\u0018B\u00014d\u0005\u0019\u0011%o\\6fe\"1\u0001\u000e\u0001Q\u0001\n\u0001\fQ\"\u00197jm\u0016\u0014%o\\6feN\u0004\u0003b\u00026\u0001\u0005\u0004%Ia[\u0001\u000bC2Lg/\u001a(pI\u0016\u001cX#\u00017\u0011\t\rBc#\u001c\t\u0005]>\u0004h/D\u0001'\u0013\tIc\u0005\u0005\u0002ri6\t!O\u0003\u0002tw\u00059a.\u001a;x_J\\\u0017BA;s\u00051a\u0015n\u001d;f]\u0016\u0014h*Y7f!\t9\b0D\u0001<\u0013\tI8H\u0001\u0003O_\u0012,\u0007BB>\u0001A\u0003%A.A\u0006bY&4XMT8eKN\u0004\u0003bB?\u0001\u0005\u0004%IA`\u0001\u0016a\u0006\u0014H/\u001b;j_:lU\r^1eCR\fGj\\2l+\u0005y\b\u0003BA\u0001\u0003'i!!a\u0001\u000b\t\u0005\u0015\u0011qA\u0001\u0006Y>\u001c7n\u001d\u0006\u0005\u0003\u0013\tY!\u0001\u0006d_:\u001cWO\u001d:f]RTA!!\u0004\u0002\u0010\u0005!Q\u000f^5m\u0015\t\t\t\"\u0001\u0003kCZ\f\u0017\u0002BA\u000b\u0003\u0007\u0011aCU3f]R\u0014\u0018M\u001c;SK\u0006$wK]5uK2{7m\u001b\u0005\b\u00033\u0001\u0001\u0015!\u0003\u0000\u0003Y\u0001\u0018M\u001d;ji&|g.T3uC\u0012\fG/\u0019'pG.\u0004\u0003\"CA\u000f\u0001\t\u0007I\u0011BA\u0010\u0003E\u0019H/\u0019;f\u0007\"\fgnZ3M_\u001e<WM]\u000b\u0003\u0003C\u0001B!a\t\u0002*5\u0011\u0011Q\u0005\u0006\u0004\u0003O!\u0011AC2p]R\u0014x\u000e\u001c7fe&!\u00111FA\u0013\u0005E\u0019F/\u0019;f\u0007\"\fgnZ3M_\u001e<WM\u001d\u0005\t\u0003_\u0001\u0001\u0015!\u0003\u0002\"\u0005\u00112\u000f^1uK\u000eC\u0017M\\4f\u0019><w-\u001a:!\u0011\u001d\t\u0019\u0004\u0001C\u0005\u0003k\tAbZ3u\u000b:$\u0007o\\5oiN$\u0002\"a\u000e\u0002>\u0005M\u0013q\u000b\t\u0005]\u0006eb/C\u0002\u0002<\u0019\u00121aU3r\u0011!\ty$!\rA\u0002\u0005\u0005\u0013a\u00022s_.,'o\u001d\t\u0006\u0003\u0007\niE\u0006\b\u0005\u0003\u000b\nIED\u0002.\u0003\u000fJ\u0011aC\u0005\u0004\u0003\u0017R\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003\u001f\n\tF\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\tYE\u0003\u0005\b\u0003+\n\t\u00041\u0001q\u00031a\u0017n\u001d;f]\u0016\u0014h*Y7f\u0011!\tI&!\rA\u0002\u0005m\u0013A\u00074jYR,'/\u00168bm\u0006LG.\u00192mK\u0016sG\r]8j]R\u001c\bcA\u0005\u0002^%\u0019\u0011q\f\u0006\u0003\u000f\t{w\u000e\\3b]\"9\u00111\r\u0001\u0005\n\u0005\u0015\u0014\u0001F4fiB\u000b'\u000f^5uS>tW*\u001a;bI\u0006$\u0018\r\u0006\u0006\u0002h\u0005e\u0014QPA@\u0003\u0007\u0003B!C'\u0002jA1\u00111IA'\u0003W\u0002B!!\u001c\u0002t9\u0019\u0001(a\u001c\n\u0007\u0005E\u0014(\u0001\tNKR\fG-\u0019;b%\u0016\u001c\bo\u001c8tK&!\u0011QOA<\u0005E\u0001\u0016M\u001d;ji&|g.T3uC\u0012\fG/\u0019\u0006\u0004\u0003cJ\u0004bBA>\u0003C\u0002\rAK\u0001\u0006i>\u0004\u0018n\u0019\u0005\b\u0003+\n\t\u00071\u0001q\u0011!\t\t)!\u0019A\u0002\u0005m\u0013!G3se>\u0014XK\\1wC&d\u0017M\u00197f\u000b:$\u0007o\\5oiND\u0001\"!\"\u0002b\u0001\u0007\u00111L\u0001\u001aKJ\u0014xN]+oCZ\f\u0017\u000e\\1cY\u0016d\u0015n\u001d;f]\u0016\u00148\u000fC\u0004\u0002\n\u0002!I!a#\u0002!\u001d,G/\u00117jm\u0016,e\u000e\u001a9pS:$HCBAG\u0003\u001f\u000b\t\nE\u0002\n\u001bZDa!FAD\u0001\u00041\u0002bBA+\u0003\u000f\u0003\r\u0001\u001d\u0005\b\u0003+\u0003A\u0011AAL\u0003A9W\r\u001e+pa&\u001cW*\u001a;bI\u0006$\u0018\r\u0006\u0006\u0002\u001a\u0006\u0005\u00161VAW\u0003_\u0003RA\\A\u001d\u00037\u0003B!!\u001c\u0002\u001e&!\u0011qTA<\u00055!v\u000e]5d\u001b\u0016$\u0018\rZ1uC\"A\u00111UAJ\u0001\u0004\t)+\u0001\u0004u_BL7m\u001d\t\u0005]\u0006\u001d&&C\u0002\u0002*\u001a\u00121aU3u\u0011\u001d\t)&a%A\u0002AD!\"!!\u0002\u0014B\u0005\t\u0019AA.\u0011)\t))a%\u0011\u0002\u0003\u0007\u00111\f\u0005\b\u0003g\u0003A\u0011AA[\u000319W\r^!mYR{\u0007/[2t)\t\t)\u000bC\u0004\u0002:\u0002!\t!a/\u0002!\u001d,G/\u00117m!\u0006\u0014H/\u001b;j_:\u001cHCAA_!\u0019Y\u0013qXAam%\u0011\u0011\u0006\u000e\t\u0004o\u0006\r\u0017bAAcw\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007bBAe\u0001\u0011\u0005\u00111Z\u0001\u0015O\u0016$hj\u001c8Fq&\u001cH/\u001b8h)>\u0004\u0018nY:\u0015\t\u0005\u0015\u0016Q\u001a\u0005\t\u0003G\u000b9\r1\u0001\u0002&\"9\u0011\u0011\u001b\u0001\u0005\u0002\u0005M\u0017!D5t\u0005J|7.\u001a:BY&4X\r\u0006\u0003\u0002\\\u0005U\u0007BB\u000b\u0002P\u0002\u0007a\u0003C\u0004\u0002Z\u0002!\t!a7\u0002\u001f\u001d,G/\u00117jm\u0016\u0014%o\\6feN,\"!!8\u0011\t9\fI$\u0019\u0005\b\u0003C\u0004A\u0011BAr\u0003a\tG\rZ(s+B$\u0017\r^3QCJ$\u0018\u000e^5p]&sgm\u001c\u000b\b%\u0006\u0015\u0018q]Av\u0011\u001d\tY(a8A\u0002)Bq!!;\u0002`\u0002\u0007a#A\u0006qCJ$\u0018\u000e^5p]&#\u0007bBAw\u0003?\u0004\rAN\u0001\ngR\fG/Z%oM>Dq!!=\u0001\t\u0003\t\u00190\u0001\thKR\u0004\u0016M\u001d;ji&|g.\u00138g_R1\u0011Q_A|\u0003s\u00042!C'7\u0011\u001d\tY(a<A\u0002)Bq!!;\u0002p\u0002\u0007a\u0003C\u0004\u0002~\u0002!\t!a@\u00025\u001d,G\u000fU1si&$\u0018n\u001c8MK\u0006$WM]#oIB|\u0017N\u001c;\u0015\u0011\u00055%\u0011\u0001B\u0002\u0005\u000bAq!a\u001f\u0002|\u0002\u0007!\u0006C\u0004\u0002j\u0006m\b\u0019\u0001\f\t\u000f\u0005U\u00131 a\u0001a\"1!\u0011\u0002\u0001\u0005\u0002-\u000bqbZ3u\u0007>tGO]8mY\u0016\u0014\u0018\n\u001a\u0005\b\u0005\u001b\u0001A\u0011\u0001B\b\u0003I9W\r^\"mkN$XM]'fi\u0006$\u0017\r^1\u0015\r\tE!q\u0003B\u000e!\r9(1C\u0005\u0004\u0005+Y$aB\"mkN$XM\u001d\u0005\b\u00053\u0011Y\u00011\u0001+\u0003%\u0019G.^:uKJLE\rC\u0004\u0002V\t-\u0001\u0019\u00019\t\u000f\t}\u0001\u0001\"\u0001\u0003\"\u0005YQ\u000f\u001d3bi\u0016\u001c\u0015m\u00195f)\u0019\u0011\u0019C!\n\u0003*A)a.!\u000f\u0002B\"9!q\u0005B\u000f\u0001\u00041\u0012!D2peJ,G.\u0019;j_:LE\r\u0003\u0005\u0003,\tu\u0001\u0019\u0001B\u0017\u0003U)\b\u000fZ1uK6+G/\u00193bi\u0006\u0014V-];fgR\u00042\u0001\u000fB\u0018\u0013\r\u0011\t$\u000f\u0002\u0016+B$\u0017\r^3NKR\fG-\u0019;b%\u0016\fX/Z:u\u0011\u001d\u0011)\u0004\u0001C\u0001\u0005o\t\u0001bY8oi\u0006Lgn\u001d\u000b\u0005\u00037\u0012I\u0004C\u0004\u0002|\tM\u0002\u0019\u0001\u0016\t\u000f\tU\u0002\u0001\"\u0001\u0003>Q!\u00111\fB \u0011!\u0011\tEa\u000fA\u0002\u0005\u0005\u0017A\u0001;q\u0011\u001d\u0011)\u0005\u0001C\u0005\u0005\u000f\n1C]3n_Z,\u0007+\u0019:uSRLwN\\%oM>$b!a\u0017\u0003J\t-\u0003bBA>\u0005\u0007\u0002\rA\u000b\u0005\b\u0003S\u0014\u0019\u00051\u0001\u0017\u0011%\u0011y\u0005AI\u0001\n\u0003\u0011\t&\u0001\u000ehKR$v\u000e]5d\u001b\u0016$\u0018\rZ1uC\u0012\"WMZ1vYR$3'\u0006\u0002\u0003T)\"\u00111\fB+W\t\u00119\u0006\u0005\u0003\u0003Z\t\rTB\u0001B.\u0015\u0011\u0011iFa\u0018\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B1\u0015\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u0015$1\f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"\u0003B5\u0001E\u0005I\u0011\u0001B)\u0003i9W\r\u001e+pa&\u001cW*\u001a;bI\u0006$\u0018\r\n3fM\u0006,H\u000e\u001e\u00135\u0001")
public class MetadataCache
implements Logging {
    private final int brokerId;
    private final scala.collection.mutable.Map<String, scala.collection.mutable.Map<Object, UpdateMetadataRequest.PartitionState>> cache;
    private volatile Option<Object> controllerId;
    private final scala.collection.mutable.Map<Object, Broker> aliveBrokers;
    private final scala.collection.mutable.Map<Object, Map<ListenerName, Node>> aliveNodes;
    private final ReentrantReadWriteLock partitionMetadataLock;
    private final StateChangeLogger stateChangeLogger;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        MetadataCache metadataCache = this;
        synchronized (metadataCache) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private scala.collection.mutable.Map<String, scala.collection.mutable.Map<Object, UpdateMetadataRequest.PartitionState>> cache() {
        return this.cache;
    }

    private Option<Object> controllerId() {
        return this.controllerId;
    }

    private void controllerId_$eq(Option<Object> x$1) {
        this.controllerId = x$1;
    }

    private scala.collection.mutable.Map<Object, Broker> aliveBrokers() {
        return this.aliveBrokers;
    }

    private scala.collection.mutable.Map<Object, Map<ListenerName, Node>> aliveNodes() {
        return this.aliveNodes;
    }

    private ReentrantReadWriteLock partitionMetadataLock() {
        return this.partitionMetadataLock;
    }

    private StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private Seq<Node> getEndpoints(Iterable<Object> brokers, ListenerName listenerName, boolean filterUnavailableEndpoints) {
        ArrayBuffer result = new ArrayBuffer(package$.MODULE$.min(this.aliveBrokers().size(), brokers.size()));
        brokers.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> {
            None$ none$;
            Option<Node> option = this.getAliveEndpoint(brokerId, listenerName);
            if (None$.MODULE$.equals(option)) {
                none$ = !filterUnavailableEndpoints ? new Some((Object)new Node(brokerId, "", -1)) : None$.MODULE$;
            } else if (option instanceof Some) {
                Some some = (Some)option;
                Node node = (Node)some.value();
                none$ = new Some((Object)node);
            } else {
                throw new MatchError(option);
            }
            None$ endpoint = none$;
            endpoint.foreach((Function1 & Serializable & scala.Serializable)elem -> result.$plus$eq(elem));
        });
        return result;
    }

    private Option<Iterable<MetadataResponse.PartitionMetadata>> getPartitionMetadata(String topic, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        return this.cache().get((Object)topic).map((Function1 & Serializable & scala.Serializable)partitions -> (Iterable)partitions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            MetadataResponse.PartitionMetadata partitionMetadata;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            int partitionId = tuple2._1$mcI$sp();
            UpdateMetadataRequest.PartitionState partitionState = (UpdateMetadataRequest.PartitionState)tuple2._2();
            TopicAndPartition topicPartition = new TopicAndPartition(topic, partitionId);
            int leaderBrokerId = partitionState.basePartitionState.leader;
            Option<Node> maybeLeader = this.getAliveEndpoint(leaderBrokerId, listenerName);
            Buffer replicas = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionState.basePartitionState.replicas).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$1)), Buffer$.MODULE$.canBuildFrom());
            Seq<Node> replicaInfo = this.getEndpoints((Iterable<Object>)replicas, listenerName, errorUnavailableEndpoints);
            Seq<Node> offlineReplicaInfo = this.getEndpoints((Iterable<Object>)((Iterable)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionState.offlineReplicas).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$2)), Buffer$.MODULE$.canBuildFrom())), listenerName, errorUnavailableEndpoints);
            Option<Node> option = maybeLeader;
            if (None$.MODULE$.equals(option)) {
                Errors errors;
                if (!this.aliveBrokers().contains((Object)BoxesRunTime.boxToInteger((int)$this.brokerId))) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Error while fetching metadata for ").append(topicPartition).append(": leader not available").toString());
                    errors = Errors.LEADER_NOT_AVAILABLE;
                } else {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Error while fetching metadata for ").append(topicPartition).append(": listener ").append(listenerName).append(" not found on leader ").append(leaderBrokerId).toString());
                    errors = errorUnavailableListeners ? Errors.LISTENER_NOT_FOUND : Errors.LEADER_NOT_AVAILABLE;
                }
                Errors error = errors;
                partitionMetadata = new MetadataResponse.PartitionMetadata(error, partitionId, Node.noNode(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(replicaInfo).asJava(), Collections.emptyList(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(offlineReplicaInfo).asJava());
                return partitionMetadata;
            } else {
                MetadataResponse.PartitionMetadata partitionMetadata2;
                if (!(option instanceof Some)) throw new MatchError(option);
                Some some = (Some)option;
                Node leader = (Node)some.value();
                Buffer isr = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionState.basePartitionState.isr).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$3)), Buffer$.MODULE$.canBuildFrom());
                Seq<Node> isrInfo = this.getEndpoints((Iterable<Object>)isr, listenerName, errorUnavailableEndpoints);
                if (replicaInfo.size() < replicas.size()) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
                        Seq seq = (Seq)replicaInfo.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id()), Seq$.MODULE$.canBuildFrom());
                        return new StringBuilder(74).append("Error while fetching metadata for ").append(topicPartition).append(": replica information not available for ").append(new StringBuilder(18).append("following brokers ").append(((TraversableOnce)replicas.filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)seq.contains(elem)))).mkString(",")).toString()).toString();
                    });
                    partitionMetadata2 = new MetadataResponse.PartitionMetadata(Errors.REPLICA_NOT_AVAILABLE, partitionId, leader, (List)JavaConverters$.MODULE$.seqAsJavaListConverter(replicaInfo).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(isrInfo).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(offlineReplicaInfo).asJava());
                } else if (isrInfo.size() < isr.size()) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
                        Seq seq = (Seq)isrInfo.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.id()), Seq$.MODULE$.canBuildFrom());
                        return new StringBuilder(82).append("Error while fetching metadata for ").append(topicPartition).append(": in sync replica information not available for ").append(new StringBuilder(18).append("following brokers ").append(((TraversableOnce)isr.filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)seq.contains(elem)))).mkString(",")).toString()).toString();
                    });
                    partitionMetadata2 = new MetadataResponse.PartitionMetadata(Errors.REPLICA_NOT_AVAILABLE, partitionId, leader, (List)JavaConverters$.MODULE$.seqAsJavaListConverter(replicaInfo).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(isrInfo).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(offlineReplicaInfo).asJava());
                } else {
                    partitionMetadata2 = new MetadataResponse.PartitionMetadata(Errors.NONE, partitionId, leader, (List)JavaConverters$.MODULE$.seqAsJavaListConverter(replicaInfo).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(isrInfo).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(offlineReplicaInfo).asJava());
                }
                partitionMetadata = partitionMetadata2;
            }
            return partitionMetadata;
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom()));
    }

    private Option<Node> getAliveEndpoint(int brokerId, ListenerName listenerName) {
        return (Option)CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (Function0 & Serializable & scala.Serializable)() -> this.aliveNodes().get((Object)BoxesRunTime.boxToInteger((int)brokerId)).flatMap((Function1 & Serializable & scala.Serializable)x$6 -> x$6.get((Object)listenerName)));
    }

    public Seq<MetadataResponse.TopicMetadata> getTopicMetadata(Set<String> topics, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        return (Seq)CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (Function0 & Serializable & scala.Serializable)() -> (Seq)topics.toSeq().flatMap((Function1 & Serializable & scala.Serializable)topic -> Option$.MODULE$.option2Iterable(this.getPartitionMetadata((String)topic, listenerName, errorUnavailableEndpoints, errorUnavailableListeners).map((Function1 & Serializable & scala.Serializable)partitionMetadata -> new MetadataResponse.TopicMetadata(Errors.NONE, topic, Topic.isInternal((String)topic), (List)JavaConverters$.MODULE$.bufferAsJavaListConverter(partitionMetadata.toBuffer()).asJava()))), Seq$.MODULE$.canBuildFrom()));
    }

    public boolean getTopicMetadata$default$3() {
        return false;
    }

    public boolean getTopicMetadata$default$4() {
        return false;
    }

    public Set<String> getAllTopics() {
        return (Set)CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (Function0 & Serializable & scala.Serializable)() -> this.cache().keySet().toSet());
    }

    public scala.collection.immutable.Map<TopicPartition, UpdateMetadataRequest.PartitionState> getAllPartitions() {
        return (scala.collection.immutable.Map)CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (Function0 & Serializable & scala.Serializable)() -> ((TraversableOnce)this.cache().flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String topic = (String)tuple2._1();
            scala.collection.mutable.Map partitionStates = (scala.collection.mutable.Map)tuple2._2();
            scala.collection.mutable.Map map = (scala.collection.mutable.Map)partitionStates.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int partition = tuple2._1$mcI$sp();
                UpdateMetadataRequest.PartitionState state = (UpdateMetadataRequest.PartitionState)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)new TopicPartition(topic, partition), (Object)state);
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
            return map;
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
    }

    public Set<String> getNonExistingTopics(Set<String> topics) {
        return (Set)CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (Function0 & Serializable & scala.Serializable)() -> (Set)topics.$minus$minus((GenTraversableOnce)this.cache().keySet()));
    }

    public boolean isBrokerAlive(int brokerId) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.aliveBrokers().contains((Object)BoxesRunTime.boxToInteger((int)brokerId))));
    }

    public Seq<Broker> getAliveBrokers() {
        return (Seq)CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (Function0 & Serializable & scala.Serializable)() -> this.aliveBrokers().values().toBuffer());
    }

    private void addOrUpdatePartitionInfo(String topic, int partitionId, UpdateMetadataRequest.PartitionState stateInfo) {
        CoreUtils$.MODULE$.inWriteLock(this.partitionMetadataLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            scala.collection.mutable.Map infos = (scala.collection.mutable.Map)this.cache().getOrElseUpdate((Object)topic, (Function0 & Serializable & scala.Serializable)() -> (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$));
            infos.update((Object)BoxesRunTime.boxToInteger((int)partitionId), (Object)stateInfo);
        });
    }

    public Option<UpdateMetadataRequest.PartitionState> getPartitionInfo(String topic, int partitionId) {
        return (Option)CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (Function0 & Serializable & scala.Serializable)() -> this.cache().get((Object)topic).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> x$7.get((Object)BoxesRunTime.boxToInteger((int)partitionId))));
    }

    public Option<Node> getPartitionLeaderEndpoint(String topic, int partitionId, ListenerName listenerName) {
        return (Option)CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (Function0 & Serializable & scala.Serializable)() -> this.cache().get((Object)topic).flatMap((Function1 & Serializable & scala.Serializable)x$8 -> x$8.get((Object)BoxesRunTime.boxToInteger((int)partitionId))).map((Function1 & Serializable & scala.Serializable)partitionInfo -> {
            Node node;
            int leaderId = partitionInfo.basePartitionState.leader;
            Option option = this.aliveNodes().get((Object)BoxesRunTime.boxToInteger((int)leaderId));
            if (option instanceof Some) {
                Some some = (Some)option;
                Map nodeMap = (Map)some.value();
                node = (Node)nodeMap.getOrElse((Object)listenerName, (Function0 & Serializable & scala.Serializable)() -> Node.noNode());
            } else if (None$.MODULE$.equals(option)) {
                node = Node.noNode();
            } else {
                throw new MatchError((Object)option);
            }
            return node;
        }));
    }

    public Option<Object> getControllerId() {
        return this.controllerId();
    }

    public Cluster getClusterMetadata(String clusterId, ListenerName listenerName) {
        return (Cluster)CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (Function0 & Serializable & scala.Serializable)() -> {
            scala.collection.mutable.Map nodes = (scala.collection.mutable.Map)this.aliveNodes().map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                Tuple2 tuple2 = x0$4;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int id = tuple2._1$mcI$sp();
                Map nodes = (Map)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)id), nodes.get((Object)listenerName).orNull(Predef$.MODULE$.$conforms()));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
            scala.collection.immutable.Iterable partitions = (scala.collection.immutable.Iterable)((TraversableLike)this.getAllPartitions().filter((Function1 & Serializable & scala.Serializable)x0$5 -> BoxesRunTime.boxToBoolean((boolean)MetadataCache.$anonfun$getClusterMetadata$3(x0$5)))).map((Function1 & Serializable & scala.Serializable)x0$6 -> {
                Tuple2 tuple2 = x0$6;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition tp = (TopicPartition)tuple2._1();
                UpdateMetadataRequest.PartitionState state = (UpdateMetadataRequest.PartitionState)tuple2._2();
                PartitionInfo partitionInfo = new PartitionInfo(tp.topic(), tp.partition(), MetadataCache.node$1(Predef$.MODULE$.int2Integer(state.basePartitionState.leader), nodes), (Node[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(state.basePartitionState.replicas).asScala()).map((Function1 & Serializable & scala.Serializable)id -> MetadataCache.node$1(id, nodes), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Node.class)), (Node[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(state.basePartitionState.isr).asScala()).map((Function1 & Serializable & scala.Serializable)id -> MetadataCache.node$1(id, nodes), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Node.class)), (Node[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(state.offlineReplicas).asScala()).map((Function1 & Serializable & scala.Serializable)id -> MetadataCache.node$1(id, nodes), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Node.class)));
                return partitionInfo;
            }, Iterable$.MODULE$.canBuildFrom());
            java.util.Set unauthorizedTopics = Collections.emptySet();
            java.util.Set internalTopics = (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.getAllTopics().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MetadataCache.$anonfun$getClusterMetadata$8(x$1)))).asJava();
            return new Cluster(clusterId, (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)nodes.values().filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)MetadataCache.$anonfun$getClusterMetadata$9(x$9)))).toList()).asJava(), (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)partitions.toList()).asJava(), unauthorizedTopics, internalTopics, (Node)this.getControllerId().map((Function1 & Serializable & scala.Serializable)id -> MetadataCache.node$1(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)id)), nodes)).orNull(Predef$.MODULE$.$conforms()));
        });
    }

    public Seq<TopicPartition> updateCache(int correlationId, UpdateMetadataRequest updateMetadataRequest) {
        return (Seq)CoreUtils$.MODULE$.inWriteLock(this.partitionMetadataLock(), (Function0 & Serializable & scala.Serializable)() -> {
            int n = updateMetadataRequest.controllerId();
            switch (n) {
                default: 
            }
            this.controllerId_$eq((Option<Object>)(n < 0 ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)n))));
            this.aliveNodes().clear();
            this.aliveBrokers().clear();
            ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(updateMetadataRequest.liveBrokers()).asScala()).foreach((Function1 & Serializable & scala.Serializable)broker -> {
                MetadataCache.$anonfun$updateCache$2(this, broker);
                return BoxedUnit.UNIT;
            });
            this.aliveNodes().get((Object)BoxesRunTime.boxToInteger((int)$this.brokerId)).foreach((Function1 & Serializable & scala.Serializable)listenerMap -> {
                MetadataCache.$anonfun$updateCache$4(this, listenerMap);
                return BoxedUnit.UNIT;
            });
            ArrayBuffer deletedPartitions = new ArrayBuffer();
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(updateMetadataRequest.partitionStates()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$7 -> {
                BoxedUnit boxedUnit;
                Tuple2 tuple2 = x0$7;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    UpdateMetadataRequest.PartitionState info = (UpdateMetadataRequest.PartitionState)tuple2._2();
                    int controllerId = updateMetadataRequest.controllerId();
                    int controllerEpoch = updateMetadataRequest.controllerEpoch();
                    if (info.basePartitionState.leader == LeaderAndIsr$.MODULE$.LeaderDuringDelete()) {
                        this.removePartitionInfo(tp.topic(), tp.partition());
                        this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Deleted partition ").append(tp).append(" from metadata cache in response to UpdateMetadata ").append(new StringBuilder(55).append("request sent by controller ").append(controllerId).append(" epoch ").append(controllerEpoch).append(" with correlation id ").append(correlationId).toString()).toString());
                        boxedUnit = deletedPartitions.$plus$eq((Object)tp);
                    } else {
                        this.addOrUpdatePartitionInfo(tp.topic(), tp.partition(), info);
                        this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Cached leader info ").append(info).append(" for partition ").append(tp).append(" in response to ").append(new StringBuilder(70).append("UpdateMetadata request sent by controller ").append(controllerId).append(" epoch ").append(controllerEpoch).append(" with correlation id ").append(correlationId).toString()).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                BoxedUnit boxedUnit2 = boxedUnit;
                return boxedUnit2;
            });
            return deletedPartitions;
        });
    }

    public boolean contains(String topic) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.cache().contains((Object)topic)));
    }

    public boolean contains(TopicPartition tp) {
        return this.getPartitionInfo(tp.topic(), tp.partition()).isDefined();
    }

    private boolean removePartitionInfo(String topic, int partitionId) {
        return this.cache().get((Object)topic).exists((Function1 & Serializable & scala.Serializable)infos -> BoxesRunTime.boxToBoolean((boolean)MetadataCache.$anonfun$removePartitionInfo$1(this, topic, partitionId, infos)));
    }

    private static final Node node$1(Integer id, scala.collection.mutable.Map nodes$1) {
        return (Node)nodes$1.get((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(id))).orNull(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ boolean $anonfun$getClusterMetadata$3(Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        UpdateMetadataRequest.PartitionState state = (UpdateMetadataRequest.PartitionState)tuple2._2();
        boolean bl = state.basePartitionState.leader != LeaderAndIsr$.MODULE$.LeaderDuringDelete();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$getClusterMetadata$8(String x$1) {
        return Topic.isInternal((String)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$getClusterMetadata$9(Node x$9) {
        return x$9 != null;
    }

    public static final /* synthetic */ void $anonfun$updateCache$2(MetadataCache $this, UpdateMetadataRequest.Broker broker) {
        HashMap nodes = new HashMap();
        ArrayBuffer endPoints = new ArrayBuffer();
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(broker.endPoints).asScala()).foreach((Function1 & Serializable & scala.Serializable)ep -> {
            endPoints.$plus$eq((Object)new EndPoint(ep.host, ep.port, ep.listenerName, ep.securityProtocol));
            return nodes.put(ep.listenerName, new Node(broker$1.id, ep.host, ep.port));
        });
        $this.aliveBrokers().update((Object)BoxesRunTime.boxToInteger((int)broker.id), (Object)new Broker(broker.id, (Seq<EndPoint>)endPoints, (Option<String>)Option$.MODULE$.apply((Object)broker.rack)));
        $this.aliveNodes().update((Object)BoxesRunTime.boxToInteger((int)broker.id), JavaConverters$.MODULE$.mapAsScalaMapConverter(nodes).asScala());
    }

    public static final /* synthetic */ boolean $anonfun$updateCache$5(Set listeners$1, Map x$10) {
        Set set = x$10.keySet();
        Set set2 = listeners$1;
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ void $anonfun$updateCache$4(MetadataCache $this, Map listenerMap) {
        block0: {
            Set listeners = listenerMap.keySet();
            if ($this.aliveNodes().values().forall((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)MetadataCache.$anonfun$updateCache$5(listeners, x$10)))) break block0;
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Listeners are not identical across brokers: ").append($this.aliveNodes()).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$removePartitionInfo$1(MetadataCache $this, String topic$7, int partitionId$4, scala.collection.mutable.Map infos) {
        infos.remove((Object)BoxesRunTime.boxToInteger((int)partitionId$4));
        Object object = infos.isEmpty() ? $this.cache().remove((Object)topic$7) : BoxedUnit.UNIT;
        return true;
    }

    public MetadataCache(int brokerId) {
        this.brokerId = brokerId;
        Logging.$init$(this);
        this.cache = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.controllerId = None$.MODULE$;
        this.aliveBrokers = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.aliveNodes = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.partitionMetadataLock = new ReentrantReadWriteLock();
        this.logIdent_$eq(new StringBuilder(26).append("[MetadataCache brokerId=").append(brokerId).append("] ").toString());
        this.stateChangeLogger = new StateChangeLogger(brokerId, false, (Option<Object>)None$.MODULE$);
    }
}

