/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.LogCleaningAbortedException;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerManager$;
import kafka.log.LogCleaningAborted$;
import kafka.log.LogCleaningInProgress$;
import kafka.log.LogCleaningPaused$;
import kafka.log.LogCleaningState;
import kafka.log.LogToClean;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.LogDirFailureChannel;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t}e!B\u0001\u0003\u0001\t1!!\u0005'pO\u000ecW-\u00198fe6\u000bg.Y4fe*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0014\t\u00019Qb\u0005\t\u0003\u0011-i\u0011!\u0003\u0006\u0002\u0015\u0005)1oY1mC&\u0011A\"\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u00059\tR\"A\b\u000b\u0005A!\u0011!B;uS2\u001c\u0018B\u0001\n\u0010\u0005\u001daunZ4j]\u001e\u0004\"\u0001F\f\u000e\u0003UQ!A\u0006\u0003\u0002\u000f5,GO]5dg&\u0011\u0001$\u0006\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\b\u0002\u0003\u000e\u0001\u0005\u000b\u0007I\u0011\u0001\u000f\u0002\u000f1|w\rR5sg\u000e\u0001Q#A\u000f\u0011\u0007y1\u0013F\u0004\u0002 I9\u0011\u0001eI\u0007\u0002C)\u0011!eG\u0001\u0007yI|w\u000e\u001e \n\u0003)I!!J\u0005\u0002\u000fA\f7m[1hK&\u0011q\u0005\u000b\u0002\u0004'\u0016\f(BA\u0013\n!\tQs&D\u0001,\u0015\taS&\u0001\u0002j_*\ta&\u0001\u0003kCZ\f\u0017B\u0001\u0019,\u0005\u00111\u0015\u000e\\3\t\u0011I\u0002!\u0011!Q\u0001\nu\t\u0001\u0002\\8h\t&\u00148\u000f\t\u0005\ti\u0001\u0011)\u0019!C\u0001k\u0005!An\\4t+\u00051\u0004\u0003\u0002\b8s\u0011K!\u0001O\b\u0003\tA{w\u000e\u001c\t\u0003u\tk\u0011a\u000f\u0006\u0003yu\naaY8n[>t'BA\u0003?\u0015\ty\u0004)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0003\u0006\u0019qN]4\n\u0005\r[$A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0003\u000b\u001ak\u0011AA\u0005\u0003\u000f\n\u00111\u0001T8h\u0011!I\u0005A!A!\u0002\u00131\u0014!\u00027pON\u0004\u0003\u0002C&\u0001\u0005\u000b\u0007I\u0011\u0001'\u0002)1|w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m+\u0005i\u0005C\u0001(R\u001b\u0005y%B\u0001)\u0005\u0003\u0019\u0019XM\u001d<fe&\u0011!k\u0014\u0002\u0015\u0019><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7\t\u0011Q\u0003!\u0011!Q\u0001\n5\u000bQ\u0003\\8h\t&\u0014h)Y5mkJ,7\t[1o]\u0016d\u0007\u0005C\u0003W\u0001\u0011\u0005q+\u0001\u0004=S:LGO\u0010\u000b\u00051fS6\f\u0005\u0002F\u0001!)!$\u0016a\u0001;!)A'\u0016a\u0001m!)1*\u0016a\u0001\u001b\")Q\f\u0001C)=\u0006QAn\\4hKJt\u0015-\\3\u0016\u0003}\u0003\"\u0001Y2\u000e\u0003\u0005T!AY\u0017\u0002\t1\fgnZ\u0005\u0003I\u0006\u0014aa\u0015;sS:<\u0007\u0002\u00034\u0001\u0005\u0004%\tA\u00010\u0002)=4gm]3u\u0007\",7m\u001b9pS:$h)\u001b7f\u0011\u0019A\u0007\u0001)A\u0005?\u0006)rN\u001a4tKR\u001c\u0005.Z2la>Lg\u000e\u001e$jY\u0016\u0004\u0003b\u00026\u0001\u0001\u0004%Ia[\u0001\fG\",7m\u001b9pS:$8/F\u0001m!\u0011i'/\u000b;\u000e\u00039T!a\u001c9\u0002\u0013%lW.\u001e;bE2,'BA9\n\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003g:\u00141!T1q!\t)x/D\u0001w\u0015\tQw*\u0003\u0002ym\n!rJ\u001a4tKR\u001c\u0005.Z2la>Lg\u000e\u001e$jY\u0016DqA\u001f\u0001A\u0002\u0013%10A\bdQ\u0016\u001c7\u000e]8j]R\u001cx\fJ3r)\tax\u0010\u0005\u0002\t{&\u0011a0\u0003\u0002\u0005+:LG\u000f\u0003\u0005\u0002\u0002e\f\t\u00111\u0001m\u0003\rAH%\r\u0005\b\u0003\u000b\u0001\u0001\u0015)\u0003m\u00031\u0019\u0007.Z2la>Lg\u000e^:!Q\u0011\t\u0019!!\u0003\u0011\u0007!\tY!C\u0002\u0002\u000e%\u0011\u0001B^8mCRLG.\u001a\u0005\n\u0003#\u0001!\u0019!C\u0005\u0003'\t!\"\u001b8Qe><'/Z:t+\t\t)\u0002E\u0004\u0002\u0018\u0005u\u0011(!\t\u000e\u0005\u0005e!bAA\u000ea\u00069Q.\u001e;bE2,\u0017\u0002BA\u0010\u00033\u0011q\u0001S1tQ6\u000b\u0007\u000fE\u0002F\u0003GI1!!\n\u0003\u0005AaunZ\"mK\u0006t\u0017N\\4Ti\u0006$X\r\u0003\u0005\u0002*\u0001\u0001\u000b\u0011BA\u000b\u0003-Ig\u000e\u0015:pOJ,7o\u001d\u0011\t\u0013\u00055\u0002A1A\u0005\n\u0005=\u0012\u0001\u00027pG.,\"!!\r\u0011\t\u0005M\u0012\u0011I\u0007\u0003\u0003kQA!a\u000e\u0002:\u0005)An\\2lg*!\u00111HA\u001f\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0004\u0003\u007fi\u0013\u0001B;uS2LA!a\u0011\u00026\ti!+Z3oiJ\fg\u000e\u001e'pG.D\u0001\"a\u0012\u0001A\u0003%\u0011\u0011G\u0001\u0006Y>\u001c7\u000e\t\u0005\n\u0003\u0017\u0002!\u0019!C\u0005\u0003\u001b\n!\u0003]1vg\u0016$7\t\\3b]&twmQ8oIV\u0011\u0011q\n\t\u0005\u0003g\t\t&\u0003\u0003\u0002T\u0005U\"!C\"p]\u0012LG/[8o\u0011!\t9\u0006\u0001Q\u0001\n\u0005=\u0013a\u00059bkN,Gm\u00117fC:LgnZ\"p]\u0012\u0004\u0003\"CA.\u0001\u0001\u0007I\u0011BA/\u0003e!\u0017N\u001d;jKN$Hj\\4DY\u0016\fg.\u00192mKJ\u000bG/[8\u0016\u0005\u0005}\u0003c\u0001\u0005\u0002b%\u0019\u00111M\u0005\u0003\r\u0011{WO\u00197f\u0011%\t9\u0007\u0001a\u0001\n\u0013\tI'A\u000feSJ$\u0018.Z:u\u0019><7\t\\3b]\u0006\u0014G.\u001a*bi&|w\fJ3r)\ra\u00181\u000e\u0005\u000b\u0003\u0003\t)'!AA\u0002\u0005}\u0003\u0002CA8\u0001\u0001\u0006K!a\u0018\u00025\u0011L'\u000f^5fgRdunZ\"mK\u0006t\u0017M\u00197f%\u0006$\u0018n\u001c\u0011)\t\u00055\u0014\u0011\u0002\u0005\n\u0003k\u0002\u0001\u0019!C\u0005\u0003o\nQ\u0002^5nK>3G*Y:u%VtWCAA=!\rA\u00111P\u0005\u0004\u0003{J!\u0001\u0002'p]\u001eD\u0011\"!!\u0001\u0001\u0004%I!a!\u0002#QLW.Z(g\u0019\u0006\u001cHOU;o?\u0012*\u0017\u000fF\u0002}\u0003\u000bC!\"!\u0001\u0002\u0000\u0005\u0005\t\u0019AA=\u0011!\tI\t\u0001Q!\n\u0005e\u0014A\u0004;j[\u0016|e\rT1tiJ+h\u000e\t\u0015\u0005\u0003\u000f\u000bI\u0001C\u0004\u0002\u0010\u0002!\t!!%\u0002+\u0005dGn\u00117fC:,'o\u00115fG.\u0004x.\u001b8ugV\u0011\u00111\u0013\t\b\u0003+\u000bi*OA=\u001d\u0011\t9*!'\u0011\u0005\u0001J\u0011bAAN\u0013\u00051\u0001K]3eK\u001aL1a]AP\u0015\r\tY*\u0003\u0005\t\u0003G\u0003A\u0011\u0001\u0002\u0002&\u0006i1\r\\3b]&twm\u0015;bi\u0016$B!a*\u0002.B)\u0001\"!+\u0002\"%\u0019\u00111V\u0005\u0003\r=\u0003H/[8o\u0011\u001d\ty+!)A\u0002e\n!\u0001\u001e9\t\u0011\u0005M\u0006\u0001\"\u0001\u0003\u0003k\u000b\u0001c]3u\u00072,\u0017M\\5oON#\u0018\r^3\u0015\u000bq\f9,!/\t\u000f\u0005=\u0016\u0011\u0017a\u0001s!A\u00111XAY\u0001\u0004\t\t#A\u0003ti\u0006$X\rC\u0004\u0002@\u0002!\t!!1\u00023\u001d\u0014\u0018M\u0019$jYRD\u0017.Z:u\u0007>l\u0007/Y2uK\u0012dun\u001a\u000b\u0005\u0003\u0007\fY\rE\u0003\t\u0003S\u000b)\rE\u0002F\u0003\u000fL1!!3\u0003\u0005)aun\u001a+p\u00072,\u0017M\u001c\u0005\t\u0003\u001b\fi\f1\u0001\u0002P\u0006!A/[7f!\u0011\t\t.!6\u000e\u0005\u0005M'B\u0001\t<\u0013\u0011\t9.a5\u0003\tQKW.\u001a\u0005\b\u00037\u0004A\u0011AAo\u00035!W\r\\3uC\ndW\rT8hgR\u0011\u0011q\u001c\t\u0006=\u0005\u0005\u0018Q]\u0005\u0004\u0003GD#\u0001C%uKJ\f'\r\\3\u0011\u000b!\t9/\u000f#\n\u0007\u0005%\u0018B\u0001\u0004UkBdWM\r\u0005\b\u0003[\u0004A\u0011AAx\u00035\t'm\u001c:u\u00072,\u0017M\\5oOR\u0019A0!=\t\u000f\u0005M\u00181\u001ea\u0001s\u0005qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007bBA|\u0001\u0011\u0005\u0011\u0011`\u0001\u0016C\n|'\u000f^!oIB\u000bWo]3DY\u0016\fg.\u001b8h)\ra\u00181 \u0005\b\u0003g\f)\u00101\u0001:\u0011\u001d\ty\u0010\u0001C\u0001\u0005\u0003\taB]3tk6,7\t\\3b]&tw\rF\u0002}\u0005\u0007Aq!a=\u0002~\u0002\u0007\u0011\bC\u0004\u0003\b\u0001!IA!\u0003\u0002#%\u001c8\t\\3b]&tw-\u00138Ti\u0006$X\r\u0006\u0004\u0003\f\tE!1\u0003\t\u0004\u0011\t5\u0011b\u0001B\b\u0013\t9!i\\8mK\u0006t\u0007bBAz\u0005\u000b\u0001\r!\u000f\u0005\t\u0005+\u0011)\u00011\u0001\u0002\"\u0005iQ\r\u001f9fGR,Gm\u0015;bi\u0016DqA!\u0007\u0001\t\u0003\u0011Y\"\u0001\u000bdQ\u0016\u001c7n\u00117fC:LgnZ!c_J$X\r\u001a\u000b\u0004y\nu\u0001bBAz\u0005/\u0001\r!\u000f\u0005\b\u0005C\u0001A\u0011\u0001B\u0012\u0003E)\b\u000fZ1uK\u000eCWmY6q_&tGo\u001d\u000b\u0006y\n\u0015\"\u0011\u0006\u0005\b\u0005O\u0011y\u00021\u0001*\u0003\u001d!\u0017\r^1ESJD\u0001Ba\u000b\u0003 \u0001\u0007!QF\u0001\u0007kB$\u0017\r^3\u0011\u000b!\tIKa\f\u0011\r!\t9/OA=\u0011\u001d\u0011\u0019\u0004\u0001C\u0001\u0005k\t!#\u00197uKJ\u001c\u0005.Z2la>Lg\u000e\u001e#jeR9APa\u000e\u0003:\tu\u0002bBAz\u0005c\u0001\r!\u000f\u0005\b\u0005w\u0011\t\u00041\u0001*\u00031\u0019x.\u001e:dK2{w\rR5s\u0011\u001d\u0011yD!\rA\u0002%\n!\u0002Z3ti2{w\rR5s\u0011\u001d\u0011\u0019\u0005\u0001C\u0001\u0005\u000b\n1\u0003[1oI2,Gj\\4ESJ4\u0015-\u001b7ve\u0016$2\u0001 B$\u0011!\u0011IE!\u0011A\u0002\t-\u0013a\u00013jeB!\u0011Q\u0013B'\u0013\r!\u0017q\u0014\u0005\b\u0005#\u0002A\u0011\u0001B*\u0003]i\u0017-\u001f2f)J,hnY1uK\u000eCWmY6q_&tG\u000fF\u0004}\u0005+\u00129F!\u0017\t\u000f\t\u001d\"q\na\u0001S!9\u00111\u001fB(\u0001\u0004I\u0004\u0002\u0003B.\u0005\u001f\u0002\r!!\u001f\u0002\r=4gm]3u\u0011\u001d\u0011y\u0006\u0001C\u0001\u0005C\nA\u0002Z8oK\u000ecW-\u00198j]\u001e$r\u0001 B2\u0005K\u00129\u0007C\u0004\u0002t\nu\u0003\u0019A\u001d\t\u000f\t\u001d\"Q\fa\u0001S!A!\u0011\u000eB/\u0001\u0004\tI(A\u0005f]\u0012|eMZ:fi\"9!Q\u000e\u0001\u0005\u0002\t=\u0014\u0001\u00043p]\u0016$U\r\\3uS:<Gc\u0001?\u0003r!9\u00111\u001fB6\u0001\u0004It\u0001\u0003B;\u0005!\u0005!Aa\u001e\u0002#1{wm\u00117fC:,'/T1oC\u001e,'\u000fE\u0002F\u0005s2q!\u0001\u0002\t\u0002\t\u0011Yh\u0005\u0003\u0003z\u001di\u0001b\u0002,\u0003z\u0011\u0005!q\u0010\u000b\u0003\u0005oB\u0001Ba!\u0003z\u0011\u0005!QQ\u0001\u0013SN\u001cu.\u001c9bGR\fe\u000e\u001a#fY\u0016$X\r\u0006\u0003\u0003\f\t\u001d\u0005BB\u0002\u0003\u0002\u0002\u0007A\t\u0003\u0005\u0003\f\neD\u0011\u0001BG\u0003A\u0019G.Z1oC\ndWm\u00144gg\u0016$8\u000f\u0006\u0006\u0003\u0010\nE%1\u0013BK\u00057\u0003r\u0001CAt\u0003s\nI\b\u0003\u0004\u0004\u0005\u0013\u0003\r\u0001\u0012\u0005\b\u0003g\u0014I\t1\u0001:\u0011!\u00119J!#A\u0002\te\u0015!\u00037bgR\u001cE.Z1o!\u0015i'/OA=\u0011!\u0011iJ!#A\u0002\u0005e\u0014a\u00018po\u0002")
public class LogCleanerManager
implements KafkaMetricsGroup {
    private final Seq<File> logDirs;
    private final Pool<TopicPartition, Log> logs;
    private final LogDirFailureChannel logDirFailureChannel;
    private final String offsetCheckpointFile;
    private volatile scala.collection.immutable.Map<File, OffsetCheckpointFile> checkpoints;
    private final HashMap<TopicPartition, LogCleaningState> inProgress;
    private final ReentrantLock lock;
    private final Condition pausedCleaningCond;
    private volatile double kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio;
    private volatile long kafka$log$LogCleanerManager$$timeOfLastRun;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Tuple2<Object, Object> cleanableOffsets(Log log, TopicPartition topicPartition, scala.collection.immutable.Map<TopicPartition, Object> map, long l) {
        return LogCleanerManager$.MODULE$.cleanableOffsets(log, topicPartition, map, l);
    }

    public static boolean isCompactAndDelete(Log log) {
        return LogCleanerManager$.MODULE$.isCompactAndDelete(log);
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        LogCleanerManager logCleanerManager = this;
        synchronized (logCleanerManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Seq<File> logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, Log> logs() {
        return this.logs;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    @Override
    public String loggerName() {
        return LogCleaner.class.getName();
    }

    public String offsetCheckpointFile() {
        return this.offsetCheckpointFile;
    }

    private scala.collection.immutable.Map<File, OffsetCheckpointFile> checkpoints() {
        return this.checkpoints;
    }

    private void checkpoints_$eq(scala.collection.immutable.Map<File, OffsetCheckpointFile> x$1) {
        this.checkpoints = x$1;
    }

    private HashMap<TopicPartition, LogCleaningState> inProgress() {
        return this.inProgress;
    }

    private ReentrantLock lock() {
        return this.lock;
    }

    private Condition pausedCleaningCond() {
        return this.pausedCleaningCond;
    }

    public double kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio() {
        return this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio;
    }

    private void kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio_$eq(double x$1) {
        this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio = x$1;
    }

    public long kafka$log$LogCleanerManager$$timeOfLastRun() {
        return this.kafka$log$LogCleanerManager$$timeOfLastRun;
    }

    private void kafka$log$LogCleanerManager$$timeOfLastRun_$eq(long x$1) {
        this.kafka$log$LogCleanerManager$$timeOfLastRun = x$1;
    }

    public scala.collection.immutable.Map<TopicPartition, Object> allCleanerCheckpoints() {
        return (scala.collection.immutable.Map)CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> ((TraversableOnce)this.checkpoints().values().flatMap((Function1 & Serializable & scala.Serializable)checkpoint -> {
            scala.collection.immutable.Map map;
            try {
                map = checkpoint.read();
            }
            catch (KafkaStorageException e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Failed to access checkpoint file ").append(checkpoint.file().getName()).append(" in dir ").append(checkpoint.file().getParentFile().getAbsolutePath()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                map = Predef$.MODULE$.Map().empty();
            }
            return map;
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
    }

    public Option<LogCleaningState> cleaningState(TopicPartition tp) {
        return (Option)CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> this.inProgress().get((Object)tp));
    }

    public void setCleaningState(TopicPartition tp, LogCleaningState state) {
        CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> this.inProgress().put((Object)tp, (Object)state));
    }

    public Option<LogToClean> grabFilthiestCompactedLog(Time time) {
        return (Option)CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            None$ none$;
            long now = time.milliseconds();
            this.kafka$log$LogCleanerManager$$timeOfLastRun_$eq(now);
            scala.collection.immutable.Map<TopicPartition, Object> lastClean = this.allCleanerCheckpoints();
            Iterable dirtyLogs = (Iterable)((TraversableLike)((TraversableLike)((TraversableLike)this.logs().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$2(x0$1)))).filterNot((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$3(this, x0$2)))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2.mcJJ.sp sp2;
                Log log;
                TopicPartition topicPartition;
                Tuple2 tuple2 = x0$3;
                if (tuple2 != null) {
                    topicPartition = (TopicPartition)tuple2._1();
                    log = (Log)tuple2._2();
                    Tuple2<Object, Object> tuple22 = LogCleanerManager$.MODULE$.cleanableOffsets(log, topicPartition, lastClean, now);
                    if (tuple22 == null) {
                        throw new MatchError(tuple22);
                    }
                    long firstDirtyOffset = tuple22._1$mcJ$sp();
                    long firstUncleanableDirtyOffset = tuple22._2$mcJ$sp();
                    sp2 = new Tuple2.mcJJ.sp(firstDirtyOffset, firstUncleanableDirtyOffset);
                } else {
                    throw new MatchError((Object)tuple2);
                }
                Tuple2.mcJJ.sp sp3 = sp2;
                long firstDirtyOffset = sp3._1$mcJ$sp();
                long firstUncleanableDirtyOffset = sp3._2$mcJ$sp();
                LogToClean logToClean = new LogToClean(topicPartition, log, firstDirtyOffset, firstUncleanableDirtyOffset);
                return logToClean;
            }, Iterable$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)ltc -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$5(ltc)));
            this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio_$eq(dirtyLogs.nonEmpty() ? ((LogToClean)dirtyLogs.max(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).cleanableRatio() : 0.0);
            Iterable cleanableLogs = (Iterable)dirtyLogs.filter((Function1 & Serializable & scala.Serializable)ltc -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$6(ltc)));
            if (cleanableLogs.isEmpty()) {
                none$ = None$.MODULE$;
            } else {
                LogToClean filthiest = (LogToClean)cleanableLogs.max(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
                this.inProgress().put((Object)filthiest.topicPartition(), (Object)LogCleaningInProgress$.MODULE$);
                none$ = new Some((Object)filthiest);
            }
            return none$;
        });
    }

    public Iterable<Tuple2<TopicPartition, Log>> deletableLogs() {
        return (Iterable)CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            void var1_1;
            Iterable toClean = (Iterable)this.logs().filter((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$deletableLogs$2(this, x0$4)));
            toClean.foreach((Function1 & Serializable & scala.Serializable)x0$5 -> {
                Tuple2 tuple2 = x0$5;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition tp = (TopicPartition)tuple2._1();
                Option option = this.inProgress().put((Object)tp, (Object)LogCleaningInProgress$.MODULE$);
                return option;
            });
            return var1_1;
        });
    }

    public void abortCleaning(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.abortAndPauseCleaning(topicPartition);
            this.resumeCleaning(topicPartition);
        });
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("The cleaning for partition ").append(topicPartition).append(" is aborted").toString());
    }

    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Option option;
            Option option2 = this.inProgress().get((Object)topicPartition);
            if (None$.MODULE$.equals(option2)) {
                option = this.inProgress().put((Object)topicPartition, (Object)LogCleaningPaused$.MODULE$);
            } else if (option2 instanceof Some) {
                Option option3;
                Some some = (Some)option2;
                LogCleaningState state = (LogCleaningState)some.value();
                LogCleaningState logCleaningState = state;
                if (LogCleaningInProgress$.MODULE$.equals(logCleaningState)) {
                    option3 = this.inProgress().put((Object)topicPartition, (Object)LogCleaningAborted$.MODULE$);
                } else if (LogCleaningPaused$.MODULE$.equals(logCleaningState)) {
                    option3 = BoxedUnit.UNIT;
                } else {
                    throw new IllegalStateException(new StringBuilder(77).append("Compaction for partition ").append(topicPartition).append(" cannot be aborted and paused since it is in ").append(logCleaningState).append(" state.").toString());
                }
                option = option3;
            } else {
                throw new MatchError((Object)option2);
            }
            while (!this.isCleaningInState(topicPartition, LogCleaningPaused$.MODULE$)) {
                this.pausedCleaningCond().await(100L, TimeUnit.MILLISECONDS);
            }
        });
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("The cleaning for partition ").append(topicPartition).append(" is aborted and paused").toString());
    }

    public void resumeCleaning(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            Option option;
            Option option2 = this.inProgress().get((Object)topicPartition);
            if (None$.MODULE$.equals(option2)) {
                throw new IllegalStateException(new StringBuilder(67).append("Compaction for partition ").append(topicPartition).append(" cannot be resumed since it is not paused.").toString());
            }
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                LogCleaningState state = (LogCleaningState)some.value();
                LogCleaningState logCleaningState = state;
                if (!LogCleaningPaused$.MODULE$.equals(logCleaningState)) {
                    throw new IllegalStateException(new StringBuilder(66).append("Compaction for partition ").append(topicPartition).append(" cannot be resumed since it is in ").append(logCleaningState).append(" state.").toString());
                }
                option = this.inProgress().remove((Object)topicPartition);
            } else {
                throw new MatchError((Object)option2);
            }
            Option option3 = option;
            return option3;
        });
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Compaction for partition ").append(topicPartition).append(" is resumed").toString());
    }

    private boolean isCleaningInState(TopicPartition topicPartition, LogCleaningState expectedState) {
        boolean bl;
        Option option = this.inProgress().get((Object)topicPartition);
        if (None$.MODULE$.equals(option)) {
            bl = false;
        } else if (option instanceof Some) {
            LogCleaningState state;
            Some some = (Some)option;
            LogCleaningState logCleaningState = state = (LogCleaningState)some.value();
            LogCleaningState logCleaningState2 = expectedState;
            bl = !(logCleaningState != null ? !logCleaningState.equals(logCleaningState2) : logCleaningState2 != null);
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public void checkCleaningAborted(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (this.isCleaningInState(topicPartition, LogCleaningAborted$.MODULE$)) {
                throw new LogCleaningAbortedException();
            }
        });
    }

    public void updateCheckpoints(File dataDir, Option<Tuple2<TopicPartition, Object>> update) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block2: {
                OffsetCheckpointFile checkpoint = (OffsetCheckpointFile)this.checkpoints().apply((Object)dataDir);
                if (checkpoint == null) break block2;
                try {
                    Map existing = checkpoint.read().filterKeys(this.logs().keys()).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(update));
                    checkpoint.write((Map<TopicPartition, Object>)existing);
                }
                catch (KafkaStorageException e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Failed to access checkpoint file ").append(checkpoint.file().getName()).append(" in dir ").append(checkpoint.file().getParentFile().getAbsolutePath()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                }
            }
        });
    }

    public void alterCheckpointDir(TopicPartition topicPartition, File sourceLogDir, File destLogDir) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block4: {
                try {
                    Option option = this.checkpoints().get((Object)sourceLogDir).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.read().get((Object)topicPartition));
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        long offset = BoxesRunTime.unboxToLong((Object)some.value());
                        this.updateCheckpoints(sourceLogDir, (Option<Tuple2<TopicPartition, Object>>)None$.MODULE$);
                        this.updateCheckpoints(destLogDir, (Option<Tuple2<TopicPartition, Object>>)Option$.MODULE$.apply((Object)new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToLong((long)offset))));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block4;
                    }
                    if (None$.MODULE$.equals(option)) {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block4;
                    }
                    throw new MatchError((Object)option);
                }
                catch (KafkaStorageException e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Failed to access checkpoint file in dir ").append(sourceLogDir.getAbsolutePath()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                }
            }
        });
    }

    public void handleLogDirFailure(String dir) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Stopping cleaning logs in dir ").append(dir).toString());
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkpoints_$eq((scala.collection.immutable.Map<File, OffsetCheckpointFile>)this.checkpoints().filterKeys((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$handleLogDirFailure$3(dir, x$3)))));
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                Map<TopicPartition, Object> existing;
                OffsetCheckpointFile checkpoint;
                if (!this.logs().get(topicPartition).config().compact() || (checkpoint = (OffsetCheckpointFile)this.checkpoints().apply((Object)dataDir)) == null || BoxesRunTime.unboxToLong((Object)(existing = checkpoint.read()).getOrElse((Object)topicPartition, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)) <= offset) break block0;
                checkpoint.write((Map<TopicPartition, Object>)existing.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)offset))));
            }
        });
    }

    public void doneCleaning(TopicPartition topicPartition, File dataDir, long endOffset) {
        CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            LogCleaningState logCleaningState;
            boolean bl = false;
            Some some = null;
            Option option = this.inProgress().get((Object)topicPartition);
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                LogCleaningState logCleaningState2 = (LogCleaningState)some.value();
                if (LogCleaningInProgress$.MODULE$.equals(logCleaningState2)) {
                    this.updateCheckpoints(dataDir, (Option<Tuple2<TopicPartition, Object>>)Option$.MODULE$.apply((Object)new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToLong((long)endOffset))));
                    return this.inProgress().remove((Object)topicPartition);
                }
            }
            if (bl && LogCleaningAborted$.MODULE$.equals(logCleaningState = (LogCleaningState)some.value())) {
                this.inProgress().put((Object)topicPartition, (Object)LogCleaningPaused$.MODULE$);
                this.pausedCleaningCond().signalAll();
                return BoxedUnit.UNIT;
            }
            if (!None$.MODULE$.equals(option)) throw new IllegalStateException(new StringBuilder(43).append("In-progress partition ").append(topicPartition).append(" cannot be in ").append(option).append(" state.").toString());
            throw new IllegalStateException(new StringBuilder(34).append("State for partition ").append(topicPartition).append(" should exist.").toString());
        });
    }

    public void doneDeleting(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            LogCleaningState logCleaningState;
            boolean bl = false;
            Some some = null;
            Option option = this.inProgress().get((Object)topicPartition);
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                LogCleaningState logCleaningState2 = (LogCleaningState)some.value();
                if (LogCleaningInProgress$.MODULE$.equals(logCleaningState2)) {
                    return this.inProgress().remove((Object)topicPartition);
                }
            }
            if (bl && LogCleaningAborted$.MODULE$.equals(logCleaningState = (LogCleaningState)some.value())) {
                this.inProgress().put((Object)topicPartition, (Object)LogCleaningPaused$.MODULE$);
                this.pausedCleaningCond().signalAll();
                return BoxedUnit.UNIT;
            }
            if (!None$.MODULE$.equals(option)) throw new IllegalStateException(new StringBuilder(43).append("In-progress partition ").append(topicPartition).append(" cannot be in ").append(option).append(" state.").toString());
            throw new IllegalStateException(new StringBuilder(34).append("State for partition ").append(topicPartition).append(" should exist.").toString());
        });
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Log log = (Log)tuple2._2();
        boolean bl = log.config().compact();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$3(LogCleanerManager $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        boolean bl = $this.inProgress().contains((Object)topicPartition);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$5(LogToClean ltc) {
        return ltc.totalBytes() > 0L;
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$6(LogToClean ltc) {
        return ltc.cleanableRatio() > Predef$.MODULE$.Double2double(ltc.log().config().minCleanableRatio());
    }

    public static final /* synthetic */ boolean $anonfun$deletableLogs$2(LogCleanerManager $this, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        Log log = (Log)tuple2._2();
        boolean bl = !$this.inProgress().contains((Object)topicPartition) && LogCleanerManager$.MODULE$.isCompactAndDelete(log);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$handleLogDirFailure$3(String dir$1, File x$3) {
        String string = x$3.getAbsolutePath();
        String string2 = dir$1;
        return string == null ? string2 != null : !string.equals(string2);
    }

    public LogCleanerManager(Seq<File> logDirs, Pool<TopicPartition, Log> logs, LogDirFailureChannel logDirFailureChannel) {
        this.logDirs = logDirs;
        this.logs = logs;
        this.logDirFailureChannel = logDirFailureChannel;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.offsetCheckpointFile = "cleaner-offset-checkpoint";
        this.checkpoints = ((TraversableOnce)logDirs.map((Function1 & Serializable & scala.Serializable)dir -> new Tuple2(dir, (Object)new OffsetCheckpointFile(new File((File)dir, this.offsetCheckpointFile()), this.logDirFailureChannel())), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.inProgress = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.lock = new ReentrantLock();
        this.pausedCleaningCond = this.lock().newCondition();
        this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio = 0.0;
        this.newGauge("max-dirty-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleanerManager $outer;

            public int value() {
                return (int)((double)100 * this.$outer.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.kafka$log$LogCleanerManager$$timeOfLastRun = Time.SYSTEM.milliseconds();
        this.newGauge("time-since-last-run-ms", new Gauge<Object>(this){
            private final /* synthetic */ LogCleanerManager $outer;

            public long value() {
                return Time.SYSTEM.milliseconds() - this.$outer.kafka$log$LogCleanerManager$$timeOfLastRun();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
    }
}

