/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSpec;
import kafka.admin.AclCommand;
import kafka.security.auth.Acl;
import kafka.security.auth.Acl$;
import kafka.security.auth.All$;
import kafka.security.auth.Allow$;
import kafka.security.auth.Alter$;
import kafka.security.auth.AlterConfigs$;
import kafka.security.auth.Authorizer;
import kafka.security.auth.ClusterAction$;
import kafka.security.auth.Create$;
import kafka.security.auth.Delete$;
import kafka.security.auth.Deny$;
import kafka.security.auth.Describe$;
import kafka.security.auth.DescribeConfigs$;
import kafka.security.auth.IdempotentWrite$;
import kafka.security.auth.Operation;
import kafka.security.auth.Operation$;
import kafka.security.auth.PermissionType;
import kafka.security.auth.Read$;
import kafka.security.auth.Resource;
import kafka.security.auth.ResourceType$;
import kafka.security.auth.Write$;
import kafka.server.KafkaConfig$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Utils;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.Subtractable;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashSet;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Properties$;

public final class AclCommand$
implements Logging {
    public static AclCommand$ MODULE$;
    private final ResourcePatternFilter ClusterResourceFilter;
    private final String kafka$admin$AclCommand$$Newline;
    private final scala.collection.immutable.Map<ResourceType, Set<Operation>> ResourceTypeToValidOperations;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new AclCommand$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        AclCommand$ aclCommand$ = this;
        synchronized (aclCommand$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ResourcePatternFilter ClusterResourceFilter() {
        return this.ClusterResourceFilter;
    }

    public String kafka$admin$AclCommand$$Newline() {
        return this.kafka$admin$AclCommand$$Newline;
    }

    public scala.collection.immutable.Map<ResourceType, Set<Operation>> ResourceTypeToValidOperations() {
        return this.ResourceTypeToValidOperations;
    }

    public void main(String[] args) {
        AclCommand.AclCommandOptions opts = new AclCommand.AclCommandOptions(args);
        if (opts.options().has((OptionSpec)opts.helpOpt())) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "Usage:");
        }
        opts.checkArgs();
        try {
            if (opts.options().has((OptionSpec)opts.addOpt())) {
                this.addAcl(opts);
            } else if (opts.options().has((OptionSpec)opts.removeOpt())) {
                this.removeAcl(opts);
            } else if (opts.options().has((OptionSpec)opts.listOpt())) {
                this.listAcl(opts);
            }
        }
        catch (Throwable e) {
            Predef$.MODULE$.println((Object)new StringBuilder(35).append("Error while executing ACL command: ").append(e.getMessage()).toString());
            Predef$.MODULE$.println((Object)Utils.stackTrace((Throwable)e));
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
    }

    public void withAuthorizer(AclCommand.AclCommandOptions opts, Function1<Authorizer, BoxedUnit> f) {
        scala.collection.immutable.Map map;
        scala.collection.immutable.Map defaultProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkEnableSecureAclsProp()), (Object)BoxesRunTime.boxToBoolean((boolean)JaasUtils.isZkSecurityEnabled()))}));
        if (opts.options().has(opts.authorizerPropertiesOpt())) {
            Buffer authorizerProperties = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.authorizerPropertiesOpt())).asScala();
            map = defaultProps.$plus$plus((GenTraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(CommandLineUtils$.MODULE$.parseKeyValueArgs((Iterable<String>)authorizerProperties, false)).asScala());
        } else {
            map = defaultProps;
        }
        scala.collection.immutable.Map authorizerProperties = map;
        String authorizerClass = (String)opts.options().valueOf(opts.authorizerOpt());
        Authorizer authZ = (Authorizer)CoreUtils$.MODULE$.createObject(authorizerClass, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[0]));
        try {
            authZ.configure((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)authorizerProperties).asJava());
            f.apply((Object)authZ);
        }
        finally {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> authZ.close(), this, CoreUtils$.MODULE$.swallow$default$3());
        }
    }

    private void addAcl(AclCommand.AclCommandOptions opts) {
        block3: {
            PatternType patternType;
            block2: {
                PatternType patternType2 = patternType = (PatternType)opts.options().valueOf(opts.resourcePatternType());
                PatternType patternType3 = PatternType.MATCH;
                if (!(patternType2 == null ? patternType3 != null : !patternType2.equals(patternType3))) break block2;
                PatternType patternType4 = patternType;
                PatternType patternType5 = PatternType.ANY;
                if (patternType4 != null ? !patternType4.equals(patternType5) : patternType5 != null) break block3;
            }
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), new StringBuilder(70).append("A '--resource-pattern-type' value of '").append(patternType).append("' is not valid when adding acls.").toString());
        }
        this.withAuthorizer(opts, (Function1<Authorizer, BoxedUnit>)(Function1 & Serializable & scala.Serializable)authorizer -> {
            AclCommand$.$anonfun$addAcl$1(opts, authorizer);
            return BoxedUnit.UNIT;
        });
    }

    private void removeAcl(AclCommand.AclCommandOptions opts) {
        this.withAuthorizer(opts, (Function1<Authorizer, BoxedUnit>)(Function1 & Serializable & scala.Serializable)authorizer -> {
            AclCommand$.$anonfun$removeAcl$1(opts, authorizer);
            return BoxedUnit.UNIT;
        });
    }

    private void removeAcls(Authorizer authorizer, Set<Acl> acls, ResourcePatternFilter filter) {
        this.getAcls(authorizer, filter).keys().foreach((Function1 & Serializable & scala.Serializable)resource -> BoxesRunTime.boxToBoolean((boolean)AclCommand$.$anonfun$removeAcls$1(authorizer, acls, resource)));
    }

    private void listAcl(AclCommand.AclCommandOptions opts) {
        this.withAuthorizer(opts, (Function1<Authorizer, BoxedUnit>)(Function1 & Serializable & scala.Serializable)authorizer -> {
            AclCommand$.$anonfun$listAcl$1(opts, authorizer);
            return BoxedUnit.UNIT;
        });
    }

    private scala.collection.immutable.Map<Resource, Set<Acl>> getAcls(Authorizer authorizer, ResourcePatternFilter filter) {
        return (scala.collection.immutable.Map)authorizer.getAcls().filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)AclCommand$.$anonfun$getAcls$1(filter, x0$2)));
    }

    private scala.collection.immutable.Map<ResourcePatternFilter, Set<Acl>> getResourceFilterToAcls(AclCommand.AclCommandOptions opts) {
        ObjectRef resourceToAcls = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
        if (!opts.options().has((OptionSpec)opts.producerOpt()) && !opts.options().has((OptionSpec)opts.consumerOpt())) {
            resourceToAcls.elem = ((scala.collection.immutable.Map)resourceToAcls.elem).$plus$plus(this.getCliResourceFilterToAcls(opts));
        }
        if (opts.options().has((OptionSpec)opts.producerOpt())) {
            resourceToAcls.elem = ((scala.collection.immutable.Map)resourceToAcls.elem).$plus$plus(this.getProducerResourceFilterToAcls(opts));
        }
        if (opts.options().has((OptionSpec)opts.consumerOpt())) {
            resourceToAcls.elem = ((scala.collection.immutable.Map)resourceToAcls.elem).$plus$plus((GenTraversableOnce)this.getConsumerResourceFilterToAcls(opts).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                ResourcePatternFilter k = (ResourcePatternFilter)tuple2._1();
                Set v = (Set)tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.$plus$plus((GenTraversableOnce)((scala.collection.immutable.Map)resourceToAcls$1.elem).getOrElse((Object)k, (Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty())));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom()));
        }
        this.validateOperation(opts, (scala.collection.immutable.Map<ResourcePatternFilter, Set<Acl>>)((scala.collection.immutable.Map)resourceToAcls.elem));
        return (scala.collection.immutable.Map)resourceToAcls.elem;
    }

    private scala.collection.immutable.Map<ResourcePatternFilter, Set<Acl>> getProducerResourceFilterToAcls(AclCommand.AclCommandOptions opts) {
        Set<ResourcePatternFilter> filters = this.getResourceFilter(opts, this.getResourceFilter$default$2());
        Set topics = (Set)filters.filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)AclCommand$.$anonfun$getProducerResourceFilterToAcls$1(x$8)));
        Set transactionalIds = (Set)filters.filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)AclCommand$.$anonfun$getProducerResourceFilterToAcls$2(x$9)));
        boolean enableIdempotence = opts.options().has((OptionSpec)opts.idempotentOpt());
        Set<Acl> topicAcls = this.getAcl(opts, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Write$.MODULE$, Describe$.MODULE$, Create$.MODULE$}))));
        Set<Acl> transactionalIdAcls = this.getAcl(opts, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Write$.MODULE$, Describe$.MODULE$}))));
        return ((TraversableOnce)topics.map((Function1 & Serializable & scala.Serializable)x$10 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$10), (Object)topicAcls), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)((TraversableOnce)transactionalIds.map((Function1 & Serializable & scala.Serializable)x$11 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$11), (Object)transactionalIdAcls), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).$plus$plus((GenTraversableOnce)(enableIdempotence ? Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ClusterResourceFilter()), this.getAcl(opts, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{IdempotentWrite$.MODULE$})))))})) : Predef$.MODULE$.Map().empty()));
    }

    private scala.collection.immutable.Map<ResourcePatternFilter, Set<Acl>> getConsumerResourceFilterToAcls(AclCommand.AclCommandOptions opts) {
        Set<ResourcePatternFilter> filters = this.getResourceFilter(opts, this.getResourceFilter$default$2());
        Set topics = (Set)filters.filter((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)AclCommand$.$anonfun$getConsumerResourceFilterToAcls$1(x$12)));
        Set groups = (Set)filters.filter((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)AclCommand$.$anonfun$getConsumerResourceFilterToAcls$2(x$13)));
        Set<Acl> acls = this.getAcl(opts, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Read$.MODULE$, Describe$.MODULE$}))));
        return ((TraversableOnce)topics.map((Function1 & Serializable & scala.Serializable)x$14 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$14), (Object)acls), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)((TraversableOnce)groups.map((Function1 & Serializable & scala.Serializable)x$15 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$15), MODULE$.getAcl(opts, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Read$.MODULE$}))))), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
    }

    private scala.collection.immutable.Map<ResourcePatternFilter, Set<Acl>> getCliResourceFilterToAcls(AclCommand.AclCommandOptions opts) {
        Set<Acl> acls = this.getAcl(opts);
        Set<ResourcePatternFilter> filters = this.getResourceFilter(opts, this.getResourceFilter$default$2());
        return ((TraversableOnce)filters.map((Function1 & Serializable & scala.Serializable)x$16 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$16), (Object)acls), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private Set<Acl> getAcl(AclCommand.AclCommandOptions opts, Set<Operation> operations) {
        Set<KafkaPrincipal> allowedPrincipals = this.getPrincipals(opts, opts.allowPrincipalsOpt());
        Set<KafkaPrincipal> deniedPrincipals = this.getPrincipals(opts, opts.denyPrincipalsOpt());
        Set<String> allowedHosts = this.getHosts(opts, opts.allowHostsOpt(), opts.allowPrincipalsOpt());
        Set<String> deniedHosts = this.getHosts(opts, opts.denyHostsOpt(), opts.denyPrincipalsOpt());
        HashSet acls = new HashSet();
        Object object = allowedHosts.nonEmpty() && allowedPrincipals.nonEmpty() ? acls.$plus$plus$eq(this.getAcls(allowedPrincipals, Allow$.MODULE$, operations, allowedHosts)) : BoxedUnit.UNIT;
        Object object2 = deniedHosts.nonEmpty() && deniedPrincipals.nonEmpty() ? acls.$plus$plus$eq(this.getAcls(deniedPrincipals, Deny$.MODULE$, operations, deniedHosts)) : BoxedUnit.UNIT;
        return acls.toSet();
    }

    private Set<Acl> getAcl(AclCommand.AclCommandOptions opts) {
        Set operations = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.operationsOpt())).asScala()).map((Function1 & Serializable & scala.Serializable)operation -> Operation$.MODULE$.fromString(operation.trim()), Buffer$.MODULE$.canBuildFrom())).toSet();
        return this.getAcl(opts, (Set<Operation>)operations);
    }

    public Set<Acl> getAcls(Set<KafkaPrincipal> principals, PermissionType permissionType, Set<Operation> operations, Set<String> hosts) {
        return (Set)principals.flatMap((Function1 & Serializable & scala.Serializable)principal -> (Set)operations.flatMap((Function1 & Serializable & scala.Serializable)operation -> (Set)hosts.map((Function1 & Serializable & scala.Serializable)host -> new Acl((KafkaPrincipal)principal, permissionType, (String)host, (Operation)operation), Set$.MODULE$.canBuildFrom()), Set$.MODULE$.canBuildFrom()), Set$.MODULE$.canBuildFrom());
    }

    private Set<String> getHosts(AclCommand.AclCommandOptions opts, ArgumentAcceptingOptionSpec<String> hostOptionSpec, ArgumentAcceptingOptionSpec<String> principalOptionSpec) {
        return opts.options().has(hostOptionSpec) ? ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(hostOptionSpec)).asScala()).map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.trim(), Buffer$.MODULE$.canBuildFrom())).toSet() : (opts.options().has(principalOptionSpec) ? (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{Acl$.MODULE$.WildCardHost()})) : Predef$.MODULE$.Set().empty());
    }

    private Set<KafkaPrincipal> getPrincipals(AclCommand.AclCommandOptions opts, ArgumentAcceptingOptionSpec<String> principalOptionSpec) {
        return opts.options().has(principalOptionSpec) ? ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(principalOptionSpec)).asScala()).map((Function1 & Serializable & scala.Serializable)s -> KafkaPrincipal.fromString((String)s.trim()), Buffer$.MODULE$.canBuildFrom())).toSet() : Predef$.MODULE$.Set().empty();
    }

    private Set<ResourcePatternFilter> getResourceFilter(AclCommand.AclCommandOptions opts, boolean dieIfNoResourceFound) {
        PatternType patternType = (PatternType)opts.options().valueOf(opts.resourcePatternType());
        ObjectRef resourceFilters = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
        if (opts.options().has(opts.topicOpt())) {
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.topicOpt())).asScala()).foreach((Function1 & Serializable & scala.Serializable)topic -> {
                resourceFilters.elem = (Set)((Set)resourceFilters.elem).$plus((Object)new ResourcePatternFilter(ResourceType.TOPIC, topic.trim(), patternType));
                return BoxedUnit.UNIT;
            });
        }
        PatternType patternType2 = patternType;
        PatternType patternType3 = PatternType.LITERAL;
        if (!(patternType2 != null ? !patternType2.equals(patternType3) : patternType3 != null)) {
            if (opts.options().has((OptionSpec)opts.clusterOpt()) || opts.options().has((OptionSpec)opts.idempotentOpt())) {
                resourceFilters.elem = (Set)((Set)resourceFilters.elem).$plus((Object)this.ClusterResourceFilter());
            }
        }
        if (opts.options().has(opts.groupOpt())) {
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.groupOpt())).asScala()).foreach((Function1 & Serializable & scala.Serializable)group -> {
                resourceFilters.elem = (Set)((Set)resourceFilters.elem).$plus((Object)new ResourcePatternFilter(ResourceType.GROUP, group.trim(), patternType));
                return BoxedUnit.UNIT;
            });
        }
        if (opts.options().has(opts.transactionalIdOpt())) {
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.transactionalIdOpt())).asScala()).foreach((Function1 & Serializable & scala.Serializable)transactionalId -> {
                resourceFilters.elem = (Set)((Set)resourceFilters.elem).$plus((Object)new ResourcePatternFilter(ResourceType.TRANSACTIONAL_ID, transactionalId, patternType));
                return BoxedUnit.UNIT;
            });
        }
        if (opts.options().has(opts.delegationTokenOpt())) {
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.delegationTokenOpt())).asScala()).foreach((Function1 & Serializable & scala.Serializable)token -> {
                resourceFilters.elem = (Set)((Set)resourceFilters.elem).$plus((Object)new ResourcePatternFilter(ResourceType.DELEGATION_TOKEN, token.trim(), patternType));
                return BoxedUnit.UNIT;
            });
        }
        if (((Set)resourceFilters.elem).isEmpty() && dieIfNoResourceFound) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "You must provide at least one resource: --topic <topic> or --cluster or --group <group> or --delegation-token <Delegation Token ID>");
        }
        return (Set)resourceFilters.elem;
    }

    private boolean getResourceFilter$default$2() {
        return true;
    }

    private boolean confirmAction(AclCommand.AclCommandOptions opts, String msg) {
        if (opts.options().has((OptionSpec)opts.forceOpt())) {
            return true;
        }
        Predef$.MODULE$.println((Object)msg);
        return Console$.MODULE$.readLine().equalsIgnoreCase("y");
    }

    private void validateOperation(AclCommand.AclCommandOptions opts, scala.collection.immutable.Map<ResourcePatternFilter, Set<Acl>> resourceToAcls) {
        resourceToAcls.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)AclCommand$.$anonfun$validateOperation$1(check$ifrefutable$4))).foreach((Function1 & Serializable & scala.Serializable)x$19 -> {
            AclCommand$.$anonfun$validateOperation$2(opts, x$19);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$addAcl$4(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$addAcl$5(Authorizer authorizer$2, Tuple2 x$3) {
        Tuple2 tuple2 = x$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Resource resource = (Resource)tuple2._1();
        Set acls = (Set)tuple2._2();
        Predef$.MODULE$.println((Object)new StringBuilder(31).append("Adding ACLs for resource `").append(resource).append("`: ").append(MODULE$.kafka$admin$AclCommand$$Newline()).append(" ").append(((TraversableOnce)acls.map((Function1 & Serializable & scala.Serializable)x$2 -> new StringBuilder(1).append("\t").append(x$2).toString(), Set$.MODULE$.canBuildFrom())).mkString(MODULE$.kafka$admin$AclCommand$$Newline())).append(" ").append(MODULE$.kafka$admin$AclCommand$$Newline()).toString());
        authorizer$2.addAcls((Set<Acl>)acls, resource);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$addAcl$1(AclCommand.AclCommandOptions opts$1, Authorizer authorizer) {
        scala.collection.immutable.Map resourceToAcl = (scala.collection.immutable.Map)MODULE$.getResourceFilterToAcls(opts$1).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ResourcePatternFilter filter = (ResourcePatternFilter)tuple2._1();
            Set acls = (Set)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Resource(ResourceType$.MODULE$.fromJava(filter.resourceType()), filter.name(), filter.patternType())), (Object)acls);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        if (resourceToAcl.values().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isEmpty()))) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts$1.parser(), "You must specify one of: --allow-principal, --deny-principal when trying to add ACLs.");
        }
        resourceToAcl.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)AclCommand$.$anonfun$addAcl$4(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            AclCommand$.$anonfun$addAcl$5(authorizer, x$3);
            return BoxedUnit.UNIT;
        });
        MODULE$.listAcl(opts$1);
    }

    public static final /* synthetic */ boolean $anonfun$removeAcl$2(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$removeAcl$3(AclCommand.AclCommandOptions opts$2, Authorizer authorizer$3, Tuple2 x$5) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x$5;
        if (tuple2 != null) {
            ResourcePatternFilter filter = (ResourcePatternFilter)tuple2._1();
            Set acls = (Set)tuple2._2();
            if (acls.isEmpty()) {
                if (MODULE$.confirmAction(opts$2, new StringBuilder(70).append("Are you sure you want to delete all ACLs for resource filter `").append(filter).append("`? (y/n)").toString())) {
                    MODULE$.removeAcls(authorizer$3, (Set<Acl>)acls, filter);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else if (MODULE$.confirmAction(opts$2, new StringBuilder(71).append("Are you sure you want to remove ACLs: ").append(MODULE$.kafka$admin$AclCommand$$Newline()).append(" ").append(((TraversableOnce)acls.map((Function1 & Serializable & scala.Serializable)x$4 -> new StringBuilder(1).append("\t").append(x$4).toString(), Set$.MODULE$.canBuildFrom())).mkString(MODULE$.kafka$admin$AclCommand$$Newline())).append(" ").append(MODULE$.kafka$admin$AclCommand$$Newline()).append(" from resource filter `").append(filter).append("`? (y/n)").toString())) {
                MODULE$.removeAcls(authorizer$3, (Set<Acl>)acls, filter);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$removeAcl$1(AclCommand.AclCommandOptions opts$2, Authorizer authorizer) {
        scala.collection.immutable.Map<ResourcePatternFilter, Set<Acl>> filterToAcl = MODULE$.getResourceFilterToAcls(opts$2);
        filterToAcl.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)AclCommand$.$anonfun$removeAcl$2(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            AclCommand$.$anonfun$removeAcl$3(opts$2, authorizer, x$5);
            return BoxedUnit.UNIT;
        });
        MODULE$.listAcl(opts$2);
    }

    public static final /* synthetic */ boolean $anonfun$removeAcls$1(Authorizer authorizer$1, Set acls$1, Resource resource) {
        return acls$1.isEmpty() ? authorizer$1.removeAcls(resource) : authorizer$1.removeAcls((Set<Acl>)acls$1, resource);
    }

    public static final /* synthetic */ boolean $anonfun$listAcl$3(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$listAcl$4(Tuple2 x$7) {
        Tuple2 tuple2 = x$7;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Resource resource = (Resource)tuple2._1();
        Set acls = (Set)tuple2._2();
        Predef$.MODULE$.println((Object)new StringBuilder(32).append("Current ACLs for resource `").append(resource).append("`: ").append(MODULE$.kafka$admin$AclCommand$$Newline()).append(" ").append(((TraversableOnce)acls.map((Function1 & Serializable & scala.Serializable)x$6 -> new StringBuilder(1).append("\t").append(x$6).toString(), Set$.MODULE$.canBuildFrom())).mkString(MODULE$.kafka$admin$AclCommand$$Newline())).append(" ").append(MODULE$.kafka$admin$AclCommand$$Newline()).toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$listAcl$1(AclCommand.AclCommandOptions opts$3, Authorizer authorizer) {
        Set<ResourcePatternFilter> filters = MODULE$.getResourceFilter(opts$3, false);
        Iterable resourceToAcls = filters.isEmpty() ? authorizer.getAcls() : (Iterable)filters.flatMap((Function1 & Serializable & scala.Serializable)filter -> MODULE$.getAcls(authorizer, (ResourcePatternFilter)filter), Set$.MODULE$.canBuildFrom());
        resourceToAcls.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)AclCommand$.$anonfun$listAcl$3(check$ifrefutable$3))).foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            AclCommand$.$anonfun$listAcl$4(x$7);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getAcls$1(ResourcePatternFilter filter$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Resource resource = (Resource)tuple2._1();
        boolean bl = filter$1.matches(resource.toPattern());
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$getProducerResourceFilterToAcls$1(ResourcePatternFilter x$8) {
        ResourceType resourceType = x$8.resourceType();
        ResourceType resourceType2 = ResourceType.TOPIC;
        return !(resourceType != null ? !resourceType.equals(resourceType2) : resourceType2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getProducerResourceFilterToAcls$2(ResourcePatternFilter x$9) {
        ResourceType resourceType = x$9.resourceType();
        ResourceType resourceType2 = ResourceType.TRANSACTIONAL_ID;
        return !(resourceType != null ? !resourceType.equals(resourceType2) : resourceType2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getConsumerResourceFilterToAcls$1(ResourcePatternFilter x$12) {
        ResourceType resourceType = x$12.resourceType();
        ResourceType resourceType2 = ResourceType.TOPIC;
        return !(resourceType != null ? !resourceType.equals(resourceType2) : resourceType2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getConsumerResourceFilterToAcls$2(ResourcePatternFilter x$13) {
        ResourceType resourceType = x$13.resourceType();
        ResourceType resourceType2 = ResourceType.GROUP;
        return !(resourceType != null ? !resourceType.equals(resourceType2) : resourceType2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateOperation$1(Tuple2 check$ifrefutable$4) {
        Tuple2 tuple2 = check$ifrefutable$4;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$validateOperation$2(AclCommand.AclCommandOptions opts$5, Tuple2 x$19) {
        Tuple2 tuple2 = x$19;
        if (tuple2 != null) {
            ResourcePatternFilter resource = (ResourcePatternFilter)tuple2._1();
            Set acls = (Set)tuple2._2();
            Set validOps = (Set)MODULE$.ResourceTypeToValidOperations().apply((Object)resource.resourceType());
            if (((TraversableOnce)((Subtractable)acls.map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.operation(), Set$.MODULE$.canBuildFrom())).$minus$minus((GenTraversableOnce)validOps)).nonEmpty()) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(opts$5.parser(), new StringBuilder(39).append("ResourceType ").append(resource.resourceType()).append(" only supports operations ").append(validOps.mkString(",")).toString());
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private AclCommand$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.ClusterResourceFilter = new ResourcePatternFilter(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL);
        this.kafka$admin$AclCommand$$Newline = Properties$.MODULE$.lineSeparator();
        this.ResourceTypeToValidOperations = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ResourceType.TOPIC), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Read$.MODULE$, Write$.MODULE$, Create$.MODULE$, Describe$.MODULE$, Delete$.MODULE$, DescribeConfigs$.MODULE$, AlterConfigs$.MODULE$, All$.MODULE$}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ResourceType.GROUP), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Read$.MODULE$, Describe$.MODULE$, Delete$.MODULE$, All$.MODULE$}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ResourceType.CLUSTER), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Create$.MODULE$, ClusterAction$.MODULE$, DescribeConfigs$.MODULE$, AlterConfigs$.MODULE$, IdempotentWrite$.MODULE$, Alter$.MODULE$, Describe$.MODULE$, All$.MODULE$}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ResourceType.TRANSACTIONAL_ID), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Describe$.MODULE$, Write$.MODULE$, All$.MODULE$}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ResourceType.DELEGATION_TOKEN), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Describe$.MODULE$, All$.MODULE$})))}));
    }
}

