/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import com.hp.hpl.jena.graph.Node;
import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.iterator.PeekIterator;
import org.apache.jena.riot.RiotParseException;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.tokens.Token;
import org.apache.jena.riot.tokens.TokenType;
import org.apache.jena.riot.tokens.Tokenizer;

public class LangEngine {
    protected ParserProfile profile;
    protected final Tokenizer tokens;
    private final PeekIterator<Token> peekIter;
    private Token tokenEOF = null;
    protected long currLine = -1L;
    protected long currCol = -1L;

    protected LangEngine(Tokenizer tokens2, ParserProfile profile) {
        this.tokens = tokens2;
        this.profile = profile;
        this.peekIter = new PeekIterator<Token>(tokens2);
    }

    protected final Token peekToken() {
        if (this.eof()) {
            return this.tokenEOF;
        }
        return this.peekIter.peek();
    }

    protected final boolean eof() {
        if (this.tokenEOF != null) {
            return true;
        }
        if (!this.moreTokens()) {
            this.tokenEOF = new Token(this.tokens.getLine(), this.tokens.getColumn());
            this.tokenEOF.setType(TokenType.EOF);
            return true;
        }
        return false;
    }

    protected final boolean moreTokens() {
        return this.peekIter.hasNext();
    }

    protected final boolean lookingAt(TokenType tokenType) {
        if (this.eof()) {
            return tokenType == TokenType.EOF;
        }
        if (tokenType == TokenType.NODE) {
            return this.peekToken().isNode();
        }
        return this.peekToken().hasType(tokenType);
    }

    protected final Token nextToken() {
        if (this.eof()) {
            return this.tokenEOF;
        }
        try {
            Token t = this.peekIter.next();
            this.currLine = t.getLine();
            this.currCol = t.getColumn();
            return t;
        }
        catch (RiotParseException ex) {
            this.raiseException(ex);
            throw ex;
        }
        catch (AtlasException ex) {
            RiotParseException ex2 = new RiotParseException(ex.getMessage(), -1L, -1L);
            this.raiseException(ex2);
            throw ex2;
        }
    }

    protected final Node scopedBNode(Node scopeNode, String label) {
        return (Node)this.profile.getLabelToNode().get(scopeNode, label);
    }

    protected final void expectOrEOF(String msg, TokenType tokenType) {
        if (this.eof()) {
            return;
        }
        this.expect(msg, tokenType);
    }

    protected final void skipIf(TokenType ttype) {
        if (this.lookingAt(ttype)) {
            this.nextToken();
        }
    }

    protected final void expect(String msg, TokenType ttype) {
        if (!this.lookingAt(ttype)) {
            Token location = this.peekToken();
            this.exception(location, msg, new Object[0]);
        }
        this.nextToken();
    }

    protected final void exception(Token token, String msg, Object ... args) {
        if (token != null) {
            this.exceptionDirect(String.format(msg, args), token.getLine(), token.getColumn());
        } else {
            this.exceptionDirect(String.format(msg, args), -1L, -1L);
        }
    }

    protected final void exceptionDirect(String msg, long line, long col) {
        this.raiseException(new RiotParseException(msg, line, col));
    }

    protected final void raiseException(RiotParseException ex) {
        ErrorHandler errorHandler = this.profile.getHandler();
        if (errorHandler != null) {
            errorHandler.fatal(ex.getOriginalMessage(), ex.getLine(), ex.getCol());
        }
        throw ex;
    }
}

