/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.serializer;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.PathBlock;
import com.hp.hpl.jena.sparql.core.TriplePath;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.path.PathWriter;
import com.hp.hpl.jena.sparql.serializer.FmtExprSPARQL;
import com.hp.hpl.jena.sparql.serializer.FormatterBase;
import com.hp.hpl.jena.sparql.serializer.QuerySerializer;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.serializer.Serializer;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.Element1;
import com.hp.hpl.jena.sparql.syntax.ElementAssign;
import com.hp.hpl.jena.sparql.syntax.ElementBind;
import com.hp.hpl.jena.sparql.syntax.ElementData;
import com.hp.hpl.jena.sparql.syntax.ElementDataset;
import com.hp.hpl.jena.sparql.syntax.ElementExists;
import com.hp.hpl.jena.sparql.syntax.ElementFilter;
import com.hp.hpl.jena.sparql.syntax.ElementGroup;
import com.hp.hpl.jena.sparql.syntax.ElementMinus;
import com.hp.hpl.jena.sparql.syntax.ElementNamedGraph;
import com.hp.hpl.jena.sparql.syntax.ElementNotExists;
import com.hp.hpl.jena.sparql.syntax.ElementOptional;
import com.hp.hpl.jena.sparql.syntax.ElementPathBlock;
import com.hp.hpl.jena.sparql.syntax.ElementService;
import com.hp.hpl.jena.sparql.syntax.ElementSubQuery;
import com.hp.hpl.jena.sparql.syntax.ElementTriplesBlock;
import com.hp.hpl.jena.sparql.syntax.ElementUnion;
import com.hp.hpl.jena.sparql.syntax.ElementVisitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;

public class FormatterElement
extends FormatterBase
implements ElementVisitor {
    public static final int INDENT = 2;
    public static final boolean PATTERN_MARKERS = false;
    public static final boolean GROUP_SEP_DOT = false;
    public static final boolean GROUP_FIRST_ON_SAME_LINE = false;
    public static final boolean PRETTY_PRINT = true;
    public static final boolean UNION_MARKERS = false;
    public static final boolean GROUP_UNNEST_ONE = false;
    public static final boolean GRAPH_FIXED_INDENT = true;
    public static final boolean ELEMENT1_FIXED_INDENT = true;
    public static final int TRIPLES_SUBJECT_COLUMN = 8;
    public static final int TRIPLES_SUBJECT_LONG = 12;
    public static final int TRIPLES_PROPERTY_COLUMN = 20;
    public static final int TRIPLES_COLUMN_GAP = 2;
    int subjectWidth = -1;
    int predicateWidth = -1;

    public FormatterElement(IndentedWriter out, SerializationContext context) {
        super(out, context);
    }

    public static void format(IndentedWriter out, SerializationContext cxt, Element el) {
        FormatterElement fmt = new FormatterElement(out, cxt);
        fmt.startVisit();
        el.visit(fmt);
        fmt.finishVisit();
    }

    public static String asString(Element el) {
        SerializationContext cxt = new SerializationContext();
        IndentedLineBuffer b = new IndentedLineBuffer();
        FormatterElement.format(b, cxt, el);
        return b.toString();
    }

    public boolean topMustBeGroup() {
        return false;
    }

    @Override
    public void visit(ElementTriplesBlock el) {
        if (el.isEmpty()) {
            this.out.println("# Empty BGP");
            return;
        }
        this.formatTriples(el.getPattern());
    }

    @Override
    public void visit(ElementPathBlock el) {
        if (el.isEmpty()) {
            this.out.println("# Empty BGP");
            return;
        }
        boolean first = true;
        PathBlock pBlk = el.getPattern();
        for (TriplePath tp : pBlk) {
            if (!first) {
                this.out.println(" .");
            }
            first = false;
            if (tp.isTriple()) {
                this.printSubject(tp.getSubject());
                this.out.print(" ");
                this.printProperty(tp.getPredicate());
                this.out.print(" ");
                this.printObject(tp.getObject());
                continue;
            }
            this.printSubject(tp.getSubject());
            this.out.print(" ");
            PathWriter.write(this.out, tp.getPath(), this.context.getPrologue());
            this.out.print(" ");
            this.printObject(tp.getObject());
        }
    }

    @Override
    public void visit(ElementDataset el) {
        if (el.getPatternElement() != null) {
            this.visitAsGroup(el.getPatternElement());
        }
    }

    @Override
    public void visit(ElementFilter el) {
        this.out.print("FILTER ");
        Expr expr = el.getExpr();
        FmtExprSPARQL v = new FmtExprSPARQL(this.out, this.context);
        boolean addParens = false;
        if (expr.isVariable()) {
            addParens = true;
        }
        if (expr.isConstant()) {
            addParens = true;
        }
        if (addParens) {
            this.out.print("( ");
        }
        v.format(expr);
        if (addParens) {
            this.out.print(" )");
        }
    }

    @Override
    public void visit(ElementAssign el) {
        this.out.print("LET (");
        this.out.print("?" + el.getVar().getVarName());
        this.out.print(" := ");
        FmtExprSPARQL v = new FmtExprSPARQL(this.out, this.context);
        v.format(el.getExpr());
        this.out.print(")");
    }

    @Override
    public void visit(ElementBind el) {
        this.out.print("BIND(");
        FmtExprSPARQL v = new FmtExprSPARQL(this.out, this.context);
        v.format(el.getExpr());
        this.out.print(" AS ");
        this.out.print("?" + el.getVar().getVarName());
        this.out.print(")");
    }

    @Override
    public void visit(ElementData el) {
        QuerySerializer.outputDataBlock(this.out, el.getVars(), el.getRows(), this.context.getPrologue());
    }

    @Override
    public void visit(ElementUnion el) {
        if (el.getElements().size() == 1) {
            this.out.print("UNION");
            this.out.incIndent(2);
            this.out.newline();
            this.visitAsGroup(el.getElements().get(0));
            this.out.decIndent(2);
            return;
        }
        this.out.incIndent(2);
        boolean first = true;
        for (Element subElement : el.getElements()) {
            if (!first) {
                this.out.decIndent(2);
                this.out.newline();
                this.out.print("UNION");
                this.out.newline();
                this.out.incIndent(2);
            }
            this.visitAsGroup(subElement);
            first = false;
        }
        this.out.decIndent(2);
    }

    @Override
    public void visit(ElementGroup el) {
        this.out.print("{");
        this.out.incIndent(2);
        int row1 = this.out.getRow();
        this.out.pad();
        boolean first = true;
        Element lastElt = null;
        for (Element subElement : el.getElements()) {
            if (!first) {
                if (FormatterElement.needsDotSeparator(lastElt, subElement)) {
                    this.out.print(" . ");
                }
                this.out.newline();
            }
            subElement.visit(this);
            first = false;
            lastElt = subElement;
        }
        this.out.decIndent(2);
        int row2 = this.out.getRow();
        if (row1 != row2) {
            this.out.newline();
        }
        this.out.print("}");
    }

    private static boolean needsDotSeparator(Element el1, Element el2) {
        return FormatterElement.needsDotSeparator(el1) && FormatterElement.needsDotSeparator(el2);
    }

    private static boolean needsDotSeparator(Element el) {
        return el instanceof ElementTriplesBlock || el instanceof ElementPathBlock;
    }

    @Override
    public void visit(ElementOptional el) {
        this.out.print("OPTIONAL");
        this.out.incIndent(2);
        this.out.newline();
        this.visitAsGroup(el.getOptionalElement());
        this.out.decIndent(2);
    }

    @Override
    public void visit(ElementNamedGraph el) {
        this.visitNodePattern("GRAPH", el.getGraphNameNode(), el.getElement());
    }

    @Override
    public void visit(ElementService el) {
        String x = "SERVICE";
        if (el.getSilent()) {
            x = "SERVICE SILENT";
        }
        this.visitNodePattern(x, el.getServiceNode(), el.getElement());
    }

    private void visitNodePattern(String label, Node node, Element subElement) {
        int len = label.length();
        this.out.print(label);
        this.out.print(" ");
        String nodeStr = node == null ? "*" : this.slotToString(node);
        this.out.print(nodeStr);
        len += nodeStr.length();
        this.out.incIndent(2);
        this.out.newline();
        this.visitAsGroup(subElement);
        this.out.decIndent(2);
    }

    private void visitElement1(String label, Element1 el) {
        int len = label.length();
        this.out.print(label);
        len += label.length();
        this.out.incIndent(2);
        this.out.newline();
        this.visitAsGroup(el.getElement());
        this.out.decIndent(2);
    }

    @Override
    public void visit(ElementExists el) {
        this.visitElement1("EXISTS", el);
    }

    @Override
    public void visit(ElementNotExists el) {
        this.visitElement1("NOT EXISTS", el);
    }

    @Override
    public void visit(ElementMinus el) {
        this.out.print("MINUS");
        this.out.incIndent(2);
        this.out.newline();
        this.visitAsGroup(el.getMinusElement());
        this.out.decIndent(2);
    }

    @Override
    public void visit(ElementSubQuery el) {
        this.out.print("{ ");
        this.out.incIndent(2);
        Query q = el.getQuery();
        Serializer.serializeARQ(q, this.out, new FormatterElement(this.out, this.context), new FmtExprSPARQL(this.out, this.context), null);
        this.out.decIndent(2);
        this.out.print("}");
    }

    public void visitAsGroup(Element el) {
        boolean needBraces;
        boolean bl = needBraces = !(el instanceof ElementGroup) && !(el instanceof ElementSubQuery);
        if (needBraces) {
            this.out.print("{ ");
            this.out.incIndent(2);
        }
        el.visit(this);
        if (needBraces) {
            this.out.decIndent(2);
            this.out.print("}");
        }
    }

    @Override
    protected void formatTriples(BasicPattern triples) {
        if (triples.isEmpty()) {
            return;
        }
        this.setWidths(triples);
        if (this.subjectWidth > 8) {
            this.subjectWidth = 8;
        }
        if (this.predicateWidth > 20) {
            this.predicateWidth = 20;
        }
        ArrayList<Triple> subjAcc = new ArrayList<Triple>();
        Node subj = null;
        boolean first = true;
        int indent = -1;
        for (Triple t : triples) {
            if (subj != null && t.getSubject().equals(subj)) {
                subjAcc.add(t);
                continue;
            }
            if (subj != null) {
                if (!first) {
                    this.out.println();
                }
                this.formatSameSubject(subj, subjAcc);
                first = false;
            }
            subj = t.getSubject();
            subjAcc.clear();
            subjAcc.add(t);
        }
        if (subj != null && subjAcc.size() != 0) {
            if (!first) {
                this.out.println();
            }
            first = false;
            this.formatSameSubject(subj, subjAcc);
        }
    }

    private void formatSameSubject(Node subject, List<Triple> triples) {
        if (triples == null || triples.size() == 0) {
            return;
        }
        Iterator<Triple> iter = triples.iterator();
        Triple t1 = iter.next();
        int indent = this.subjectWidth + 2;
        int s1_len = this.printSubject(t1.getSubject());
        if (s1_len > 12) {
            this.out.incIndent(indent);
            this.out.println();
        } else {
            this.printGap();
            this.out.incIndent(indent);
        }
        this.printProperty(t1.getPredicate());
        this.printGap();
        this.printObject(t1.getObject());
        while (iter.hasNext()) {
            Triple t = iter.next();
            this.out.println(" ;");
            this.printProperty(t.getPredicate());
            this.printGap();
            this.printObject(t.getObject());
        }
        this.out.decIndent(indent);
        this.out.print(" .");
    }

    private void setWidths(BasicPattern triples) {
        this.subjectWidth = -1;
        this.predicateWidth = -1;
        for (Triple t : triples) {
            String p;
            String s = this.slotToString(t.getSubject());
            if (s.length() > this.subjectWidth) {
                this.subjectWidth = s.length();
            }
            if ((p = this.slotToString(t.getPredicate())).length() <= this.predicateWidth) continue;
            this.predicateWidth = p.length();
        }
    }

    private void printGap() {
        this.out.print(' ', 2);
    }

    private int printSubject(Node s) {
        String str2 = this.slotToString(s);
        this.out.print(str2);
        this.out.pad(this.subjectWidth);
        return str2.length();
    }

    private int printProperty(Node p) {
        String str2 = this.slotToString(p);
        this.out.print(str2);
        this.out.pad(this.predicateWidth);
        return str2.length();
    }

    private int printObject(Node obj) {
        return this.printNoCol(obj);
    }

    private int printNoCol(Node node) {
        String str2 = this.slotToString(node);
        this.out.print(str2);
        return str2.length();
    }
}

