/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.lang;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.sparql.lang.SPARQLParser;
import com.hp.hpl.jena.sparql.lang.sparql_11.ParseException;
import com.hp.hpl.jena.sparql.lang.sparql_11.SPARQLParser11;
import com.hp.hpl.jena.sparql.lang.sparql_11.TokenMgrError;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.Template;
import java.io.StringReader;
import org.apache.jena.atlas.logging.Log;

public class ParserSPARQL11
extends SPARQLParser {
    @Override
    protected Query parse$(Query query2, String queryString) {
        query2.setSyntax(Syntax.syntaxSPARQL_11);
        Action action = new Action(){

            @Override
            public void exec(SPARQLParser11 parser) throws Exception {
                parser.QueryUnit();
            }
        };
        ParserSPARQL11.perform(query2, queryString, action);
        this.validateParsedQuery(query2);
        return query2;
    }

    public static Element parseElement(String string) {
        final Query query2 = new Query();
        Action action = new Action(){

            @Override
            public void exec(SPARQLParser11 parser) throws Exception {
                Element el = parser.GroupGraphPattern();
                query2.setQueryPattern(el);
            }
        };
        ParserSPARQL11.perform(query2, string, action);
        return query2.getQueryPattern();
    }

    public static Template parseTemplate(String string) {
        final Query query2 = new Query();
        Action action = new Action(){

            @Override
            public void exec(SPARQLParser11 parser) throws Exception {
                Template t = parser.ConstructTemplate();
                query2.setConstructTemplate(t);
            }
        };
        ParserSPARQL11.perform(query2, string, action);
        return query2.getConstructTemplate();
    }

    private static void perform(Query query2, String string, Action action) {
        StringReader in = new StringReader(string);
        SPARQLParser11 parser = new SPARQLParser11(in);
        try {
            query2.setStrict(true);
            parser.setQuery(query2);
            action.exec(parser);
        }
        catch (ParseException ex) {
            throw new QueryParseException(ex.getMessage(), ex.currentToken.beginLine, ex.currentToken.beginColumn);
        }
        catch (TokenMgrError tErr) {
            int col = parser.token.endColumn;
            int line = parser.token.endLine;
            throw new QueryParseException(tErr.getMessage(), line, col);
        }
        catch (QueryException ex) {
            throw ex;
        }
        catch (JenaException ex) {
            throw new QueryException(ex.getMessage(), ex);
        }
        catch (Error err) {
            throw new QueryParseException(err.getMessage(), err, -1, -1);
        }
        catch (Throwable th) {
            Log.warn(ParserSPARQL11.class, "Unexpected throwable: ", th);
            throw new QueryException(th.getMessage(), th);
        }
    }

    private static interface Action {
        public void exec(SPARQLParser11 var1) throws Exception;
    }
}

