/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.query.SortCondition;
import com.hp.hpl.jena.sparql.algebra.OpVars;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunctionOp;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.ExprVisitorBase;
import com.hp.hpl.jena.sparql.expr.ExprWalker;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class ExprVars {
    public static Set<Var> getVarsMentioned(Expr expr) {
        HashSet<Var> acc = new HashSet<Var>();
        ExprVars.varsMentioned(acc, expr);
        return acc;
    }

    public static Set<Var> getVarsMentioned(ExprList exprs) {
        HashSet<Var> acc = new HashSet<Var>();
        for (Expr expr : exprs) {
            ExprVars.varsMentioned(acc, expr);
        }
        return acc;
    }

    public static void varsMentioned(Collection<Var> acc, Expr expr) {
        Action<Var> action = new Action<Var>(){

            @Override
            public void var(Collection<Var> acc, Var var) {
                acc.add(var);
            }
        };
        ExprVarsWorker<Var> vv = new ExprVarsWorker<Var>(acc, action);
        ExprWalker.walk(vv, expr);
    }

    public static Set<String> getVarNamesMentioned(Expr expr) {
        HashSet<String> acc = new HashSet<String>();
        ExprVars.varNamesMentioned(acc, expr);
        return acc;
    }

    public static void varNamesMentioned(Collection<String> acc, Expr expr) {
        Action<String> action = new Action<String>(){

            @Override
            public void var(Collection<String> acc, Var var) {
                acc.add(var.getVarName());
            }
        };
        ExprVarsWorker<String> vv = new ExprVarsWorker<String>(acc, action);
        ExprWalker.walk(vv, expr);
    }

    public static Set<Var> getVarsMentioned(SortCondition sortCondition) {
        HashSet<Var> acc = new HashSet<Var>();
        ExprVars.varsMentioned(acc, sortCondition);
        return acc;
    }

    public static Set<Var> getVarsMentioned(Collection<SortCondition> sortConditions) {
        HashSet<Var> acc = new HashSet<Var>();
        ExprVars.varsMentioned(acc, sortConditions);
        return acc;
    }

    public static void varsMentioned(Collection<Var> acc, SortCondition sortCondition) {
        sortCondition.getExpression().varsMentioned(acc);
    }

    public static void varsMentioned(Collection<Var> acc, Collection<SortCondition> sortConditions) {
        for (SortCondition sc : sortConditions) {
            ExprVars.varsMentioned(acc, sc);
        }
    }

    static class ExprVarsWorker<T>
    extends ExprVisitorBase {
        final Collection<T> acc;
        final Action<T> action;

        public ExprVarsWorker(Collection<T> acc, Action<T> action) {
            this.acc = acc;
            this.action = action;
        }

        @Override
        public void visit(ExprVar nv) {
            this.action.var(this.acc, nv.asVar());
        }

        @Override
        public void visit(ExprFunctionOp funcOp) {
            Set<Var> vars = OpVars.visibleVars(funcOp.getGraphPattern());
            for (Var v : vars) {
                this.action.var(this.acc, v);
            }
        }
    }

    static interface Action<T> {
        public void var(Collection<T> var1, Var var2);
    }
}

