// Code generated by Thrift Compiler (0.14.1). DO NOT EDIT.

package main

import (
	"context"
	"flag"
	"fmt"
	"math"
	"net"
	"net/url"
	"os"
	"strconv"
	"strings"
	"github.com/apache/thrift/lib/go/thrift"
	"common"
	"rpc"
)

var _ = common.GoUnusedProtection__
var _ = rpc.GoUnusedProtection__

func Usage() {
  fmt.Fprintln(os.Stderr, "Usage of ", os.Args[0], " [-h host:port] [-u url] [-f[ramed]] function [arg1 [arg2...]]:")
  flag.PrintDefaults()
  fmt.Fprintln(os.Stderr, "\nFunctions:")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeQueryStatementV2(TSExecuteStatementReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeUpdateStatementV2(TSExecuteStatementReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeStatementV2(TSExecuteStatementReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeRawDataQueryV2(TSRawDataQueryReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeLastDataQueryV2(TSLastDataQueryReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeFastLastDataQueryForOneDeviceV2(TSFastLastDataQueryForOneDeviceReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeAggregationQueryV2(TSAggregationQueryReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeGroupByQueryIntervalQuery(TSGroupByQueryIntervalReq req)")
  fmt.Fprintln(os.Stderr, "  TSFetchResultsResp fetchResultsV2(TSFetchResultsReq req)")
  fmt.Fprintln(os.Stderr, "  TSOpenSessionResp openSession(TSOpenSessionReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus closeSession(TSCloseSessionReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeStatement(TSExecuteStatementReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus executeBatchStatement(TSExecuteBatchStatementReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeQueryStatement(TSExecuteStatementReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeUpdateStatement(TSExecuteStatementReq req)")
  fmt.Fprintln(os.Stderr, "  TSFetchResultsResp fetchResults(TSFetchResultsReq req)")
  fmt.Fprintln(os.Stderr, "  TSFetchMetadataResp fetchMetadata(TSFetchMetadataReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus cancelOperation(TSCancelOperationReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus closeOperation(TSCloseOperationReq req)")
  fmt.Fprintln(os.Stderr, "  TSGetTimeZoneResp getTimeZone(i64 sessionId)")
  fmt.Fprintln(os.Stderr, "  TSStatus setTimeZone(TSSetTimeZoneReq req)")
  fmt.Fprintln(os.Stderr, "  ServerProperties getProperties()")
  fmt.Fprintln(os.Stderr, "  TSStatus setStorageGroup(i64 sessionId, string storageGroup)")
  fmt.Fprintln(os.Stderr, "  TSStatus createTimeseries(TSCreateTimeseriesReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus createAlignedTimeseries(TSCreateAlignedTimeseriesReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus createMultiTimeseries(TSCreateMultiTimeseriesReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus deleteTimeseries(i64 sessionId,  path)")
  fmt.Fprintln(os.Stderr, "  TSStatus deleteStorageGroups(i64 sessionId,  storageGroup)")
  fmt.Fprintln(os.Stderr, "  TSStatus insertRecord(TSInsertRecordReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus insertStringRecord(TSInsertStringRecordReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus insertTablet(TSInsertTabletReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus insertTablets(TSInsertTabletsReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus insertRecords(TSInsertRecordsReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus insertRecordsOfOneDevice(TSInsertRecordsOfOneDeviceReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus insertStringRecordsOfOneDevice(TSInsertStringRecordsOfOneDeviceReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus insertStringRecords(TSInsertStringRecordsReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus testInsertTablet(TSInsertTabletReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus testInsertTablets(TSInsertTabletsReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus testInsertRecord(TSInsertRecordReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus testInsertStringRecord(TSInsertStringRecordReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus testInsertRecords(TSInsertRecordsReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus testInsertRecordsOfOneDevice(TSInsertRecordsOfOneDeviceReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus testInsertStringRecords(TSInsertStringRecordsReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus deleteData(TSDeleteDataReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeRawDataQuery(TSRawDataQueryReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeLastDataQuery(TSLastDataQueryReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeAggregationQuery(TSAggregationQueryReq req)")
  fmt.Fprintln(os.Stderr, "  i64 requestStatementId(i64 sessionId)")
  fmt.Fprintln(os.Stderr, "  TSStatus createSchemaTemplate(TSCreateSchemaTemplateReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus appendSchemaTemplate(TSAppendSchemaTemplateReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus pruneSchemaTemplate(TSPruneSchemaTemplateReq req)")
  fmt.Fprintln(os.Stderr, "  TSQueryTemplateResp querySchemaTemplate(TSQueryTemplateReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus setSchemaTemplate(TSSetSchemaTemplateReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus unsetSchemaTemplate(TSUnsetSchemaTemplateReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus dropSchemaTemplate(TSDropSchemaTemplateReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus createTimeseriesUsingSchemaTemplate(TCreateTimeseriesUsingSchemaTemplateReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus handshake(TSyncIdentityInfo info)")
  fmt.Fprintln(os.Stderr, "  TSStatus sendPipeData(string buff)")
  fmt.Fprintln(os.Stderr, "  TSStatus sendFile(TSyncTransportMetaInfo metaInfo, string buff)")
  fmt.Fprintln(os.Stderr, "  TPipeTransferResp pipeTransfer(TPipeTransferReq req)")
  fmt.Fprintln(os.Stderr, "  TPipeSubscribeResp pipeSubscribe(TPipeSubscribeReq req)")
  fmt.Fprintln(os.Stderr, "  TSBackupConfigurationResp getBackupConfiguration()")
  fmt.Fprintln(os.Stderr, "  TSConnectionInfoResp fetchAllConnectionsInfo()")
  fmt.Fprintln(os.Stderr)
  os.Exit(0)
}

type httpHeaders map[string]string

func (h httpHeaders) String() string {
  var m map[string]string = h
  return fmt.Sprintf("%s", m)
}

func (h httpHeaders) Set(value string) error {
  parts := strings.Split(value, ": ")
  if len(parts) != 2 {
    return fmt.Errorf("header should be of format 'Key: Value'")
  }
  h[parts[0]] = parts[1]
  return nil
}

func main() {
  flag.Usage = Usage
  var host string
  var port int
  var protocol string
  var urlString string
  var framed bool
  var useHttp bool
  headers := make(httpHeaders)
  var parsedUrl *url.URL
  var trans thrift.TTransport
  _ = strconv.Atoi
  _ = math.Abs
  flag.Usage = Usage
  flag.StringVar(&host, "h", "localhost", "Specify host and port")
  flag.IntVar(&port, "p", 9090, "Specify port")
  flag.StringVar(&protocol, "P", "binary", "Specify the protocol (binary, compact, simplejson, json)")
  flag.StringVar(&urlString, "u", "", "Specify the url")
  flag.BoolVar(&framed, "framed", false, "Use framed transport")
  flag.BoolVar(&useHttp, "http", false, "Use http")
  flag.Var(headers, "H", "Headers to set on the http(s) request (e.g. -H \"Key: Value\")")
  flag.Parse()
  
  if len(urlString) > 0 {
    var err error
    parsedUrl, err = url.Parse(urlString)
    if err != nil {
      fmt.Fprintln(os.Stderr, "Error parsing URL: ", err)
      flag.Usage()
    }
    host = parsedUrl.Host
    useHttp = len(parsedUrl.Scheme) <= 0 || parsedUrl.Scheme == "http" || parsedUrl.Scheme == "https"
  } else if useHttp {
    _, err := url.Parse(fmt.Sprint("http://", host, ":", port))
    if err != nil {
      fmt.Fprintln(os.Stderr, "Error parsing URL: ", err)
      flag.Usage()
    }
  }
  
  cmd := flag.Arg(0)
  var err error
  if useHttp {
    trans, err = thrift.NewTHttpClient(parsedUrl.String())
    if len(headers) > 0 {
      httptrans := trans.(*thrift.THttpClient)
      for key, value := range headers {
        httptrans.SetHeader(key, value)
      }
    }
  } else {
    portStr := fmt.Sprint(port)
    if strings.Contains(host, ":") {
           host, portStr, err = net.SplitHostPort(host)
           if err != nil {
                   fmt.Fprintln(os.Stderr, "error with host:", err)
                   os.Exit(1)
           }
    }
    trans, err = thrift.NewTSocket(net.JoinHostPort(host, portStr))
    if err != nil {
      fmt.Fprintln(os.Stderr, "error resolving address:", err)
      os.Exit(1)
    }
    if framed {
      trans = thrift.NewTFramedTransport(trans)
    }
  }
  if err != nil {
    fmt.Fprintln(os.Stderr, "Error creating transport", err)
    os.Exit(1)
  }
  defer trans.Close()
  var protocolFactory thrift.TProtocolFactory
  switch protocol {
  case "compact":
    protocolFactory = thrift.NewTCompactProtocolFactory()
    break
  case "simplejson":
    protocolFactory = thrift.NewTSimpleJSONProtocolFactory()
    break
  case "json":
    protocolFactory = thrift.NewTJSONProtocolFactory()
    break
  case "binary", "":
    protocolFactory = thrift.NewTBinaryProtocolFactoryDefault()
    break
  default:
    fmt.Fprintln(os.Stderr, "Invalid protocol specified: ", protocol)
    Usage()
    os.Exit(1)
  }
  iprot := protocolFactory.GetProtocol(trans)
  oprot := protocolFactory.GetProtocol(trans)
  client := rpc.NewIClientRPCServiceClient(thrift.NewTStandardClient(iprot, oprot))
  if err := trans.Open(); err != nil {
    fmt.Fprintln(os.Stderr, "Error opening socket to ", host, ":", port, " ", err)
    os.Exit(1)
  }
  
  switch cmd {
  case "executeQueryStatementV2":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteQueryStatementV2 requires 1 args")
      flag.Usage()
    }
    arg380 := flag.Arg(1)
    mbTrans381 := thrift.NewTMemoryBufferLen(len(arg380))
    defer mbTrans381.Close()
    _, err382 := mbTrans381.WriteString(arg380)
    if err382 != nil {
      Usage()
      return
    }
    factory383 := thrift.NewTJSONProtocolFactory()
    jsProt384 := factory383.GetProtocol(mbTrans381)
    argvalue0 := rpc.NewTSExecuteStatementReq()
    err385 := argvalue0.Read(context.Background(), jsProt384)
    if err385 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteQueryStatementV2(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeUpdateStatementV2":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteUpdateStatementV2 requires 1 args")
      flag.Usage()
    }
    arg386 := flag.Arg(1)
    mbTrans387 := thrift.NewTMemoryBufferLen(len(arg386))
    defer mbTrans387.Close()
    _, err388 := mbTrans387.WriteString(arg386)
    if err388 != nil {
      Usage()
      return
    }
    factory389 := thrift.NewTJSONProtocolFactory()
    jsProt390 := factory389.GetProtocol(mbTrans387)
    argvalue0 := rpc.NewTSExecuteStatementReq()
    err391 := argvalue0.Read(context.Background(), jsProt390)
    if err391 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteUpdateStatementV2(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeStatementV2":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteStatementV2 requires 1 args")
      flag.Usage()
    }
    arg392 := flag.Arg(1)
    mbTrans393 := thrift.NewTMemoryBufferLen(len(arg392))
    defer mbTrans393.Close()
    _, err394 := mbTrans393.WriteString(arg392)
    if err394 != nil {
      Usage()
      return
    }
    factory395 := thrift.NewTJSONProtocolFactory()
    jsProt396 := factory395.GetProtocol(mbTrans393)
    argvalue0 := rpc.NewTSExecuteStatementReq()
    err397 := argvalue0.Read(context.Background(), jsProt396)
    if err397 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteStatementV2(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeRawDataQueryV2":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteRawDataQueryV2 requires 1 args")
      flag.Usage()
    }
    arg398 := flag.Arg(1)
    mbTrans399 := thrift.NewTMemoryBufferLen(len(arg398))
    defer mbTrans399.Close()
    _, err400 := mbTrans399.WriteString(arg398)
    if err400 != nil {
      Usage()
      return
    }
    factory401 := thrift.NewTJSONProtocolFactory()
    jsProt402 := factory401.GetProtocol(mbTrans399)
    argvalue0 := rpc.NewTSRawDataQueryReq()
    err403 := argvalue0.Read(context.Background(), jsProt402)
    if err403 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteRawDataQueryV2(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeLastDataQueryV2":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteLastDataQueryV2 requires 1 args")
      flag.Usage()
    }
    arg404 := flag.Arg(1)
    mbTrans405 := thrift.NewTMemoryBufferLen(len(arg404))
    defer mbTrans405.Close()
    _, err406 := mbTrans405.WriteString(arg404)
    if err406 != nil {
      Usage()
      return
    }
    factory407 := thrift.NewTJSONProtocolFactory()
    jsProt408 := factory407.GetProtocol(mbTrans405)
    argvalue0 := rpc.NewTSLastDataQueryReq()
    err409 := argvalue0.Read(context.Background(), jsProt408)
    if err409 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteLastDataQueryV2(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeFastLastDataQueryForOneDeviceV2":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteFastLastDataQueryForOneDeviceV2 requires 1 args")
      flag.Usage()
    }
    arg410 := flag.Arg(1)
    mbTrans411 := thrift.NewTMemoryBufferLen(len(arg410))
    defer mbTrans411.Close()
    _, err412 := mbTrans411.WriteString(arg410)
    if err412 != nil {
      Usage()
      return
    }
    factory413 := thrift.NewTJSONProtocolFactory()
    jsProt414 := factory413.GetProtocol(mbTrans411)
    argvalue0 := rpc.NewTSFastLastDataQueryForOneDeviceReq()
    err415 := argvalue0.Read(context.Background(), jsProt414)
    if err415 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteFastLastDataQueryForOneDeviceV2(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeAggregationQueryV2":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteAggregationQueryV2 requires 1 args")
      flag.Usage()
    }
    arg416 := flag.Arg(1)
    mbTrans417 := thrift.NewTMemoryBufferLen(len(arg416))
    defer mbTrans417.Close()
    _, err418 := mbTrans417.WriteString(arg416)
    if err418 != nil {
      Usage()
      return
    }
    factory419 := thrift.NewTJSONProtocolFactory()
    jsProt420 := factory419.GetProtocol(mbTrans417)
    argvalue0 := rpc.NewTSAggregationQueryReq()
    err421 := argvalue0.Read(context.Background(), jsProt420)
    if err421 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteAggregationQueryV2(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeGroupByQueryIntervalQuery":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteGroupByQueryIntervalQuery requires 1 args")
      flag.Usage()
    }
    arg422 := flag.Arg(1)
    mbTrans423 := thrift.NewTMemoryBufferLen(len(arg422))
    defer mbTrans423.Close()
    _, err424 := mbTrans423.WriteString(arg422)
    if err424 != nil {
      Usage()
      return
    }
    factory425 := thrift.NewTJSONProtocolFactory()
    jsProt426 := factory425.GetProtocol(mbTrans423)
    argvalue0 := rpc.NewTSGroupByQueryIntervalReq()
    err427 := argvalue0.Read(context.Background(), jsProt426)
    if err427 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteGroupByQueryIntervalQuery(context.Background(), value0))
    fmt.Print("\n")
    break
  case "fetchResultsV2":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "FetchResultsV2 requires 1 args")
      flag.Usage()
    }
    arg428 := flag.Arg(1)
    mbTrans429 := thrift.NewTMemoryBufferLen(len(arg428))
    defer mbTrans429.Close()
    _, err430 := mbTrans429.WriteString(arg428)
    if err430 != nil {
      Usage()
      return
    }
    factory431 := thrift.NewTJSONProtocolFactory()
    jsProt432 := factory431.GetProtocol(mbTrans429)
    argvalue0 := rpc.NewTSFetchResultsReq()
    err433 := argvalue0.Read(context.Background(), jsProt432)
    if err433 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.FetchResultsV2(context.Background(), value0))
    fmt.Print("\n")
    break
  case "openSession":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "OpenSession requires 1 args")
      flag.Usage()
    }
    arg434 := flag.Arg(1)
    mbTrans435 := thrift.NewTMemoryBufferLen(len(arg434))
    defer mbTrans435.Close()
    _, err436 := mbTrans435.WriteString(arg434)
    if err436 != nil {
      Usage()
      return
    }
    factory437 := thrift.NewTJSONProtocolFactory()
    jsProt438 := factory437.GetProtocol(mbTrans435)
    argvalue0 := rpc.NewTSOpenSessionReq()
    err439 := argvalue0.Read(context.Background(), jsProt438)
    if err439 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.OpenSession(context.Background(), value0))
    fmt.Print("\n")
    break
  case "closeSession":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "CloseSession requires 1 args")
      flag.Usage()
    }
    arg440 := flag.Arg(1)
    mbTrans441 := thrift.NewTMemoryBufferLen(len(arg440))
    defer mbTrans441.Close()
    _, err442 := mbTrans441.WriteString(arg440)
    if err442 != nil {
      Usage()
      return
    }
    factory443 := thrift.NewTJSONProtocolFactory()
    jsProt444 := factory443.GetProtocol(mbTrans441)
    argvalue0 := rpc.NewTSCloseSessionReq()
    err445 := argvalue0.Read(context.Background(), jsProt444)
    if err445 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.CloseSession(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeStatement":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteStatement requires 1 args")
      flag.Usage()
    }
    arg446 := flag.Arg(1)
    mbTrans447 := thrift.NewTMemoryBufferLen(len(arg446))
    defer mbTrans447.Close()
    _, err448 := mbTrans447.WriteString(arg446)
    if err448 != nil {
      Usage()
      return
    }
    factory449 := thrift.NewTJSONProtocolFactory()
    jsProt450 := factory449.GetProtocol(mbTrans447)
    argvalue0 := rpc.NewTSExecuteStatementReq()
    err451 := argvalue0.Read(context.Background(), jsProt450)
    if err451 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteStatement(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeBatchStatement":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteBatchStatement requires 1 args")
      flag.Usage()
    }
    arg452 := flag.Arg(1)
    mbTrans453 := thrift.NewTMemoryBufferLen(len(arg452))
    defer mbTrans453.Close()
    _, err454 := mbTrans453.WriteString(arg452)
    if err454 != nil {
      Usage()
      return
    }
    factory455 := thrift.NewTJSONProtocolFactory()
    jsProt456 := factory455.GetProtocol(mbTrans453)
    argvalue0 := rpc.NewTSExecuteBatchStatementReq()
    err457 := argvalue0.Read(context.Background(), jsProt456)
    if err457 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteBatchStatement(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeQueryStatement":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteQueryStatement requires 1 args")
      flag.Usage()
    }
    arg458 := flag.Arg(1)
    mbTrans459 := thrift.NewTMemoryBufferLen(len(arg458))
    defer mbTrans459.Close()
    _, err460 := mbTrans459.WriteString(arg458)
    if err460 != nil {
      Usage()
      return
    }
    factory461 := thrift.NewTJSONProtocolFactory()
    jsProt462 := factory461.GetProtocol(mbTrans459)
    argvalue0 := rpc.NewTSExecuteStatementReq()
    err463 := argvalue0.Read(context.Background(), jsProt462)
    if err463 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteQueryStatement(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeUpdateStatement":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteUpdateStatement requires 1 args")
      flag.Usage()
    }
    arg464 := flag.Arg(1)
    mbTrans465 := thrift.NewTMemoryBufferLen(len(arg464))
    defer mbTrans465.Close()
    _, err466 := mbTrans465.WriteString(arg464)
    if err466 != nil {
      Usage()
      return
    }
    factory467 := thrift.NewTJSONProtocolFactory()
    jsProt468 := factory467.GetProtocol(mbTrans465)
    argvalue0 := rpc.NewTSExecuteStatementReq()
    err469 := argvalue0.Read(context.Background(), jsProt468)
    if err469 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteUpdateStatement(context.Background(), value0))
    fmt.Print("\n")
    break
  case "fetchResults":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "FetchResults requires 1 args")
      flag.Usage()
    }
    arg470 := flag.Arg(1)
    mbTrans471 := thrift.NewTMemoryBufferLen(len(arg470))
    defer mbTrans471.Close()
    _, err472 := mbTrans471.WriteString(arg470)
    if err472 != nil {
      Usage()
      return
    }
    factory473 := thrift.NewTJSONProtocolFactory()
    jsProt474 := factory473.GetProtocol(mbTrans471)
    argvalue0 := rpc.NewTSFetchResultsReq()
    err475 := argvalue0.Read(context.Background(), jsProt474)
    if err475 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.FetchResults(context.Background(), value0))
    fmt.Print("\n")
    break
  case "fetchMetadata":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "FetchMetadata requires 1 args")
      flag.Usage()
    }
    arg476 := flag.Arg(1)
    mbTrans477 := thrift.NewTMemoryBufferLen(len(arg476))
    defer mbTrans477.Close()
    _, err478 := mbTrans477.WriteString(arg476)
    if err478 != nil {
      Usage()
      return
    }
    factory479 := thrift.NewTJSONProtocolFactory()
    jsProt480 := factory479.GetProtocol(mbTrans477)
    argvalue0 := rpc.NewTSFetchMetadataReq()
    err481 := argvalue0.Read(context.Background(), jsProt480)
    if err481 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.FetchMetadata(context.Background(), value0))
    fmt.Print("\n")
    break
  case "cancelOperation":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "CancelOperation requires 1 args")
      flag.Usage()
    }
    arg482 := flag.Arg(1)
    mbTrans483 := thrift.NewTMemoryBufferLen(len(arg482))
    defer mbTrans483.Close()
    _, err484 := mbTrans483.WriteString(arg482)
    if err484 != nil {
      Usage()
      return
    }
    factory485 := thrift.NewTJSONProtocolFactory()
    jsProt486 := factory485.GetProtocol(mbTrans483)
    argvalue0 := rpc.NewTSCancelOperationReq()
    err487 := argvalue0.Read(context.Background(), jsProt486)
    if err487 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.CancelOperation(context.Background(), value0))
    fmt.Print("\n")
    break
  case "closeOperation":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "CloseOperation requires 1 args")
      flag.Usage()
    }
    arg488 := flag.Arg(1)
    mbTrans489 := thrift.NewTMemoryBufferLen(len(arg488))
    defer mbTrans489.Close()
    _, err490 := mbTrans489.WriteString(arg488)
    if err490 != nil {
      Usage()
      return
    }
    factory491 := thrift.NewTJSONProtocolFactory()
    jsProt492 := factory491.GetProtocol(mbTrans489)
    argvalue0 := rpc.NewTSCloseOperationReq()
    err493 := argvalue0.Read(context.Background(), jsProt492)
    if err493 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.CloseOperation(context.Background(), value0))
    fmt.Print("\n")
    break
  case "getTimeZone":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "GetTimeZone requires 1 args")
      flag.Usage()
    }
    argvalue0, err494 := (strconv.ParseInt(flag.Arg(1), 10, 64))
    if err494 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.GetTimeZone(context.Background(), value0))
    fmt.Print("\n")
    break
  case "setTimeZone":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "SetTimeZone requires 1 args")
      flag.Usage()
    }
    arg495 := flag.Arg(1)
    mbTrans496 := thrift.NewTMemoryBufferLen(len(arg495))
    defer mbTrans496.Close()
    _, err497 := mbTrans496.WriteString(arg495)
    if err497 != nil {
      Usage()
      return
    }
    factory498 := thrift.NewTJSONProtocolFactory()
    jsProt499 := factory498.GetProtocol(mbTrans496)
    argvalue0 := rpc.NewTSSetTimeZoneReq()
    err500 := argvalue0.Read(context.Background(), jsProt499)
    if err500 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.SetTimeZone(context.Background(), value0))
    fmt.Print("\n")
    break
  case "getProperties":
    if flag.NArg() - 1 != 0 {
      fmt.Fprintln(os.Stderr, "GetProperties requires 0 args")
      flag.Usage()
    }
    fmt.Print(client.GetProperties(context.Background()))
    fmt.Print("\n")
    break
  case "setStorageGroup":
    if flag.NArg() - 1 != 2 {
      fmt.Fprintln(os.Stderr, "SetStorageGroup requires 2 args")
      flag.Usage()
    }
    argvalue0, err501 := (strconv.ParseInt(flag.Arg(1), 10, 64))
    if err501 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    argvalue1 := flag.Arg(2)
    value1 := argvalue1
    fmt.Print(client.SetStorageGroup(context.Background(), value0, value1))
    fmt.Print("\n")
    break
  case "createTimeseries":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "CreateTimeseries requires 1 args")
      flag.Usage()
    }
    arg503 := flag.Arg(1)
    mbTrans504 := thrift.NewTMemoryBufferLen(len(arg503))
    defer mbTrans504.Close()
    _, err505 := mbTrans504.WriteString(arg503)
    if err505 != nil {
      Usage()
      return
    }
    factory506 := thrift.NewTJSONProtocolFactory()
    jsProt507 := factory506.GetProtocol(mbTrans504)
    argvalue0 := rpc.NewTSCreateTimeseriesReq()
    err508 := argvalue0.Read(context.Background(), jsProt507)
    if err508 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.CreateTimeseries(context.Background(), value0))
    fmt.Print("\n")
    break
  case "createAlignedTimeseries":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "CreateAlignedTimeseries requires 1 args")
      flag.Usage()
    }
    arg509 := flag.Arg(1)
    mbTrans510 := thrift.NewTMemoryBufferLen(len(arg509))
    defer mbTrans510.Close()
    _, err511 := mbTrans510.WriteString(arg509)
    if err511 != nil {
      Usage()
      return
    }
    factory512 := thrift.NewTJSONProtocolFactory()
    jsProt513 := factory512.GetProtocol(mbTrans510)
    argvalue0 := rpc.NewTSCreateAlignedTimeseriesReq()
    err514 := argvalue0.Read(context.Background(), jsProt513)
    if err514 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.CreateAlignedTimeseries(context.Background(), value0))
    fmt.Print("\n")
    break
  case "createMultiTimeseries":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "CreateMultiTimeseries requires 1 args")
      flag.Usage()
    }
    arg515 := flag.Arg(1)
    mbTrans516 := thrift.NewTMemoryBufferLen(len(arg515))
    defer mbTrans516.Close()
    _, err517 := mbTrans516.WriteString(arg515)
    if err517 != nil {
      Usage()
      return
    }
    factory518 := thrift.NewTJSONProtocolFactory()
    jsProt519 := factory518.GetProtocol(mbTrans516)
    argvalue0 := rpc.NewTSCreateMultiTimeseriesReq()
    err520 := argvalue0.Read(context.Background(), jsProt519)
    if err520 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.CreateMultiTimeseries(context.Background(), value0))
    fmt.Print("\n")
    break
  case "deleteTimeseries":
    if flag.NArg() - 1 != 2 {
      fmt.Fprintln(os.Stderr, "DeleteTimeseries requires 2 args")
      flag.Usage()
    }
    argvalue0, err521 := (strconv.ParseInt(flag.Arg(1), 10, 64))
    if err521 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    arg522 := flag.Arg(2)
    mbTrans523 := thrift.NewTMemoryBufferLen(len(arg522))
    defer mbTrans523.Close()
    _, err524 := mbTrans523.WriteString(arg522)
    if err524 != nil { 
      Usage()
      return
    }
    factory525 := thrift.NewTJSONProtocolFactory()
    jsProt526 := factory525.GetProtocol(mbTrans523)
    containerStruct1 := rpc.NewIClientRPCServiceDeleteTimeseriesArgs()
    err527 := containerStruct1.ReadField2(context.Background(), jsProt526)
    if err527 != nil {
      Usage()
      return
    }
    argvalue1 := containerStruct1.Path
    value1 := argvalue1
    fmt.Print(client.DeleteTimeseries(context.Background(), value0, value1))
    fmt.Print("\n")
    break
  case "deleteStorageGroups":
    if flag.NArg() - 1 != 2 {
      fmt.Fprintln(os.Stderr, "DeleteStorageGroups requires 2 args")
      flag.Usage()
    }
    argvalue0, err528 := (strconv.ParseInt(flag.Arg(1), 10, 64))
    if err528 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    arg529 := flag.Arg(2)
    mbTrans530 := thrift.NewTMemoryBufferLen(len(arg529))
    defer mbTrans530.Close()
    _, err531 := mbTrans530.WriteString(arg529)
    if err531 != nil { 
      Usage()
      return
    }
    factory532 := thrift.NewTJSONProtocolFactory()
    jsProt533 := factory532.GetProtocol(mbTrans530)
    containerStruct1 := rpc.NewIClientRPCServiceDeleteStorageGroupsArgs()
    err534 := containerStruct1.ReadField2(context.Background(), jsProt533)
    if err534 != nil {
      Usage()
      return
    }
    argvalue1 := containerStruct1.StorageGroup
    value1 := argvalue1
    fmt.Print(client.DeleteStorageGroups(context.Background(), value0, value1))
    fmt.Print("\n")
    break
  case "insertRecord":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "InsertRecord requires 1 args")
      flag.Usage()
    }
    arg535 := flag.Arg(1)
    mbTrans536 := thrift.NewTMemoryBufferLen(len(arg535))
    defer mbTrans536.Close()
    _, err537 := mbTrans536.WriteString(arg535)
    if err537 != nil {
      Usage()
      return
    }
    factory538 := thrift.NewTJSONProtocolFactory()
    jsProt539 := factory538.GetProtocol(mbTrans536)
    argvalue0 := rpc.NewTSInsertRecordReq()
    err540 := argvalue0.Read(context.Background(), jsProt539)
    if err540 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.InsertRecord(context.Background(), value0))
    fmt.Print("\n")
    break
  case "insertStringRecord":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "InsertStringRecord requires 1 args")
      flag.Usage()
    }
    arg541 := flag.Arg(1)
    mbTrans542 := thrift.NewTMemoryBufferLen(len(arg541))
    defer mbTrans542.Close()
    _, err543 := mbTrans542.WriteString(arg541)
    if err543 != nil {
      Usage()
      return
    }
    factory544 := thrift.NewTJSONProtocolFactory()
    jsProt545 := factory544.GetProtocol(mbTrans542)
    argvalue0 := rpc.NewTSInsertStringRecordReq()
    err546 := argvalue0.Read(context.Background(), jsProt545)
    if err546 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.InsertStringRecord(context.Background(), value0))
    fmt.Print("\n")
    break
  case "insertTablet":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "InsertTablet requires 1 args")
      flag.Usage()
    }
    arg547 := flag.Arg(1)
    mbTrans548 := thrift.NewTMemoryBufferLen(len(arg547))
    defer mbTrans548.Close()
    _, err549 := mbTrans548.WriteString(arg547)
    if err549 != nil {
      Usage()
      return
    }
    factory550 := thrift.NewTJSONProtocolFactory()
    jsProt551 := factory550.GetProtocol(mbTrans548)
    argvalue0 := rpc.NewTSInsertTabletReq()
    err552 := argvalue0.Read(context.Background(), jsProt551)
    if err552 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.InsertTablet(context.Background(), value0))
    fmt.Print("\n")
    break
  case "insertTablets":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "InsertTablets requires 1 args")
      flag.Usage()
    }
    arg553 := flag.Arg(1)
    mbTrans554 := thrift.NewTMemoryBufferLen(len(arg553))
    defer mbTrans554.Close()
    _, err555 := mbTrans554.WriteString(arg553)
    if err555 != nil {
      Usage()
      return
    }
    factory556 := thrift.NewTJSONProtocolFactory()
    jsProt557 := factory556.GetProtocol(mbTrans554)
    argvalue0 := rpc.NewTSInsertTabletsReq()
    err558 := argvalue0.Read(context.Background(), jsProt557)
    if err558 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.InsertTablets(context.Background(), value0))
    fmt.Print("\n")
    break
  case "insertRecords":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "InsertRecords requires 1 args")
      flag.Usage()
    }
    arg559 := flag.Arg(1)
    mbTrans560 := thrift.NewTMemoryBufferLen(len(arg559))
    defer mbTrans560.Close()
    _, err561 := mbTrans560.WriteString(arg559)
    if err561 != nil {
      Usage()
      return
    }
    factory562 := thrift.NewTJSONProtocolFactory()
    jsProt563 := factory562.GetProtocol(mbTrans560)
    argvalue0 := rpc.NewTSInsertRecordsReq()
    err564 := argvalue0.Read(context.Background(), jsProt563)
    if err564 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.InsertRecords(context.Background(), value0))
    fmt.Print("\n")
    break
  case "insertRecordsOfOneDevice":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "InsertRecordsOfOneDevice requires 1 args")
      flag.Usage()
    }
    arg565 := flag.Arg(1)
    mbTrans566 := thrift.NewTMemoryBufferLen(len(arg565))
    defer mbTrans566.Close()
    _, err567 := mbTrans566.WriteString(arg565)
    if err567 != nil {
      Usage()
      return
    }
    factory568 := thrift.NewTJSONProtocolFactory()
    jsProt569 := factory568.GetProtocol(mbTrans566)
    argvalue0 := rpc.NewTSInsertRecordsOfOneDeviceReq()
    err570 := argvalue0.Read(context.Background(), jsProt569)
    if err570 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.InsertRecordsOfOneDevice(context.Background(), value0))
    fmt.Print("\n")
    break
  case "insertStringRecordsOfOneDevice":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "InsertStringRecordsOfOneDevice requires 1 args")
      flag.Usage()
    }
    arg571 := flag.Arg(1)
    mbTrans572 := thrift.NewTMemoryBufferLen(len(arg571))
    defer mbTrans572.Close()
    _, err573 := mbTrans572.WriteString(arg571)
    if err573 != nil {
      Usage()
      return
    }
    factory574 := thrift.NewTJSONProtocolFactory()
    jsProt575 := factory574.GetProtocol(mbTrans572)
    argvalue0 := rpc.NewTSInsertStringRecordsOfOneDeviceReq()
    err576 := argvalue0.Read(context.Background(), jsProt575)
    if err576 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.InsertStringRecordsOfOneDevice(context.Background(), value0))
    fmt.Print("\n")
    break
  case "insertStringRecords":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "InsertStringRecords requires 1 args")
      flag.Usage()
    }
    arg577 := flag.Arg(1)
    mbTrans578 := thrift.NewTMemoryBufferLen(len(arg577))
    defer mbTrans578.Close()
    _, err579 := mbTrans578.WriteString(arg577)
    if err579 != nil {
      Usage()
      return
    }
    factory580 := thrift.NewTJSONProtocolFactory()
    jsProt581 := factory580.GetProtocol(mbTrans578)
    argvalue0 := rpc.NewTSInsertStringRecordsReq()
    err582 := argvalue0.Read(context.Background(), jsProt581)
    if err582 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.InsertStringRecords(context.Background(), value0))
    fmt.Print("\n")
    break
  case "testInsertTablet":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "TestInsertTablet requires 1 args")
      flag.Usage()
    }
    arg583 := flag.Arg(1)
    mbTrans584 := thrift.NewTMemoryBufferLen(len(arg583))
    defer mbTrans584.Close()
    _, err585 := mbTrans584.WriteString(arg583)
    if err585 != nil {
      Usage()
      return
    }
    factory586 := thrift.NewTJSONProtocolFactory()
    jsProt587 := factory586.GetProtocol(mbTrans584)
    argvalue0 := rpc.NewTSInsertTabletReq()
    err588 := argvalue0.Read(context.Background(), jsProt587)
    if err588 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.TestInsertTablet(context.Background(), value0))
    fmt.Print("\n")
    break
  case "testInsertTablets":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "TestInsertTablets requires 1 args")
      flag.Usage()
    }
    arg589 := flag.Arg(1)
    mbTrans590 := thrift.NewTMemoryBufferLen(len(arg589))
    defer mbTrans590.Close()
    _, err591 := mbTrans590.WriteString(arg589)
    if err591 != nil {
      Usage()
      return
    }
    factory592 := thrift.NewTJSONProtocolFactory()
    jsProt593 := factory592.GetProtocol(mbTrans590)
    argvalue0 := rpc.NewTSInsertTabletsReq()
    err594 := argvalue0.Read(context.Background(), jsProt593)
    if err594 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.TestInsertTablets(context.Background(), value0))
    fmt.Print("\n")
    break
  case "testInsertRecord":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "TestInsertRecord requires 1 args")
      flag.Usage()
    }
    arg595 := flag.Arg(1)
    mbTrans596 := thrift.NewTMemoryBufferLen(len(arg595))
    defer mbTrans596.Close()
    _, err597 := mbTrans596.WriteString(arg595)
    if err597 != nil {
      Usage()
      return
    }
    factory598 := thrift.NewTJSONProtocolFactory()
    jsProt599 := factory598.GetProtocol(mbTrans596)
    argvalue0 := rpc.NewTSInsertRecordReq()
    err600 := argvalue0.Read(context.Background(), jsProt599)
    if err600 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.TestInsertRecord(context.Background(), value0))
    fmt.Print("\n")
    break
  case "testInsertStringRecord":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "TestInsertStringRecord requires 1 args")
      flag.Usage()
    }
    arg601 := flag.Arg(1)
    mbTrans602 := thrift.NewTMemoryBufferLen(len(arg601))
    defer mbTrans602.Close()
    _, err603 := mbTrans602.WriteString(arg601)
    if err603 != nil {
      Usage()
      return
    }
    factory604 := thrift.NewTJSONProtocolFactory()
    jsProt605 := factory604.GetProtocol(mbTrans602)
    argvalue0 := rpc.NewTSInsertStringRecordReq()
    err606 := argvalue0.Read(context.Background(), jsProt605)
    if err606 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.TestInsertStringRecord(context.Background(), value0))
    fmt.Print("\n")
    break
  case "testInsertRecords":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "TestInsertRecords requires 1 args")
      flag.Usage()
    }
    arg607 := flag.Arg(1)
    mbTrans608 := thrift.NewTMemoryBufferLen(len(arg607))
    defer mbTrans608.Close()
    _, err609 := mbTrans608.WriteString(arg607)
    if err609 != nil {
      Usage()
      return
    }
    factory610 := thrift.NewTJSONProtocolFactory()
    jsProt611 := factory610.GetProtocol(mbTrans608)
    argvalue0 := rpc.NewTSInsertRecordsReq()
    err612 := argvalue0.Read(context.Background(), jsProt611)
    if err612 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.TestInsertRecords(context.Background(), value0))
    fmt.Print("\n")
    break
  case "testInsertRecordsOfOneDevice":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "TestInsertRecordsOfOneDevice requires 1 args")
      flag.Usage()
    }
    arg613 := flag.Arg(1)
    mbTrans614 := thrift.NewTMemoryBufferLen(len(arg613))
    defer mbTrans614.Close()
    _, err615 := mbTrans614.WriteString(arg613)
    if err615 != nil {
      Usage()
      return
    }
    factory616 := thrift.NewTJSONProtocolFactory()
    jsProt617 := factory616.GetProtocol(mbTrans614)
    argvalue0 := rpc.NewTSInsertRecordsOfOneDeviceReq()
    err618 := argvalue0.Read(context.Background(), jsProt617)
    if err618 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.TestInsertRecordsOfOneDevice(context.Background(), value0))
    fmt.Print("\n")
    break
  case "testInsertStringRecords":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "TestInsertStringRecords requires 1 args")
      flag.Usage()
    }
    arg619 := flag.Arg(1)
    mbTrans620 := thrift.NewTMemoryBufferLen(len(arg619))
    defer mbTrans620.Close()
    _, err621 := mbTrans620.WriteString(arg619)
    if err621 != nil {
      Usage()
      return
    }
    factory622 := thrift.NewTJSONProtocolFactory()
    jsProt623 := factory622.GetProtocol(mbTrans620)
    argvalue0 := rpc.NewTSInsertStringRecordsReq()
    err624 := argvalue0.Read(context.Background(), jsProt623)
    if err624 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.TestInsertStringRecords(context.Background(), value0))
    fmt.Print("\n")
    break
  case "deleteData":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "DeleteData requires 1 args")
      flag.Usage()
    }
    arg625 := flag.Arg(1)
    mbTrans626 := thrift.NewTMemoryBufferLen(len(arg625))
    defer mbTrans626.Close()
    _, err627 := mbTrans626.WriteString(arg625)
    if err627 != nil {
      Usage()
      return
    }
    factory628 := thrift.NewTJSONProtocolFactory()
    jsProt629 := factory628.GetProtocol(mbTrans626)
    argvalue0 := rpc.NewTSDeleteDataReq()
    err630 := argvalue0.Read(context.Background(), jsProt629)
    if err630 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.DeleteData(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeRawDataQuery":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteRawDataQuery requires 1 args")
      flag.Usage()
    }
    arg631 := flag.Arg(1)
    mbTrans632 := thrift.NewTMemoryBufferLen(len(arg631))
    defer mbTrans632.Close()
    _, err633 := mbTrans632.WriteString(arg631)
    if err633 != nil {
      Usage()
      return
    }
    factory634 := thrift.NewTJSONProtocolFactory()
    jsProt635 := factory634.GetProtocol(mbTrans632)
    argvalue0 := rpc.NewTSRawDataQueryReq()
    err636 := argvalue0.Read(context.Background(), jsProt635)
    if err636 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteRawDataQuery(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeLastDataQuery":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteLastDataQuery requires 1 args")
      flag.Usage()
    }
    arg637 := flag.Arg(1)
    mbTrans638 := thrift.NewTMemoryBufferLen(len(arg637))
    defer mbTrans638.Close()
    _, err639 := mbTrans638.WriteString(arg637)
    if err639 != nil {
      Usage()
      return
    }
    factory640 := thrift.NewTJSONProtocolFactory()
    jsProt641 := factory640.GetProtocol(mbTrans638)
    argvalue0 := rpc.NewTSLastDataQueryReq()
    err642 := argvalue0.Read(context.Background(), jsProt641)
    if err642 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteLastDataQuery(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeAggregationQuery":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteAggregationQuery requires 1 args")
      flag.Usage()
    }
    arg643 := flag.Arg(1)
    mbTrans644 := thrift.NewTMemoryBufferLen(len(arg643))
    defer mbTrans644.Close()
    _, err645 := mbTrans644.WriteString(arg643)
    if err645 != nil {
      Usage()
      return
    }
    factory646 := thrift.NewTJSONProtocolFactory()
    jsProt647 := factory646.GetProtocol(mbTrans644)
    argvalue0 := rpc.NewTSAggregationQueryReq()
    err648 := argvalue0.Read(context.Background(), jsProt647)
    if err648 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteAggregationQuery(context.Background(), value0))
    fmt.Print("\n")
    break
  case "requestStatementId":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "RequestStatementId requires 1 args")
      flag.Usage()
    }
    argvalue0, err649 := (strconv.ParseInt(flag.Arg(1), 10, 64))
    if err649 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.RequestStatementId(context.Background(), value0))
    fmt.Print("\n")
    break
  case "createSchemaTemplate":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "CreateSchemaTemplate requires 1 args")
      flag.Usage()
    }
    arg650 := flag.Arg(1)
    mbTrans651 := thrift.NewTMemoryBufferLen(len(arg650))
    defer mbTrans651.Close()
    _, err652 := mbTrans651.WriteString(arg650)
    if err652 != nil {
      Usage()
      return
    }
    factory653 := thrift.NewTJSONProtocolFactory()
    jsProt654 := factory653.GetProtocol(mbTrans651)
    argvalue0 := rpc.NewTSCreateSchemaTemplateReq()
    err655 := argvalue0.Read(context.Background(), jsProt654)
    if err655 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.CreateSchemaTemplate(context.Background(), value0))
    fmt.Print("\n")
    break
  case "appendSchemaTemplate":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "AppendSchemaTemplate requires 1 args")
      flag.Usage()
    }
    arg656 := flag.Arg(1)
    mbTrans657 := thrift.NewTMemoryBufferLen(len(arg656))
    defer mbTrans657.Close()
    _, err658 := mbTrans657.WriteString(arg656)
    if err658 != nil {
      Usage()
      return
    }
    factory659 := thrift.NewTJSONProtocolFactory()
    jsProt660 := factory659.GetProtocol(mbTrans657)
    argvalue0 := rpc.NewTSAppendSchemaTemplateReq()
    err661 := argvalue0.Read(context.Background(), jsProt660)
    if err661 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.AppendSchemaTemplate(context.Background(), value0))
    fmt.Print("\n")
    break
  case "pruneSchemaTemplate":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "PruneSchemaTemplate requires 1 args")
      flag.Usage()
    }
    arg662 := flag.Arg(1)
    mbTrans663 := thrift.NewTMemoryBufferLen(len(arg662))
    defer mbTrans663.Close()
    _, err664 := mbTrans663.WriteString(arg662)
    if err664 != nil {
      Usage()
      return
    }
    factory665 := thrift.NewTJSONProtocolFactory()
    jsProt666 := factory665.GetProtocol(mbTrans663)
    argvalue0 := rpc.NewTSPruneSchemaTemplateReq()
    err667 := argvalue0.Read(context.Background(), jsProt666)
    if err667 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.PruneSchemaTemplate(context.Background(), value0))
    fmt.Print("\n")
    break
  case "querySchemaTemplate":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "QuerySchemaTemplate requires 1 args")
      flag.Usage()
    }
    arg668 := flag.Arg(1)
    mbTrans669 := thrift.NewTMemoryBufferLen(len(arg668))
    defer mbTrans669.Close()
    _, err670 := mbTrans669.WriteString(arg668)
    if err670 != nil {
      Usage()
      return
    }
    factory671 := thrift.NewTJSONProtocolFactory()
    jsProt672 := factory671.GetProtocol(mbTrans669)
    argvalue0 := rpc.NewTSQueryTemplateReq()
    err673 := argvalue0.Read(context.Background(), jsProt672)
    if err673 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.QuerySchemaTemplate(context.Background(), value0))
    fmt.Print("\n")
    break
  case "setSchemaTemplate":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "SetSchemaTemplate requires 1 args")
      flag.Usage()
    }
    arg674 := flag.Arg(1)
    mbTrans675 := thrift.NewTMemoryBufferLen(len(arg674))
    defer mbTrans675.Close()
    _, err676 := mbTrans675.WriteString(arg674)
    if err676 != nil {
      Usage()
      return
    }
    factory677 := thrift.NewTJSONProtocolFactory()
    jsProt678 := factory677.GetProtocol(mbTrans675)
    argvalue0 := rpc.NewTSSetSchemaTemplateReq()
    err679 := argvalue0.Read(context.Background(), jsProt678)
    if err679 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.SetSchemaTemplate(context.Background(), value0))
    fmt.Print("\n")
    break
  case "unsetSchemaTemplate":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "UnsetSchemaTemplate requires 1 args")
      flag.Usage()
    }
    arg680 := flag.Arg(1)
    mbTrans681 := thrift.NewTMemoryBufferLen(len(arg680))
    defer mbTrans681.Close()
    _, err682 := mbTrans681.WriteString(arg680)
    if err682 != nil {
      Usage()
      return
    }
    factory683 := thrift.NewTJSONProtocolFactory()
    jsProt684 := factory683.GetProtocol(mbTrans681)
    argvalue0 := rpc.NewTSUnsetSchemaTemplateReq()
    err685 := argvalue0.Read(context.Background(), jsProt684)
    if err685 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.UnsetSchemaTemplate(context.Background(), value0))
    fmt.Print("\n")
    break
  case "dropSchemaTemplate":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "DropSchemaTemplate requires 1 args")
      flag.Usage()
    }
    arg686 := flag.Arg(1)
    mbTrans687 := thrift.NewTMemoryBufferLen(len(arg686))
    defer mbTrans687.Close()
    _, err688 := mbTrans687.WriteString(arg686)
    if err688 != nil {
      Usage()
      return
    }
    factory689 := thrift.NewTJSONProtocolFactory()
    jsProt690 := factory689.GetProtocol(mbTrans687)
    argvalue0 := rpc.NewTSDropSchemaTemplateReq()
    err691 := argvalue0.Read(context.Background(), jsProt690)
    if err691 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.DropSchemaTemplate(context.Background(), value0))
    fmt.Print("\n")
    break
  case "createTimeseriesUsingSchemaTemplate":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "CreateTimeseriesUsingSchemaTemplate requires 1 args")
      flag.Usage()
    }
    arg692 := flag.Arg(1)
    mbTrans693 := thrift.NewTMemoryBufferLen(len(arg692))
    defer mbTrans693.Close()
    _, err694 := mbTrans693.WriteString(arg692)
    if err694 != nil {
      Usage()
      return
    }
    factory695 := thrift.NewTJSONProtocolFactory()
    jsProt696 := factory695.GetProtocol(mbTrans693)
    argvalue0 := rpc.NewTCreateTimeseriesUsingSchemaTemplateReq()
    err697 := argvalue0.Read(context.Background(), jsProt696)
    if err697 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.CreateTimeseriesUsingSchemaTemplate(context.Background(), value0))
    fmt.Print("\n")
    break
  case "handshake":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "Handshake requires 1 args")
      flag.Usage()
    }
    arg698 := flag.Arg(1)
    mbTrans699 := thrift.NewTMemoryBufferLen(len(arg698))
    defer mbTrans699.Close()
    _, err700 := mbTrans699.WriteString(arg698)
    if err700 != nil {
      Usage()
      return
    }
    factory701 := thrift.NewTJSONProtocolFactory()
    jsProt702 := factory701.GetProtocol(mbTrans699)
    argvalue0 := rpc.NewTSyncIdentityInfo()
    err703 := argvalue0.Read(context.Background(), jsProt702)
    if err703 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.Handshake(context.Background(), value0))
    fmt.Print("\n")
    break
  case "sendPipeData":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "SendPipeData requires 1 args")
      flag.Usage()
    }
    argvalue0 := []byte(flag.Arg(1))
    value0 := argvalue0
    fmt.Print(client.SendPipeData(context.Background(), value0))
    fmt.Print("\n")
    break
  case "sendFile":
    if flag.NArg() - 1 != 2 {
      fmt.Fprintln(os.Stderr, "SendFile requires 2 args")
      flag.Usage()
    }
    arg705 := flag.Arg(1)
    mbTrans706 := thrift.NewTMemoryBufferLen(len(arg705))
    defer mbTrans706.Close()
    _, err707 := mbTrans706.WriteString(arg705)
    if err707 != nil {
      Usage()
      return
    }
    factory708 := thrift.NewTJSONProtocolFactory()
    jsProt709 := factory708.GetProtocol(mbTrans706)
    argvalue0 := rpc.NewTSyncTransportMetaInfo()
    err710 := argvalue0.Read(context.Background(), jsProt709)
    if err710 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    argvalue1 := []byte(flag.Arg(2))
    value1 := argvalue1
    fmt.Print(client.SendFile(context.Background(), value0, value1))
    fmt.Print("\n")
    break
  case "pipeTransfer":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "PipeTransfer requires 1 args")
      flag.Usage()
    }
    arg712 := flag.Arg(1)
    mbTrans713 := thrift.NewTMemoryBufferLen(len(arg712))
    defer mbTrans713.Close()
    _, err714 := mbTrans713.WriteString(arg712)
    if err714 != nil {
      Usage()
      return
    }
    factory715 := thrift.NewTJSONProtocolFactory()
    jsProt716 := factory715.GetProtocol(mbTrans713)
    argvalue0 := rpc.NewTPipeTransferReq()
    err717 := argvalue0.Read(context.Background(), jsProt716)
    if err717 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.PipeTransfer(context.Background(), value0))
    fmt.Print("\n")
    break
  case "pipeSubscribe":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "PipeSubscribe requires 1 args")
      flag.Usage()
    }
    arg718 := flag.Arg(1)
    mbTrans719 := thrift.NewTMemoryBufferLen(len(arg718))
    defer mbTrans719.Close()
    _, err720 := mbTrans719.WriteString(arg718)
    if err720 != nil {
      Usage()
      return
    }
    factory721 := thrift.NewTJSONProtocolFactory()
    jsProt722 := factory721.GetProtocol(mbTrans719)
    argvalue0 := rpc.NewTPipeSubscribeReq()
    err723 := argvalue0.Read(context.Background(), jsProt722)
    if err723 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.PipeSubscribe(context.Background(), value0))
    fmt.Print("\n")
    break
  case "getBackupConfiguration":
    if flag.NArg() - 1 != 0 {
      fmt.Fprintln(os.Stderr, "GetBackupConfiguration requires 0 args")
      flag.Usage()
    }
    fmt.Print(client.GetBackupConfiguration(context.Background()))
    fmt.Print("\n")
    break
  case "fetchAllConnectionsInfo":
    if flag.NArg() - 1 != 0 {
      fmt.Fprintln(os.Stderr, "FetchAllConnectionsInfo requires 0 args")
      flag.Usage()
    }
    fmt.Print(client.FetchAllConnectionsInfo(context.Background()))
    fmt.Print("\n")
    break
  case "":
    Usage()
    break
  default:
    fmt.Fprintln(os.Stderr, "Invalid function ", cmd)
  }
}
