/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.client.methods;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.protocol.AbstractAsyncResponseConsumer;
import org.apache.http.util.Asserts;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AsyncByteConsumer<T>
extends AbstractAsyncResponseConsumer<T> {
    private final int bufSize;
    private ByteBuffer bbuf;

    public AsyncByteConsumer(int bufSize) {
        this.bufSize = bufSize;
    }

    public AsyncByteConsumer() {
        this(8192);
    }

    protected abstract void onByteReceived(ByteBuffer var1, IOControl var2) throws IOException;

    protected final void onEntityEnclosed(HttpEntity entity, ContentType contentType) {
        this.bbuf = ByteBuffer.allocate(this.bufSize);
    }

    protected final void onContentReceived(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        Asserts.notNull((Object)this.bbuf, (String)"Byte buffer");
        int bytesRead = decoder.read(this.bbuf);
        if (bytesRead > 0) {
            this.bbuf.flip();
            this.onByteReceived(this.bbuf, ioctrl);
            this.bbuf.clear();
        }
    }

    protected void releaseResources() {
        this.bbuf = null;
    }
}

