/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.objectinspector;

import org.apache.hadoop.hive.serde2.objectinspector.DelegatedListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.DelegatedMapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.DelegatedStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.DelegatedUnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;

public class DelegatedObjectInspectorFactory {
    public static ObjectInspector wrap(ObjectInspector inspector) {
        switch (inspector.getCategory()) {
            case PRIMITIVE: {
                return inspector;
            }
            case LIST: {
                return new DelegatedListObjectInspector((ListObjectInspector)inspector);
            }
            case MAP: {
                return new DelegatedMapObjectInspector((MapObjectInspector)inspector);
            }
            case STRUCT: {
                return new DelegatedStructObjectInspector((StructObjectInspector)inspector);
            }
            case UNION: {
                return new DelegatedUnionObjectInspector((UnionObjectInspector)inspector);
            }
        }
        throw new RuntimeException("invalid category " + (Object)((Object)inspector.getCategory()));
    }

    public static ObjectInspector reset(ObjectInspector prev, ObjectInspector current) {
        switch (current.getCategory()) {
            case PRIMITIVE: {
                break;
            }
            case LIST: {
                ((DelegatedListObjectInspector)prev).reset((ListObjectInspector)current);
                break;
            }
            case MAP: {
                ((DelegatedMapObjectInspector)prev).reset((MapObjectInspector)current);
                break;
            }
            case STRUCT: {
                ((DelegatedStructObjectInspector)prev).reset((StructObjectInspector)current);
                break;
            }
            case UNION: {
                ((DelegatedUnionObjectInspector)prev).reset((UnionObjectInspector)current);
                break;
            }
            default: {
                throw new RuntimeException("invalid category " + (Object)((Object)current.getCategory()));
            }
        }
        return prev;
    }
}

