/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.exec.WindowFunctionDescription;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.IntWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WindowFunctionDescription(description=@Description(name="rank", value="_FUNC_(x) NTILE allows easy calculation of tertiles, quartiles, deciles and other common summary statistics. This function divides an ordered partition into a specified number of groups called buckets and assigns a bucket number to each row in the partition."), supportsWindow=false, pivotResult=true)
public class GenericUDAFNTile
extends AbstractGenericUDAFResolver {
    static final Logger LOG = LoggerFactory.getLogger((String)GenericUDAFNTile.class.getName());

    @Override
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        if (parameters.length != 1) {
            throw new UDFArgumentTypeException(parameters.length - 1, "Exactly one argument is expected.");
        }
        ObjectInspector oi = TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo(parameters[0]);
        boolean c = ObjectInspectorUtils.compareTypes(oi, PrimitiveObjectInspectorFactory.writableIntObjectInspector);
        if (!c) {
            throw new UDFArgumentTypeException(0, "Number of tiles must be an int expression");
        }
        return new GenericUDAFNTileEvaluator();
    }

    public static class GenericUDAFNTileEvaluator
    extends GenericUDAFEvaluator {
        private transient PrimitiveObjectInspector inputOI;

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            assert (parameters.length == 1);
            super.init(m, parameters);
            if (m != GenericUDAFEvaluator.Mode.COMPLETE) {
                throw new HiveException("Only COMPLETE mode supported for NTile function");
            }
            this.inputOI = (PrimitiveObjectInspector)parameters[0];
            return ObjectInspectorFactory.getStandardListObjectInspector(PrimitiveObjectInspectorFactory.writableIntObjectInspector);
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            return new NTileBuffer();
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            ((NTileBuffer)agg).init();
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            NTileBuffer rb = (NTileBuffer)agg;
            if (rb.numBuckets == null) {
                rb.numBuckets = PrimitiveObjectInspectorUtils.getInt(parameters[0], this.inputOI);
            }
            ++rb.numRows;
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            throw new HiveException("terminatePartial not supported");
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            throw new HiveException("merge not supported");
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            NTileBuffer rb = (NTileBuffer)agg;
            ArrayList<IntWritable> res = new ArrayList<IntWritable>(rb.numRows);
            int bucketsz = rb.numRows / rb.numBuckets;
            int rem = rb.numRows % rb.numBuckets;
            int start = 0;
            int bucket = 1;
            while (start < rb.numRows) {
                int end = start + bucketsz;
                if (rem > 0) {
                    ++end;
                    --rem;
                }
                end = Math.min(rb.numRows, end);
                for (int i = start; i < end; ++i) {
                    res.add(new IntWritable(bucket));
                }
                start = end;
                ++bucket;
            }
            return res;
        }
    }

    static class NTileBuffer
    implements GenericUDAFEvaluator.AggregationBuffer {
        Integer numBuckets;
        int numRows;

        void init() {
            this.numBuckets = null;
            this.numRows = 0;
        }

        NTileBuffer() {
            this.init();
        }
    }
}

