/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NullUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.util.DateTimeMath;

public class IntervalDayTimeColSubtractIntervalDayTimeColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final int colNum1;
    private final int colNum2;
    private final transient DateTimeMath dtm = new DateTimeMath();

    public IntervalDayTimeColSubtractIntervalDayTimeColumn(int colNum1, int colNum2, int outputColumnNum) {
        super(outputColumnNum);
        this.colNum1 = colNum1;
        this.colNum2 = colNum2;
    }

    public IntervalDayTimeColSubtractIntervalDayTimeColumn() {
        this.colNum1 = -1;
        this.colNum2 = -1;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        IntervalDayTimeColumnVector inputColVector1 = (IntervalDayTimeColumnVector)batch.cols[this.colNum1];
        IntervalDayTimeColumnVector inputColVector2 = (IntervalDayTimeColumnVector)batch.cols[this.colNum2];
        IntervalDayTimeColumnVector outputColVector = (IntervalDayTimeColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        NullUtil.propagateNullsColCol(inputColVector1, inputColVector2, outputColVector, sel, n, batch.selectedInUse);
        if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
            this.dtm.subtract(inputColVector1.asScratchIntervalDayTime(0), inputColVector2.asScratchIntervalDayTime(0), outputColVector.getScratchIntervalDayTime());
            outputColVector.setFromScratchIntervalDayTime(0);
        } else if (inputColVector1.isRepeating) {
            HiveIntervalDayTime value1 = inputColVector1.asScratchIntervalDayTime(0);
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    this.dtm.subtract(value1, inputColVector2.asScratchIntervalDayTime(i), outputColVector.getScratchIntervalDayTime());
                    outputColVector.setFromScratchIntervalDayTime(i);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    this.dtm.subtract(value1, inputColVector2.asScratchIntervalDayTime(i), outputColVector.getScratchIntervalDayTime());
                    outputColVector.setFromScratchIntervalDayTime(i);
                }
            }
        } else if (inputColVector2.isRepeating) {
            HiveIntervalDayTime value2 = inputColVector2.asScratchIntervalDayTime(0);
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    this.dtm.subtract(inputColVector1.asScratchIntervalDayTime(i), value2, outputColVector.getScratchIntervalDayTime());
                    outputColVector.setFromScratchIntervalDayTime(i);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    this.dtm.subtract(inputColVector1.asScratchIntervalDayTime(i), value2, outputColVector.getScratchIntervalDayTime());
                    outputColVector.setFromScratchIntervalDayTime(i);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                this.dtm.subtract(inputColVector1.asScratchIntervalDayTime(i), inputColVector2.asScratchIntervalDayTime(i), outputColVector.getScratchIntervalDayTime());
                outputColVector.setFromScratchIntervalDayTime(i);
            }
        } else {
            for (int i = 0; i != n; ++i) {
                this.dtm.subtract(inputColVector1.asScratchIntervalDayTime(i), inputColVector2.asScratchIntervalDayTime(i), outputColVector.getScratchIntervalDayTime());
                outputColVector.setFromScratchIntervalDayTime(i);
            }
        }
        NullUtil.setNullDataEntriesIntervalDayTime(outputColVector, batch.selectedInUse, sel, n);
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.colNum1) + ", " + this.getColumnParamString(1, this.colNum2);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("interval_day_time"), VectorExpressionDescriptor.ArgumentType.getType("interval_day_time")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

