/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFMapIndexBase;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public abstract class VectorUDFMapIndexBaseCol
extends VectorUDFMapIndexBase {
    private static final long serialVersionUID = 1L;
    private int mapColumnNum;
    private int indexColumnNum;
    private ColumnVector indexColumnVector;

    public VectorUDFMapIndexBaseCol() {
    }

    public VectorUDFMapIndexBaseCol(int mapColumnNum, int indexColumnNum, int outputColumnNum) {
        super(outputColumnNum);
        this.mapColumnNum = mapColumnNum;
        this.indexColumnNum = indexColumnNum;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        ColumnVector outV = batch.cols[this.outputColumnNum];
        MapColumnVector mapV = (MapColumnVector)batch.cols[this.mapColumnNum];
        this.indexColumnVector = batch.cols[this.indexColumnNum];
        if (mapV.isRepeating) {
            if (mapV.isNull[0]) {
                outV.isNull[0] = true;
                outV.noNulls = false;
                outV.isRepeating = true;
            } else {
                int[] mapValueIndex = this.getMapValueIndex(mapV, batch);
                if (this.indexColumnVector.isRepeating) {
                    if (mapValueIndex[0] == -1) {
                        outV.isNull[0] = true;
                        outV.noNulls = false;
                    } else {
                        outV.isNull[0] = false;
                        outV.setElement(0, (int)(mapV.offsets[0] + (long)mapValueIndex[0]), mapV.values);
                    }
                    outV.isRepeating = true;
                } else {
                    this.setUnRepeatingOutVector(batch, mapV, outV, mapValueIndex);
                }
            }
        } else {
            int[] mapValueIndex = this.getMapValueIndex(mapV, batch);
            this.setUnRepeatingOutVector(batch, mapV, outV, mapValueIndex);
        }
    }

    private void setUnRepeatingOutVector(VectorizedRowBatch batch, MapColumnVector mapV, ColumnVector outV, int[] mapValueIndex) {
        for (int i = 0; i < batch.size; ++i) {
            int j;
            int n = j = batch.selectedInUse ? batch.selected[i] : i;
            if (mapV.isNull[j] || mapValueIndex[j] == -1) {
                outV.isNull[j] = true;
                outV.noNulls = false;
                continue;
            }
            outV.isNull[j] = false;
            outV.setElement(j, (int)(mapV.offsets[j] + (long)mapValueIndex[j]), mapV.values);
        }
        outV.isRepeating = false;
    }

    @Override
    protected Object getCurrentKey(int index) {
        return this.getKeyByIndex(this.indexColumnVector, index);
    }

    public int getMapColumnNum() {
        return this.mapColumnNum;
    }

    public int getIndexColumnNum() {
        return this.indexColumnNum;
    }
}

