/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FuncDecimalToLong;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

public class CastDecimalToLong
extends FuncDecimalToLong {
    private static final long serialVersionUID = 1L;

    public CastDecimalToLong() {
    }

    public CastDecimalToLong(int inputColumn, int outputColumnNum) {
        super(inputColumn, outputColumnNum);
    }

    @Override
    protected void func(LongColumnVector outV, DecimalColumnVector inV, int i) {
        boolean isInRange;
        HiveDecimalWritable decWritable = inV.vector[i];
        switch (this.integerPrimitiveCategory) {
            case BYTE: {
                isInRange = decWritable.isByte();
                break;
            }
            case SHORT: {
                isInRange = decWritable.isShort();
                break;
            }
            case INT: {
                isInRange = decWritable.isInt();
                break;
            }
            case LONG: {
                isInRange = decWritable.isLong();
                break;
            }
            default: {
                throw new RuntimeException("Unexpected integer primitive category " + (Object)((Object)this.integerPrimitiveCategory));
            }
        }
        if (!isInRange) {
            outV.isNull[i] = true;
            outV.noNulls = false;
            return;
        }
        outV.isNull[i] = false;
        switch (this.integerPrimitiveCategory) {
            case BYTE: {
                outV.vector[i] = decWritable.byteValue();
                break;
            }
            case SHORT: {
                outV.vector[i] = decWritable.shortValue();
                break;
            }
            case INT: {
                outV.vector[i] = decWritable.intValue();
                break;
            }
            case LONG: {
                outV.vector[i] = decWritable.longValue();
                break;
            }
            default: {
                throw new RuntimeException("Unexpected integer primitive category " + (Object)((Object)this.integerPrimitiveCategory));
            }
        }
    }
}

