/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.messaging.json;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.messaging.AddPrimaryKeyMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageDeserializer;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageFactory;
import org.apache.thrift.TException;
import org.codehaus.jackson.annotate.JsonProperty;

public class JSONAddPrimaryKeyMessage
extends AddPrimaryKeyMessage {
    @JsonProperty
    String server;
    @JsonProperty
    String servicePrincipal;
    @JsonProperty
    Long timestamp;
    @JsonProperty
    List<String> primaryKeyListJson;

    public JSONAddPrimaryKeyMessage() {
    }

    public JSONAddPrimaryKeyMessage(String server, String servicePrincipal, List<SQLPrimaryKey> pks, Long timestamp) {
        this.server = server;
        this.servicePrincipal = servicePrincipal;
        this.timestamp = timestamp;
        this.primaryKeyListJson = new ArrayList<String>();
        try {
            for (SQLPrimaryKey pk : pks) {
                this.primaryKeyListJson.add(JSONMessageFactory.createPrimaryKeyObjJson(pk));
            }
        }
        catch (TException e) {
            throw new IllegalArgumentException("Could not serialize: ", e);
        }
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public String getServicePrincipal() {
        return this.servicePrincipal;
    }

    @Override
    public String getDB() {
        return null;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public List<SQLPrimaryKey> getPrimaryKeys() throws Exception {
        ArrayList<SQLPrimaryKey> pks = new ArrayList<SQLPrimaryKey>();
        for (String pkJson : this.primaryKeyListJson) {
            pks.add((SQLPrimaryKey)JSONMessageFactory.getTObj(pkJson, SQLPrimaryKey.class));
        }
        return pks;
    }

    public String toString() {
        try {
            return JSONMessageDeserializer.mapper.writeValueAsString(this);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Could not serialize: ", exception);
        }
    }
}

