/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.optiq.translator;

import com.google.common.collect.Iterables;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.hydromatic.optiq.util.BitSets;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.optimizer.optiq.OptiqSemanticException;
import org.apache.hadoop.hive.ql.optimizer.optiq.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.optiq.reloperators.HiveSortRel;
import org.apache.hadoop.hive.ql.optimizer.optiq.translator.ASTBuilder;
import org.apache.hadoop.hive.ql.optimizer.optiq.translator.PlanModifierForASTConv;
import org.apache.hadoop.hive.ql.optimizer.optiq.translator.SqlFunctionConverter;
import org.apache.hadoop.hive.ql.optimizer.optiq.translator.TypeConverter;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.eigenbase.rel.AggregateCall;
import org.eigenbase.rel.AggregateRelBase;
import org.eigenbase.rel.FilterRelBase;
import org.eigenbase.rel.JoinRelBase;
import org.eigenbase.rel.ProjectRelBase;
import org.eigenbase.rel.RelFieldCollation;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelVisitor;
import org.eigenbase.rel.SortRel;
import org.eigenbase.rel.TableAccessRelBase;
import org.eigenbase.rel.UnionRelBase;
import org.eigenbase.rel.rules.SemiJoinRel;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexFieldAccess;
import org.eigenbase.rex.RexFieldCollation;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexOver;
import org.eigenbase.rex.RexVisitorImpl;
import org.eigenbase.rex.RexWindow;
import org.eigenbase.rex.RexWindowBound;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.type.SqlTypeName;

public class ASTConverter {
    private static final Log LOG = LogFactory.getLog(ASTConverter.class);
    private RelNode root;
    private HiveAST hiveAST;
    private RelNode from;
    private FilterRelBase where;
    private AggregateRelBase groupBy;
    private FilterRelBase having;
    private ProjectRelBase select;
    private SortRel order;
    private SortRel limit;
    private Schema schema;
    private long derivedTableCount;

    ASTConverter(RelNode root, long dtCounterInitVal) {
        this.root = root;
        this.hiveAST = new HiveAST();
        this.derivedTableCount = dtCounterInitVal;
    }

    public static ASTNode convert(RelNode relNode, List<FieldSchema> resultSchema) throws OptiqSemanticException {
        RelNode root = PlanModifierForASTConv.convertOpTree(relNode, resultSchema);
        ASTConverter c = new ASTConverter(root, 0L);
        return c.convert();
    }

    private ASTNode convert() {
        ASTBuilder b;
        ASTNode cond;
        new QBVisitor().go(this.root);
        QueryBlockInfo qb = this.convertSource(this.from);
        this.schema = qb.schema;
        this.hiveAST.from = ASTBuilder.construct(677, "TOK_FROM").add(qb.ast).node();
        if (this.where != null) {
            cond = (ASTNode)this.where.getCondition().accept((org.eigenbase.rex.RexVisitor)new RexVisitor(this.schema));
            this.hiveAST.where = ASTBuilder.where(cond);
        }
        if (this.groupBy != null) {
            b = ASTBuilder.construct(688, "TOK_GROUPBY");
            Iterator i$ = BitSets.toIter((BitSet)this.groupBy.getGroupSet()).iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                RexInputRef iRef = new RexInputRef(i, this.groupBy.getCluster().getTypeFactory().createSqlType(SqlTypeName.ANY));
                b.add((ASTNode)iRef.accept((org.eigenbase.rex.RexVisitor)new RexVisitor(this.schema)));
            }
            if (!this.groupBy.getGroupSet().isEmpty()) {
                this.hiveAST.groupBy = b.node();
            }
            this.schema = new Schema(this.schema, this.groupBy);
        }
        if (this.having != null) {
            cond = (ASTNode)this.having.getCondition().accept((org.eigenbase.rex.RexVisitor)new RexVisitor(this.schema));
            this.hiveAST.having = ASTBuilder.having(cond);
        }
        b = ASTBuilder.construct(787, "TOK_SELECT");
        if (this.select.getChildExps().isEmpty()) {
            RexLiteral r = this.select.getCluster().getRexBuilder().makeExactLiteral(new BigDecimal(1));
            ASTNode selectExpr = ASTBuilder.selectExpr(ASTBuilder.literal(r), "1");
            b.add(selectExpr);
        } else {
            int i = 0;
            for (RexNode r : this.select.getChildExps()) {
                ASTNode selectExpr = ASTBuilder.selectExpr((ASTNode)r.accept((org.eigenbase.rex.RexVisitor)new RexVisitor(this.schema, r instanceof RexLiteral)), (String)this.select.getRowType().getFieldNames().get(i++));
                b.add(selectExpr);
            }
        }
        this.hiveAST.select = b.node();
        this.convertOBToASTNode((HiveSortRel)this.order);
        this.convertLimitToASTNode((HiveSortRel)this.limit);
        return this.hiveAST.getAST();
    }

    private void convertLimitToASTNode(HiveSortRel limit) {
        HiveSortRel hiveLimit;
        RexNode limitExpr;
        if (limit != null && (limitExpr = (hiveLimit = limit).getFetchExpr()) != null) {
            Object val = ((RexLiteral)limitExpr).getValue2();
            this.hiveAST.limit = ASTBuilder.limit(val);
        }
    }

    private void convertOBToASTNode(HiveSortRel order) {
        HiveSortRel hiveSort;
        if (order != null && !(hiveSort = order).getCollation().getFieldCollations().isEmpty()) {
            ASTNode orderAst = ASTBuilder.createAST(749, "TOK_ORDERBY");
            this.schema = new Schema(hiveSort);
            Map<Integer, RexNode> obRefToCallMap = hiveSort.getInputRefToCallMap();
            for (RelFieldCollation c : hiveSort.getCollation().getFieldCollations()) {
                ASTNode astCol;
                ASTNode directionAST = c.getDirection() == RelFieldCollation.Direction.ASCENDING ? ASTBuilder.createAST(860, "TOK_TABSORTCOLNAMEASC") : ASTBuilder.createAST(861, "TOK_TABSORTCOLNAMEDESC");
                RexNode obExpr = null;
                if (obRefToCallMap != null) {
                    obExpr = obRefToCallMap.get(c.getFieldIndex());
                }
                if (obExpr != null) {
                    astCol = (ASTNode)obExpr.accept((org.eigenbase.rex.RexVisitor)new RexVisitor(this.schema));
                } else {
                    ColumnInfo cI = (ColumnInfo)this.schema.get(c.getFieldIndex());
                    astCol = ASTBuilder.unqualifiedName(cI.column);
                }
                directionAST.addChild((Tree)astCol);
                orderAst.addChild((Tree)directionAST);
            }
            this.hiveAST.order = orderAst;
        }
    }

    private Schema getRowSchema(String tblAlias) {
        return new Schema(this.select, tblAlias);
    }

    private QueryBlockInfo convertSource(RelNode r) {
        ASTNode ast;
        Schema s;
        if (r instanceof TableAccessRelBase) {
            TableAccessRelBase f = (TableAccessRelBase)r;
            s = new Schema(f);
            ast = ASTBuilder.table(f);
        } else if (r instanceof JoinRelBase) {
            JoinRelBase join = (JoinRelBase)r;
            QueryBlockInfo left = this.convertSource(join.getLeft());
            QueryBlockInfo right = this.convertSource(join.getRight());
            s = new Schema(left.schema, right.schema);
            ASTNode cond = (ASTNode)join.getCondition().accept((org.eigenbase.rex.RexVisitor)new RexVisitor(s));
            boolean semiJoin = join instanceof SemiJoinRel;
            ast = ASTBuilder.join(left.ast, right.ast, join.getJoinType(), cond, semiJoin);
            if (semiJoin) {
                s = left.schema;
            }
        } else if (r instanceof UnionRelBase) {
            RelNode leftInput = ((UnionRelBase)r).getInput(0);
            RelNode rightInput = ((UnionRelBase)r).getInput(1);
            ASTConverter leftConv = new ASTConverter(leftInput, this.derivedTableCount);
            ASTConverter rightConv = new ASTConverter(rightInput, this.derivedTableCount);
            ASTNode leftAST = leftConv.convert();
            ASTNode rightAST = rightConv.convert();
            ASTNode unionAST = this.getUnionAllAST(leftAST, rightAST);
            String sqAlias = this.nextAlias();
            ast = ASTBuilder.subQuery(unionAST, sqAlias);
            s = new Schema((UnionRelBase)r, sqAlias);
        } else {
            ASTConverter src = new ASTConverter(r, this.derivedTableCount);
            ASTNode srcAST = src.convert();
            String sqAlias = this.nextAlias();
            s = src.getRowSchema(sqAlias);
            ast = ASTBuilder.subQuery(srcAST, sqAlias);
        }
        return new QueryBlockInfo(s, ast);
    }

    private String nextAlias() {
        String tabAlias = String.format("$hdt$_%d", this.derivedTableCount);
        ++this.derivedTableCount;
        return tabAlias;
    }

    public ASTNode getUnionAllAST(ASTNode leftAST, ASTNode rightAST) {
        ASTNode unionTokAST = ASTBuilder.construct(871, "TOK_UNION").add(leftAST).add(rightAST).node();
        return unionTokAST;
    }

    public static boolean isFlat(RexCall call) {
        SqlOperator op;
        boolean flat = false;
        if (call.operands != null && call.operands.size() > 2 && ((op = call.getOperator()).getKind() == SqlKind.AND || op.getKind() == SqlKind.OR)) {
            flat = true;
        }
        return flat;
    }

    static class HiveAST {
        ASTNode from;
        ASTNode where;
        ASTNode groupBy;
        ASTNode having;
        ASTNode select;
        ASTNode order;
        ASTNode limit;

        HiveAST() {
        }

        public ASTNode getAST() {
            ASTBuilder b = ASTBuilder.construct(773, "TOK_QUERY").add(this.from).add(ASTBuilder.construct(703, "TOK_INSERT").add(ASTBuilder.destNode()).add(this.select).add(this.where).add(this.groupBy).add(this.having).add(this.order).add(this.limit));
            return b.node();
        }
    }

    static class ColumnInfo {
        String table;
        String column;
        ASTNode agg;

        ColumnInfo(String table, String column) {
            this.table = table;
            this.column = column;
        }

        ColumnInfo(String table, ASTNode agg) {
            this.table = table;
            this.agg = agg;
        }

        ColumnInfo(String alias, ColumnInfo srcCol) {
            this.table = alias;
            this.column = srcCol.column;
            this.agg = srcCol.agg;
        }
    }

    static class Schema
    extends ArrayList<ColumnInfo> {
        private static final long serialVersionUID = 1L;

        Schema(TableAccessRelBase scan) {
            String tabName = ((RelOptHiveTable)scan.getTable()).getTableAlias();
            for (RelDataTypeField field : scan.getRowType().getFieldList()) {
                this.add(new ColumnInfo(tabName, field.getName()));
            }
        }

        Schema(ProjectRelBase select, String alias) {
            for (RelDataTypeField field : select.getRowType().getFieldList()) {
                this.add(new ColumnInfo(alias, field.getName()));
            }
        }

        Schema(UnionRelBase unionRel, String alias) {
            for (RelDataTypeField field : unionRel.getRowType().getFieldList()) {
                this.add(new ColumnInfo(alias, field.getName()));
            }
        }

        Schema(Schema left, Schema right) {
            for (ColumnInfo cI : Iterables.concat(left, right)) {
                this.add(cI);
            }
        }

        Schema(Schema src, AggregateRelBase gBy) {
            Iterator i$ = BitSets.toIter((BitSet)gBy.getGroupSet()).iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                ColumnInfo cI = (ColumnInfo)src.get(i);
                this.add(cI);
            }
            List aggs = gBy.getAggCallList();
            for (AggregateCall agg : aggs) {
                int argCount = agg.getArgList().size();
                ASTBuilder b = agg.isDistinct() ? ASTBuilder.construct(680, "TOK_FUNCTIONDI") : (argCount == 0 ? ASTBuilder.construct(681, "TOK_FUNCTIONSTAR") : ASTBuilder.construct(679, "TOK_FUNCTION"));
                b.add(26, agg.getAggregation().getName());
                Iterator i$2 = agg.getArgList().iterator();
                while (i$2.hasNext()) {
                    int i = (Integer)i$2.next();
                    RexInputRef iRef = new RexInputRef(i, gBy.getCluster().getTypeFactory().createSqlType(SqlTypeName.ANY));
                    b.add((ASTNode)iRef.accept((org.eigenbase.rex.RexVisitor)new RexVisitor(src)));
                }
                this.add(new ColumnInfo(null, b.node()));
            }
        }

        public Schema(HiveSortRel order) {
            ProjectRelBase select = (ProjectRelBase)order.getChild();
            for (String projName : select.getRowType().getFieldNames()) {
                this.add(new ColumnInfo(null, projName));
            }
        }
    }

    static class QueryBlockInfo {
        Schema schema;
        ASTNode ast;

        public QueryBlockInfo(Schema schema, ASTNode ast) {
            this.schema = schema;
            this.ast = ast;
        }
    }

    static class RexVisitor
    extends RexVisitorImpl<ASTNode> {
        private final Schema schema;
        private boolean useTypeQualInLiteral;

        protected RexVisitor(Schema schema) {
            this(schema, false);
        }

        protected RexVisitor(Schema schema, boolean useTypeQualInLiteral) {
            super(true);
            this.schema = schema;
            this.useTypeQualInLiteral = useTypeQualInLiteral;
        }

        public ASTNode visitFieldAccess(RexFieldAccess fieldAccess) {
            return ASTBuilder.construct(17, ".").add((ASTNode)super.visitFieldAccess(fieldAccess)).add(26, fieldAccess.getField().getName()).node();
        }

        public ASTNode visitInputRef(RexInputRef inputRef) {
            ColumnInfo cI = (ColumnInfo)this.schema.get(inputRef.getIndex());
            if (cI.agg != null) {
                return (ASTNode)ParseDriver.adaptor.dupTree((Object)cI.agg);
            }
            if (cI.table == null || cI.table.isEmpty()) {
                return ASTBuilder.unqualifiedName(cI.column);
            }
            return ASTBuilder.qualifiedName(cI.table, cI.column);
        }

        public ASTNode visitLiteral(RexLiteral literal) {
            return ASTBuilder.literal(literal, this.useTypeQualInLiteral);
        }

        private ASTNode getPSpecAST(RexWindow window) {
            ASTNode pSpecAst = null;
            ASTNode dByAst = null;
            if (window.partitionKeys != null && !window.partitionKeys.isEmpty()) {
                dByAst = ASTBuilder.createAST(659, "TOK_DISTRIBUTEBY");
                for (RexNode pk : window.partitionKeys) {
                    ASTNode astCol = (ASTNode)pk.accept((org.eigenbase.rex.RexVisitor)this);
                    dByAst.addChild((Tree)astCol);
                }
            }
            ASTNode oByAst = null;
            if (window.orderKeys != null && !window.orderKeys.isEmpty()) {
                oByAst = ASTBuilder.createAST(749, "TOK_ORDERBY");
                for (RexFieldCollation ok : window.orderKeys) {
                    ASTNode astNode = ok.getDirection() == RelFieldCollation.Direction.ASCENDING ? ASTBuilder.createAST(860, "TOK_TABSORTCOLNAMEASC") : ASTBuilder.createAST(861, "TOK_TABSORTCOLNAMEDESC");
                    ASTNode astCol = (ASTNode)((RexNode)ok.left).accept((org.eigenbase.rex.RexVisitor)this);
                    astNode.addChild((Tree)astCol);
                    oByAst.addChild((Tree)astNode);
                }
            }
            if (dByAst != null || oByAst != null) {
                pSpecAst = ASTBuilder.createAST(751, "TOK_PARTITIONINGSPEC");
                if (dByAst != null) {
                    pSpecAst.addChild((Tree)dByAst);
                }
                if (oByAst != null) {
                    pSpecAst.addChild((Tree)oByAst);
                }
            }
            return pSpecAst;
        }

        private ASTNode getWindowBound(RexWindowBound wb) {
            ASTNode wbAST = null;
            if (wb.isCurrentRow()) {
                wbAST = ASTBuilder.createAST(69, "CURRENT");
            } else {
                wbAST = wb.isPreceding() ? ASTBuilder.createAST(190, "PRECEDING") : ASTBuilder.createAST(112, "FOLLOWING");
                if (wb.isUnbounded()) {
                    wbAST.addChild((Tree)ASTBuilder.createAST(257, "UNBOUNDED"));
                } else {
                    ASTNode offset = (ASTNode)wb.getOffset().accept((org.eigenbase.rex.RexVisitor)this);
                    wbAST.addChild((Tree)offset);
                }
            }
            return wbAST;
        }

        private ASTNode getWindowRangeAST(RexWindow window) {
            ASTNode wRangeAst = null;
            ASTNode startAST = null;
            RexWindowBound ub = window.getUpperBound();
            if (ub != null) {
                startAST = this.getWindowBound(ub);
            }
            ASTNode endAST = null;
            RexWindowBound lb = window.getLowerBound();
            if (lb != null) {
                endAST = this.getWindowBound(lb);
            }
            if (startAST != null || endAST != null) {
                wRangeAst = window.isRows() ? ASTBuilder.createAST(888, "TOK_WINDOWRANGE") : ASTBuilder.createAST(890, "TOK_WINDOWVALUES");
                if (startAST != null) {
                    wRangeAst.addChild((Tree)startAST);
                }
                if (endAST != null) {
                    wRangeAst.addChild((Tree)endAST);
                }
            }
            return wRangeAst;
        }

        public ASTNode visitOver(RexOver over) {
            if (!this.deep) {
                return null;
            }
            ASTNode wUDAFAst = this.visitCall((RexCall)over);
            ASTNode wSpec = ASTBuilder.createAST(889, "TOK_WINDOWSPEC");
            wUDAFAst.addChild((Tree)wSpec);
            RexWindow window = over.getWindow();
            ASTNode wPSpecAst = this.getPSpecAST(window);
            ASTNode wRangeAst = this.getWindowRangeAST(window);
            if (wPSpecAst != null) {
                wSpec.addChild((Tree)wPSpecAst);
            }
            if (wRangeAst != null) {
                wSpec.addChild((Tree)wRangeAst);
            }
            return wUDAFAst;
        }

        public ASTNode visitCall(RexCall call) {
            if (!this.deep) {
                return null;
            }
            SqlOperator op = call.getOperator();
            LinkedList<ASTNode> astNodeLst = new LinkedList<ASTNode>();
            if (op.kind == SqlKind.CAST) {
                SqlFunctionConverter.HiveToken ht = TypeConverter.hiveToken(call.getType());
                ASTBuilder astBldr = ASTBuilder.construct(ht.type, ht.text);
                if (ht.args != null) {
                    for (String castArg : ht.args) {
                        astBldr.add(26, castArg);
                    }
                }
                astNodeLst.add(astBldr.node());
            }
            for (RexNode operand : call.operands) {
                astNodeLst.add((ASTNode)operand.accept((org.eigenbase.rex.RexVisitor)this));
            }
            if (ASTConverter.isFlat(call)) {
                return SqlFunctionConverter.buildAST(op, astNodeLst, 0);
            }
            return SqlFunctionConverter.buildAST(op, astNodeLst);
        }
    }

    class QBVisitor
    extends RelVisitor {
        QBVisitor() {
        }

        public void handle(FilterRelBase filter) {
            RelNode child = filter.getChild();
            if (child instanceof AggregateRelBase && !((AggregateRelBase)child).getGroupSet().isEmpty()) {
                ASTConverter.this.having = filter;
            } else {
                ASTConverter.this.where = filter;
            }
        }

        public void handle(ProjectRelBase project) {
            if (ASTConverter.this.select == null) {
                ASTConverter.this.select = project;
            } else {
                ASTConverter.this.from = (RelNode)project;
            }
        }

        public void visit(RelNode node, int ordinal, RelNode parent) {
            if (node instanceof TableAccessRelBase) {
                ASTConverter.this.from = node;
            } else if (node instanceof FilterRelBase) {
                this.handle((FilterRelBase)node);
            } else if (node instanceof ProjectRelBase) {
                this.handle((ProjectRelBase)node);
            } else if (node instanceof JoinRelBase) {
                ASTConverter.this.from = node;
            } else if (node instanceof UnionRelBase) {
                ASTConverter.this.from = node;
            } else if (node instanceof AggregateRelBase) {
                ASTConverter.this.groupBy = (AggregateRelBase)node;
            } else if (node instanceof SortRel) {
                if (ASTConverter.this.select != null) {
                    ASTConverter.this.from = node;
                } else {
                    SortRel hiveSortRel = (SortRel)node;
                    if (hiveSortRel.getCollation().getFieldCollations().isEmpty()) {
                        ASTConverter.this.limit = hiveSortRel;
                    } else {
                        ASTConverter.this.order = hiveSortRel;
                    }
                }
            }
            if (ASTConverter.this.from == null) {
                node.childrenAccept((RelVisitor)this);
            }
        }
    }
}

