/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.write;

import java.sql.Timestamp;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.NanoTime;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.NanoTimeUtils;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import parquet.io.api.Binary;
import parquet.io.api.RecordConsumer;
import parquet.schema.GroupType;
import parquet.schema.OriginalType;
import parquet.schema.Type;

public class DataWritableWriter {
    private static final Log LOG = LogFactory.getLog(DataWritableWriter.class);
    private final RecordConsumer recordConsumer;
    private final GroupType schema;

    public DataWritableWriter(RecordConsumer recordConsumer, GroupType schema) {
        this.recordConsumer = recordConsumer;
        this.schema = schema;
    }

    public void write(ArrayWritable record) {
        if (record != null) {
            this.recordConsumer.startMessage();
            try {
                this.writeGroupFields(record, this.schema);
            }
            catch (RuntimeException e) {
                String errorMessage = "Parquet record is malformed: " + e.getMessage();
                LOG.error((Object)errorMessage, (Throwable)e);
                throw new RuntimeException(errorMessage, e);
            }
            this.recordConsumer.endMessage();
        }
    }

    public void writeGroupFields(ArrayWritable value, GroupType type) {
        if (value != null) {
            for (int i = 0; i < type.getFieldCount(); ++i) {
                Type fieldType = type.getType(i);
                String fieldName = fieldType.getName();
                Writable fieldValue = value.get()[i];
                if (fieldValue == null) continue;
                this.recordConsumer.startField(fieldName, i);
                this.writeValue(fieldValue, fieldType);
                this.recordConsumer.endField(fieldName, i);
            }
        }
    }

    private void writeValue(Writable value, Type type) {
        if (type.isPrimitive()) {
            this.writePrimitive(value);
        } else if (value instanceof ArrayWritable) {
            GroupType groupType = type.asGroupType();
            OriginalType originalType = type.getOriginalType();
            if (originalType != null && originalType.equals((Object)OriginalType.LIST)) {
                this.writeArray((ArrayWritable)value, groupType);
            } else if (originalType != null && originalType.equals((Object)OriginalType.MAP)) {
                this.writeMap((ArrayWritable)value, groupType);
            } else {
                this.writeGroup((ArrayWritable)value, groupType);
            }
        } else {
            throw new RuntimeException("Field value is not an ArrayWritable object: " + type);
        }
    }

    private void writeGroup(ArrayWritable value, GroupType type) {
        this.recordConsumer.startGroup();
        this.writeGroupFields(value, type);
        this.recordConsumer.endGroup();
    }

    private void writeMap(ArrayWritable value, GroupType type) {
        GroupType repeatedType = type.getType(0).asGroupType();
        ArrayWritable repeatedValue = (ArrayWritable)value.get()[0];
        this.recordConsumer.startGroup();
        this.recordConsumer.startField(repeatedType.getName(), 0);
        Writable[] map_values = repeatedValue.get();
        for (int record = 0; record < map_values.length; ++record) {
            Writable key_value_pair = map_values[record];
            if (key_value_pair != null) {
                if (!(key_value_pair instanceof ArrayWritable)) {
                    throw new RuntimeException("Map key-value pair is not an ArrayWritable object on record " + record);
                }
            } else {
                throw new RuntimeException("Map key-value pair is null on record " + record);
            }
            this.writeGroup((ArrayWritable)key_value_pair, repeatedType);
        }
        this.recordConsumer.endField(repeatedType.getName(), 0);
        this.recordConsumer.endGroup();
    }

    private void writeArray(ArrayWritable array, GroupType type) {
        GroupType repeatedType = type.getType(0).asGroupType();
        ArrayWritable repeatedValue = (ArrayWritable)array.get()[0];
        this.recordConsumer.startGroup();
        this.recordConsumer.startField(repeatedType.getName(), 0);
        Writable[] array_values = repeatedValue.get();
        for (int record = 0; record < array_values.length; ++record) {
            this.recordConsumer.startGroup();
            Writable element = array_values[record];
            if (element != null) {
                for (int i = 0; i < type.getFieldCount(); ++i) {
                    Type fieldType = repeatedType.getType(i);
                    String fieldName = fieldType.getName();
                    this.recordConsumer.startField(fieldName, i);
                    this.writeValue(element, fieldType);
                    this.recordConsumer.endField(fieldName, i);
                }
            }
            this.recordConsumer.endGroup();
        }
        this.recordConsumer.endField(repeatedType.getName(), 0);
        this.recordConsumer.endGroup();
    }

    private void writePrimitive(Writable value) {
        if (value == null) {
            return;
        }
        if (value instanceof DoubleWritable) {
            this.recordConsumer.addDouble(((DoubleWritable)value).get());
        } else if (value instanceof BooleanWritable) {
            this.recordConsumer.addBoolean(((BooleanWritable)value).get());
        } else if (value instanceof FloatWritable) {
            this.recordConsumer.addFloat(((FloatWritable)value).get());
        } else if (value instanceof IntWritable) {
            this.recordConsumer.addInteger(((IntWritable)value).get());
        } else if (value instanceof LongWritable) {
            this.recordConsumer.addLong(((LongWritable)value).get());
        } else if (value instanceof ShortWritable) {
            this.recordConsumer.addInteger(((ShortWritable)value).get());
        } else if (value instanceof ByteWritable) {
            this.recordConsumer.addInteger(((ByteWritable)value).get());
        } else {
            if (value instanceof HiveDecimalWritable) {
                throw new UnsupportedOperationException("HiveDecimalWritable writing not implemented");
            }
            if (value instanceof BytesWritable) {
                this.recordConsumer.addBinary(Binary.fromByteArray(((BytesWritable)value).getBytes()));
            } else if (value instanceof TimestampWritable) {
                Timestamp ts = ((TimestampWritable)value).getTimestamp();
                NanoTime nt = NanoTimeUtils.getNanoTime(ts);
                nt.writeValue(this.recordConsumer);
            } else {
                throw new IllegalArgumentException("Unknown value type: " + value + " " + value.getClass());
            }
        }
    }
}

