/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.compress;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.util.JVM;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.CompressorStream;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.io.compress.zlib.ZlibFactory;

@InterfaceAudience.Private
public class ReusableStreamGzipCodec
extends GzipCodec {
    private static final Log LOG = LogFactory.getLog(Compression.class);

    @Override
    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        if (ZlibFactory.isNativeZlibLoaded(this.getConf())) {
            return super.createOutputStream(out);
        }
        return new ReusableGzipOutputStream(out);
    }

    protected static class ReusableGzipOutputStream
    extends CompressorStream {
        private static final int GZIP_HEADER_LENGTH = 10;
        private static final byte[] GZIP_HEADER;

        public ReusableGzipOutputStream(OutputStream out) throws IOException {
            super(new ResetableGZIPOutputStream(out));
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
        }

        @Override
        public void write(byte[] data, int offset, int length) throws IOException {
            this.out.write(data, offset, length);
        }

        @Override
        public void finish() throws IOException {
            ((GZIPOutputStream)this.out).finish();
        }

        @Override
        public void resetState() throws IOException {
            ((ResetableGZIPOutputStream)this.out).resetState();
        }

        static {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] header = null;
            GZIPOutputStream gzipStream = null;
            try {
                gzipStream = new GZIPOutputStream(baos);
                gzipStream.finish();
                header = Arrays.copyOfRange(baos.toByteArray(), 0, 10);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not create gzip stream", e);
            }
            finally {
                if (gzipStream != null) {
                    try {
                        gzipStream.close();
                    }
                    catch (IOException e) {
                        LOG.error((Object)e);
                    }
                }
            }
            GZIP_HEADER = header;
        }

        private static class ResetableGZIPOutputStream
        extends GZIPOutputStream {
            private static final int TRAILER_SIZE = 8;
            private static final boolean HAS_BROKEN_FINISH = JVM.isGZIPOutputStreamFinishBroken();

            public ResetableGZIPOutputStream(OutputStream out) throws IOException {
                super(out);
            }

            public void resetState() throws IOException {
                this.def.reset();
                this.crc.reset();
                this.out.write(GZIP_HEADER);
            }

            @Override
            public void finish() throws IOException {
                if (HAS_BROKEN_FINISH) {
                    if (!this.def.finished()) {
                        this.def.finish();
                        while (!this.def.finished()) {
                            int i = this.def.deflate(this.buf, 0, this.buf.length);
                            if (this.def.finished() && i <= this.buf.length - 8) {
                                this.writeTrailer(this.buf, i);
                                this.out.write(this.buf, 0, i += 8);
                                return;
                            }
                            if (i <= 0) continue;
                            this.out.write(this.buf, 0, i);
                        }
                        byte[] arrayOfByte = new byte[8];
                        this.writeTrailer(arrayOfByte, 0);
                        this.out.write(arrayOfByte);
                    }
                } else {
                    super.finish();
                }
            }

            private void writeTrailer(byte[] paramArrayOfByte, int paramInt) throws IOException {
                this.writeInt((int)this.crc.getValue(), paramArrayOfByte, paramInt);
                this.writeInt(this.def.getTotalIn(), paramArrayOfByte, paramInt + 4);
            }

            private void writeInt(int paramInt1, byte[] paramArrayOfByte, int paramInt2) throws IOException {
                this.writeShort(paramInt1 & 0xFFFF, paramArrayOfByte, paramInt2);
                this.writeShort(paramInt1 >> 16 & 0xFFFF, paramArrayOfByte, paramInt2 + 2);
            }

            private void writeShort(int paramInt1, byte[] paramArrayOfByte, int paramInt2) throws IOException {
                paramArrayOfByte[paramInt2] = (byte)(paramInt1 & 0xFF);
                paramArrayOfByte[paramInt2 + 1] = (byte)(paramInt1 >> 8 & 0xFF);
            }
        }
    }
}

