/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.janitor;

import java.io.IOException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.janitor.MetaFixer;
import org.apache.hadoop.hbase.master.janitor.Report;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class ReportMakingVisitor
implements MetaTableAccessor.CloseableVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(ReportMakingVisitor.class);
    private final MasterServices services;
    private volatile boolean closed;
    private Report report = new Report();
    private RegionInfo previous = null;
    private RegionInfo highestEndKeyRegionInfo = null;

    ReportMakingVisitor(MasterServices services) {
        this.services = services;
    }

    Report getReport() {
        if (!this.closed) {
            throw new RuntimeException("Report not ready until after close()");
        }
        return this.report;
    }

    public boolean visit(Result r) {
        if (r == null || r.isEmpty()) {
            return true;
        }
        ++this.report.count;
        RegionInfo regionInfo = null;
        try {
            regionInfo = this.metaTableConsistencyCheck(r);
        }
        catch (Throwable t) {
            LOG.warn("Failed consistency check on {}", (Object)Bytes.toStringBinary((byte[])r.getRow()), (Object)t);
        }
        if (regionInfo != null) {
            LOG.trace(regionInfo.toString());
            if (regionInfo.isSplitParent()) {
                this.report.splitParents.put(regionInfo, r);
            }
            if (MetaTableAccessor.hasMergeRegions((Cell[])r.rawCells())) {
                this.report.mergedRegions.put(regionInfo, r);
            }
        }
        return true;
    }

    private RegionInfo metaTableConsistencyCheck(Result metaTableRow) {
        RegionInfo ri;
        RegionLocations locations = MetaTableAccessor.getRegionLocations((Result)metaTableRow);
        if (locations == null) {
            ri = MetaTableAccessor.getRegionInfo((Result)metaTableRow, (byte[])HConstants.REGIONINFO_QUALIFIER);
        } else {
            ri = locations.getDefaultRegionLocation().getRegion();
            this.checkServer(locations);
        }
        if (ri == null) {
            this.report.emptyRegionInfo.add(metaTableRow.getRow());
            return ri;
        }
        if (!Bytes.equals((byte[])metaTableRow.getRow(), (byte[])ri.getRegionName())) {
            LOG.warn("INCONSISTENCY: Row name is not equal to serialized info:regioninfo content; row={} {}; See if RegionInfo is referenced in another hbase:meta row? Delete?", (Object)Bytes.toStringBinary((byte[])metaTableRow.getRow()), (Object)ri.getRegionNameAsString());
            return null;
        }
        if (ri.isSplitParent()) {
            return ri;
        }
        if (!this.isTableDisabled(ri)) {
            if (this.isTableTransition(ri)) {
                if (!ri.isFirst()) {
                    this.addHole(RegionInfoBuilder.UNDEFINED, ri);
                }
                if (this.previous != null && !this.previous.isLast()) {
                    this.addHole(this.previous, RegionInfoBuilder.UNDEFINED);
                }
            } else if (!this.previous.isNext(ri)) {
                if (this.previous.isOverlap(ri)) {
                    this.addOverlap(this.previous, ri);
                } else if (ri.isOverlap(this.highestEndKeyRegionInfo)) {
                    this.addOverlap(this.highestEndKeyRegionInfo, ri);
                } else if (!this.highestEndKeyRegionInfo.isNext(ri)) {
                    this.addHole(this.previous, ri);
                }
            } else if (ri.isOverlap(this.highestEndKeyRegionInfo)) {
                this.addOverlap(this.highestEndKeyRegionInfo, ri);
            }
        }
        this.previous = ri;
        this.highestEndKeyRegionInfo = MetaFixer.getRegionInfoWithLargestEndKey(this.highestEndKeyRegionInfo, ri);
        return ri;
    }

    private void addOverlap(RegionInfo a, RegionInfo b) {
        this.report.overlaps.add((Pair<RegionInfo, RegionInfo>)new Pair((Object)a, (Object)b));
    }

    private void addHole(RegionInfo a, RegionInfo b) {
        this.report.holes.add((Pair<RegionInfo, RegionInfo>)new Pair((Object)a, (Object)b));
    }

    boolean isTableDisabled(RegionInfo ri) {
        if (ri == null) {
            return false;
        }
        if (this.services == null) {
            return false;
        }
        if (this.services.getTableStateManager() == null) {
            return false;
        }
        TableState state = null;
        try {
            state = this.services.getTableStateManager().getTableState(ri.getTable());
        }
        catch (IOException e) {
            LOG.warn("Failed getting table state", (Throwable)e);
        }
        return state != null && state.isDisabledOrDisabling();
    }

    private void checkServer(RegionLocations locations) {
        if (this.services == null) {
            return;
        }
        if (locations == null) {
            return;
        }
        if (locations.getRegionLocations() == null) {
            return;
        }
        block3: for (HRegionLocation location : locations.getRegionLocations()) {
            RegionState rs;
            ServerName sn;
            if (location == null || (sn = location.getServerName()) == null) continue;
            if (location.getRegion() == null) {
                LOG.warn("Empty RegionInfo in {}", (Object)location);
                continue;
            }
            RegionInfo ri = location.getRegion();
            if (ri.isSplitParent() || this.isTableDisabled(ri) || (rs = this.services.getAssignmentManager().getRegionStates().getRegionState(ri)) == null || rs.isClosedOrAbnormallyClosed()) continue;
            ServerManager.ServerLiveState state = this.services.getServerManager().isServerKnownAndOnline(sn);
            switch (state) {
                case UNKNOWN: {
                    this.report.unknownServers.add((Pair<RegionInfo, ServerName>)new Pair((Object)ri, (Object)sn));
                    continue block3;
                }
            }
        }
    }

    private boolean isTableTransition(RegionInfo ri) {
        return this.previous == null || !this.previous.getTable().equals((Object)ri.getTable());
    }

    public void close() throws IOException {
        if (this.previous != null && !this.previous.isLast()) {
            this.addHole(this.previous, RegionInfoBuilder.UNDEFINED);
        }
        this.closed = true;
    }
}

