/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.balancer.BaseLoadBalancer;
import org.apache.hadoop.hbase.master.balancer.CandidateGenerator;
import org.apache.hbase.thirdparty.com.google.common.base.Optional;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class LocalityBasedCandidateGenerator
extends CandidateGenerator {
    private MasterServices masterServices;

    LocalityBasedCandidateGenerator(MasterServices masterServices) {
        this.masterServices = masterServices;
    }

    @Override
    BaseLoadBalancer.Cluster.Action generate(BaseLoadBalancer.Cluster cluster) {
        if (this.masterServices == null) {
            int thisServer = this.pickRandomServer(cluster);
            int otherServer = this.pickOtherRandomServer(cluster, thisServer);
            return this.pickRandomRegions(cluster, thisServer, otherServer);
        }
        for (int region : this.getRandomIterationOrder(cluster.numRegions)) {
            Optional<BaseLoadBalancer.Cluster.Action> potential;
            int currentServer = cluster.regionIndexToServerIndex[region];
            if (currentServer == cluster.getOrComputeRegionsToMostLocalEntities(BaseLoadBalancer.Cluster.LocalityType.SERVER)[region] || !(potential = this.tryMoveOrSwap(cluster, currentServer, region, cluster.getOrComputeRegionsToMostLocalEntities(BaseLoadBalancer.Cluster.LocalityType.SERVER)[region])).isPresent()) continue;
            return (BaseLoadBalancer.Cluster.Action)potential.get();
        }
        return BaseLoadBalancer.Cluster.NullAction;
    }

    private Optional<BaseLoadBalancer.Cluster.Action> tryMoveOrSwap(BaseLoadBalancer.Cluster cluster, int fromServer, int fromRegion, int toServer) {
        if (cluster.serverHasTooFewRegions(toServer)) {
            return Optional.of((Object)this.getAction(fromServer, fromRegion, toServer, -1));
        }
        double fromRegionLocalityDelta = this.getWeightedLocality(cluster, fromRegion, toServer) - this.getWeightedLocality(cluster, fromRegion, fromServer);
        for (int toRegionIndex : this.getRandomIterationOrder(cluster.regionsPerServer[toServer].length)) {
            int toRegion = cluster.regionsPerServer[toServer][toRegionIndex];
            double toRegionLocalityDelta = this.getWeightedLocality(cluster, toRegion, fromServer) - this.getWeightedLocality(cluster, toRegion, toServer);
            if (!(fromRegionLocalityDelta + toRegionLocalityDelta >= 0.0)) continue;
            return Optional.of((Object)this.getAction(fromServer, fromRegion, toServer, toRegion));
        }
        return Optional.absent();
    }

    private double getWeightedLocality(BaseLoadBalancer.Cluster cluster, int region, int server) {
        return cluster.getOrComputeWeightedLocality(region, server, BaseLoadBalancer.Cluster.LocalityType.SERVER);
    }

    void setServices(MasterServices services) {
        this.masterServices = services;
    }
}

