/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.FilterProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class FilterWrapper
extends Filter {
    Filter filter = null;

    public FilterWrapper(Filter filter) {
        if (null == filter) {
            throw new NullPointerException("Cannot create FilterWrapper with null Filter");
        }
        this.filter = filter;
    }

    public byte[] toByteArray() throws IOException {
        FilterProtos.FilterWrapper.Builder builder = FilterProtos.FilterWrapper.newBuilder();
        builder.setFilter(ProtobufUtil.toFilter((Filter)this.filter));
        return builder.build().toByteArray();
    }

    public static FilterWrapper parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.FilterWrapper proto;
        try {
            proto = FilterProtos.FilterWrapper.parseFrom((byte[])pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException((Throwable)e);
        }
        try {
            return new FilterWrapper(ProtobufUtil.toFilter((FilterProtos.Filter)proto.getFilter()));
        }
        catch (IOException ioe) {
            throw new DeserializationException((Throwable)ioe);
        }
    }

    public void reset() throws IOException {
        this.filter.reset();
    }

    public boolean filterAllRemaining() throws IOException {
        return this.filter.filterAllRemaining();
    }

    public boolean filterRow() throws IOException {
        return this.filter.filterRow();
    }

    public Cell getNextCellHint(Cell currentCell) throws IOException {
        return this.filter.getNextCellHint(currentCell);
    }

    public boolean filterRowKey(byte[] buffer, int offset, int length) throws IOException {
        if (this.filterAllRemaining()) {
            return true;
        }
        return this.filter.filterRowKey(buffer, offset, length);
    }

    public boolean filterRowKey(Cell cell) throws IOException {
        if (this.filterAllRemaining()) {
            return true;
        }
        return this.filter.filterRowKey(cell);
    }

    @Deprecated
    public Filter.ReturnCode filterKeyValue(Cell c) throws IOException {
        return this.filterCell(c);
    }

    public Filter.ReturnCode filterCell(Cell c) throws IOException {
        return this.filter.filterCell(c);
    }

    public Cell transformCell(Cell v) throws IOException {
        return this.filter.transformCell(v);
    }

    public boolean hasFilterRow() {
        return this.filter.hasFilterRow();
    }

    public void filterRowCells(List<Cell> kvs) throws IOException {
        this.filterRowCellsWithRet(kvs);
    }

    public FilterRowRetCode filterRowCellsWithRet(List<Cell> kvs) throws IOException {
        this.filter.filterRowCells(kvs);
        if (!kvs.isEmpty()) {
            if (this.filter.filterRow()) {
                kvs.clear();
                return FilterRowRetCode.EXCLUDE;
            }
            return FilterRowRetCode.INCLUDE;
        }
        return FilterRowRetCode.NOT_CALLED;
    }

    public boolean isFamilyEssential(byte[] name) throws IOException {
        return this.filter.isFamilyEssential(name);
    }

    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FilterWrapper)) {
            return false;
        }
        FilterWrapper other = (FilterWrapper)o;
        return this.filter.areSerializedFieldsEqual(other.filter);
    }

    public static enum FilterRowRetCode {
        NOT_CALLED,
        INCLUDE,
        EXCLUDE,
        INCLUDE_THIS_FAMILY;

    }
}

