/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTestLogRolling {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTestLogRolling.class);
    protected HRegionServer server = null;
    protected String tableName = null;
    protected byte[] value;
    protected FileSystem fs;
    protected MiniDFSCluster dfsCluster;
    protected Admin admin;
    protected MiniHBaseCluster cluster;
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    @Rule
    public final TestName name = new TestName();

    public AbstractTestLogRolling() {
        String className = this.getClass().getName();
        StringBuilder v = new StringBuilder(className);
        while (v.length() < 1000) {
            v.append(className);
        }
        this.value = Bytes.toBytes((String)v.toString());
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setLong("hbase.hregion.max.filesize", 786432L);
        conf.setInt("hbase.regionserver.maxlogentries", 32);
        conf.setInt("hbase.regionserver.logroll.errors.tolerated", 2);
        conf.setInt("hbase.rpc.timeout", 10000);
        conf.setInt("hbase.hregion.memstore.optionalflushcount", 2);
        conf.setInt("hbase.hregion.memstore.flush.size", 8192);
        conf.setLong("hbase.client.pause", 10000L);
        conf.setInt("hbase.server.thread.wakefrequency", 2000);
        conf.setLong("hbase.regionserver.hlog.check.lowreplication.interval", 86400000L);
    }

    @Before
    public void setUp() throws Exception {
        TEST_UTIL.startMiniCluster(StartMiniClusterOption.builder().numDataNodes(2).build());
        this.cluster = TEST_UTIL.getHBaseCluster();
        this.dfsCluster = TEST_UTIL.getDFSCluster();
        this.fs = TEST_UTIL.getTestFileSystem();
        this.admin = TEST_UTIL.getAdmin();
        this.cluster.getMaster().balanceSwitch(false);
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    protected void startAndWriteData() throws IOException, InterruptedException {
        TEST_UTIL.getConnection().getTable(TableName.META_TABLE_NAME);
        this.server = this.cluster.getRegionServerThreads().get(0).getRegionServer();
        Table table = this.createTestTable(this.tableName);
        this.server = TEST_UTIL.getRSForFirstRegionInTable(table.getName());
        for (int i = 1; i <= 256; ++i) {
            this.doPut(table, i);
            if (i % 32 != 0) continue;
            try {
                Thread.sleep(2000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLogRollOnNothingWritten() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        WALFactory wals = new WALFactory(conf, ServerName.valueOf((String)"test.com", (int)8080, (long)1L).toString());
        WAL newLog = wals.getWAL(null);
        try {
            newLog.rollWriter(true);
        }
        finally {
            wals.close();
        }
    }

    private void assertLogFileSize(WAL log) {
        if (AbstractFSWALProvider.getNumRolledLogFiles((WAL)log) > 0) {
            Assert.assertTrue((AbstractFSWALProvider.getLogFileSize((WAL)log) > 0L ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((long)0L, (long)AbstractFSWALProvider.getLogFileSize((WAL)log));
        }
    }

    @Test
    public void testLogRolling() throws Exception {
        this.tableName = this.getName();
        this.startAndWriteData();
        RegionInfo region = ((HRegion)this.server.getRegions(TableName.valueOf((String)this.tableName)).get(0)).getRegionInfo();
        WAL log = this.server.getWAL(region);
        LOG.info("after writing there are " + AbstractFSWALProvider.getNumRolledLogFiles((WAL)log) + " log files");
        this.assertLogFileSize(log);
        for (HRegion r : this.server.getOnlineRegionsLocalContext()) {
            r.flush(true);
        }
        log.rollWriter();
        int count = AbstractFSWALProvider.getNumRolledLogFiles((WAL)log);
        LOG.info("after flushing all regions and rolling logs there are " + count + " log files");
        Assert.assertTrue((String)("actual count: " + count), (count <= 2 ? 1 : 0) != 0);
        this.assertLogFileSize(log);
    }

    protected String getName() {
        return "TestLogRolling-" + this.name.getMethodName();
    }

    void writeData(Table table, int rownum) throws IOException {
        this.doPut(table, rownum);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    void validateData(Table table, int rownum) throws IOException {
        String row = "row" + String.format("%1$04d", rownum);
        Get get = new Get(Bytes.toBytes((String)row));
        get.addFamily(HConstants.CATALOG_FAMILY);
        Result result = table.get(get);
        Assert.assertTrue((result.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Bytes.equals((byte[])this.value, (byte[])result.getValue(HConstants.CATALOG_FAMILY, null)));
        LOG.info("Validated row " + row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompactionRecordDoesntBlockRolling() throws Exception {
        Table table = null;
        Table t = TEST_UTIL.getConnection().getTable(TableName.META_TABLE_NAME);
        try {
            table = this.createTestTable(this.getName());
            this.server = TEST_UTIL.getRSForFirstRegionInTable(table.getName());
            HRegion region = (HRegion)this.server.getRegions(table.getName()).get(0);
            WAL log = this.server.getWAL(region.getRegionInfo());
            HStore s = region.getStore(HConstants.CATALOG_FAMILY);
            this.admin.flush(TableName.NAMESPACE_TABLE_NAME);
            for (int i = 1; i <= 2; ++i) {
                this.doPut(table, i);
                this.admin.flush(table.getName());
            }
            this.doPut(table, 3);
            Assert.assertEquals((String)"Should have no WAL after initial writes", (long)0L, (long)AbstractFSWALProvider.getNumRolledLogFiles((WAL)log));
            Assert.assertEquals((long)2L, (long)s.getStorefilesCount());
            log.rollWriter();
            Assert.assertEquals((String)"Should have WAL; one table is not flushed", (long)1L, (long)AbstractFSWALProvider.getNumRolledLogFiles((WAL)log));
            this.admin.flush(table.getName());
            region.compact(false);
            Assert.assertNotNull((Object)s);
            for (int waitTime = 3000; s.getStorefilesCount() > 1 && waitTime > 0; waitTime -= 200) {
                Threads.sleepWithoutInterrupt((long)200L);
            }
            Assert.assertEquals((String)"Compaction didn't happen", (long)1L, (long)s.getStorefilesCount());
            this.doPut(table, 0);
            log.rollWriter();
            Assert.assertEquals((String)"Should have WAL; one table is not flushed", (long)1L, (long)AbstractFSWALProvider.getNumRolledLogFiles((WAL)log));
            this.admin.flush(table.getName());
            this.doPut(table, 1);
            log.rollWriter();
            Assert.assertEquals((String)"Should have 1 WALs at the end", (long)1L, (long)AbstractFSWALProvider.getNumRolledLogFiles((WAL)log));
        }
        finally {
            if (t != null) {
                t.close();
            }
            if (table != null) {
                table.close();
            }
        }
    }

    protected void doPut(Table table, int i) throws IOException {
        Put put = new Put(Bytes.toBytes((String)("row" + String.format("%1$04d", i))));
        put.addColumn(HConstants.CATALOG_FAMILY, null, this.value);
        table.put(put);
    }

    protected Table createTestTable(String tableName) throws IOException {
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.getName())).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])HConstants.CATALOG_FAMILY)).build();
        this.admin.createTable(desc);
        return TEST_UTIL.getConnection().getTable(desc.getTableName());
    }
}

