/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.io.ByteBufferOutputStream;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestByteBufferOutputStream {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestByteBufferOutputStream.class);

    @Test
    public void testByteBufferReuse() throws IOException {
        byte[] someBytes = Bytes.toBytes((String)"some bytes");
        ByteBuffer bb = ByteBuffer.allocate(someBytes.length);
        ByteBuffer bbToReuse = this.write(bb, someBytes);
        Assert.assertTrue((bb == (bbToReuse = this.write(bbToReuse, Bytes.toBytes((String)"less"))) ? 1 : 0) != 0);
    }

    private ByteBuffer write(ByteBuffer bb, byte[] bytes) throws IOException {
        try (ByteBufferOutputStream bbos = new ByteBufferOutputStream(bb);){
            bbos.write(bytes);
            Assert.assertTrue((Bytes.compareTo((byte[])bytes, (byte[])bbos.toByteArray(0, bytes.length)) == 0 ? 1 : 0) != 0);
            bbos.flush();
            ByteBuffer byteBuffer = bbos.getByteBuffer();
            return byteBuffer;
        }
    }
}

