/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Collections;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.FamilyFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.TimestampsFilter;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class})
public class TestCheckAndMutate {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCheckAndMutate.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] ROWKEY = Bytes.toBytes((String)"12345");
    private static final byte[] FAMILY = Bytes.toBytes((String)"cf");
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    private Table createTable() throws IOException, InterruptedException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table table = TEST_UTIL.createTable(tableName, FAMILY);
        TEST_UTIL.waitTableAvailable(tableName.getName(), 5000L);
        return table;
    }

    private void putOneRow(Table table) throws IOException {
        Put put = new Put(ROWKEY);
        put.addColumn(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a"));
        put.addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b"));
        put.addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"c"));
        table.put(put);
    }

    private void getOneRowAndAssertAllExist(Table table) throws IOException {
        Get get = new Get(ROWKEY);
        Result result = table.get(get);
        Assert.assertTrue((String)"Column A value should be a", (boolean)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"A"))).equals("a"));
        Assert.assertTrue((String)"Column B value should be b", (boolean)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))).equals("b"));
        Assert.assertTrue((String)"Column C value should be c", (boolean)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"C"))).equals("c"));
    }

    private void getOneRowAndAssertAllButCExist(Table table) throws IOException {
        Get get = new Get(ROWKEY);
        Result result = table.get(get);
        Assert.assertTrue((String)"Column A value should be a", (boolean)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"A"))).equals("a"));
        Assert.assertTrue((String)"Column B value should be b", (boolean)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))).equals("b"));
        Assert.assertTrue((String)"Column C should not exist", (result.getValue(FAMILY, Bytes.toBytes((String)"C")) == null ? 1 : 0) != 0);
    }

    private RowMutations makeRowMutationsWithColumnCDeleted() throws IOException {
        RowMutations rm = new RowMutations(ROWKEY, 2);
        Put put = new Put(ROWKEY);
        put.addColumn(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a"));
        put.addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b"));
        rm.add(put);
        Delete del = new Delete(ROWKEY);
        del.addColumn(FAMILY, Bytes.toBytes((String)"C"));
        rm.add(del);
        return rm;
    }

    private RowMutations getBogusRowMutations() throws IOException {
        Put p = new Put(ROWKEY);
        byte[] value = new byte[]{};
        p.addColumn(new byte[]{98, 111, 103, 117, 115}, new byte[]{65}, value);
        RowMutations rm = new RowMutations(ROWKEY);
        rm.add(p);
        return rm;
    }

    @Test
    public void testCheckAndMutate() throws Throwable {
        try (Table table = this.createTable();){
            this.putOneRow(table);
            this.getOneRowAndAssertAllExist(table);
            RowMutations rm = this.makeRowMutationsWithColumnCDeleted();
            boolean res = table.checkAndMutate(ROWKEY, FAMILY).qualifier(Bytes.toBytes((String)"A")).ifEquals(Bytes.toBytes((String)"a")).thenMutate(rm);
            Assert.assertTrue((boolean)res);
            this.getOneRowAndAssertAllButCExist(table);
            try {
                rm = this.getBogusRowMutations();
                table.checkAndMutate(ROWKEY, FAMILY).qualifier(Bytes.toBytes((String)"A")).ifEquals(Bytes.toBytes((String)"a")).thenMutate(rm);
                Assert.fail((String)"Expected NoSuchColumnFamilyException");
            }
            catch (RetriesExhaustedWithDetailsException e) {
                try {
                    throw e.getCause(0);
                }
                catch (NoSuchColumnFamilyException noSuchColumnFamilyException) {
                    // empty catch block
                }
            }
        }
    }

    @Test
    public void testCheckAndMutateWithBuilder() throws Throwable {
        try (Table table = this.createTable();){
            this.putOneRow(table);
            this.getOneRowAndAssertAllExist(table);
            RowMutations rm = this.makeRowMutationsWithColumnCDeleted();
            boolean res = table.checkAndMutate(ROWKEY, FAMILY).qualifier(Bytes.toBytes((String)"A")).ifEquals(Bytes.toBytes((String)"a")).thenMutate(rm);
            Assert.assertTrue((boolean)res);
            this.getOneRowAndAssertAllButCExist(table);
            try {
                rm = this.getBogusRowMutations();
                table.checkAndMutate(ROWKEY, FAMILY).qualifier(Bytes.toBytes((String)"A")).ifEquals(Bytes.toBytes((String)"a")).thenMutate(rm);
                Assert.fail((String)"Expected NoSuchColumnFamilyException");
            }
            catch (RetriesExhaustedWithDetailsException e) {
                try {
                    throw e.getCause(0);
                }
                catch (NoSuchColumnFamilyException noSuchColumnFamilyException) {
                    // empty catch block
                }
            }
        }
    }

    @Test
    public void testCheckAndMutateWithSingleFilter() throws Throwable {
        try (Table table = this.createTable();){
            this.putOneRow(table);
            this.getOneRowAndAssertAllExist(table);
            boolean ok = table.checkAndMutate(ROWKEY, (Filter)new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a"))).thenPut(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"d")));
            Assert.assertTrue((boolean)ok);
            Result result = table.get(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"D")));
            Assert.assertEquals((Object)"d", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"D"))));
            ok = table.checkAndMutate(ROWKEY, (Filter)new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"b"))).thenPut(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"E"), Bytes.toBytes((String)"e")));
            Assert.assertFalse((boolean)ok);
            Assert.assertFalse((boolean)table.exists(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"E"))));
            ok = table.checkAndMutate(ROWKEY, (Filter)new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a"))).thenDelete(new Delete(ROWKEY).addColumns(FAMILY, Bytes.toBytes((String)"D")));
            Assert.assertTrue((boolean)ok);
            Assert.assertFalse((boolean)table.exists(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"D"))));
            ok = table.checkAndMutate(ROWKEY, (Filter)new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"B"), CompareOperator.EQUAL, Bytes.toBytes((String)"b"))).thenMutate(new RowMutations(ROWKEY).add((Mutation)new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"d"))).add((Mutation)new Delete(ROWKEY).addColumns(FAMILY, Bytes.toBytes((String)"A"))));
            Assert.assertTrue((boolean)ok);
            result = table.get(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"D")));
            Assert.assertEquals((Object)"d", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"D"))));
            Assert.assertFalse((boolean)table.exists(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"A"))));
        }
    }

    @Test
    public void testCheckAndMutateWithMultipleFilters() throws Throwable {
        try (Table table = this.createTable();){
            this.putOneRow(table);
            this.getOneRowAndAssertAllExist(table);
            boolean ok = table.checkAndMutate(ROWKEY, (Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"B"), CompareOperator.EQUAL, Bytes.toBytes((String)"b"))})).thenPut(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"d")));
            Assert.assertTrue((boolean)ok);
            Result result = table.get(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"D")));
            Assert.assertEquals((Object)"d", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"D"))));
            ok = table.checkAndMutate(ROWKEY, (Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"B"), CompareOperator.EQUAL, Bytes.toBytes((String)"c"))})).thenPut(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"E"), Bytes.toBytes((String)"e")));
            Assert.assertFalse((boolean)ok);
            Assert.assertFalse((boolean)table.exists(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"E"))));
            ok = table.checkAndMutate(ROWKEY, (Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"B"), CompareOperator.EQUAL, Bytes.toBytes((String)"b"))})).thenDelete(new Delete(ROWKEY).addColumns(FAMILY, Bytes.toBytes((String)"D")));
            Assert.assertTrue((boolean)ok);
            Assert.assertFalse((boolean)table.exists(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"D"))));
            ok = table.checkAndMutate(ROWKEY, (Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"B"), CompareOperator.EQUAL, Bytes.toBytes((String)"b"))})).thenMutate(new RowMutations(ROWKEY).add((Mutation)new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"d"))).add((Mutation)new Delete(ROWKEY).addColumns(FAMILY, Bytes.toBytes((String)"A"))));
            Assert.assertTrue((boolean)ok);
            result = table.get(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"D")));
            Assert.assertEquals((Object)"d", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"D"))));
            Assert.assertFalse((boolean)table.exists(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"A"))));
        }
    }

    @Test
    public void testCheckAndMutateWithTimestampFilter() throws Throwable {
        try (Table table = this.createTable();){
            table.put(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"A"), 100L, Bytes.toBytes((String)"a")));
            boolean ok = table.checkAndMutate(ROWKEY, (Filter)new FilterList(new Filter[]{new FamilyFilter(CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(FAMILY)), new QualifierFilter(CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"A"))), new TimestampsFilter(Collections.singletonList(100L))})).thenPut(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b")));
            Assert.assertTrue((boolean)ok);
            Result result = table.get(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"B")));
            Assert.assertEquals((Object)"b", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
            ok = table.checkAndMutate(ROWKEY, (Filter)new FilterList(new Filter[]{new FamilyFilter(CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(FAMILY)), new QualifierFilter(CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"A"))), new TimestampsFilter(Collections.singletonList(101L))})).thenPut(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"c")));
            Assert.assertFalse((boolean)ok);
            Assert.assertFalse((boolean)table.exists(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"C"))));
        }
    }

    @Test
    public void testCheckAndMutateWithFilterAndTimeRange() throws Throwable {
        try (Table table = this.createTable();){
            table.put(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"A"), 100L, Bytes.toBytes((String)"a")));
            boolean ok = table.checkAndMutate(ROWKEY, (Filter)new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a"))).timeRange(TimeRange.between((long)0L, (long)101L)).thenPut(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b")));
            Assert.assertTrue((boolean)ok);
            Result result = table.get(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"B")));
            Assert.assertEquals((Object)"b", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
            ok = table.checkAndMutate(ROWKEY, (Filter)new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a"))).timeRange(TimeRange.between((long)0L, (long)100L)).thenPut(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"c")));
            Assert.assertFalse((boolean)ok);
            Assert.assertFalse((boolean)table.exists(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"C"))));
        }
    }

    @Test(expected=NullPointerException.class)
    public void testCheckAndMutateWithNotSpecifyingCondition() throws Throwable {
        try (Table table = this.createTable();){
            table.checkAndMutate(ROWKEY, FAMILY).thenPut(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"d")));
        }
    }
}

