/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.exceptions.TimeoutIOException;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class SyncFuture {
    private static final long NOT_DONE = -1L;
    private long txid;
    private long doneTxid;
    private Throwable throwable;
    private Thread t;
    private boolean forceSync;

    SyncFuture() {
    }

    synchronized SyncFuture reset(long txid) {
        if (this.t != null && this.t != Thread.currentThread()) {
            throw new IllegalStateException();
        }
        this.t = Thread.currentThread();
        if (!this.isDone()) {
            throw new IllegalStateException("" + txid + " " + Thread.currentThread());
        }
        this.doneTxid = -1L;
        this.txid = txid;
        this.throwable = null;
        return this;
    }

    public synchronized String toString() {
        return "done=" + this.isDone() + ", txid=" + this.txid;
    }

    synchronized long getTxid() {
        return this.txid;
    }

    synchronized boolean isForceSync() {
        return this.forceSync;
    }

    synchronized SyncFuture setForceSync(boolean forceSync) {
        this.forceSync = forceSync;
        return this;
    }

    synchronized boolean done(long txid, Throwable t) {
        if (this.isDone()) {
            return false;
        }
        this.throwable = t;
        if (txid < this.txid && this.throwable == null) {
            this.throwable = new IllegalStateException("done txid=" + txid + ", my txid=" + this.txid);
        }
        this.doneTxid = txid;
        this.notify();
        return true;
    }

    boolean cancel(boolean mayInterruptIfRunning) {
        throw new UnsupportedOperationException();
    }

    synchronized long get(long timeoutNs) throws InterruptedException, ExecutionException, TimeoutIOException {
        long done = System.nanoTime() + timeoutNs;
        while (!this.isDone()) {
            this.wait(1000L);
            if (System.nanoTime() < done) continue;
            throw new TimeoutIOException("Failed to get sync result after " + TimeUnit.NANOSECONDS.toMillis(timeoutNs) + " ms for txid=" + this.txid + ", WAL system stuck?");
        }
        if (this.throwable != null) {
            throw new ExecutionException(this.throwable);
        }
        return this.doneTxid;
    }

    synchronized boolean isDone() {
        return this.doneTxid != -1L;
    }

    synchronized boolean isThrowable() {
        return this.isDone() && this.getThrowable() != null;
    }

    synchronized Throwable getThrowable() {
        return this.throwable;
    }
}

