/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.AuthUtil;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.ObserverContextImpl;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessorEnvironment;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionServerCoprocessorHost;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessControlClient;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.security.access.TestAccessController;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={SecurityTests.class, MediumTests.class})
public class TestAccessController3
extends SecureTestUtil {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAccessController3.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestAccessController.class);
    private static TableName TEST_TABLE = TableName.valueOf((String)"testtable1");
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static Configuration conf;
    private static Connection systemUserConnection;
    private static User SUPERUSER;
    private static User USER_ADMIN;
    private static User USER_RW;
    private static User USER_RO;
    private static User USER_OWNER;
    private static User USER_CREATE;
    private static User USER_NONE;
    private static User USER_ADMIN_CF;
    private static final String GROUP_ADMIN = "group_admin";
    private static final String GROUP_CREATE = "group_create";
    private static final String GROUP_READ = "group_read";
    private static final String GROUP_WRITE = "group_write";
    private static User USER_GROUP_ADMIN;
    private static User USER_GROUP_CREATE;
    private static User USER_GROUP_READ;
    private static User USER_GROUP_WRITE;
    private static byte[] TEST_FAMILY;
    private static MasterCoprocessorEnvironment CP_ENV;
    private static AccessController ACCESS_CONTROLLER;
    private static RegionServerCoprocessorEnvironment RSCP_ENV;
    private static RegionCoprocessorEnvironment RCP_ENV;
    private static boolean callSuperTwice;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        RegionServerCoprocessorHost rsHost;
        conf = TEST_UTIL.getConfiguration();
        TestAccessController3.enableSecurity(conf);
        String accessControllerClassName = FaultyAccessController.class.getName();
        conf.set("hbase.coprocessor.region.classes", accessControllerClassName);
        TestAccessController3.verifyConfiguration(conf);
        conf.setBoolean("hbase.security.exec.permission.checks", true);
        TEST_UTIL.startMiniCluster();
        MasterCoprocessorHost cpHost = TEST_UTIL.getMiniHBaseCluster().getMaster().getMasterCoprocessorHost();
        cpHost.load(FaultyAccessController.class, 0, conf);
        ACCESS_CONTROLLER = (AccessController)cpHost.findCoprocessor(accessControllerClassName);
        CP_ENV = cpHost.createEnvironment((MasterCoprocessor)ACCESS_CONTROLLER, 0, 1, conf);
        while ((rsHost = TEST_UTIL.getMiniHBaseCluster().getRegionServer(0).getRegionServerCoprocessorHost()) == null) {
        }
        RSCP_ENV = rsHost.createEnvironment((RegionServerCoprocessor)ACCESS_CONTROLLER, 0, 1, conf);
        TEST_UTIL.waitUntilAllRegionsAssigned(AccessControlLists.ACL_TABLE_NAME);
        SUPERUSER = User.createUserForTesting((Configuration)conf, (String)"admin", (String[])new String[]{"supergroup"});
        USER_ADMIN = User.createUserForTesting((Configuration)conf, (String)"admin2", (String[])new String[0]);
        USER_RW = User.createUserForTesting((Configuration)conf, (String)"rwuser", (String[])new String[0]);
        USER_RO = User.createUserForTesting((Configuration)conf, (String)"rouser", (String[])new String[0]);
        USER_OWNER = User.createUserForTesting((Configuration)conf, (String)"owner", (String[])new String[0]);
        USER_CREATE = User.createUserForTesting((Configuration)conf, (String)"tbl_create", (String[])new String[0]);
        USER_NONE = User.createUserForTesting((Configuration)conf, (String)"nouser", (String[])new String[0]);
        USER_ADMIN_CF = User.createUserForTesting((Configuration)conf, (String)"col_family_admin", (String[])new String[0]);
        USER_GROUP_ADMIN = User.createUserForTesting((Configuration)conf, (String)"user_group_admin", (String[])new String[]{GROUP_ADMIN});
        USER_GROUP_CREATE = User.createUserForTesting((Configuration)conf, (String)"user_group_create", (String[])new String[]{GROUP_CREATE});
        USER_GROUP_READ = User.createUserForTesting((Configuration)conf, (String)"user_group_read", (String[])new String[]{GROUP_READ});
        USER_GROUP_WRITE = User.createUserForTesting((Configuration)conf, (String)"user_group_write", (String[])new String[]{GROUP_WRITE});
        systemUserConnection = TEST_UTIL.getConnection();
        TestAccessController3.setUpTableAndUserPermissions();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        HRegionServer rs = null;
        for (JVMClusterUtil.RegionServerThread thread : TEST_UTIL.getMiniHBaseCluster().getRegionServerThreads()) {
            rs = thread.getRegionServer();
        }
        TestAccessController3.cleanUp();
        TEST_UTIL.shutdownMiniCluster();
        Assert.assertTrue((String)"region server should have aborted due to FaultyAccessController", (boolean)rs.isAborted());
    }

    private static void setUpTableAndUserPermissions() throws Exception {
        HTableDescriptor htd = new HTableDescriptor(TEST_TABLE);
        HColumnDescriptor hcd = new HColumnDescriptor(TEST_FAMILY);
        hcd.setMaxVersions(100);
        htd.addFamily(hcd);
        htd.setOwner(USER_OWNER);
        TestAccessController3.createTable(TEST_UTIL, (TableDescriptor)htd, (byte[][])new byte[][]{Bytes.toBytes((String)"s")});
        HRegion region = TEST_UTIL.getHBaseCluster().getRegions(TEST_TABLE).get(0);
        RegionCoprocessorHost rcpHost = region.getCoprocessorHost();
        RCP_ENV = rcpHost.createEnvironment((RegionCoprocessor)ACCESS_CONTROLLER, 0, 1, conf);
        TestAccessController3.grantGlobal(TEST_UTIL, USER_ADMIN.getShortName(), Permission.Action.ADMIN, Permission.Action.CREATE, Permission.Action.READ, Permission.Action.WRITE);
        TestAccessController3.grantOnTable(TEST_UTIL, USER_RW.getShortName(), TEST_TABLE, TEST_FAMILY, null, Permission.Action.READ, Permission.Action.WRITE);
        TestAccessController3.grantOnTable(TEST_UTIL, USER_CREATE.getShortName(), TEST_TABLE, null, null, Permission.Action.CREATE, Permission.Action.READ, Permission.Action.WRITE);
        TestAccessController3.grantOnTable(TEST_UTIL, USER_RO.getShortName(), TEST_TABLE, TEST_FAMILY, null, Permission.Action.READ);
        TestAccessController3.grantOnTable(TEST_UTIL, USER_ADMIN_CF.getShortName(), TEST_TABLE, TEST_FAMILY, null, Permission.Action.ADMIN, Permission.Action.CREATE);
        TestAccessController3.grantGlobal(TEST_UTIL, AuthUtil.toGroupEntry((String)GROUP_ADMIN), Permission.Action.ADMIN);
        TestAccessController3.grantGlobal(TEST_UTIL, AuthUtil.toGroupEntry((String)GROUP_CREATE), Permission.Action.CREATE);
        TestAccessController3.grantGlobal(TEST_UTIL, AuthUtil.toGroupEntry((String)GROUP_READ), Permission.Action.READ);
        TestAccessController3.grantGlobal(TEST_UTIL, AuthUtil.toGroupEntry((String)GROUP_WRITE), Permission.Action.WRITE);
        Assert.assertEquals((long)5L, (long)AccessControlLists.getTablePermissions((Configuration)conf, (TableName)TEST_TABLE).size());
        try {
            Assert.assertEquals((long)5L, (long)AccessControlClient.getUserPermissions((Connection)systemUserConnection, (String)TEST_TABLE.toString()).size());
        }
        catch (Throwable e) {
            LOG.error("error during call of AccessControlClient.getUserPermissions. ", e);
        }
    }

    private static void cleanUp() throws Exception {
        try {
            TestAccessController3.deleteTable(TEST_UTIL, TEST_TABLE);
        }
        catch (TableNotFoundException ex) {
            LOG.info("Test deleted table " + TEST_TABLE);
        }
        Assert.assertEquals((long)0L, (long)AccessControlLists.getTablePermissions((Configuration)conf, (TableName)TEST_TABLE).size());
        Assert.assertEquals((long)0L, (long)AccessControlLists.getNamespacePermissions((Configuration)conf, (String)TEST_TABLE.getNamespaceAsString()).size());
    }

    @Test
    public void testTableCreate() throws Exception {
        SecureTestUtil.AccessTestAction createTable = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)TestAccessController3.this.name.getMethodName()));
                htd.addFamily(new HColumnDescriptor(TEST_FAMILY));
                ACCESS_CONTROLLER.preCreateTable(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), (TableDescriptor)htd, null);
                return null;
            }
        };
        TestAccessController3.verifyAllowed(createTable, SUPERUSER, USER_ADMIN, USER_GROUP_CREATE);
        TestAccessController3.verifyDenied(createTable, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_GROUP_ADMIN, USER_GROUP_READ, USER_GROUP_WRITE);
    }

    static {
        TEST_FAMILY = Bytes.toBytes((String)"f1");
        callSuperTwice = true;
    }

    public static class FaultyAccessController
    extends AccessController {
        public void stop(CoprocessorEnvironment env) {
            super.stop(env);
            if (callSuperTwice) {
                super.stop(env);
            }
        }
    }
}

