/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.lang.reflect.Method;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestHBaseWalOnEC {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHBaseWalOnEC.class);
    private static final HBaseTestingUtility util = new HBaseTestingUtility();
    private static final String HFLUSH = "hflush";

    @BeforeClass
    public static void setup() throws Exception {
        try {
            MiniDFSCluster cluster = util.startMiniDFSCluster(3);
            DistributedFileSystem fs = cluster.getFileSystem();
            Method enableAllECPolicies = DFSTestUtil.class.getMethod("enableAllECPolicies", DistributedFileSystem.class);
            enableAllECPolicies.invoke(null, fs);
            DFSClient client = fs.getClient();
            Method setErasureCodingPolicy = DFSClient.class.getMethod("setErasureCodingPolicy", String.class, String.class);
            setErasureCodingPolicy.invoke((Object)client, "/", "RS-3-2-1024k");
            try (FSDataOutputStream out = fs.create(new Path("/canary"));){
                Assert.assertFalse((String)"Did not enable EC!", (boolean)CommonFSUtils.hasCapability((FSDataOutputStream)out, (String)HFLUSH));
            }
        }
        catch (NoSuchMethodException e) {
            Assume.assumeNoException((String)"Using an older version of hadoop; EC not available.", (Throwable)e);
        }
        util.getConfiguration().setBoolean("hbase.unsafe.stream.capability.enforce", true);
        util.startMiniCluster();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        util.shutdownMiniCluster();
    }

    @Test
    public void testStreamCreate() throws IOException {
        try (FSDataOutputStream out = CommonFSUtils.createForWal((FileSystem)util.getDFSCluster().getFileSystem(), (Path)new Path("/testStreamCreate"), (boolean)true);){
            Assert.assertTrue((boolean)CommonFSUtils.hasCapability((FSDataOutputStream)out, (String)HFLUSH));
        }
    }

    @Test
    public void testFlush() throws IOException {
        byte[] row = Bytes.toBytes((String)"row");
        byte[] cf = Bytes.toBytes((String)"cf");
        byte[] cq = Bytes.toBytes((String)"cq");
        byte[] value = Bytes.toBytes((String)"value");
        TableName name = TableName.valueOf((String)this.getClass().getSimpleName());
        Table t = util.createTable(name, cf);
        t.put(new Put(row).addColumn(cf, cq, value));
        util.getAdmin().flush(name);
        Assert.assertArrayEquals((byte[])value, (byte[])t.get(new Get(row)).getValue(cf, cq));
    }
}

