/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueTestUtil;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.BlockCacheFactory;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TestMultiColumnScanner {
    private static final Logger LOG = LoggerFactory.getLogger(TestMultiColumnScanner.class);
    private static final String TABLE_NAME = TestMultiColumnScanner.class.getSimpleName();
    static final int MAX_VERSIONS = 50;
    private static final String FAMILY = "CF";
    private static final byte[] FAMILY_BYTES = Bytes.toBytes((String)"CF");
    private static final int NUM_COLUMNS = 8;
    private static final int MAX_COLUMN_BIT_MASK = 128;
    private static final int NUM_FLUSHES = 10;
    private static final int NUM_ROWS = 20;
    private static final long BIG_LONG = 9111222333444555666L;
    private static final long[] TIMESTAMPS = new long[]{1L, 3L, 5L, Integer.MAX_VALUE, 9111222333444555666L, 0x7FFFFFFFFFFFFFFEL};
    private static final double COLUMN_SKIP_IN_STORE_FILE_PROB = 0.7;
    private static final double DELETE_PROBABILITY = 0.02;
    private static final HBaseTestingUtility TEST_UTIL = HBaseTestingUtility.createLocalHTU();
    @Parameterized.Parameter(value=0)
    public Compression.Algorithm comprAlgo;
    @Parameterized.Parameter(value=1)
    public BloomType bloomType;
    @Parameterized.Parameter(value=2)
    public DataBlockEncoding dataBlockEncoding;

    public static Collection<Object[]> generateParams(Compression.Algorithm algo, boolean useDataBlockEncoding) {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        for (BloomType bloomType : BloomType.values()) {
            DataBlockEncoding dataBlockEncoding = useDataBlockEncoding ? DataBlockEncoding.PREFIX : DataBlockEncoding.NONE;
            parameters.add(new Object[]{algo, bloomType, dataBlockEncoding});
        }
        return parameters;
    }

    @Test
    public void testMultiColumnScanner() throws IOException {
        TEST_UTIL.getConfiguration().setInt("RowPrefixBloomFilter.prefix_length", 10);
        HRegion region = TEST_UTIL.createTestRegion(TABLE_NAME, ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILY_BYTES).setCompressionType(this.comprAlgo).setBloomFilterType(this.bloomType).setMaxVersions(50).setDataBlockEncoding(this.dataBlockEncoding).build(), BlockCacheFactory.createBlockCache((Configuration)TEST_UTIL.getConfiguration()));
        List<String> rows = TestMultiColumnScanner.sequentialStrings("row", 20);
        List<String> qualifiers = TestMultiColumnScanner.sequentialStrings("qual", 8);
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        HashSet<String> keySet = new HashSet<String>();
        HashMap<String, Long> lastDelTimeMap = new HashMap<String, Long>();
        Random rand = new Random(29372937L);
        for (int iFlush = 0; iFlush < 10; ++iFlush) {
            for (String qual : qualifiers) {
                if (rand.nextDouble() < 0.7) continue;
                byte[] qualBytes = Bytes.toBytes((String)qual);
                for (String string : rows) {
                    Put p = new Put(Bytes.toBytes((String)string));
                    for (long ts : TIMESTAMPS) {
                        String value = TestMultiColumnScanner.createValue(string, qual, ts);
                        KeyValue kv = KeyValueTestUtil.create((String)string, (String)FAMILY, (String)qual, (long)ts, (String)value);
                        Assert.assertEquals((long)kv.getTimestamp(), (long)ts);
                        p.add((Cell)kv);
                        String keyAsString = kv.toString();
                        if (keySet.contains(keyAsString)) continue;
                        keySet.add(keyAsString);
                        kvs.add(kv);
                    }
                    region.put(p);
                    Delete d = new Delete(Bytes.toBytes((String)string));
                    boolean deletedSomething = false;
                    for (long ts : TIMESTAMPS) {
                        if (!(rand.nextDouble() < 0.02)) continue;
                        d.addColumns(FAMILY_BYTES, qualBytes, ts);
                        String rowAndQual = string + "_" + qual;
                        Long whenDeleted = (Long)lastDelTimeMap.get(rowAndQual);
                        lastDelTimeMap.put(rowAndQual, whenDeleted == null ? ts : Math.max(ts, whenDeleted));
                        deletedSomething = true;
                    }
                    if (!deletedSomething) continue;
                    region.delete(d);
                }
            }
            region.flush(true);
        }
        Collections.sort(kvs, CellComparatorImpl.COMPARATOR);
        for (int maxVersions = 1; maxVersions <= TIMESTAMPS.length; ++maxVersions) {
            for (int columnBitMask = 1; columnBitMask <= 128; ++columnBitMask) {
                Scan scan = new Scan();
                scan.readVersions(maxVersions);
                TreeSet<String> qualSet = new TreeSet<String>();
                int columnMaskTmp = columnBitMask;
                for (String qual : qualifiers) {
                    if ((columnMaskTmp & 1) != 0) {
                        scan.addColumn(FAMILY_BYTES, Bytes.toBytes((String)qual));
                        qualSet.add(qual);
                    }
                    columnMaskTmp >>= 1;
                }
                Assert.assertEquals((long)0L, (long)columnMaskTmp);
                HRegion.RegionScannerImpl scanner = region.getScanner(scan);
                ArrayList arrayList = new ArrayList();
                int kvPos = 0;
                int numResults = 0;
                String queryInfo = "columns queried: " + qualSet + " (columnBitMask=" + columnBitMask + "), maxVersions=" + maxVersions;
                while (scanner.next(arrayList) || arrayList.size() > 0) {
                    Object object = arrayList.iterator();
                    while (object.hasNext()) {
                        Cell kv = (Cell)object.next();
                        while (kvPos < kvs.size() && !TestMultiColumnScanner.matchesQuery((KeyValue)kvs.get(kvPos), qualSet, maxVersions, lastDelTimeMap)) {
                            ++kvPos;
                        }
                        String rowQual = TestMultiColumnScanner.getRowQualStr(kv);
                        String deleteInfo = "";
                        Long lastDelTS = (Long)lastDelTimeMap.get(rowQual);
                        if (lastDelTS != null) {
                            deleteInfo = "; last timestamp when row/column " + rowQual + " was deleted: " + lastDelTS;
                        }
                        Assert.assertTrue((String)("Scanner returned additional key/value: " + kv + ", " + queryInfo + deleteInfo + ";"), (kvPos < kvs.size() ? 1 : 0) != 0);
                        Assert.assertTrue((String)("Scanner returned wrong key/value; " + queryInfo + deleteInfo + ";"), (boolean)PrivateCellUtil.equalsIgnoreMvccVersion((Cell)((Cell)kvs.get(kvPos)), (Cell)kv));
                        ++kvPos;
                        ++numResults;
                    }
                    arrayList.clear();
                }
                while (kvPos < kvs.size()) {
                    KeyValue remainingKV = (KeyValue)kvs.get(kvPos);
                    Assert.assertFalse((String)("Matching column not returned by scanner: " + remainingKV + ", " + queryInfo + ", results returned: " + numResults), (boolean)TestMultiColumnScanner.matchesQuery(remainingKV, qualSet, maxVersions, lastDelTimeMap));
                    ++kvPos;
                }
            }
        }
        Assert.assertTrue((String)"This test is supposed to delete at least some row/column pairs", (lastDelTimeMap.size() > 0 ? 1 : 0) != 0);
        LOG.info("Number of row/col pairs deleted at least once: " + lastDelTimeMap.size());
        HBaseTestingUtility.closeRegionAndWAL(region);
    }

    private static String getRowQualStr(Cell kv) {
        String rowStr = Bytes.toString((byte[])CellUtil.cloneRow((Cell)kv));
        String qualStr = Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)kv));
        return rowStr + "_" + qualStr;
    }

    private static boolean matchesQuery(KeyValue kv, Set<String> qualSet, int maxVersions, Map<String, Long> lastDelTimeMap) {
        Long lastDelTS = lastDelTimeMap.get(TestMultiColumnScanner.getRowQualStr((Cell)kv));
        long ts = kv.getTimestamp();
        return qualSet.contains(TestMultiColumnScanner.qualStr(kv)) && ts >= TIMESTAMPS[TIMESTAMPS.length - maxVersions] && (lastDelTS == null || ts > lastDelTS);
    }

    private static String qualStr(KeyValue kv) {
        return Bytes.toString((byte[])kv.getQualifierArray(), (int)kv.getQualifierOffset(), (int)kv.getQualifierLength());
    }

    static String createValue(String row, String qual, long ts) {
        return "value_for_" + row + "_" + qual + "_" + ts;
    }

    private static List<String> sequentialStrings(String prefix, int n) {
        ArrayList<String> lst = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            StringBuilder sb = new StringBuilder();
            sb.append(prefix + i);
            for (int iBitShifted = i; iBitShifted != 0; iBitShifted >>= 1) {
                sb.append((iBitShifted & 1) == 0 ? (char)'a' : 'b');
            }
            lst.add(sb.toString());
        }
        return lst;
    }

    static {
        Assert.assertTrue((boolean)true);
        for (int i = 0; i < TIMESTAMPS.length - 1; ++i) {
            Assert.assertTrue((TIMESTAMPS[i] < TIMESTAMPS[i + 1] ? 1 : 0) != 0);
        }
    }
}

