/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestFailedProcCleanup {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFailedProcCleanup.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestFailedProcCleanup.class);
    protected static HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static Configuration conf;
    private static final TableName TABLE;
    private static final byte[] FAMILY;
    private static final int evictionDelay = 10000;

    @BeforeClass
    public static void setUpBeforeClass() {
        conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.procedure.cleaner.evict.ttl", 10000);
        conf.setInt("hbase.procedure.cleaner.evict.batch.size", 1);
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testFailCreateTable() throws Exception {
        conf.set("hbase.coprocessor.master.classes", CreateFailObserver.class.getName());
        TEST_UTIL.startMiniCluster(3);
        try {
            TEST_UTIL.createTable(TABLE, FAMILY);
        }
        catch (AccessDeniedException e) {
            LOG.debug("Ignoring exception: ", (Throwable)e);
            Thread.sleep(30000L);
        }
        List procedureInfos = TEST_UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor().getProcedures();
        for (Procedure procedureInfo : procedureInfos) {
            if (!procedureInfo.getProcName().equals("CreateTableProcedure") || procedureInfo.getState() != ProcedureProtos.ProcedureState.ROLLEDBACK) continue;
            Assert.fail((String)("Found procedure " + procedureInfo + " that hasn't been cleaned up"));
        }
    }

    @Test
    public void testFailCreateTableAction() throws Exception {
        conf.set("hbase.coprocessor.master.classes", CreateFailObserverHandler.class.getName());
        TEST_UTIL.startMiniCluster(3);
        try {
            TEST_UTIL.createTable(TABLE, FAMILY);
            Assert.fail((String)"Table shouldn't be created");
        }
        catch (AccessDeniedException e) {
            LOG.debug("Ignoring exception: ", (Throwable)e);
            Thread.sleep(30000L);
        }
        List procedureInfos = TEST_UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor().getProcedures();
        for (Procedure procedureInfo : procedureInfos) {
            if (!procedureInfo.getProcName().equals("CreateTableProcedure") || procedureInfo.getState() != ProcedureProtos.ProcedureState.ROLLEDBACK) continue;
            Assert.fail((String)("Found procedure " + procedureInfo + " that hasn't been cleaned up"));
        }
    }

    static {
        TABLE = TableName.valueOf((String)"test");
        FAMILY = Bytes.toBytesBinary((String)"f");
    }

    public static class CreateFailObserverHandler
    implements MasterCoprocessor,
    MasterObserver {
        public void preCreateTableAction(ObserverContext<MasterCoprocessorEnvironment> ctx, TableDescriptor desc, RegionInfo[] regions) throws IOException {
            if (desc.getTableName().equals((Object)TABLE)) {
                throw new AccessDeniedException("Don't allow creation of table");
            }
        }

        public Optional<MasterObserver> getMasterObserver() {
            return Optional.of(this);
        }
    }

    public static class CreateFailObserver
    implements MasterCoprocessor,
    MasterObserver {
        public void preCreateTable(ObserverContext<MasterCoprocessorEnvironment> env, TableDescriptor desc, RegionInfo[] regions) throws IOException {
            if (desc.getTableName().equals((Object)TABLE)) {
                throw new AccessDeniedException("Don't allow creation of table");
            }
        }

        public Optional<MasterObserver> getMasterObserver() {
            return Optional.of(this);
        }
    }
}

